/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.control;

import java.util.Collection;
import java.util.Collections;
import oracle.dbtools.raptor.metrics.control.AbstractTreeLayout;
import oracle.dbtools.raptor.metrics.control.ExpandableEdge;
import oracle.dbtools.raptor.metrics.control.ExpandableVertex;
import oracle.dbtools.raptor.metrics.control.LocatedVertex;
import oracle.dbtools.raptor.metrics.control.Tree;

public class RadialTreeLayout<T, V extends ExpandableVertex<T, V, E>, E extends ExpandableEdge<T, V, E>>
extends AbstractTreeLayout<T, V, E> {
    public RadialTreeLayout(Tree<T, V, E> tree) {
        super(tree);
    }

    @Override
    protected void adjustLayoutModel(AbstractTreeLayout.VertexLayout vertexLayout) {
        this.addExtensionVertexTo(vertexLayout);
        this.extendLayoutModel(vertexLayout, this.getGraph().getMaxVertexLevel());
    }

    @Override
    protected void convertLayoutCoordinates(AbstractTreeLayout.VertexLayout vertexLayout, Collection<V> collection) {
        double d = ((LocatedVertex)vertexLayout.treeVertex).getY();
        for (ExpandableVertex expandableVertex : collection) {
            double d2 = expandableVertex.getY();
            double d3 = (d2 >= d ? d2 - d : d2 + 1.0 - d) * 2.0 * Math.PI;
            double d4 = expandableVertex.getX();
            expandableVertex.setX(0.5 * (1.0 + d4 * Math.cos(d3)));
            expandableVertex.setY(0.5 * (1.0 + d4 * Math.sin(d3)));
        }
    }

    private void extendLayoutModel(AbstractTreeLayout.VertexLayout vertexLayout, int n) {
        for (AbstractTreeLayout.VertexLayout vertexLayout2 : vertexLayout.orderedChildren) {
            if (vertexLayout2.isLeaf && vertexLayout2.level < n) {
                this.addExtensionVertexTo(vertexLayout2);
            }
            if (vertexLayout2.isLeaf) continue;
            this.extendLayoutModel(vertexLayout2, n);
        }
    }

    private void addExtensionVertexTo(AbstractTreeLayout.VertexLayout vertexLayout) {
        AbstractTreeLayout.VertexLayout vertexLayout2 = new AbstractTreeLayout.VertexLayout();
        vertexLayout2.isLeaf = true;
        vertexLayout2.level = vertexLayout.level + 1;
        vertexLayout2.parent = vertexLayout;
        if (vertexLayout.isLeaf) {
            vertexLayout.isLeaf = false;
            vertexLayout.orderedChildren = Collections.singletonList(vertexLayout2);
            vertexLayout.leftmostChild = vertexLayout2;
            vertexLayout.rightmostChild = vertexLayout2;
        } else {
            vertexLayout2.number = vertexLayout.orderedChildren.size();
            vertexLayout2.leftSibling = vertexLayout.orderedChildren.get(vertexLayout2.number - 1);
            vertexLayout2.leftmostSibling = vertexLayout.orderedChildren.get(0);
            vertexLayout.orderedChildren.add(vertexLayout2);
            vertexLayout.rightmostChild = vertexLayout2;
        }
    }
}

