/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.control;

import java.util.function.BiFunction;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.geometry.Orientation;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ScrollBar;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.scene.shape.Rectangle;

public class GridViewControl
extends Region {
    private final ObservableList<Node> columnPanels = FXCollections.observableArrayList();
    private final ObservableList<Node> rowPanels = FXCollections.observableArrayList();
    private final ObjectProperty<BiFunction<Integer, Integer, Node>> cellFactoryProperty = new SimpleObjectProperty();
    private final GridPane rowsGrid = new GridPane();
    private final GridPane columnsGrid = new GridPane();
    private final GridPane cellsGrid = new GridPane();
    private final ScrollBar verticalScrollBar = new ScrollBar();
    private final ScrollBar horizontalScrollBar;
    private boolean reloadModel;

    public ObservableList<Node> getColumns() {
        return this.columnPanels;
    }

    public ObservableList<Node> getRows() {
        return this.rowPanels;
    }

    public BiFunction<Integer, Integer, Node> getCellFactory() {
        return (BiFunction)this.cellFactoryProperty.get();
    }

    public void setCellFactory(BiFunction<Integer, Integer, Node> biFunction) {
        this.cellFactoryProperty.set(biFunction);
    }

    public ObjectProperty<BiFunction<Integer, Integer, Node>> cellFactoryProperty() {
        return this.cellFactoryProperty;
    }

    public GridViewControl() {
        this.verticalScrollBar.setOrientation(Orientation.VERTICAL);
        this.horizontalScrollBar = new ScrollBar();
        this.horizontalScrollBar.setOrientation(Orientation.HORIZONTAL);
        this.getStyleClass().add((Object)"gridview");
        this.rowsGrid.getStyleClass().add((Object)"rows-grid");
        this.columnsGrid.getStyleClass().add((Object)"columns-grid");
        this.cellsGrid.getStyleClass().add((Object)"cells-grid");
        this.verticalScrollBar.getStyleClass().add((Object)"vertical-scrollBar");
        this.horizontalScrollBar.getStyleClass().add((Object)"horizontal-scrollbar");
        this.rowsGrid.setClip((Node)new Rectangle());
        this.columnsGrid.setClip((Node)new Rectangle());
        this.cellsGrid.setClip((Node)new Rectangle());
        this.horizontalScrollBar.valueProperty().addListener((observableValue, number, number2) -> this.refresh(false));
        this.verticalScrollBar.valueProperty().addListener((observableValue, number, number2) -> this.refresh(false));
        this.columnPanels.addListener(change -> this.refresh(true));
        this.rowPanels.addListener(change -> this.refresh(true));
        this.getChildren().addAll((Object[])new Node[]{this.rowsGrid, this.columnsGrid, this.cellsGrid, this.verticalScrollBar, this.horizontalScrollBar});
    }

    protected void layoutChildren() {
        boolean bl;
        boolean bl2;
        this.reloadModel();
        this.sizeColumns();
        this.sizeRows();
        double d = this.snappedLeftInset();
        double d2 = this.snappedTopInset();
        double d3 = this.getWidth() - d - this.snappedRightInset();
        double d4 = this.getHeight() - d2 - this.snappedBottomInset();
        double d5 = this.rowsGrid.prefWidth(-1.0);
        double d6 = this.verticalScrollBar.prefWidth(-1.0);
        double d7 = d3 - d5 - d6;
        double d8 = this.columnsGrid.prefHeight(-1.0);
        double d9 = this.horizontalScrollBar.prefHeight(-1.0);
        double d10 = d4 - d8 - d9;
        double d11 = this.cellsGrid.prefWidth(-1.0);
        double d12 = this.cellsGrid.prefHeight(-1.0);
        boolean bl3 = bl2 = d7 < d11;
        if (!bl2) {
            this.horizontalScrollBar.setValue(0.0);
            d10 += d9;
            d9 = 0.0;
        }
        this.horizontalScrollBar.setVisible(bl2);
        boolean bl4 = bl = d10 < d12;
        if (!bl) {
            this.verticalScrollBar.setValue(0.0);
            d7 += d6;
            d6 = 0.0;
        }
        this.verticalScrollBar.setVisible(bl);
        double d13 = (d11 - d7) * this.horizontalScrollBar.getValue() / 100.0;
        double d14 = (d12 - d10) * this.verticalScrollBar.getValue() / 100.0;
        this.horizontalScrollBar.setVisibleAmount(100.0 * d7 / d11);
        this.verticalScrollBar.setVisibleAmount(100.0 * d10 / d12);
        this.layout((Node)this.columnsGrid, d, d2, d5 - d13, 0.0, d7, d8);
        this.layout((Node)this.rowsGrid, d, d2, 0.0, d8 - d14, d5, d10);
        this.layout((Node)this.verticalScrollBar, d, d2, d5 + d7, d8, d6, d10);
        this.layout((Node)this.horizontalScrollBar, d, d2, d5, d8 + d10, d7, d9);
        this.layout((Node)this.cellsGrid, d, d2, d5 - d13, d8 - d14, d7, d10);
        this.clip((Node)this.columnsGrid, d, d2, d13, 0.0, d7, d8);
        this.clip((Node)this.rowsGrid, d, d2, 0.0, d14, d5, d10);
        this.clip((Node)this.cellsGrid, d, d2, d13, d14, d7, d10);
    }

    private void refresh(boolean bl) {
        if (bl) {
            this.reloadModel = true;
        }
        this.requestLayout();
    }

    private void reloadModel() {
        if (this.reloadModel) {
            this.updateCellsChildren();
            this.updateColumnsChildren();
            this.updateRowsChildren();
            this.reloadModel = false;
        }
    }

    private void updateCellsChildren() {
        int n = this.columnPanels.size();
        int n2 = this.rowPanels.size();
        BiFunction<Integer, Integer, Node> biFunction = this.getCellFactory();
        ObservableList observableList = this.cellsGrid.getChildren();
        observableList.clear();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                this.cellsGrid.add(biFunction.apply(j, i), j, i);
            }
        }
    }

    private void updateColumnsChildren() {
        int n = this.columnPanels.size();
        ObservableList observableList = this.columnsGrid.getChildren();
        observableList.clear();
        for (int i = 0; i < n; ++i) {
            this.columnsGrid.add((Node)this.columnPanels.get(i), i, 0);
        }
    }

    private void updateRowsChildren() {
        int n = this.rowPanels.size();
        ObservableList observableList = this.rowsGrid.getChildren();
        observableList.clear();
        for (int i = 0; i < n; ++i) {
            this.rowsGrid.add((Node)this.rowPanels.get(i), 0, i);
        }
    }

    private void sizeColumns() {
        int n = this.columnPanels.size();
        int n2 = this.rowPanels.size();
        ObservableList observableList = this.columnsGrid.getColumnConstraints();
        observableList.clear();
        for (int i = 0; i < n; ++i) {
            double d = 0.0;
            for (int j = 0; j < n2; ++j) {
                Node node = (Node)this.cellsGrid.getChildren().get(j * n + i);
                double d2 = node.prefWidth(-1.0);
                if (!(d2 > d)) continue;
                d = d2;
            }
            observableList.add(new ColumnConstraints(d));
        }
    }

    private void sizeRows() {
        int n = this.columnPanels.size();
        int n2 = this.rowPanels.size();
        ObservableList observableList = this.rowsGrid.getRowConstraints();
        observableList.clear();
        for (int i = 0; i < n2; ++i) {
            double d = 0.0;
            for (int j = 0; j < n; ++j) {
                Node node = (Node)this.cellsGrid.getChildren().get(i * n + j);
                double d2 = node.prefHeight(-1.0);
                if (!(d2 > d)) continue;
                d = d2;
            }
            observableList.add(new RowConstraints(d));
        }
    }

    private void layout(Node node, double d, double d2, double d3, double d4, double d5, double d6) {
        this.layoutInArea(node, d + d3, d2 + d4, d5, d6, 0.0, HPos.LEFT, VPos.TOP);
    }

    private void clip(Node node, double d, double d2, double d3, double d4, double d5, double d6) {
        Rectangle rectangle = (Rectangle)node.getClip();
        rectangle.setLayoutX(d3);
        rectangle.setLayoutY(d4);
        rectangle.setWidth(d5);
        rectangle.setHeight(d6);
    }
}

