/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.control;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import oracle.dbtools.raptor.metrics.control.AbstractGraphLayout;
import oracle.dbtools.raptor.metrics.control.Graph;
import oracle.dbtools.raptor.metrics.control.LocatedEdge;
import oracle.dbtools.raptor.metrics.control.LocatedVertex;

public class GraphLayout<T, V extends LocatedVertex<T, V, E>, E extends LocatedEdge<T, V, E>>
extends AbstractGraphLayout<T, V, E> {
    public GraphLayout(Graph<T, V, E> graph) {
        super(graph);
    }

    @Override
    protected void initializeVertices(Graph<T, V, E> graph, List<List<V>> list) {
        int n = 0;
        ListIterator<List<V>> listIterator = list.listIterator(0);
        while (listIterator.hasNext()) {
            List<V> list2 = listIterator.next();
            this.sortVerticesById(list2);
            double d = n;
            int n2 = 0;
            for (LocatedVertex locatedVertex : list2) {
                locatedVertex.setX(d);
                locatedVertex.setY(n2++);
            }
            ++n;
        }
    }

    @Override
    protected void relaxVertexLevel(List<V> list, Graph<T, V, E> graph, List<List<V>> list2, double d) {
        for (LocatedVertex locatedVertex : list) {
            int n;
            LocatedVertex locatedVertex2;
            int n2 = this.getModifiedLevel(locatedVertex);
            double d2 = 0.0;
            double d3 = 0.0;
            for (LocatedEdge locatedEdge : locatedVertex.getInEdges()) {
                locatedVertex2 = (LocatedVertex)locatedEdge.getSource();
                n = this.getModifiedLevel(locatedVertex2);
                d2 += locatedVertex2.getY() / (double)(n2 - n);
                d3 += 1.0;
            }
            for (LocatedEdge locatedEdge : locatedVertex.getOutEdges()) {
                locatedVertex2 = (LocatedVertex)locatedEdge.getDest();
                n = this.getModifiedLevel(locatedVertex2);
                d2 += locatedVertex2.getY() / (double)(n - n2);
                d3 += 1.0;
            }
            if (!(d3 > 0.0)) continue;
            double d4 = d2 / d3;
            double d5 = locatedVertex.getY();
            d5 += (d4 - d5) * d;
            locatedVertex.setY(d5);
        }
    }

    @Override
    protected void resolveCollisions(Graph<T, V, E> graph, List<List<V>> list) {
        double d;
        double d2;
        double d3 = this.getMinGap((Collection<V>)graph.getVertices());
        ListIterator<List<V>> listIterator = list.listIterator(0);
        while (listIterator.hasNext()) {
            List<V> list2 = listIterator.next();
            double d4 = this.getAverageY(list2);
            this.sortVerticesByY(list2);
            int n = list2.size();
            d2 = 0.0;
            for (int i = n - 1; i > 0; --i) {
                double d5;
                LocatedVertex locatedVertex = (LocatedVertex)list2.get(i);
                LocatedVertex locatedVertex2 = (LocatedVertex)list2.get(i - 1);
                double d6 = locatedVertex.getY();
                double d7 = d6 - (d5 = locatedVertex2.getY() + d2);
                if (d7 < d3) {
                    d2 += d7 - d3;
                }
                locatedVertex2.setY(locatedVertex2.getY() + d2);
            }
            d = d4 - this.getAverageY(list2);
            for (LocatedVertex locatedVertex : list2) {
                locatedVertex.setY(locatedVertex.getY() + d);
            }
        }
        double d8 = Double.MAX_VALUE;
        for (LocatedVertex locatedVertex : graph.getVertices()) {
            d2 = locatedVertex.getY();
            d = d2;
            if (!(d < d8)) continue;
            d8 = d;
        }
        for (LocatedVertex locatedVertex : graph.getVertices()) {
            locatedVertex.setY(locatedVertex.getY() - d8);
        }
        double d9 = 0.0;
        for (LocatedVertex locatedVertex : list.get(0)) {
            locatedVertex.setY(d9);
            d9 += d3;
        }
        double d10 = 0.0;
        for (LocatedVertex locatedVertex : list.get(list.size() - 1)) {
            locatedVertex.setY(d10);
            d10 += d3;
        }
    }

    @Override
    protected void normalize(Graph<T, V, E> graph, List<List<V>> list) {
        double d;
        double d2 = -1.7976931348623157E308;
        double d3 = Double.MAX_VALUE;
        for (LocatedVertex locatedVertex : graph.getVertices()) {
            double d4 = d = locatedVertex.getY();
            double d5 = d;
            if (d4 < d3) {
                d3 = d4;
            }
            if (!(d5 > d2)) continue;
            d2 = d5;
        }
        double d6 = 1.0 / (d2 - d3);
        d = 1.0 / (double)(list.size() - 1);
        for (LocatedVertex locatedVertex : graph.getVertices()) {
            locatedVertex.setY(d6 * (locatedVertex.getY() - d3));
            locatedVertex.setX(d * (double)this.getModifiedLevel(locatedVertex));
        }
    }

    private double getMinGap(Collection<V> collection) {
        double d = -1.7976931348623157E308;
        double d2 = Double.MAX_VALUE;
        for (LocatedVertex locatedVertex : collection) {
            double d3;
            double d4 = d3 = locatedVertex.getY();
            double d5 = d3;
            if (d4 < d2) {
                d2 = d4;
            }
            if (!(d5 > d)) continue;
            d = d5;
        }
        return (d - d2) / 10.0;
    }

    private double getAverageY(List<V> list) {
        double d = 0.0;
        double d2 = 0.0;
        for (LocatedVertex locatedVertex : list) {
            d += locatedVertex.getY();
            d2 += 1.0;
        }
        return d / d2;
    }

    private void sortVerticesById(List<V> list) {
        Collections.sort(list, (locatedVertex, locatedVertex2) -> locatedVertex2.getId() > locatedVertex.getId() ? -1 : 1);
    }

    private void sortVerticesByY(List<V> list) {
        Collections.sort(list, (locatedVertex, locatedVertex2) -> locatedVertex.getY() < locatedVertex2.getY() ? -1 : 1);
    }
}

