/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.javafx.ui;

import java.awt.Component;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.javatools.dialogs.ExceptionDialog;

public class JFXPanelFactory {
    private static final Class<?> CLAZZ = JFXPanelFactory.class;
    private static Throwable JAVAFX_RUNTIME_LINK_ERROR;
    private static ShutdownHook fxShutdownHook;
    private static String JAVAFX_VERSION;

    public static JFXPanel createJFXPanel() {
        JFXPanel jFXPanel = null;
        try {
            jFXPanel = JFXPanelFactory.createJFXPanelImpl();
            JFXPanelFactory.checkVersion();
            JFXPanelFactory.addShutdownHook();
        }
        catch (Throwable throwable) {
            jFXPanel = null;
            String string = "Problem initializing the JavaFX runtime. This feature requires JavaFX.";
            Logger.warn(CLAZZ, (String)string, (Throwable)throwable);
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)throwable, (String)string);
        }
        return jFXPanel;
    }

    private static JFXPanel createJFXPanelImpl() throws Throwable {
        JFXPanel jFXPanel = null;
        try {
            if (JAVAFX_RUNTIME_LINK_ERROR != null) {
                throw JAVAFX_RUNTIME_LINK_ERROR;
            }
            jFXPanel = new JFXPanel();
        }
        catch (Throwable throwable) {
            if (throwable.getCause() instanceof UnsatisfiedLinkError) {
                JAVAFX_RUNTIME_LINK_ERROR = throwable;
            }
            throw throwable;
        }
        return jFXPanel;
    }

    private static void addShutdownHook() {
        Platform.setImplicitExit((boolean)false);
        fxShutdownHook = new ShutdownHook(){

            public boolean canShutdown() {
                return true;
            }

            public void shutdown() {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Platform.exit();
                    }
                });
            }
        };
        ExitCommand.removeShutdownHook((ShutdownHook)fxShutdownHook);
        ExitCommand.addShutdownHook((ShutdownHook)fxShutdownHook);
    }

    private static void checkVersion() {
        String string = "javafx.runtime.version";
        Object object = System.getProperties().get(string);
        JAVAFX_VERSION = object == null ? "null" : object.toString();
        Logger.info(CLAZZ, (String)(string + '=' + JAVAFX_VERSION));
    }
}

