/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.insight;

import java.util.List;
import javax.swing.SwingUtilities;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.plsql.BackgroundParser;
import oracle.dbtools.raptor.plsql.ParserEventListener;
import oracle.dbtools.raptor.refactor.CaseConverter;
import oracle.javatools.editor.BasicEditorPane;

public class Autoformat
implements ParserEventListener {
    private int lastEnd = -1;

    @Override
    public void stateChanged(BackgroundParser backgroundParser) {
        if (!DBConfig.getInstance().getBoolean("AUTOFORMAT").booleanValue()) {
            return;
        }
        if (backgroundParser.increments.size() > 0) {
            return;
        }
        if (!backgroundParser.isInsertion) {
            return;
        }
        String string = backgroundParser.text;
        final BasicEditorPane basicEditorPane = backgroundParser.editor;
        final int n = basicEditorPane.getCaretPosition();
        final int n2 = string.substring(0, n).lastIndexOf(10);
        if (n2 == this.lastEnd) {
            return;
        }
        this.lastEnd = n2;
        List<LexerToken> list = backgroundParser.src;
        int n3 = string.substring(0, n2).lastIndexOf(10);
        if (n3 == -1) {
            n3 = 0;
        }
        boolean bl = true;
        for (LexerToken object : list) {
            if (n3 <= object.begin && object.end <= n2) {
                bl = false;
                break;
            }
            if (object.end <= n3) continue;
            if (object.begin > n3 || n2 > object.end) break;
            return;
        }
        if (bl) {
            return;
        }
        try {
            final String string2 = string.substring(n3, n2);
            final String string3 = CaseConverter.getState().convert(string2);
            if (string3 != null && string2.length() == string3.length() && !string2.equals(string3)) {
                final int n4 = n3;
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        basicEditorPane.setSelectionStart(n4);
                        basicEditorPane.setSelectionEnd(n2);
                        basicEditorPane.replaceSelection(string3);
                        basicEditorPane.setCaretPosition(n + string3.length() - string2.length());
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

