/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.headless;

import java.io.PrintWriter;

public abstract class HeadlessCore {
    protected HeadlessCore() {
    }

    public final void printMessage(String ... stringArray) {
        assert (this.isOutputEnabled());
        HeadlessCore.printLines(this.getOutputWriter(), stringArray);
    }

    public final void printErrorMessage(String ... stringArray) {
        assert (this.isOutputEnabled());
        HeadlessCore.printLines(this.getErrorWriter(), stringArray);
    }

    public abstract boolean isOutputEnabled();

    protected abstract PrintWriter getOutputWriter();

    protected abstract PrintWriter getErrorWriter();

    protected static void printLines(PrintWriter printWriter, String ... stringArray) {
        for (String string : stringArray) {
            int n;
            if (string == null) break;
            int n2 = 0;
            while ((n = string.indexOf(10, n2)) >= 0) {
                printWriter.write(string, n2, n - n2);
                n2 = n + 1;
                printWriter.println();
            }
            printWriter.write(string, n2, string.length() - n2);
            printWriter.println();
        }
        printWriter.flush();
    }
}

