/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.features;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.JMenu;
import oracle.dbtools.raptor.features.DatabaseFeatureRegistryImpl;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.ToggleAction;
import oracle.ide.model.Element;

public class FeatureMenuListener
implements ContextMenuListener {
    private static final int MANAGE_FEATURES = Ide.findOrCreateCmdID((String)"Features.EnableFeatures");

    public void menuWillShow(ContextMenu contextMenu) {
        Context context;
        Element[] elementArray;
        final DatabaseFeatureRegistryImpl databaseFeatureRegistryImpl = DatabaseFeatureRegistryImpl.getInstance();
        Collection<DatabaseFeatureRegistryImpl.DynamicFeature> collection = databaseFeatureRegistryImpl.getDynamicFeatures();
        if (collection.size() > 0 && (elementArray = (context = contextMenu.getContext()).getSelection()) != null && elementArray.length == 1 && elementArray[0] instanceof DatabaseConnection) {
            IdeAction ideAction;
            final String string = ((DatabaseConnection)elementArray[0]).getQualifiedConnectionName();
            if (Connections.getInstance().isOracle(string) && (ideAction = IdeAction.find((int)MANAGE_FEATURES)) != null) {
                JMenu jMenu = contextMenu.createSubMenu((String)ideAction.getValue("Name"), (Integer)ideAction.getValue("MnemonicKey"));
                for (DatabaseFeatureRegistryImpl.DynamicFeature dynamicFeature : collection) {
                    final String string2 = dynamicFeature.getID();
                    final boolean bl = databaseFeatureRegistryImpl.isDynamicFeatureEnabled(string, string2);
                    ToggleAction toggleAction = new ToggleAction(dynamicFeature.getLabel(), null){

                        public void actionPerformed(ActionEvent actionEvent) {
                            databaseFeatureRegistryImpl.setDynamicFeatureEnabled(string, string2, !bl);
                        }
                    };
                    toggleAction.putValue("Check", (Object)true);
                    toggleAction.setState(bl);
                    jMenu.add(contextMenu.createMenuItem(toggleAction));
                }
                contextMenu.add((Component)jMenu, MenuConstants.SECTION_NAVIGATE_CTXT_MENU);
            }
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }
}

