/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extract.models;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.util.Logger;

public class ExtractConnectionAccess {
    String _connName = null;
    String _connDisplayName = null;
    String _connUser = null;
    String _dbName = null;
    String _schemaName = null;
    Connection _conn = null;
    boolean _isConnOwner = false;
    boolean _isSpatial = false;
    boolean _isSpatialSet = false;

    public ExtractConnectionAccess(DBObject dBObject) {
        this._connName = dBObject.getConnectionName();
        this._connDisplayName = Connections.getDisplayName(this._connName);
        this._dbName = DBURLFormatHelper.getCatalog(dBObject.getURL());
        if (this._dbName == null) {
            this._dbName = "";
        }
        this._schemaName = dBObject.getSchemaName();
        this._conn = dBObject.getConnection();
        Properties properties = Connections.getInstance().getConnectionInfo(this._connName);
        this._connUser = properties == null ? null : properties.getProperty("user");
        this._isConnOwner = !this._connUser.startsWith("\"") ? this._connUser.equalsIgnoreCase(this._schemaName) : this._schemaName.equals(this._connUser.substring(1, this._connUser.length() - 1));
    }

    public String getConnectionName() {
        return this._connName;
    }

    public String getConnectionDisplayName() {
        return this._connDisplayName;
    }

    public String getConnectionUser() {
        return this._connUser;
    }

    public String getDbName() {
        return this._dbName;
    }

    public String getSchemaName() {
        return this._schemaName;
    }

    public Connection getConnection() {
        return this._conn;
    }

    public boolean isConnOwner() {
        return this._isConnOwner;
    }

    public void isSchemaSpatial(boolean bl) {
        this._isSpatialSet = true;
    }

    public boolean isSchemaSpatial() {
        if (!this._isSpatialSet) {
            this.setSchemaSpatial();
        }
        return this._isSpatial;
    }

    public String getKey() {
        return this._connName + (this._dbName.isEmpty() ? "" : "_") + this._dbName + "_" + this._schemaName;
    }

    public String toString() {
        return this._connName;
    }

    public void setSchemaSpatial() {
        if (!this._isSpatialSet) {
            this._isSpatialSet = true;
            DBUtil dBUtil = DBUtil.getInstance((Connection)this._conn);
            String string = "select count(*) from MDSYS.all_sdo_geom_metadata where OWNER = '" + this._schemaName + "'";
            String string2 = dBUtil.executeReturnOneCol(string);
            SQLException sQLException = dBUtil.getLastException();
            if (sQLException != null) {
                Logger.warn(ExtractConnectionAccess.class, (Throwable)sQLException);
                this._isSpatial = false;
            }
            this._isSpatial = !string2.equals("0");
        }
    }
}

