/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.security;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dbtools.raptor.dialogs.security.QuotaObject;
import oracle.dbtools.raptor.dialogs.security.SecurityArb;
import oracle.dbtools.raptor.utils.TableSorter;
import oracle.ide.help.HelpSystem;

public class QuotaPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTable table;
    private QuotaTableTableModel myTableModel = new QuotaTableTableModel();

    QuotaTableTableModel getTableModel() {
        return this.myTableModel;
    }

    public QuotaPanel() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_userdialogquota_html");
        this.setLayout(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        this.add((Component)jScrollPane, gridBagConstraints);
        TableSorter tableSorter = new TableSorter((TableModel)this.myTableModel);
        this.table = new JTable((TableModel)tableSorter);
        this.table.setName("table");
        tableSorter.setTableHeader(this.table.getTableHeader());
        tableSorter.setSortingStatus(0, 1);
        TableColumn tableColumn = null;
        for (int i = 0; i < 4; ++i) {
            tableColumn = this.table.getColumnModel().getColumn(i);
            if (i == 0) {
                tableColumn.setPreferredWidth(150);
                continue;
            }
            tableColumn.setPreferredWidth(15);
        }
        TestRenderer testRenderer = new TestRenderer();
        this.table.setDefaultRenderer(String.class, testRenderer);
        jScrollPane.setViewportView(this.table);
    }

    class TestRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        TestRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (n2 == 2) {
                this.setHorizontalAlignment(4);
            } else {
                this.setHorizontalAlignment(2);
            }
            return this;
        }
    }

    class QuotaTableTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        public static final int NAME_INDEX = 0;
        public static final int UNLIMITED_INDEX = 1;
        public static final int QUOTA_INDEX = 2;
        public static final int UNIT_INDEX = 3;
        private final String[] COLUMN_NAMES = new String[]{SecurityArb.getString("TABLESPACE_LABEL"), SecurityArb.getString("UNLIMITED_LABEL"), SecurityArb.getString("QUOTA_LABEL"), SecurityArb.getString("UNITS_LABEL")};
        protected List<QuotaObject> dataVector = new ArrayList<QuotaObject>();

        @Override
        public String getColumnName(int n) {
            return this.COLUMN_NAMES[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 0;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            switch (n) {
                case 1: {
                    return Boolean.class;
                }
            }
            return String.class;
        }

        public QuotaObject getRowObject(int n) {
            QuotaObject quotaObject = this.dataVector.get(n);
            return quotaObject;
        }

        public List<QuotaObject> getData() {
            return this.dataVector;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            QuotaObject quotaObject = this.dataVector.get(n);
            switch (n2) {
                case 1: {
                    return quotaObject.isUnlimited();
                }
                case 2: {
                    return quotaObject.getQuota();
                }
                case 3: {
                    return quotaObject.getUnit();
                }
                case 0: {
                    return quotaObject.getName();
                }
            }
            return new Object();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            QuotaObject quotaObject = this.dataVector.get(n);
            switch (n2) {
                case 1: {
                    quotaObject.setUnlimited((Boolean)object);
                    break;
                }
                case 2: {
                    quotaObject.setQuota((String)object);
                    break;
                }
                case 3: {
                    quotaObject.setUnit((String)object);
                    break;
                }
            }
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.dataVector.size();
        }

        @Override
        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        public void addRow(String string, Boolean bl, String string2, String string3) {
            this.dataVector.add(new QuotaObject(string, bl, string2, string3));
            this.fireTableRowsInserted(this.dataVector.size() - 1, this.dataVector.size() - 1);
        }
    }
}

