/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.actions;

import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.ide.extension.ElementName;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.util.MetaResource;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.controls.display.SQLDevXMLFactory;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.dialogs.Messages;
import oracle.dbtools.raptor.format.ui.ExportContextMenuListener;
import oracle.dbtools.raptor.navigator.IViewerNode;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.support.MetaPackageReference;
import oracle.dbtools.raptor.support.MetaURLReference;
import oracle.dbtools.raptor.support.MetaXMLReference;
import oracle.dbtools.raptor.utils.AbstractFolderedXml;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.FileUtils;
import oracle.dbtools.raptor.utils.XLIFFHelper;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.dbtools.util.Logger;
import oracle.dbtools.util.Resource;
import oracle.dbtools.util.Util;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.editor.EditorManager;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.LazyResourceAdapter;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.net.URLFactory;
import oracle.ideri.util.Product;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.ModelUtil;

public final class XMLBasedObjectAction {
    private static final String NS = "http://xmlns.oracle.com/sqldeveloper/sqldev-actions";
    public static final ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/sqldeveloper/sqldev-actions", "sqldev-action-hook");
    private static final String ENTRY_ELEMENT = "actionDescriptor";
    private static final String PACKAGE_ATTR = "package";
    private static final String FILE_ATTR = "file";
    private static XMLBasedObjectAction _instance;
    private static Object LOCK;
    private static Object REGISTRATION_LOCK;
    private static List<MetaPackageReference> s_packages;
    private static List<MetaURLReference> s_files;
    private static Listener s_listener;
    private DefaultController _controller = null;
    private Map<ActionKey, List<ObjectAction>> m_actionMap = new HashMap<ActionKey, List<ObjectAction>>();
    private Map<ActionKey, List<JMenu>> m_menus = new HashMap<ActionKey, List<JMenu>>();
    private List<ObjectAction> m_actions;
    private Map<Component, ObjectAction> m_menusToActions = new HashMap<Component, ObjectAction>();
    static final String DEFAULT_CMD = "DEFAULT_XML_ACTION_ID";
    static final int DEFAULT_CMD_ID;
    private IdeAction defaultAction = IdeAction.find((int)DEFAULT_CMD_ID);
    private boolean _loaded = false;

    public static synchronized void registerContextMenus(URL uRL) {
        XMLBasedObjectAction.registerContextMenus(MetaURLReference.createURLReference((URL)uRL, (ClassLoader)XMLBasedObjectAction.class.getClassLoader()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerContextMenus(MetaURLReference metaURLReference) {
        Object object = REGISTRATION_LOCK;
        synchronized (object) {
            s_files.add(metaURLReference);
        }
    }

    private static void registerContextMenus(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            uRL = URLFactory.newFileURL((File)new File(string));
        }
        if (uRL != null) {
            XMLBasedObjectAction.registerContextMenus(MetaURLReference.createURLReference((URL)uRL, (ClassLoader)XMLBasedObjectAction.class.getClassLoader()));
        } else {
            Logger.info(XMLBasedObjectAction.class, (String)(Messages.getString((String)"XMLBasedObjectAction.0") + string));
        }
    }

    public static void registerPackage(String string) {
        XMLBasedObjectAction.registerPackage(string, XMLBasedObjectAction.class.getClassLoader());
    }

    public static void registerPackage(String string, ClassLoader classLoader) {
        XMLBasedObjectAction.registerPackage(MetaPackageReference.createPackageReference((String)string, (ClassLoader)classLoader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerPackage(MetaPackageReference metaPackageReference) {
        Object object = REGISTRATION_LOCK;
        synchronized (object) {
            for (MetaPackageReference metaPackageReference2 : s_packages) {
                if (!ModelUtil.areEqual((Object)metaPackageReference2.getPackage(), (Object)metaPackageReference.getPackage())) continue;
                return;
            }
            s_packages.add(metaPackageReference);
        }
    }

    private XMLBasedObjectAction() {
        this._controller = new DefaultController();
        this.defaultAction.addController((Controller)this._controller);
        this.defaultAction.putValue("ActionCommandKey", (Object)DEFAULT_CMD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLBasedObjectAction getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (_instance == null) {
                _instance = new XMLBasedObjectAction();
            }
        }
        return _instance;
    }

    public ObjectAction findCurrentAction(IdeAction ideAction) {
        ObjectAction objectAction = null;
        for (int i = 0; objectAction == null && i < this.m_actions.size(); ++i) {
            if (this.m_actions.get(i).getId() != ideAction.getCommandId()) continue;
            objectAction = this.m_actions.get(i);
        }
        return objectAction;
    }

    public IdeAction getIdeAction() {
        return this.defaultAction;
    }

    public void setController(Controller controller) {
        this._controller.setController(controller);
    }

    public JPopupMenu getMenu(DBObject dBObject) {
        int n;
        this.loadXML();
        ActionKey actionKey = new ActionKey(dBObject.getKey());
        List<ObjectAction> list = this.getActionList(actionKey, false);
        List<JMenu> list2 = this.m_menus.get(actionKey);
        this.checkActionVersions(dBObject, false);
        JPopupMenu jPopupMenu = new JPopupMenu(Messages.getString((String)"XMLBasedObjectAction.7"));
        for (n = 0; list2 != null && n < list2.size(); ++n) {
            JMenu jMenu = list2.get(n);
            jPopupMenu.add(jMenu);
            JPopupMenu jPopupMenu2 = jMenu.getPopupMenu();
            int n2 = jPopupMenu2.getComponentCount();
            for (int i = 0; i < n2; ++i) {
                Component component = jPopupMenu2.getComponent(i);
                if (!(component instanceof JMenuItem)) continue;
                ((JMenuItem)component).putClientProperty("ObjectAction.DBOBJECT", dBObject);
            }
        }
        for (n = 0; list != null && n < list.size(); ++n) {
            jPopupMenu.add(list.get(n).getMenuItem());
        }
        return jPopupMenu;
    }

    public void checkActionVersions(DBObject dBObject, boolean bl) {
        this.loadXML();
        ActionKey actionKey = bl ? new ActionKey("MULTI_" + dBObject.getKey()) : new ActionKey(dBObject.getKey());
        List<ObjectAction> list = this.m_actionMap.get(actionKey);
        List<JMenu> list2 = this.m_menus.get(actionKey);
        if (list != null) {
            for (Object object : list) {
                if (object.isValidForVersion(dBObject) && dBObject.isActionAllowed()) {
                    object.getAction().setEnabled(true);
                    object.getMenuItem().setEnabled(true);
                    continue;
                }
                object.getAction().setEnabled(false);
                object.getMenuItem().setEnabled(false);
            }
        }
        for (int i = 0; list2 != null && i < list2.size(); ++i) {
            Object object;
            object = list2.get(i);
            int n = ((JMenu)object).getPopupMenu().getComponentCount();
            int n2 = 0;
            for (int j = 0; j < n; ++j) {
                Component component = ((JMenu)object).getPopupMenu().getComponent(j);
                if (!(component instanceof JMenuItem)) continue;
                IdeAction ideAction = (IdeAction)((JMenuItem)component).getAction();
                ObjectAction objectAction = (ObjectAction)((Object)ideAction.getValue("ObjectAction.KEY"));
                if (objectAction.isValidForVersion(dBObject) && dBObject.isActionAllowed()) {
                    objectAction.getAction().setEnabled(true);
                    objectAction.getMenuItem().setEnabled(true);
                    continue;
                }
                objectAction.getAction().setEnabled(false);
                objectAction.getMenuItem().setEnabled(false);
                ++n2;
            }
            if (n == n2) {
                ((JComponent)object).setVisible(false);
                continue;
            }
            ((JComponent)object).setVisible(true);
        }
    }

    private List<ObjectAction> getActions(String string, boolean bl) {
        this.loadXML();
        List<ObjectAction> list = this.m_actionMap.get(new ActionKey(string));
        ArrayList<ObjectAction> arrayList = new ArrayList<ObjectAction>();
        if (list != null) {
            for (ObjectAction objectAction : list) {
                if (bl && objectAction.getSelectionMode() == 2) {
                    arrayList.add(objectAction);
                    continue;
                }
                if (!bl && objectAction.getSelectionMode() == 1) {
                    arrayList.add(objectAction);
                    continue;
                }
                if (objectAction.getSelectionMode() != 3) continue;
                arrayList.add(objectAction);
            }
        }
        return arrayList;
    }

    private List<JMenu> getMenus(DBObject dBObject, boolean bl) {
        String string = dBObject.getKey();
        this.loadXML();
        List<JMenu> list = this.m_menus.get(new ActionKey(string));
        ArrayList<JMenu> arrayList = new ArrayList<JMenu>();
        if (list != null) {
            for (JMenu jMenu : list) {
                boolean bl2 = false;
                for (Component component : jMenu.getPopupMenu().getComponents()) {
                    int n;
                    ObjectAction objectAction = this.m_menusToActions.get(component);
                    int n2 = n = bl ? 2 : 1;
                    if (objectAction.isSelectable(n)) {
                        component.setVisible(true);
                        bl2 = true;
                    } else {
                        component.setVisible(false);
                    }
                    if (objectAction.isValidForVersion(dBObject)) {
                        component.setVisible(true);
                        continue;
                    }
                    component.setVisible(false);
                }
                if (!bl2) continue;
                arrayList.add(jMenu);
            }
        }
        return arrayList;
    }

    public void addToMenu(ContextMenu contextMenu, DBObject dBObject, boolean bl) {
        Float f;
        JMenuItem jMenuItem;
        int n;
        this.loadXML();
        this.checkActionVersions(dBObject, bl);
        List<ObjectAction> list = this.getActions(dBObject.getKey(), bl);
        List<JMenu> list2 = this.getMenus(dBObject, bl);
        float f2 = MenuConstants.SECTION_TOOLS_CTXT_MENU;
        Context context = contextMenu.getContext();
        for (n = 0; list2 != null && n < list2.size(); ++n) {
            JPopupMenu jPopupMenu;
            jMenuItem = list2.get(n);
            f = (Float)jMenuItem.getClientProperty("menu-section-id");
            if (f != null) {
                f2 = f.floatValue();
            }
            if ((jPopupMenu = ((JMenu)jMenuItem).getPopupMenu()) != null) {
                jPopupMenu.putClientProperty("ContextMenuContext", context);
            }
            contextMenu.add((Component)jMenuItem, f2);
        }
        for (n = 0; list != null && n < list.size(); ++n) {
            jMenuItem = list.get(n).getMenuItem(contextMenu);
            f = (Float)jMenuItem.getClientProperty("menu-section-id");
            if (f != null) {
                f2 = f.floatValue();
            }
            contextMenu.add((Component)jMenuItem, f2);
        }
    }

    public void setEnabled(JPopupMenu jPopupMenu, DBObject dBObject) {
        Component[] componentArray = jPopupMenu.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            ObjectAction objectAction = this.m_menusToActions.get(component);
            if (objectAction == null) continue;
            if (objectAction.isValidForVersion(dBObject)) {
                component.setEnabled(true);
                continue;
            }
            component.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadXML() {
        Object object = LOCK;
        synchronized (object) {
            Object object2;
            String[] stringArray;
            List<String> list;
            long l = System.currentTimeMillis();
            XMLParser xMLParser = new XMLParser();
            if (!this._loaded || Resource.DEV_MODE) {
                if (Resource.DEV_MODE) {
                    this.m_actionMap = new HashMap<ActionKey, List<ObjectAction>>();
                    this.m_menus = new HashMap<ActionKey, List<JMenu>>();
                    this.m_actions = new ArrayList<ObjectAction>();
                    this.m_menusToActions = new HashMap<Component, ObjectAction>();
                }
                if (DBConfig.getInstance() != null && DBConfig.getInstance().getExtensions("ACTION") != null && (list = DBConfig.getInstance().getExtensions("ACTION")) != null) {
                    stringArray = list.iterator();
                    while (stringArray.hasNext()) {
                        object2 = (String)stringArray.next();
                        XMLBasedObjectAction.registerContextMenus((String)object2);
                    }
                }
                list = this.getClass().getClassLoader();
                this.m_actions = new ArrayList<ObjectAction>();
                if (System.getProperty("raptor.user.contextmenu") != null) {
                    stringArray = System.getProperty("raptor.user.contextmenu").split("[:;]");
                    object2 = null;
                    for (int i = 0; i < stringArray.length; ++i) {
                        object2 = new File(stringArray[i]);
                        if (!((File)object2).exists()) continue;
                        try {
                            xMLParser.processXML(MetaURLReference.createURLReference((File)object2, list));
                            continue;
                        }
                        catch (Exception exception) {
                            Logger.info(this.getClass(), (String)Messages.getString((String)"XMLBasedObjectAction.15"), (Throwable)exception);
                        }
                    }
                }
                if ((stringArray = Util.getUserExtensionsDirectory()) != null) {
                    for (URL uRL : FileUtils.getFilesInPath((URL[])new URL[]{stringArray}, (String)"xml")) {
                        XMLBasedObjectAction.registerContextMenus(MetaURLReference.createURLReference((URL)uRL, list));
                    }
                }
                this._loaded = true;
            }
            list = REGISTRATION_LOCK;
            synchronized (list) {
                if (s_listener == null) {
                    s_listener = new Listener();
                    stringArray = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(ELEMENT_NAME);
                    stringArray.addHashStructureHookListener((HashStructureHookListener)s_listener);
                }
                stringArray = s_packages.listIterator();
                while (stringArray.hasNext()) {
                    object2 = stringArray.next();
                    try {
                        for (MetaURLReference metaURLReference : object2.getURLReferences("xml")) {
                            try {
                                xMLParser.processXML(metaURLReference);
                            }
                            catch (Exception exception) {
                                Logger.info(this.getClass(), (String)Messages.getString((String)"XMLBasedObjectAction.10"), (Throwable)exception);
                            }
                        }
                    }
                    catch (Exception exception) {
                        Logger.warn(this.getClass(), (String)Messages.getString((String)"XMLBasedObjectAction.11"), (Throwable)exception);
                    }
                    finally {
                        stringArray.remove();
                    }
                }
                stringArray = s_files.listIterator();
                while (stringArray.hasNext()) {
                    object2 = (MetaURLReference)stringArray.next();
                    try {
                        xMLParser.processXML((MetaURLReference)object2);
                    }
                    catch (Exception exception) {
                        Logger.warn(this.getClass(), (String)Messages.getString((String)"XMLBasedObjectAction.17"), (Throwable)exception);
                    }
                    finally {
                        stringArray.remove();
                    }
                }
            }
            Logger.info(this.getClass(), (String)MessageFormat.format("Time to loadXML(): {1}ms", this.getClass().getName(), System.currentTimeMillis() - l));
        }
    }

    public void addAction(ObjectAction objectAction) {
        ActionKey actionKey = new ActionKey(objectAction);
        List<ObjectAction> list = this.getActionList(actionKey, true);
        list.add(objectAction);
    }

    public void addAction(JMenu jMenu, String string, String string2) throws Exception {
        ActionKey actionKey = new ActionKey(string, string2);
        if (this.m_menus.containsKey(actionKey)) {
            throw new Exception("Menu Exists");
        }
        this.m_menus.put(actionKey, new ArrayList<JMenu>(Collections.singletonList(jMenu)));
    }

    public void addAction(String string, ObjectAction objectAction) throws Exception {
        ActionKey actionKey = new ActionKey(objectAction);
        List<JMenu> list = this.m_menus.get(actionKey);
        if (list == null) {
            throw new Exception(Messages.getString((String)"XMLBasedObjectAction.18"));
        }
        for (JMenu jMenu : list) {
            if (!jMenu.getName().equalsIgnoreCase(string)) continue;
            jMenu.add((Action)objectAction.getAction());
        }
    }

    private ObjectAction processNode(MetaXMLReference metaXMLReference, XLIFFHelper xLIFFHelper) {
        ObjectAction objectAction = (ObjectAction)SQLDevXMLFactory.getInstance().createObjectAction(metaXMLReference.getNode(), metaXMLReference.getReferenceClassLoader(), xLIFFHelper);
        this.m_actions.add(objectAction);
        return objectAction;
    }

    private List<ObjectAction> getActionList(ActionKey actionKey, boolean bl) {
        List<ObjectAction> list = this.m_actionMap.get(actionKey);
        if (list == null && bl) {
            list = new ArrayList<ObjectAction>();
            this.m_actionMap.put(actionKey, list);
        }
        return list;
    }

    static {
        LOCK = new Object();
        REGISTRATION_LOCK = new Object();
        s_packages = new ArrayList<MetaPackageReference>();
        s_files = new ArrayList<MetaURLReference>();
        DEFAULT_CMD_ID = Ide.findOrCreateCmdID((String)DEFAULT_CMD);
        UIUtils.registerMenuItemProvider((UIUtils.MenuItemProvider)new UIUtils.MenuItemProvider(){

            public String getActionCommandKey() {
                return XMLBasedObjectAction.DEFAULT_CMD;
            }

            public JMenuItem getMenuItem(Context context) {
                JPopupMenu jPopupMenu;
                if (context.getNode() instanceof ViewerNode && (jPopupMenu = XMLBasedObjectAction.getInstance().getMenu(((ViewerNode)context.getNode()).getDBObject())).getComponentCount() > 0) {
                    JMenu jMenu = new JMenu((String)IdeAction.get((int)DEFAULT_CMD_ID).getValue("Name"));
                    for (Component component : jPopupMenu.getComponents()) {
                        Ide.getMenubar().add(component, jMenu);
                    }
                    return jMenu;
                }
                return null;
            }
        });
    }

    private class DefaultController
    implements Controller {
        private Controller _controller;

        private DefaultController() {
        }

        public void setController(Controller controller) {
            this._controller = controller;
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            Node node = context.getNode();
            if (n == DEFAULT_CMD_ID && (node instanceof IViewerNode || node instanceof PlSqlNode)) {
                context.getView().getGUI().requestFocusInWindow();
                DBObject dBObject = node instanceof IViewerNode ? new DBObject((Element)((IViewerNode)node).getBaseNode()) : new DBObject(node.getURL());
                JPopupMenu jPopupMenu = XMLBasedObjectAction.this.getMenu(dBObject);
                XMLBasedObjectAction.this.checkActionVersions(dBObject, false);
                if (jPopupMenu.getComponentCount() > 0) {
                    Component component = null;
                    if (ideAction.getValue("BUTTON") != null) {
                        component = (Component)ideAction.getValue("BUTTON");
                    } else if (context.getEvent() != null && context.getEvent().getSource() != null) {
                        component = (Component)context.getEvent().getSource();
                    }
                    context.setProperty("ObjectAction.DBOBJECT", (Object)dBObject);
                    this.updateMenu(jPopupMenu, context);
                    ContextMenu contextMenu = new ContextMenu();
                    Context context2 = EditorManager.getEditorManager().getCurrentEditor().getContext();
                    contextMenu.addContextMenuListener((ContextMenuListener)ExportContextMenuListener.getInstance());
                    contextMenu.prepareShow(context2);
                    contextMenu.sortContainer((Container)jPopupMenu);
                    for (Component component2 : jPopupMenu.getComponents()) {
                        contextMenu.add(component2);
                    }
                    jPopupMenu = (JPopupMenu)contextMenu.getGUI(true);
                    jPopupMenu.show(component, 0, 0);
                }
                return true;
            }
            return this._controller != null && this._controller.handleEvent(ideAction, context);
        }

        public boolean update(IdeAction ideAction, Context context) {
            return this._controller != null && this._controller.update(ideAction, context);
        }

        private void updateMenu(JPopupMenu jPopupMenu, Context context) {
            XMLBasedObjectAction.this.loadXML();
            int n = jPopupMenu.getComponentCount();
            for (int i = 0; i < n; ++i) {
                JPopupMenu jPopupMenu2;
                Component component = jPopupMenu.getComponent(i);
                if (component instanceof JMenu) {
                    jPopupMenu2 = ((JMenu)component).getPopupMenu();
                    jPopupMenu2.putClientProperty("ContextMenuContext", context);
                    this.updateMenu(jPopupMenu2, context);
                    continue;
                }
                if (!(component instanceof JMenuItem)) continue;
                jPopupMenu2 = (IdeAction)((JMenuItem)component).getAction();
                jPopupMenu2.updateAction(context);
            }
        }
    }

    private final class XMLParser
    extends AbstractFolderedXml {
        private Stack<JMenu> folders = new Stack();

        private XMLParser() {
        }

        @Override
        public void openFolder(String string, String string2, String string3, MetaXMLReference metaXMLReference, XLIFFHelper xLIFFHelper) {
            org.w3c.dom.Node node = metaXMLReference.getNode();
            String string4 = XMLHelper.getAttributeNode((org.w3c.dom.Node)node, (String)"type");
            String string5 = XMLHelper.getAttributeNode((org.w3c.dom.Node)node, (String)"connType");
            float f = 1.0f;
            String string6 = XMLHelper.getAttributeNode((org.w3c.dom.Node)node, (String)"weight");
            if (string6 != null) {
                try {
                    f = this.resolveFloatValue(string6).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    Logger.info(this.getClass(), (String)"Menu Weight", (Throwable)numberFormatException);
                }
            }
            float f2 = MenuConstants.SECTION_TOOLS_CTXT_MENU;
            String string7 = XMLHelper.getAttributeNode((org.w3c.dom.Node)node, (String)"section");
            if (string7 != null) {
                try {
                    f2 = this.resolveFloatValue(string7).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    Logger.severe(this.getClass(), (String)"Menu Section", (Throwable)numberFormatException);
                }
            }
            if (string5 == null) {
                string5 = "Oracle";
            }
            if (this.folders.size() == 0) {
                JMenu jMenu = new JMenu(string);
                jMenu.getAccessibleContext().setAccessibleName(string + Messages.getString((String)"XMLBasedObjectAction.24"));
                jMenu.putClientProperty("menu-weight", Float.valueOf(f));
                jMenu.putClientProperty("menu-section-id", Float.valueOf(f2));
                this.folders.push(jMenu);
                ActionKey actionKey = new ActionKey(string5, string4);
                ArrayList<JMenu> arrayList = (ArrayList<JMenu>)XMLBasedObjectAction.this.m_menus.get(actionKey);
                if (arrayList == null) {
                    arrayList = new ArrayList<JMenu>();
                    XMLBasedObjectAction.this.m_menus.put(actionKey, arrayList);
                }
                arrayList.add(jMenu);
            } else {
                JMenu jMenu = new JMenu(string);
                jMenu.getAccessibleContext().setAccessibleName(string + Messages.getString((String)"XMLBasedObjectAction.25"));
                jMenu.putClientProperty("menu-weight", Float.valueOf(f));
                this.folders.peek().add(jMenu);
            }
        }

        private Float resolveFloatValue(String string) throws NumberFormatException {
            if (null == string) {
                return null;
            }
            Float f = Float.valueOf(Float.MAX_VALUE);
            try {
                f = Float.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = string.substring(0, string.lastIndexOf("."));
                String string3 = string.substring(string.lastIndexOf(".") + 1);
                try {
                    Field field = Class.forName(string2).getDeclaredField(string3);
                    Object object = field.get(null);
                    if (object instanceof Float) {
                        f = (Float)object;
                    }
                }
                catch (Exception exception) {
                    Logger.warn(this.getClass(), (Throwable)exception);
                    throw numberFormatException;
                }
            }
            return f;
        }

        @Override
        public void newItem(MetaXMLReference metaXMLReference, XLIFFHelper xLIFFHelper) {
            ObjectAction objectAction = XMLBasedObjectAction.this.processNode(metaXMLReference, xLIFFHelper);
            if (objectAction.isSqlDevOnly() && !Product.isRaptor()) {
                return;
            }
            if (this.folders.size() > 0) {
                JMenuItem jMenuItem = this.folders.peek().add((Action)objectAction.getAction());
                jMenuItem.putClientProperty("menu-weight", Float.valueOf(objectAction.getWeight()));
                XMLBasedObjectAction.this.m_menusToActions.put(jMenuItem, objectAction);
            } else {
                ActionKey actionKey = new ActionKey(objectAction);
                List list = XMLBasedObjectAction.this.getActionList(actionKey, true);
                boolean bl = true;
                for (ObjectAction objectAction2 : list) {
                    if (!objectAction2.getTitle().equals(objectAction.getTitle())) continue;
                    bl = false;
                }
                if (bl) {
                    list.add(objectAction);
                }
            }
        }

        @Override
        public void closeFolder() {
            this.folders.pop();
        }
    }

    private static final class ActionKey {
        private String m_key;

        private ActionKey(ObjectAction objectAction) {
            this(objectAction.getConnType(), objectAction.getType());
        }

        private ActionKey(String string) {
            this.m_key = string;
        }

        private ActionKey(String string, String string2) {
            if (string == "") {
                string = null;
            }
            this.m_key = string + "#" + string2;
        }

        public boolean equals(Object object) {
            return object instanceof ActionKey && this.m_key.equals(((ActionKey)object).m_key);
        }

        public String toString() {
            return this.m_key;
        }

        public int hashCode() {
            return this.m_key.hashCode();
        }
    }

    private static final class Listener
    implements HashStructureHookListener {
        private Listener() {
        }

        public void elementVisited(HashStructureHookEvent hashStructureHookEvent) {
            this.processDescriptors(hashStructureHookEvent.getNewElementHashStructure());
        }

        public void listenerAttached(HashStructureHookEvent hashStructureHookEvent) {
            this.processDescriptors(hashStructureHookEvent.getCombinedHashStructure());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processDescriptors(HashStructure hashStructure) {
            Object object = REGISTRATION_LOCK;
            synchronized (object) {
                List list = hashStructure.getAsList(XMLBasedObjectAction.ENTRY_ELEMENT);
                if (list != null) {
                    for (HashStructure hashStructure2 : list) {
                        LazyResourceAdapter lazyResourceAdapter = LazyResourceAdapter.getInstance((HashStructure)hashStructure2);
                        MetaResource metaResource = lazyResourceAdapter.getMetaResource(XMLBasedObjectAction.PACKAGE_ATTR);
                        if (metaResource != null) {
                            XMLBasedObjectAction.registerPackage(MetaPackageReference.createPackageReference((MetaResource)metaResource));
                            continue;
                        }
                        metaResource = lazyResourceAdapter.getMetaResource(XMLBasedObjectAction.FILE_ATTR);
                        if (metaResource == null) continue;
                        XMLBasedObjectAction.registerContextMenus(MetaURLReference.createURLReference((MetaResource)metaResource));
                    }
                }
            }
        }
    }
}

