/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.actions;

import java.awt.Component;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dialogs.Messages;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.utils.RaptorVersionTracker;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class TogglePLScope
extends AbstractMenuAction {
    @Override
    public void launch() {
        try {
            Connection connection = null;
            try {
                connection = this.getDBObject().getConnection();
            }
            catch (Exception exception) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)Messages.getString((String)"TogglePLScope.0"), (String)Messages.getString((String)"TogglePLScope.1"), null);
                return;
            }
            if (RaptorVersionTracker.checkVersion(connection, null, DBUtil.ORACLE11g_VERSION)) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)Messages.getString((String)"TogglePLScope.2"), (String)Messages.getString((String)"TogglePLScope.3"), null);
                return;
            }
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                resultSet = statement.executeQuery("select value from v$parameter where lower(name) = 'plscope_settings'");
            }
            catch (Exception exception) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)Messages.getString((String)"TogglePLScope.5"), (String)Messages.getString((String)"TogglePLScope.6"), null);
                return;
            }
            resultSet.next();
            boolean bl = "IDENTIFIERS:ALL".equals(resultSet.getString("value"));
            resultSet.close();
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)(Messages.getString((String)"TogglePLScope.9") + (bl ? Messages.getString((String)"TogglePLScope.10") : Messages.getString((String)"TogglePLScope.11"))), (String)"PLSCOPE_SETTINGS", null);
            if (bl) {
                statement.execute("alter session set PLSCOPE_SETTINGS='IDENTIFIERS:NONE'");
            } else {
                statement.execute("alter session set PLSCOPE_SETTINGS='IDENTIFIERS:ALL'");
            }
            statement.close();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

