/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dbdiff;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.dbdiff.DBDiffResources;
import oracle.dbtools.raptor.dbdiff.DbCartDiffOptions;
import oracle.dbtools.raptor.dbdiff.Messages;
import oracle.dbtools.raptor.dbdiff.editor.DbDiffEditorNode;
import oracle.dbtools.raptor.dbdiff.models.DbDiffObject;
import oracle.dbtools.raptor.dbdiff.ui.DBDiffWizArb;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.ddl.DDLTypes;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;

public class DBDiffApi {
    private static final Logger LOGGER = Logger.getLogger(DBDiffApi.class.getName());
    private ExtractListModel _listModel;
    private String _sourceName;
    private String _destName;
    private LinkedList<DbDiffObject> _diffList;
    private DDLFormat _ddlFormat = null;
    private DDLTypes _ddlType = null;
    private String _EOL;
    private String badSetup = null;
    private Context context;
    private boolean _reconcileSourceFromConn = true;
    private boolean _reconcileDestFromSource = true;

    public DBDiffApi() {
    }

    public DBDiffApi(ExtractListModel extractListModel) {
        this._ddlFormat = extractListModel.getDDLFormat();
        this._ddlType = extractListModel.getDDLTypes();
        this._sourceName = Connections.getDisplayName(Connections.getConnectionName(extractListModel.getSourceConnName()));
        Connections.getInstance();
        this._destName = Connections.getDisplayName(Connections.getConnectionName(extractListModel.getDestConnName()));
        this._listModel = extractListModel;
    }

    public void setDeploy(DbCartDiffOptions dbCartDiffOptions) {
        this._listModel = new ExtractListModel();
        this._listModel.setSelectedExtractObjects(dbCartDiffOptions.getSourceExtractObjectList());
        if (dbCartDiffOptions.isDestCart()) {
            this._listModel.setDestExtractObjects(dbCartDiffOptions.getDestExtractObjectList());
        } else {
            this._listModel.setDestConnName(dbCartDiffOptions.getDestName());
        }
        this._sourceName = dbCartDiffOptions.getSourceName();
        this._destName = Connections.getDisplayName(Connections.getConnectionName(dbCartDiffOptions.getDestName()));
        this._ddlFormat = dbCartDiffOptions.getDDLFormat();
        this._listModel.setDDLFormat(this._ddlFormat);
        DDLTypes dDLTypes = this._listModel.getDDLTypes();
        List<ExtractObject> list = this._listModel.getList(0, new int[]{100, 101});
        List<ExtractObject> list2 = ExtractListModel.getList(list, new int[]{107});
        dDLTypes.setTypes(list2, false);
        this._listModel.setDDLTypes(dDLTypes);
        for (ExtractObject extractObject : dbCartDiffOptions.getSourceExtractObjectList()) {
            extractObject.setListModel(this._listModel);
            extractObject.setDestConnName(this._listModel.getDestConnName());
        }
        this._reconcileSourceFromConn = false;
        this._reconcileDestFromSource = !dbCartDiffOptions.isDestCart();
    }

    public void doDiffWithDialog() {
        final DbDiffTask dbDiffTask = new DbDiffTask();
        dbDiffTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, raptorTaskEvent.getTaskDescriptor().getName() + " " + raptorTaskEvent.getTaskDescriptor().getMessage());
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                try {
                    final LinkedList linkedList = (LinkedList)dbDiffTask.getResult();
                    if (linkedList != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DbDiffEditorNode dbDiffEditorNode = new DbDiffEditorNode();
                                dbDiffEditorNode.setDiffObjects(linkedList);
                                dbDiffEditorNode.setSourceName(DBDiffApi.this._sourceName);
                                dbDiffEditorNode.setDestName(DBDiffApi.this._destName);
                                DBDiffApi.this.context = Context.newIdeContext((Node)dbDiffEditorNode);
                                OpenEditorOptions openEditorOptions = new OpenEditorOptions(DBDiffApi.this.context);
                                openEditorOptions.setFlags(1);
                                EditorManager.getEditorManager().openEditor(openEditorOptions);
                            }
                        });
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException executionException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, executionException.getStackTrace()[0].toString(), executionException);
                }
            }
        });
        RaptorTaskManager.getInstance().addTask((RaptorTask)dbDiffTask);
    }

    public String getSummary() {
        if (!this.checkSetup()) {
            return this.badSetup;
        }
        try {
            return "Summary l8r!";
        }
        catch (Exception exception) {
            return "summary failed: " + exception.getLocalizedMessage();
        }
    }

    private boolean checkSetup() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        if (this._sourceName == null) {
            stringBuilder.append(DBDiffWizArb.getString("NO_SOURCE_CONNECTION") + this.getTerm());
            bl = false;
        }
        if (this._destName == null) {
            stringBuilder.append(DBDiffWizArb.getString("NO_DEST_CONNECTION") + this.getTerm());
            bl = false;
        }
        if (this._ddlFormat == null) {
            stringBuilder.append(DBDiffWizArb.getString("NO_FORMAT") + this.getTerm());
            bl = false;
        }
        if (this._ddlType == null) {
            stringBuilder.append(DBDiffWizArb.getString("NO_TYPE") + this.getTerm());
            bl = false;
        }
        this.badSetup = stringBuilder.toString();
        return bl;
    }

    private String getTerm() {
        if (this._EOL == null) {
            IdeSettings ideSettings;
            EnvironOptions environOptions;
            int n;
            this._EOL = Ide.isRunning() ? ((n = (environOptions = (EnvironOptions)(ideSettings = Ide.getSettings()).getData("environment-options")).getLineTerminator()) == 1 ? "\r\n" : (n == 3 ? "\r" : (n == 2 ? "\n" : System.getProperty("line.separator")))) : System.getProperty("line.separator");
        }
        return this._EOL;
    }

    private void setProg(String string, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) {
        if (iRaptorTaskProgressUpdater != null) {
            iRaptorTaskProgressUpdater.getDescriptor().setMessage(string);
        }
    }

    private LinkedList<DbDiffObject> loadDiffList(IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) throws Exception {
        if (this._reconcileSourceFromConn) {
            this._listModel.startProcess(iRaptorTaskProgressUpdater);
        } else {
            this._listModel.startProcessReconcileObjects(iRaptorTaskProgressUpdater);
        }
        if (this._reconcileDestFromSource) {
            this._listModel.reconcileDestFromSource(iRaptorTaskProgressUpdater);
        } else {
            this._listModel.reconcileDestListFromSource(iRaptorTaskProgressUpdater);
        }
        this._diffList = new LinkedList();
        List<ExtractObject> list = this._listModel.getList(0);
        String string = Integer.valueOf(list.size()).toString();
        Integer n = 1;
        DbDiffObject dbDiffObject = null;
        for (ExtractObject extractObject : list) {
            if (iRaptorTaskProgressUpdater != null) {
                iRaptorTaskProgressUpdater.checkCanProceed();
            }
            String string2 = DBDiffResources.format("DbDiffAPI_progress", n.toString(), string, extractObject.getDBObject().getObjectType(), extractObject.getDBObject().getSchemaName(), extractObject.getDBObject().getObjectName());
            this.setProg(string2, iRaptorTaskProgressUpdater);
            dbDiffObject = new DbDiffObject(extractObject, this._listModel.getSourceConnName().length() > 0 ? this._listModel.getSourceConnName() : extractObject.getSourceConnName(), this._listModel.getDestConnName().length() > 0 ? this._listModel.getDestConnName() : extractObject.getDestConnName(), this._listModel.getDDLFormat());
            dbDiffObject.initialize();
            this._diffList.add(dbDiffObject);
            n = n + 1;
        }
        return this._diffList;
    }

    private class DbDiffTask
    extends DatabaseQueryTask<LinkedList<DbDiffObject>> {
        public DbDiffTask() {
            super(Messages.getString("DbDiffApi.3"), IRaptorTaskRunMode.MODAL_OPTIONAL, false, true);
        }

        @Override
        public String getConnectionName() {
            return DBDiffApi.this._sourceName;
        }

        @Override
        public String getQuery() {
            return "";
        }

        protected LinkedList<DbDiffObject> doWork() {
            try {
                LinkedList linkedList = DBDiffApi.this.loadDiffList(this.getRaptorTaskProgressUpdater());
                return linkedList;
            }
            catch (Exception exception) {
                Throwable throwable = exception.getCause();
                if (!(throwable instanceof CancellationException)) {
                    LOGGER.log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
                }
                return null;
            }
        }
    }
}

