/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.ui.cell;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataValue;

public class BaseCellRenderer
extends DefaultTableCellRenderer
implements ListCellRenderer {
    public void configure(DataType dataType) {
    }

    @Override
    protected void setValue(Object object) {
        Object object2 = object;
        if (null == object2 || object2 instanceof DataValue && ((DataValue)object2).isNull()) {
            object2 = DBConfig.getInstance().getString("NULLDISPLAY");
        }
        if (object2 instanceof DataValue) {
            object2 = ((DataValue)object2).getStringValue().toString();
        }
        char[] cArray = object2.toString().toCharArray();
        StringBuilder stringBuilder = new StringBuilder(cArray.length + 20);
        for (char c : cArray) {
            if ('\n' == c) {
                stringBuilder.append("\\n");
                continue;
            }
            stringBuilder.append(c);
        }
        super.setValue(stringBuilder.toString());
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        this.setComponentOrientation(jList.getComponentOrientation());
        Color color = null;
        Color color2 = null;
        JList.DropLocation dropLocation = jList.getDropLocation();
        if (dropLocation != null && !dropLocation.isInsert() && dropLocation.getIndex() == n) {
            color = UIManager.getColor("List.dropCellBackground");
            color2 = UIManager.getColor("List.dropCellForeground");
            bl = true;
        }
        if (bl) {
            this.setBackground(color == null ? jList.getSelectionBackground() : color);
            this.setForeground(color2 == null ? jList.getSelectionForeground() : color2);
        } else {
            this.setBackground(jList.getBackground());
            this.setForeground(jList.getForeground());
        }
        if (object instanceof Icon) {
            this.setIcon((Icon)object);
            this.setText("");
        } else {
            this.setIcon(null);
            this.setValue(object);
        }
        this.setEnabled(jList.isEnabled());
        this.setFont(jList.getFont());
        Border border = null;
        if (bl2) {
            if (bl) {
                border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("List.focusCellHighlightBorder");
            }
        } else {
            border = noFocusBorder;
        }
        this.setBorder(border);
        return this;
    }
}

