/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.databasecopy;

import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.databasecopy.CopyAPI;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.dialogs.databasecopy.DatabaseCopyArb;
import oracle.dbtools.raptor.extract.models.ExtractObject;

public class TablespaceCopy
extends CopyAPI {
    public TablespaceCopy(HashMap<String, Boolean> hashMap) {
        super(hashMap);
    }

    @Override
    public void setDDLFormat() {
        DDLFormat dDLFormat = new DDLFormat();
        dDLFormat.setPretty(false);
        dDLFormat.setSchema(true);
        dDLFormat.setConstraint(true);
        dDLFormat.setRefConstraint(true);
        dDLFormat.setCascade(true);
        dDLFormat.setDrop(true);
        dDLFormat.setAlter(false);
        dDLFormat.setSegments(false);
        dDLFormat.isExtractEnabled(this.isCopyDDL());
        this.getExtractListModel().setDDLFormat(dDLFormat);
        this.isMaintainSchemas(true);
    }

    @Override
    protected void databaseCopyData() {
        if (this.isTruncateData()) {
            this.getExtractListAndExecuteDDL(7, 104, this.getDestinationConn());
            this.getExtractListAndExecuteDDL(5, 104, this.getDestinationConn());
        }
        this.getExtractListAndCopyData(8, this.getSourceConn(), this.getDestinationConn(), 1);
        this.getExtractListAndExecuteDDL(3, 0, this.getDestinationConn());
        if (this.isTruncateData()) {
            this.getExtractListAndExecuteDDL(6, 104, this.getDestinationConn());
        }
    }

    @Override
    protected void getExtractListAndExecuteDDL(int n, int n2, Connection connection) {
        List<ExtractObject> list = null;
        StringBuffer stringBuffer = null;
        list = n2 == 0 ? this.getExtractListModel().getList(n) : this.getExtractListModel().getList(n, new int[]{n2});
        this.lineStart();
        try {
            for (ExtractObject extractObject : list) {
                this.checkCancelled();
                this.setProg(DatabaseCopyArb.getString("CREATING_OBJ") + " " + extractObject.getDBObject().getObjectName());
                stringBuffer = new StringBuffer(extractObject.getDDL(n, ExtractObject.COPY_DDL));
                this.executeSql(this.getTablespaceAppendScript(stringBuffer, extractObject), connection);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        this.lineEnd();
    }

    private String getTablespaceAppendScript(StringBuffer stringBuffer, ExtractObject extractObject) {
        if (extractObject.getDBObject().getObjectType().equals("TABLE") && stringBuffer.indexOf("CREATE TABLE") != -1) {
            stringBuffer = stringBuffer.insert(stringBuffer.indexOf(";", stringBuffer.indexOf("CREATE TABLE")) - 1, this.getDestinationTablespaceString());
        } else if (extractObject.getDBObject().getObjectType().equals("INDEX")) {
            int n = stringBuffer.indexOf("CREATE INDEX");
            if (n == -1) {
                n = stringBuffer.indexOf("CREATE UNIQUE INDEX");
            }
            if (stringBuffer.indexOf("\"MDSYS\".\"SPATIAL_INDEX") == -1) {
                stringBuffer = stringBuffer.insert(stringBuffer.indexOf(";", n) - 1, this.getDestinationTablespaceString());
            }
        }
        return stringBuffer.toString();
    }
}

