/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.writers;

import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.sql.BatchUpdateException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.data.formattors.DataTypeFormatterRegistry;
import oracle.dbtools.data.formattors.ITypeFormattor;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.data.readservice.DataFormatException;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.Messages;
import oracle.dbtools.raptor.data.core.ImportDataFormat;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.data.core.ImportProperties;
import oracle.dbtools.raptor.data.readers.DataReadable;
import oracle.dbtools.raptor.data.readers.DataReaderException;
import oracle.dbtools.raptor.data.readers.DataReaderRegistry;
import oracle.dbtools.raptor.data.writers.ImportGen;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.ide.log.LogManager;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdbc.OraclePreparedStatement;
import org.antlr.stringtemplate.StringTemplate;

public class ImportGenInsertExec
extends ImportGen {
    private ImportProperties _iProps;
    private boolean _isValid = false;
    private LoadFile _loadFile;
    private boolean _connLocked = false;
    private boolean _autoCommit;
    private boolean _cancelled = false;
    private DataReadable _reader;
    private Column[] _insCols;
    private StringBuffer _createTableSql = new StringBuffer();
    private boolean _isIgnoreAllErrors = false;
    private int _loadRowsLimit;
    private boolean _isLoadLimit;
    private boolean _isTableCreated = false;
    private int _errorLimit = 0;
    private int _errorCount = 0;
    private String _insertForErrSql = "";
    private String _taskFullName;
    private RaptorTask<Void> _task;
    private IRaptorTaskProgressUpdater _progressUpdater;
    private ExitCode _exitCode;
    private Logger LOGGER = Logger.getLogger(this.getClass().getName());

    public ImportGenInsertExec(ImportProperties importProperties) {
        super(importProperties);
        this._iProps = importProperties;
    }

    @Override
    public ExitCode start() {
        ExitCode exitCode = super.start();
        if (exitCode == ExitCode.EXIT_SEVERE) {
            return exitCode;
        }
        return this.validate();
    }

    @Override
    public ExitCode generate() {
        if (!this._isValid) {
            return ExitCode.EXIT_SEVERE;
        }
        this._exitCode = ExitCode.EXIT_SUCCESS;
        this._loadRowsLimit = this._iProps.getValueInteger(ImportKeys.LOAD_LIMIT);
        this._isLoadLimit = this._loadRowsLimit > 0;
        this._errorLimit = this._iProps.getValueInteger(ImportKeys.ERROR_LIMIT);
        String string = this._loadFile.getName();
        GenericTable genericTable = (GenericTable)this._iProps.get(ImportKeys.TABLE);
        int n = -1;
        n = string.lastIndexOf("/");
        if (n > 0) {
            string = string.substring(n + 1);
        }
        String string2 = genericTable.getTable().getTablename();
        this._taskFullName = DataImportArb.format("TASK_FULL_NAME", string2, string);
        if (this.isBatch()) {
            this.generateBatch();
        } else {
            this.generateUI();
        }
        return this._exitCode;
    }

    private ExitCode validate() {
        this._exitCode = ExitCode.EXIT_SUCCESS;
        this._loadFile = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
        this._isValid = true;
        return this._exitCode;
    }

    private ExitCode generateBatch() {
        block12: {
            try {
                if (!this.lockConnectionForImport()) break block12;
                this.doImport();
                String string = this._taskFullName + ". ";
                if (this._exitCode == ExitCode.EXIT_SUCCESS && !this._cancelled) {
                    this.commitTask();
                    string = string + DataImportArb.getString("TASK_SUCCEEDED_AND_COMMITTED");
                } else {
                    this.rollbackTask();
                    string = string + DataImportArb.getString("TASK_CANCELLED_ROLLBACK");
                    string = string + " " + this._exitCode.getShortMessage() + " " + this._exitCode.getMessage();
                }
                this.outBad(string);
            }
            catch (Throwable throwable) {
                try {
                    if (this._connLocked) {
                        Connections.getInstance().unlock(this.getConn());
                        this.getConn().setAutoCommit(this._autoCommit);
                        this._connLocked = false;
                    }
                }
                catch (Exception exception) {
                    this.LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
                this.closeFiles();
                if (this.getStream().isBadFileUsed()) {
                    this._exitCode.setShortMessage(DataImportArb.format("BAD_FILE", this.getStream().geturlBad().toExternalForm()));
                }
                throw throwable;
            }
        }
        try {
            if (this._connLocked) {
                Connections.getInstance().unlock(this.getConn());
                this.getConn().setAutoCommit(this._autoCommit);
                this._connLocked = false;
            }
        }
        catch (Exception exception) {
            this.LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        this.closeFiles();
        if (this.getStream().isBadFileUsed()) {
            this._exitCode.setShortMessage(DataImportArb.format("BAD_FILE", this.getStream().geturlBad().toExternalForm()));
        }
        return this._exitCode;
    }

    private ExitCode generateUI() {
        try {
            this.LOGGER.log(Level.INFO, Messages.getString("ImportGenerator.78"));
            this._task = new RaptorTask<Void>(this._taskFullName, true, IRaptorTaskRunMode.MODAL_OPTIONAL){

                public Void doWork() {
                    ImportGenInsertExec.this.LOGGER.log(Level.INFO, Messages.getString("ImportGenerator.77"));
                    try {
                        if (ImportGenInsertExec.this.lockConnectionForImport()) {
                            ImportGenInsertExec.this.doImport((RaptorTask<Void>)this);
                            if (ImportGenInsertExec.this._exitCode == ExitCode.EXIT_SUCCESS && !ImportGenInsertExec.this._cancelled) {
                                ImportGenInsertExec.this.commitTask();
                            } else {
                                ImportGenInsertExec.this.rollbackTask();
                            }
                        } else {
                            this.getDescriptor().setMessage(ImportGenInsertExec.this._exitCode.getShortMessage() + " " + ImportGenInsertExec.this._exitCode.getMessage());
                            ImportGenInsertExec.this._cancelled = true;
                        }
                    }
                    finally {
                        try {
                            if (ImportGenInsertExec.this._connLocked) {
                                Connections.getInstance().unlock(ImportGenInsertExec.this.getConn());
                                ImportGenInsertExec.this.getConn().setAutoCommit(ImportGenInsertExec.this._autoCommit);
                                ImportGenInsertExec.this._connLocked = false;
                            }
                        }
                        catch (Exception exception) {
                            ImportGenInsertExec.this.LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                        }
                    }
                    return null;
                }

                public boolean cancel() {
                    ImportGenInsertExec.this._cancelled = true;
                    return true;
                }
            };
            this._task.setCancellable(true);
            this._task.setPausable(false);
            this._task.getDescriptor().addListener((IRaptorTaskListener)new DBTaskListener(this._taskFullName));
            RaptorTaskManager.getInstance().addTask(this._task);
        }
        catch (Exception exception) {
            LogManager.getLogManager().getLogWindow().selectPage(LogManager.getLogManager().getMsgPage());
            LogManager.getLogManager().getLogWindow().activate();
            this.LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return this._exitCode;
    }

    private void doImport() {
        this.doImport(null);
    }

    private void doImport(RaptorTask<Void> raptorTask) {
        if (!this.doCreateTable()) {
            if (this._task != null) {
                this._task.getDescriptor().setMessage(this._exitCode.getShortMessage() + " " + this._exitCode.getMessage());
            }
            this._cancelled = true;
        } else {
            try {
                this.doInserts(this._task);
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
    }

    private boolean doCreateTable() {
        if (!this.isExistingTable()) {
            String string = this.getCreateTableStatementWithComments();
            string = string.replace(";", "");
            string = string.replace("\n", "  ");
            this._createTableSql.append(this.getDropTableStatement() + "\n");
            this._createTableSql.append("/*\n");
            this._createTableSql.append(string);
            this._createTableSql.append("*/\n");
            string = this.getCreateTableStatement();
            string = string.replace(";", "");
            string = string.replace("\n", "  ");
            boolean bl = this.pstmtExec(string);
            if (!bl) {
                this._exitCode.setShortMessage(DataImportArb.getString("STATEMENT_FAILED") + " ");
                return false;
            }
            Column[] columnArray = (Column[])this._iProps.get(ImportKeys.SELECTED_COLUMNS);
            for (int i = 0; i < columnArray.length; ++i) {
                if (columnArray[i] == null || columnArray[i].getComment() == null || columnArray[i].getComment().trim().length() <= 0) continue;
                string = this.getCommentStatement(this.getTableName(), columnArray[i].getName(), columnArray[i].getComment());
                bl = this.pstmtExec(string = string.replace(";", ""));
                if (bl) continue;
                return false;
            }
            this._isTableCreated = true;
        }
        return true;
    }

    private boolean pstmtExec(String string) {
        try {
            PreparedStatement preparedStatement = this.getConn().prepareStatement(string);
            preparedStatement.execute();
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            this._exitCode = ExitCode.EXIT_ERROR;
            this._exitCode.setMessage(string + " " + sQLException.getMessage());
            return false;
        }
        return true;
    }

    public void doInserts() throws ExecutionException {
        this.doInserts(null);
    }

    public void doInserts(RaptorTask<Void> raptorTask) throws ExecutionException {
        if (raptorTask != null) {
            this._task = raptorTask;
            this._progressUpdater = raptorTask.getRaptorTaskProgressUpdater();
        }
        try {
            this._reader = DataReaderRegistry.getReader(this._loadFile.getType());
            this._reader.setDataFormat((ImportDataFormat)this._iProps.get(ImportKeys.IMPORT_DATA_FORMAT));
            String string = this._loadFile.getName();
            this._reader.setFileName(string);
            if (this._iProps.get(ImportKeys.PAGEID) != null) {
                this._reader.setPage((Integer)this._iProps.get(ImportKeys.PAGEID));
            }
            int n = DBConfig.getInstance().getInt("IMPORT_INSERT_BATCH_SIZE");
            ArrayList<Object> arrayList = new ArrayList<Object>(n);
            int n2 = 0;
            int n3 = 1;
            int n4 = 0;
            int n5 = 0;
            StringBuffer stringBuffer = null;
            boolean bl = false;
            this._insCols = (Column[])this._iProps.get(ImportKeys.SELECTED_COLUMNS);
            try {
                int[] nArray;
                ImportDataFormat importDataFormat;
                Object[] objectArray = new String[]{};
                String string2 = this.getInsertStatementForPrepare(this.getTableName(), this._insCols, objectArray);
                this._insertForErrSql = this.getInsertStatementForError(this.getTableName(), this._insCols, objectArray);
                this.checkCanProceed();
                OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)this.getConn().prepareStatement(string2);
                this._reader.start();
                if (this._iProps.get(ImportKeys.PAGEID) != null) {
                    this._reader.setPage((Integer)this._iProps.get(ImportKeys.PAGEID));
                }
                if ((importDataFormat = this.getDataFormat()).getSkipRows() != 0) {
                    int n6 = importDataFormat.isHeader() ? importDataFormat.getSkipRows() + 1 : importDataFormat.getSkipRows();
                    for (int i = 0; i < n6 && this._reader.hasMoreRows() && !this._cancelled; ++i) {
                        try {
                            this._reader.readline();
                            continue;
                        }
                        catch (DataFormatException dataFormatException) {
                            // empty catch block
                        }
                    }
                } else if (importDataFormat.isHeader() && this._reader.hasMoreRows()) {
                    try {
                        this._reader.readline();
                    }
                    catch (DataFormatException dataFormatException) {
                        // empty catch block
                    }
                }
                while (this._reader.hasMoreRows() && (!this._isLoadLimit || n5 < this._loadRowsLimit)) {
                    stringBuffer = new StringBuffer();
                    StringBuffer stringBuffer2 = new StringBuffer();
                    try {
                        if (this._cancelled) break;
                        try {
                            objectArray = this._reader.readline();
                        }
                        catch (DataFormatException dataFormatException) {
                            stringBuffer.append("--" + dataFormatException.getMessage() + "\n");
                            objectArray = dataFormatException.getColumns();
                        }
                        if (objectArray != null) {
                            this.checkCanProceed();
                            bl = this.getBatchForInsert(this.getTableName(), this._insCols, objectArray, stringBuffer2, oraclePreparedStatement, stringBuffer);
                            if (bl) {
                                arrayList.add(stringBuffer2.toString());
                                ++n2;
                                ++n5;
                            }
                        }
                        if (n2 == n || stringBuffer.length() > 0 && n2 > 0) {
                            n4 = n3 + n2 - 1;
                            String string3 = DataImportArb.format("TASK_PROGRESS_INS2", "" + n3, "" + n4);
                            if (n3 == n4) {
                                string3 = DataImportArb.format("TASK_PROGRESS_INS", "" + n3);
                            }
                            this.setMessage(string3);
                            this.checkCanProceed();
                            nArray = oraclePreparedStatement.executeBatch();
                            this.processUpdateCounts(nArray, n2, n3, arrayList);
                            n2 = 0;
                            n4 = n3 = n4 + 1;
                            arrayList.clear();
                        }
                        if (stringBuffer.length() <= 0) continue;
                        arrayList.add(stringBuffer2.toString());
                        n4 = n3;
                        this.handleBatchUpdateException(new BatchUpdateException(stringBuffer.toString(), null), 1, n3, n4, arrayList);
                        arrayList.clear();
                        n4 = ++n3;
                    }
                    catch (BatchUpdateException batchUpdateException) {
                        this.handleBatchUpdateException(batchUpdateException, n2, n3, n4, arrayList);
                        n2 = 0;
                        n3 = n4 + 1;
                        arrayList.clear();
                        if (stringBuffer == null || stringBuffer.length() <= 0) continue;
                        arrayList.add(stringBuffer2.toString());
                        n4 = n3;
                        this.handleBatchUpdateException(new BatchUpdateException(stringBuffer.toString(), null), 1, n3, n4, arrayList);
                        arrayList.clear();
                        n4 = ++n3;
                    }
                }
                if (n2 != 0) {
                    n4 = n3 + n2 - 1;
                    String string4 = DataImportArb.format("TASK_PROGRESS_INS2", "" + n3, "" + n4);
                    if (n2 == 1) {
                        string4 = DataImportArb.format("TASK_PROGRESS_INS", "" + n4);
                    }
                    this.checkCanProceed();
                    this.setMessage(string4);
                    this.checkCanProceed();
                    nArray = oraclePreparedStatement.executeBatch();
                    this.processUpdateCounts(nArray, n2, n3, arrayList);
                }
            }
            catch (BatchUpdateException batchUpdateException) {
                this.handleBatchUpdateException(batchUpdateException, n2, n3, n4, arrayList);
            }
            catch (SQLException sQLException) {
                this.cancelTask();
            }
            this.checkCanProceed();
        }
        catch (DataReaderException dataReaderException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dataReaderException.getMessage(), dataReaderException);
            this.cancelTask();
        }
    }

    private void handleBatchUpdateException(BatchUpdateException batchUpdateException, int n, int n2, int n3, ArrayList<Object> arrayList) throws ExecutionException {
        ++this._errorCount;
        if (this._createTableSql != null && this._createTableSql.length() > 0) {
            this.outBad(this._createTableSql.toString());
            this._createTableSql = null;
        }
        int[] nArray = batchUpdateException.getUpdateCounts();
        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, batchUpdateException.getMessage(), batchUpdateException);
        String string = batchUpdateException.getMessage().startsWith("--") ? batchUpdateException.getMessage() : "--" + batchUpdateException.getMessage();
        String string2 = DataImportArb.format("TASK_PROGRESS_INS_FAIL2", " " + n2 + " ", " " + n3 + " ") + string;
        if (n == 1) {
            string2 = DataImportArb.format("TASK_PROGRESS_INS_FAIL", " " + n2 + " ") + string;
        }
        string2 = string2.substring(0, string2.length() - 1);
        String string3 = string2.replace("--", "");
        this.outBad("--" + string2);
        this.processUpdateCounts(nArray, n, n2, arrayList);
        if (!this.isBatch() && !this._isIgnoreAllErrors) {
            try {
                this.askContinueOnError(string3 + "\n\n" + DataImportArb.getString("TASK_PROGRESS_CONTINUE"));
            }
            catch (Throwable throwable) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, throwable.getStackTrace()[0].toString(), throwable);
                this.rollbackTask();
                this.requestCancel();
            }
        }
    }

    private void processUpdateCounts(int[] nArray, int n, int n2, ArrayList<Object> arrayList) {
        String string;
        if (nArray == null || nArray.length < 1) {
            int n3 = 0;
            while (n3 < n) {
                String string2 = DataImportArb.format("ROW", n2);
                this.outBad("--" + string2);
                string2 = (String)arrayList.get(n3);
                this.outBad(this._insertForErrSql + string2);
                ++n3;
                ++n2;
            }
            return;
        }
        int n4 = 0;
        while (n4 < nArray.length) {
            if (nArray[n4] < 0 && nArray[n4] != -2 && nArray[n4] == -3) {
                string = DataImportArb.format("ROW", n2);
                this.outBad("--" + string);
                string = (String)arrayList.get(n4);
                this.outBad(this._insertForErrSql + string);
            }
            ++n4;
            ++n2;
        }
        if (nArray.length < n) {
            n4 = nArray.length;
            while (n4 < n) {
                string = DataImportArb.format("ROW", n2);
                this.outBad("--" + string);
                string = (String)arrayList.get(n4);
                this.outBad(this._insertForErrSql + string);
                ++n4;
                ++n2;
            }
            return;
        }
    }

    private void checkCanProceed() throws ExecutionException {
        if (this._progressUpdater != null) {
            this._progressUpdater.checkCanProceed();
        }
    }

    private boolean requestCancel() {
        this._cancelled = true;
        if (this._task != null) {
            return this._task.requestCancel();
        }
        return false;
    }

    private void setMessage(String string) {
        if (this._task != null) {
            this._task.setMessage(string);
        }
    }

    private boolean lockConnectionForImport() {
        try {
            this._connLocked = Connections.getInstance().lock(this.getConn());
            if (!this._connLocked) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, DataImportArb.getString("LOCK_CONN_ERR"));
                this._exitCode = ExitCode.EXIT_SEVERE;
                this._exitCode.setShortMessage(DataImportArb.getString("LOCK_CONN_ERR"));
                return false;
            }
            this._autoCommit = this.getConn().getAutoCommit();
            this.getConn().setAutoCommit(false);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            this._exitCode = ExitCode.EXIT_SEVERE;
            this._exitCode.setShortMessage(exception.getMessage());
            return false;
        }
        return this._connLocked;
    }

    protected boolean cancelTask() {
        if (this._reader != null) {
            this._reader.closeFile();
        }
        this.rollbackTask();
        if (this._task != null) {
            boolean bl = this._task.requestCancel();
            return bl;
        }
        return true;
    }

    final void rollbackTask() {
        try {
            if (!this.getConn().isClosed() && this._connLocked) {
                this.getConn().rollback();
                if (this._isTableCreated && !this._isIgnoreAllErrors) {
                    String string = this.getDropTableStatementForPrepare();
                    PreparedStatement preparedStatement = this.getConn().prepareStatement(string);
                    preparedStatement.execute();
                    this.getConn().commit();
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void commitTask() {
        try {
            if (this._connLocked) {
                this.getConn().commit();
            }
        }
        catch (Exception exception) {
            this.LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void askContinueOnError(String string) throws Throwable {
        final String string2 = string;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    int n = MessageDialog.confirmOrCancel((Component)Ide.getMainWindow(), (Object)string2, (String)DataImportArb.getString("TASK_SHORT_NAME"), null);
                    if (n == -1) {
                        ImportGenInsertExec.this.requestCancel();
                    } else if (n == 1) {
                        ImportGenInsertExec.this._isIgnoreAllErrors = true;
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    ImportGenInsertExec.this.requestCancel();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
        }
    }

    private void outBad(String string) {
        try {
            this.getStream().printlnBad(string);
        }
        catch (Exception exception) {
            this.LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private String getDropTableStatement() {
        StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("DropTableStatement");
        stringTemplate.setAttribute("tableName", (Object)this.addUser(this.getTableName()));
        return stringTemplate.toString();
    }

    private String getDropTableStatementForPrepare() {
        StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("DropTableStatementForPrepare");
        stringTemplate.setAttribute("tableName", (Object)this.addUser(this.getTableName()));
        return stringTemplate.toString();
    }

    private boolean getBatchForInsert(String string, Column[] columnArray, Object[] objectArray, StringBuffer stringBuffer, OraclePreparedStatement oraclePreparedStatement, StringBuffer stringBuffer2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < columnArray.length; ++i) {
            if (columnArray[i].getSourceColID() < objectArray.length) {
                arrayList.add(objectArray[columnArray[i].getSourceColID()]);
                continue;
            }
            arrayList.add("");
        }
        Object[] objectArray2 = arrayList.toArray();
        String string2 = "(";
        ITypeFormattor iTypeFormattor = null;
        for (int i = 0; i < objectArray2.length; ++i) {
            iTypeFormattor = DataTypeFormatterRegistry.getInstance().getFormattor(columnArray[i].getType());
            if (iTypeFormattor == null) {
                iTypeFormattor = DataTypeFormatterRegistry.getInstance().getFormattor("VARCHAR2");
            }
            iTypeFormattor.setLocale((Locale)this._iProps.get(ImportKeys.LOCALE));
            iTypeFormattor.setConnection(this.getConn());
            try {
                stringBuffer.append(string2);
                stringBuffer.append(iTypeFormattor.formatData(objectArray2[i], columnArray[i]));
                Object object = iTypeFormattor.formatDataForJava(objectArray2[i], columnArray[i]);
                if (object != null && object instanceof String) {
                    String string3 = (String)object;
                    if (string3 == null || string3.length() == 0 || string3.equals("''") || string3.equals("NULL")) {
                        oraclePreparedStatement.setNull(i + 1, iTypeFormattor.getSqlType(columnArray[i].getType()));
                    } else {
                        if (columnArray[i].getType().equals("NCHAR") || columnArray[i].getType().equals("NVARCHAR2")) {
                            oraclePreparedStatement.setFormOfUse(i + 1, (short)2);
                        }
                        oraclePreparedStatement.setString(i + 1, string3);
                    }
                } else {
                    oraclePreparedStatement.setObject(i + 1, object, iTypeFormattor.getSqlType(columnArray[i].getType()));
                }
            }
            catch (Exception exception) {
                stringBuffer2.append(columnArray[i].getName() + " " + exception.getMessage() + " ");
            }
            string2 = ",";
        }
        stringBuffer.append(");");
        if (stringBuffer2.length() == 0) {
            try {
                oraclePreparedStatement.addBatch();
            }
            catch (Exception exception) {
                stringBuffer2.append(exception.getMessage());
            }
        }
        return stringBuffer2.length() == 0;
    }

    private Column getColumnFromSourceName(String string, Column[] columnArray) {
        if (string == null || columnArray == null) {
            return null;
        }
        for (int i = 0; i < columnArray.length; ++i) {
            if (columnArray[i].getSourceColumnName() == null || !columnArray[i].getSourceColumnName().equals(string)) continue;
            return columnArray[i];
        }
        return null;
    }

    public void closeFiles() {
        if (this._reader != null) {
            this._reader.closeFile();
        }
        this.getStream().finished();
        this.getStream().deleteEmptyFile();
        try {
            this.getStream().finishedBad();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    final class DBTaskListener
    extends RaptorTaskAdapter {
        private String _taskFullName;
        private String _msg = "";

        DBTaskListener(String string) {
            this._taskFullName = string;
        }

        public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
            RaptorTaskEvent raptorTaskEvent2 = raptorTaskEvent;
            if (raptorTaskEvent2.getTaskDescriptor().isCancelled()) {
                this._msg = this._taskFullName + ". ";
                this._msg = this._msg + DataImportArb.getString("TASK_CANCELLED_ROLLBACK");
                ImportGenInsertExec.this.LOGGER.log(Level.WARNING, this._msg);
            } else {
                this._msg = this._taskFullName + ". ";
                this._msg = this._msg + DataImportArb.getString("TASK_FAILED_ROLLBACK");
                ImportGenInsertExec.this.LOGGER.log(Level.SEVERE, this._msg);
            }
            ImportGenInsertExec.this.rollbackTask();
        }

        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            this._msg = this._taskFullName + ". ";
            this._msg = this._msg + DataImportArb.getString("TASK_CANCELLED_ROLLBACK");
            this._msg = this._msg + " " + raptorTaskEvent.getTaskDescriptor().getMessage();
            ImportGenInsertExec.this.LOGGER.log(Level.WARNING, this._msg);
            ImportGenInsertExec.this.rollbackTask();
            this.finish(this._msg);
        }

        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            RaptorTaskEvent raptorTaskEvent2 = raptorTaskEvent;
            if (raptorTaskEvent2.getTaskDescriptor().isCancelled() || ImportGenInsertExec.this._cancelled) {
                this._msg = this._taskFullName + ". ";
                this._msg = this._msg + DataImportArb.getString("TASK_CANCELLED_ROLLBACK");
                this._msg = this._msg + " " + raptorTaskEvent.getTaskDescriptor().getMessage();
                ImportGenInsertExec.this.outBad("-- " + this._msg);
            } else {
                try {
                    if (ImportGenInsertExec.this._connLocked) {
                        ImportGenInsertExec.this.getConn().commit();
                    }
                }
                catch (Exception exception) {
                    ImportGenInsertExec.this.LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }
            if (this._msg.length() == 0) {
                this._msg = this._taskFullName + ". " + DataImportArb.getString("TASK_SUCCEEDED_AND_COMMITTED");
            }
            this.finish(this._msg);
        }

        private void finish(String string) {
            ImportGenInsertExec.this.closeFiles();
            if (ImportGenInsertExec.this.getStream().isBadFileUsed()) {
                try {
                    ImportGen.openSqlNodeForURL(ImportGenInsertExec.this.getStream().geturlBad());
                }
                catch (Exception exception) {
                    ImportGenInsertExec.this.LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }
            ImportGenInsertExec.this.LOGGER.log(Level.INFO, Messages.getString("ImportGenerator.77"));
            this.showFinalMsg(this._msg);
        }

        private void showFinalMsg(String string) {
            if (!ImportGenInsertExec.this.isBatch()) {
                final String string2 = string == null || string.length() == 0 ? "" : string;
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            MessageDialog.information((Component)Ide.getMainWindow(), (Object)string2, (String)DataImportArb.getString("TASK_SHORT_NAME"), null);
                        }
                        catch (Exception exception) {
                            ImportGenInsertExec.this.LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                        }
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }
    }
}

