/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.validators;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.data.validators.CharValidator;
import oracle.dbtools.raptor.data.validators.DateValidator;
import oracle.dbtools.raptor.data.validators.ITypeValidator;
import oracle.dbtools.raptor.data.validators.NumberValidator;

public class DataTypeValidatorRegistry {
    private HashMap<String, DataTypeDef> _valMap = new HashMap();
    private static DataTypeValidatorRegistry INSTANCE;

    public synchronized void registerValidator(String string, Class<? extends ITypeValidator> clazz, boolean bl, boolean bl2, boolean bl3) {
        if (this._valMap == null) {
            this._valMap = new HashMap();
        }
        DataTypeDef dataTypeDef = new DataTypeDef(clazz, bl, bl2, bl3);
        this._valMap.put(string, dataTypeDef);
    }

    public synchronized void unregisterValidator(String string) {
        if (this._valMap != null) {
            this._valMap.remove(string);
        }
    }

    public ITypeValidator getValidator(String string) {
        if (this._valMap != null && string != null) {
            try {
                DataTypeDef dataTypeDef = this._valMap.get(string);
                if (dataTypeDef == null) {
                    return null;
                }
                ITypeValidator iTypeValidator = dataTypeDef.getHandler().newInstance();
                iTypeValidator.isPrecisionAllowed(dataTypeDef.isPrecisionAllowed());
                iTypeValidator.isScaleAllowed(dataTypeDef.isScaleAllowed());
                iTypeValidator.isScaleImported(dataTypeDef.isScaleImported());
                return iTypeValidator;
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
        return null;
    }

    private DataTypeValidatorRegistry() {
        this.registerValidator("NUMBER", NumberValidator.class, true, true, true);
        this.registerValidator("INTEGER", NumberValidator.class, false, false, false);
        this.registerValidator("LONG", NumberValidator.class, false, false, false);
        this.registerValidator("FLOAT", NumberValidator.class, false, false, true);
        this.registerValidator("CHAR", CharValidator.class, true, false, false);
        this.registerValidator("NCHAR", CharValidator.class, true, false, false);
        this.registerValidator("VARCHAR2", CharValidator.class, true, false, false);
        this.registerValidator("NVARCHAR2", CharValidator.class, true, false, false);
        this.registerValidator("DATE", DateValidator.class, false, false, false);
        this.registerValidator("TIMESTAMP WITH TIME ZONE", DateValidator.class, true, false, false);
        this.registerValidator("TIMESTAMP WITH LOCAL TIME ZONE", DateValidator.class, true, false, false);
        this.registerValidator("TIMESTAMP", DateValidator.class, true, false, false);
    }

    public static DataTypeValidatorRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DataTypeValidatorRegistry();
        }
        return INSTANCE;
    }

    public class DataTypeDef {
        boolean m_isPrecisionAllowed;
        boolean m_isScaleAllowed;
        boolean m_isScaleImported;
        Class<? extends ITypeValidator> m_handler;

        public DataTypeDef(Class<? extends ITypeValidator> clazz, boolean bl, boolean bl2, boolean bl3) {
            this.m_handler = clazz;
            this.m_isPrecisionAllowed = bl;
            this.m_isScaleAllowed = bl2;
            this.m_isScaleImported = bl3;
        }

        Class<? extends ITypeValidator> getHandler() {
            return this.m_handler;
        }

        public boolean isPrecisionAllowed() {
            return this.m_isPrecisionAllowed;
        }

        public void isPrecisionAllowed(boolean bl) {
            this.m_isPrecisionAllowed = bl;
        }

        public boolean isScaleAllowed() {
            return this.m_isScaleAllowed;
        }

        public void isScaleAllowed(boolean bl) {
            this.m_isScaleAllowed = bl;
        }

        public boolean isScaleImported() {
            return this.m_isScaleImported;
        }

        public void isScaleImported(boolean bl) {
            this.m_isScaleImported = bl;
        }
    }
}

