/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.data.model.LoadField;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.core.ColumnChangeEvent;
import oracle.dbtools.raptor.data.core.ColumnChangeListener;
import oracle.dbtools.raptor.data.core.DataType;
import oracle.dbtools.raptor.data.core.ImportDataFormat;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.data.core.ImportProperties;
import oracle.dbtools.raptor.data.ui.ColumnListPanel;
import oracle.dbtools.raptor.data.ui.ColumnPropertiesPanel;
import oracle.dbtools.raptor.data.ui.ColumnPropertyPanel;
import oracle.dbtools.raptor.data.ui.DataPreviewGizmo;
import oracle.dbtools.raptor.data.ui.KnownColumnPropertiesPanel;
import oracle.dbtools.raptor.data.validators.LoadFieldValidator;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.InvalidNameException;

public abstract class ColumnPanelAbstract
extends DefaultTraversablePanel
implements ColumnChangeListener {
    private static final long serialVersionUID = 8282169188783793125L;
    private static final Logger LOGGER = Logger.getLogger(ColumnPanelAbstract.class.getName());
    private static final String[] DATE_MASKS = new String[]{"DD-MON-RR", "RRRR-MM-DD", "RR-MM-DD", "RRRR-MON-DD", "RR-MON-DD", "YYYY-MM-DD", "YY-MM-DD", "YYYY-MON-DD", "YY-MON-DD"};
    private static final String[] TIMESTAMP_MASKS = new String[]{"YYYY-MM-DD HH24:MI:SS.FF", "YYYY-MM-DD HH24:MI:SS"};
    private static final String[] TIMESTAMPTZ_MASKS = new String[]{"YYYY-MM-DD HH24:MI:SS.FF TZH:TZM", "YYYY-MM-DD HH24:MI:SS.FF TZR"};
    private GenericTable genericTable;
    private JTextPane instructions;
    private JPanel matchPanel;
    private JComboBox matchBy;
    private ActionListener matchByListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColumnPanelAbstract.this.matchByType = ((JComboBox)actionEvent.getSource()).getSelectedIndex();
            ColumnPanelAbstract.this.refreshColumnData();
        }
    };
    private ColumnListPanel clp;
    protected DataPreviewGizmo gizmo;
    private boolean insertToExistingTable;
    private ColumnPropertyPanel colPropPanel;
    private GridBagConstraints cppConstraints = new GridBagConstraints(1, 2, 1, 1, 0.5, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0);
    private Column _column;
    private TraversableContext m_ctx;
    private boolean _isDetectedDefault = false;
    private boolean _isDefaultMax = false;
    private boolean _isRounded = true;
    private boolean isHeader;
    private boolean _isDetectiveInit = false;
    private boolean matchByInit = false;
    private int matchByType;
    private static int matchByName = 0;
    private static int matchByPosition = 1;
    protected int _loadMethod;
    protected ImportProperties _iProps;
    private LoadFile _loadFile;
    protected Locale _locale;
    private String[] datatypes;
    private Column[] _selectedColumns;
    boolean _isSelectedChanged = true;
    private String[] _dateMasks;
    private String[] _timestampMasks;
    private String[] _timestamptzMasks;

    protected abstract void updateExpectedTransition();

    protected int getLoadMethod() {
        return this._loadMethod;
    }

    protected void setLoadMethod(int n) {
        this._loadMethod = n;
    }

    protected TraversableContext getContext() {
        return this.m_ctx;
    }

    protected void isDetectedDefault(boolean bl) {
        this._isDetectedDefault = bl;
    }

    protected void setPrecisionProfile(boolean bl, boolean bl2, boolean bl3) {
        this._isDetectedDefault = bl;
        this._isDefaultMax = bl2;
        this._isRounded = bl3;
    }

    protected void detectFormat(Column column) {
        this.gizmo.detectFormat(column);
    }

    protected String[] getDateMasks() {
        return DATE_MASKS;
    }

    protected String[] getTimestampMasks() {
        return TIMESTAMP_MASKS;
    }

    protected String[] getTimestamptzMasks() {
        return TIMESTAMPTZ_MASKS;
    }

    protected void initDetective(DataPreviewGizmo dataPreviewGizmo) {
        dataPreviewGizmo.initDetective(this._locale, this._dateMasks, this._timestampMasks, this._timestamptzMasks);
    }

    public ColumnPanelAbstract() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.rowHeights = new int[]{7, 7, 7, 7, 0};
        this.setLayout(gridBagLayout);
        this._dateMasks = this.getDateMasks();
        this._timestampMasks = this.getTimestampMasks();
        this._timestamptzMasks = this.getTimestamptzMasks();
        this.instructions = new JTextPane();
        this.instructions.setEditable(false);
        this.instructions.setOpaque(false);
        this.instructions.setRequestFocusEnabled(false);
        this.instructions.setFocusable(false);
        this.add(this.instructions, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.matchPanel = new JPanel(new GridBagLayout());
        this.add(this.matchPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.clp = new ColumnListPanel();
        this.clp.getLstColumns().setSelectionModel(new SingleSelectionModel(){

            @Override
            public void updateSingleSelection(int n, int n2) {
                if (n >= 0) {
                    Column column = (Column)ColumnPanelAbstract.this.clp.getLstColumns().getModel().getElementAt(n);
                    if (ColumnPanelAbstract.this.colPropPanel != null && column != null) {
                        column.refreshData(ColumnPanelAbstract.this.colPropPanel.getColumnDetails());
                        Column column2 = (Column)ColumnPanelAbstract.this.clp.getLstColumns().getModel().getElementAt(n2);
                        if (column2 != null) {
                            LoadField loadField = ColumnPanelAbstract.this._loadFile.getFieldByName(column2.getSourceColumnName());
                            loadField.isChecked(true);
                        }
                        if (ColumnPanelAbstract.this.colPropPanel != null) {
                            ColumnPanelAbstract.this._column = column2;
                            ColumnPanelAbstract.this.colPropPanel.setColumn(column2);
                            ColumnPanelAbstract.this.gizmo.refreshOneCol(column2.getSourceColID());
                        }
                        ColumnPanelAbstract.this.clp.setCurrentSelection(n2);
                    }
                } else {
                    Column column = (Column)ColumnPanelAbstract.this.clp.getLstColumns().getModel().getElementAt(n2);
                    if (column != null) {
                        LoadField loadField = ColumnPanelAbstract.this._loadFile.getFieldByName(column.getSourceColumnName());
                        if (loadField != null) {
                            loadField.isChecked(true);
                        }
                        if (ColumnPanelAbstract.this.colPropPanel != null) {
                            ColumnPanelAbstract.this._column = column;
                            ColumnPanelAbstract.this.colPropPanel.setColumn(column);
                            ColumnPanelAbstract.this.gizmo.refreshOneCol(column.getSourceColID());
                        }
                        ColumnPanelAbstract.this.clp.setCurrentSelection(n2);
                    }
                }
            }
        });
        this.add(this.clp, new GridBagConstraints(0, 2, 1, 1, 0.5, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        if (traversableContext.getDirection() == 1) {
            ImportDataFormat importDataFormat;
            this.m_ctx = traversableContext;
            this._iProps = (ImportProperties)this.m_ctx.get("IMPORT_PROPERTIES");
            this._loadFile = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
            this.m_ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
            this._isSelectedChanged = this.isSelectedChanged();
            this._selectedColumns = (Column[])this._iProps.get(ImportKeys.SELECTED_COLUMNS);
            this.clp.onEntry(traversableContext);
            this.insertToExistingTable = (Boolean)this._iProps.get(ImportKeys.IS_EXISTING_TABLE);
            this.gizmo = (DataPreviewGizmo)this._iProps.get(ImportKeys.GIZMO);
            this.gizmo.onEntry(traversableContext);
            this._locale = (Locale)this._iProps.get(ImportKeys.LOCALE);
            if (this._isSelectedChanged || !this._isDetectiveInit) {
                this.initDetective(this.gizmo);
                this._isDetectiveInit = true;
            }
            this.populateDBO(traversableContext);
            if (!this.insertToExistingTable && !this._iProps.getValueBoolean(ImportKeys.IS_CONFIGFILE).booleanValue()) {
                this.gizmo.detectColumnDefinitions(this._loadFile);
            }
            this.setupColumnDetails(traversableContext);
            this.populateSrcDataColumns(traversableContext);
            if (this.insertToExistingTable) {
                importDataFormat = (ImportDataFormat)this._iProps.get(ImportKeys.IMPORT_DATA_FORMAT);
                if (!this.matchByInit || this._isSelectedChanged) {
                    JLabel jLabel = new JLabel();
                    jLabel.setText(DataImportArb.getString("MATCH_BY_LABEL"));
                    this.matchPanel.add((Component)jLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
                    String[] stringArray = new String[]{DataImportArb.getString("MATCH_BY_NAME"), DataImportArb.getString("MATCH_BY_POSITION"), DataImportArb.getString("MATCH_BY_NONE")};
                    this.matchBy = new JComboBox<String>(stringArray);
                    this.matchBy.addActionListener(this.matchByListener);
                    this.isHeader = importDataFormat.isHeader();
                    if (!this._iProps.getValueBoolean(ImportKeys.IS_CONFIGFILE).booleanValue()) {
                        if (this.isHeader) {
                            this.matchBy.setSelectedIndex(0);
                        } else {
                            this.matchBy.setSelectedItem(DataImportArb.getString("MATCH_BY_POSITION"));
                        }
                    } else {
                        this.matchBy.setSelectedIndex(this._iProps.getValueInteger(ImportKeys.MATCH_BY_TYPE));
                    }
                    this.matchPanel.add((Component)this.matchBy, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
                } else if (this.isHeader != importDataFormat.isHeader()) {
                    this.isHeader = importDataFormat.isHeader();
                }
                this.matchByInit = true;
            }
            this._column = (Column)this.clp.getLstColumns().getModel().getElementAt(0);
            importDataFormat = new Column();
            importDataFormat.refreshData(this._column);
            importDataFormat.setSourceColID(this._column.getSourceColID());
            importDataFormat.setSourceColumnName(this._column.getSourceColumnName());
            this.clp.setCurrentSelection(0);
            this.colPropPanel.setColumn((Column)importDataFormat);
            this.updateExpectedTransition();
        }
    }

    private boolean isSelectedChanged() {
        if (this._selectedColumns == null) {
            return true;
        }
        Column[] columnArray = (Column[])this._iProps.get(ImportKeys.SELECTED_COLUMNS);
        if (this._selectedColumns.length != columnArray.length) {
            return true;
        }
        for (Column column : columnArray) {
            if (this.getFromSelectedColumns(column) != null) continue;
            return true;
        }
        return false;
    }

    private Column getFromSelectedColumns(Column column) {
        for (Column column2 : this._selectedColumns) {
            if (!column2.getSourceColumnName().equals(column.getSourceColumnName())) continue;
            return column2;
        }
        return null;
    }

    private void refreshColumnData() {
        for (int i = 0; i < this.clp.getLstColumns().getModel().getSize(); ++i) {
            Column column = (Column)this.clp.getLstColumns().getModel().getElementAt(i);
            Column column2 = null;
            if (this.matchByType == matchByName) {
                column2 = this.genericTable.getTable().getFirstColumn();
                for (Column column3 : this.genericTable.getTable().getColumns()) {
                    if (column3.getName().equalsIgnoreCase(column.getSourceColumnName().trim())) {
                        column2 = column3;
                        break;
                    }
                    column2 = this.genericTable.getTable().getFirstColumn();
                }
            } else if (this.matchByType == matchByPosition) {
                try {
                    column2 = (Column)this.genericTable.getTable().getColumns().get(i);
                }
                catch (Exception exception) {
                    column2 = this.genericTable.getTable().getFirstColumn();
                }
            } else {
                column2 = this.genericTable.getTable().getFirstColumn();
            }
            if (this.insertToExistingTable && column2 == null) {
                column2 = this.genericTable.getTable().getFirstColumn();
            }
            column.refreshData(column2);
            if (column.getFormat() != null && column2.getFormat() != null && column2.getFormat().length() != 0) continue;
            this.detectFormat(column);
        }
        if (this.colPropPanel != null) {
            Column column = this.clp.getCurrentSelection();
            this.colPropPanel.setColumn(column);
        }
        this.clp.resetValidators();
        this.clp.repaint();
    }

    protected void setupColumnDetails(TraversableContext traversableContext) {
        this.setupColumnDetails(traversableContext, null);
    }

    protected void setupColumnDetails(TraversableContext traversableContext, DataType[] dataTypeArray) {
        ColumnPropertyPanel columnPropertyPanel;
        this._iProps = (ImportProperties)traversableContext.get("IMPORT_PROPERTIES");
        this._iProps.put(ImportKeys.DATE_MASKS, this._dateMasks);
        this._iProps.put(ImportKeys.TIMESTAMP_MASKS, this._timestampMasks);
        this._iProps.put(ImportKeys.TIMESTAMPTZ_MASKS, this._timestamptzMasks);
        if (this.colPropPanel != null) {
            this.remove(this.colPropPanel);
        }
        if (this.insertToExistingTable) {
            columnPropertyPanel = new KnownColumnPropertiesPanel(this._iProps);
            ((KnownColumnPropertiesPanel)columnPropertyPanel).setTable(this.genericTable, true);
            this.colPropPanel = columnPropertyPanel;
            this.add(columnPropertyPanel, this.cppConstraints);
            ((KnownColumnPropertiesPanel)columnPropertyPanel).addColumnChangeListener(this);
        } else {
            columnPropertyPanel = new ColumnPropertiesPanel(this._iProps, dataTypeArray);
            ((ColumnPropertiesPanel)columnPropertyPanel).setPrecisionProfile(this._isDetectedDefault, this._isDefaultMax, this._isRounded);
            this.colPropPanel = columnPropertyPanel;
            ((ColumnPropertiesPanel)columnPropertyPanel).setTable(this.genericTable);
            this.add(columnPropertyPanel, this.cppConstraints);
            if (this._loadMethod == 2 || this._loadMethod == 3) {
                ((ColumnPropertiesPanel)columnPropertyPanel).enableComment(false);
            } else {
                ((ColumnPropertiesPanel)columnPropertyPanel).enableComment(true);
            }
            ((ColumnPropertiesPanel)columnPropertyPanel).addColumnChangeListener(this);
        }
        columnPropertyPanel = this.clp.getCurrentSelection();
        if (columnPropertyPanel != null) {
            this.gizmo.refreshOneCol(this.genericTable.getTable().getColumnIndexByName(columnPropertyPanel.getSourceColumnName()));
        } else {
            this.gizmo.refreshOneCol(0);
        }
        this.validate();
    }

    protected void setNullVisible(boolean bl) {
        if (this.colPropPanel != null) {
            this.colPropPanel.setNullVisible(bl);
        }
    }

    protected void setDefaultVisible(boolean bl) {
        if (this.colPropPanel != null) {
            this.colPropPanel.setDefaultVisible(bl);
        }
    }

    protected void setCommentVisible(boolean bl) {
        if (this.colPropPanel != null) {
            this.colPropPanel.setCommentVisible(bl);
        }
    }

    protected void setNameEnabled(boolean bl) {
        if (this.colPropPanel != null) {
            this.colPropPanel.setNameEnabled(bl);
        }
    }

    protected void setPrecisionScaleEnabled(boolean bl) {
        if (this.colPropPanel != null) {
            this.colPropPanel.setPrecisionScaleEnabled(bl);
        }
    }

    protected void setPrecisionScaleVisible(boolean bl) {
        if (this.colPropPanel != null) {
            this.colPropPanel.setPrecisionScaleVisible(bl);
        }
    }

    protected void addColumnChangeListener(ColumnChangeListener columnChangeListener) {
        this.colPropPanel.addColumnChangeListener(columnChangeListener);
    }

    private void populateSrcDataColumns(TraversableContext traversableContext) {
        this._iProps = (ImportProperties)traversableContext.get("IMPORT_PROPERTIES");
        ((DefaultListModel)this.clp.getLstColumns().getModel()).clear();
        Column[] columnArray = (Column[])this._iProps.get(ImportKeys.SELECTED_COLUMNS);
        for (int i = columnArray.length - 1; i >= 0; --i) {
            this.clp.addColumn(columnArray[i]);
        }
        this.clp.getLstColumns().setSelectedIndex(0);
        Column column = this.clp.getCurrentSelection();
    }

    public Object getExitTransition() {
        int n = (Integer)this._iProps.get(ImportKeys.LOAD_METHOD);
        return n != 2 && n != 3 && n != 4;
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this._iProps = (ImportProperties)traversableContext.get("IMPORT_PROPERTIES");
        if (this.matchBy != null) {
            this._iProps.put(ImportKeys.MATCH_BY_TYPE, this.matchBy.getSelectedIndex());
        }
        if (traversableContext.getDirection() == 1) {
            for (LoadFieldValidator loadFieldValidator : (LoadFieldValidator[])this._iProps.get(ImportKeys.VALIDATORS)) {
                if (!loadFieldValidator.getLoadField().isLoad() || loadFieldValidator.getHighestExitCode() != ExitCode.EXIT_SEVERE) continue;
                throw new TraversalException(DataImportArb.getString("COLUMN_ON_EXIT_ERR"));
            }
        }
        LoadFieldValidator[] loadFieldValidatorArray = (LoadFieldValidator[])this.clp.getLstColumns().getSelectedValue();
        loadFieldValidatorArray.refreshData(this.colPropPanel.getColumnDetails());
        this.colPropPanel.setDateMask(loadFieldValidatorArray.getFormat());
    }

    private void validateColumnNames(TraversableContext traversableContext) throws TraversalException {
        this._iProps = (ImportProperties)traversableContext.get("IMPORT_PROPERTIES");
        Column[] columnArray = this.genericTable.getColumns();
        int n = 0;
        String string = "";
        String string2 = " ";
        DBObject dBObject = (DBObject)this._iProps.get(ImportKeys.DBOBJECT);
        Database database = dBObject.getDatabase();
        if (columnArray != null) {
            n = columnArray.length;
            for (int i = 0; i < n; ++i) {
                String string3 = columnArray[i].getName();
                try {
                    database.validateName("COLUMN", string3);
                    continue;
                }
                catch (InvalidNameException invalidNameException) {
                    string = string + string2 + string3;
                    if (string2.equals(" ")) {
                        this.clp.setCurrentSelection(i);
                    }
                    string2 = ",";
                }
            }
        }
        if (string.length() != 0) {
            throw new TraversalException(DataImportArb.format("COLUMN_NAMES_INVALID_ERROR", string));
        }
    }

    private void ensureSelectedColumnsHaveMapping(TraversableContext traversableContext) {
        this._iProps = (ImportProperties)traversableContext.get("IMPORT_PROPERTIES");
        Column[] columnArray = (Column[])this._iProps.get(ImportKeys.SELECTED_COLUMNS);
        int n = 0;
        if (columnArray != null) {
            n = columnArray.length;
            for (int i = 0; i < n; ++i) {
                if (columnArray[i].getName() != null && columnArray[i].getPrecision() > 0 && columnArray[i].getType() != null) continue;
                this.clp.setCurrentSelection(i);
            }
        }
    }

    private void populateDBO(TraversableContext traversableContext) {
        this._iProps = (ImportProperties)traversableContext.get("IMPORT_PROPERTIES");
        GenericTable genericTable = (GenericTable)this._iProps.get(ImportKeys.TABLE);
        if (this._iProps.get(ImportKeys.DBOBJECT) == null) {
            if (genericTable == null) {
                genericTable = new GenericTable();
                genericTable.setTableName((String)this._iProps.get(ImportKeys.TABLE_NAME));
                Column[] columnArray = (Column[])this._iProps.get(ImportKeys.FILE_COLUMNS);
                for (int i = columnArray.length - 1; i >= 0; --i) {
                    genericTable.addColumn(columnArray[i]);
                }
            }
        } else if (((DBObject)this._iProps.get(ImportKeys.DBOBJECT)).getObjectName() != null) {
            this.insertToExistingTable = true;
            DBObject dBObject = (DBObject)this._iProps.get(ImportKeys.DBOBJECT);
            if (genericTable == null) {
                try {
                    genericTable = new GenericTable(Connections.getInstance().getConnection((String)this._iProps.get(ImportKeys.CONNECTION_NAME)), dBObject.getSchemaName(), dBObject.getObjectName());
                }
                catch (DBException dBException) {
                    LOGGER.log(Level.SEVERE, dBException.getStackTrace()[0].toString(), dBException);
                }
            }
        } else if (genericTable == null) {
            genericTable = new GenericTable();
            genericTable.setTableName((String)this._iProps.get(ImportKeys.TABLE_NAME));
            genericTable = new GenericTable();
            genericTable.setTableName((String)this._iProps.get(ImportKeys.TABLE_NAME));
            Column[] columnArray = (Column[])this._iProps.get(ImportKeys.FILE_COLUMNS);
            for (int i = 0; i < columnArray.length; ++i) {
                genericTable.addColumn(columnArray[i]);
            }
        }
        this.setTable(genericTable);
        this.setInstruction((DBObject)this._iProps.get(ImportKeys.DBOBJECT));
    }

    private void setInstruction(DBObject dBObject) {
        if (dBObject != null && dBObject.getObjectName() != null) {
            this.instructions.setText(DataImportArb.getString("DATA_MAPPING_EXISTING_INFO"));
            return;
        }
        this.instructions.setText(DataImportArb.getString("DATA_MAPPING_CREATE_INFO"));
    }

    private void setTable(GenericTable genericTable) {
        this.genericTable = genericTable;
    }

    @Override
    public void columnChanged(ColumnChangeEvent columnChangeEvent) {
        Column column = columnChangeEvent.getColumn();
        this._column.refreshData(column);
        ColumnChangeEvent.Type type = columnChangeEvent.getType();
        switch (type) {
            case MAPPING: {
                this.clp.resetValidators(LoadFieldValidator.Test.MAPPED);
                this.clp.resetCurrentSelectionValidator();
                break;
            }
            case NAME: {
                this.clp.resetValidators(LoadFieldValidator.Test.COLUMN_NAME);
                break;
            }
            case DATATYPE: {
                if (this.colPropPanel != null) {
                    this.colPropPanel.setColumn(this._column);
                    if ((this._column.getType().equals(DataType.DATE.toString()) || this._column.getType().equals(DataType.TIMESTAMP.toString()) || this._column.getType().equals(DataType.TIMESTAMPTZ.toString()) || this._column.getType().equals(DataType.TIMESTAMPLTZ.toString())) && (this._column.getFormat() == null || this._column.getFormat().length() == 0)) {
                        this.detectFormat(this._column);
                        if (this._column.getFormat() != null && !this._column.getFormat().isEmpty()) {
                            this.colPropPanel.setDateMask(this._column.getFormat());
                        }
                    }
                }
                this.clp.resetCurrentSelectionValidator(new LoadFieldValidator.Test[]{LoadFieldValidator.Test.HAS_DATATYPE, LoadFieldValidator.Test.HAS_FORMAT, LoadFieldValidator.Test.COMPATIBLE_DATA});
                break;
            }
            case PRECISION: {
                this.clp.resetCurrentSelectionValidator(new LoadFieldValidator.Test[]{LoadFieldValidator.Test.HAS_SIZE, LoadFieldValidator.Test.COMPATIBLE_DATA});
                break;
            }
            case SCALE: {
                this.clp.resetCurrentSelectionValidator(new LoadFieldValidator.Test[]{LoadFieldValidator.Test.HAS_SIZE, LoadFieldValidator.Test.COMPATIBLE_DATA});
                break;
            }
            case FORMAT: {
                this.clp.resetCurrentSelectionValidator(new LoadFieldValidator.Test[]{LoadFieldValidator.Test.HAS_FORMAT, LoadFieldValidator.Test.COMPATIBLE_DATA});
                break;
            }
            case DATA: {
                this.clp.resetCurrentSelectionValidator(LoadFieldValidator.Test.COMPATIBLE_DATA);
                break;
            }
            default: {
                this.clp.resetValidators(LoadFieldValidator.Test.MAPPED);
            }
        }
        this.clp.repaint();
    }

    private class SingleSelectionModel
    extends DefaultListSelectionModel {
        public SingleSelectionModel() {
            this.setSelectionMode(0);
        }

        @Override
        public void setSelectionInterval(int n, int n2) {
            int n3 = this.getMinSelectionIndex();
            super.setSelectionInterval(n, n2);
            int n4 = this.getMinSelectionIndex();
            if (n3 != n4) {
                this.updateSingleSelection(n3, n4);
            }
        }

        public void updateSingleSelection(int n, int n2) {
        }
    }
}

