/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.readers;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.data.Messages;
import oracle.dbtools.raptor.data.readers.DataReaderException;
import oracle.dbtools.raptor.data.readers.XLSReader;
import oracle.dbtools.raptor.datatools.core.BaseDataFormat;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class XLSXReader
extends XLSReader {
    public static String NAME = Messages.getString("XLSXReader.0");
    public static final String FORMAT = BaseDataFormat.EXCELX;
    public static final String EXT = "xlsx";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getType() {
        return EXT;
    }

    @Override
    public String getFormat() {
        return FORMAT;
    }

    protected XSSFWorkbook newWorkbook(FileInputStream fileInputStream) throws DataReaderException {
        try {
            return new XSSFWorkbook((InputStream)fileInputStream);
        }
        catch (Throwable throwable) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, throwable.getStackTrace()[0].toString(), throwable);
            throw new DataReaderException(throwable.getMessage());
        }
    }
}

