/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.data.Messages;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CustomDateOrder {
    private static final String OTHER = Messages.getString("CustomDateOrder.0");
    private static CustomDateOrder INSTANCE;
    private ArrayList<String> strings = new ArrayList();
    private String xmlHeader = "<?xml version='1.0'  encoding='null' ?>\n";

    public static void main(String[] stringArray) {
    }

    private CustomDateOrder() {
        DBConfig dBConfig = DBConfig.getInstance();
        String string = dBConfig.getString("DATA_IMPORT_DATE_FORMAT");
        if (string == null) {
            this.setupDefaultFormats();
        } else {
            this.loadFormats(string);
        }
    }

    private void setupDefaultFormats() {
        this.addOrder("dd/mm/yyyy");
        this.addOrder("dd/mmm/yyyy");
        this.addOrder("dd/mmmm/yyyy");
        this.addOrder("dd/mmm");
        this.addOrder("dd//mm/yy");
        this.addOrder("yyyy/mmmm");
        this.addOrder("dd/mm/yyyy hh:nn");
        this.addOrder("dd/mm/yyyy hh:nn:ss");
        this.addOrder(OTHER);
        this.saveOrders();
    }

    private void loadFormats(String string) {
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(false);
        try {
            dOMParser.parse(string);
        }
        catch (XMLParseException xMLParseException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, xMLParseException.getStackTrace()[0].toString(), xMLParseException);
        }
        catch (SAXException sAXException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sAXException.getStackTrace()[0].toString(), sAXException);
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        this.strings.clear();
        XMLDocument xMLDocument = dOMParser.getDocument();
        if (xMLDocument != null) {
            Node node = xMLDocument.getFirstChild();
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                this.strings.add(XMLHelper.getNodeValue((Node)nodeList.item(i), (String)"FORMAT"));
            }
        }
    }

    private void saveOrders() {
        String string = this.xmlHeader;
        string = string + "<FORMATS>\n";
        Iterator<String> iterator = this.strings.iterator();
        while (iterator.hasNext()) {
            string = string + "<FORMAT>" + iterator.next() + "</FORMAT>";
        }
        string = string + "</FORMATS>\n";
        DBConfig dBConfig = DBConfig.getInstance();
        dBConfig.putString("DATA_IMPORT_DATE_FORMAT", string);
    }

    public static CustomDateOrder getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CustomDateOrder();
        }
        return INSTANCE;
    }

    public void addOrder(String string) {
        this.strings.remove(Messages.getString("CustomDateOrder.1"));
        this.strings.add(string);
        this.strings.add(OTHER);
    }

    public void removeOrder(String string) {
        this.strings.remove(string);
    }

    public String[] getOrders() {
        return this.strings.toArray(new String[this.strings.size()]);
    }
}

