/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.sqldialog;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.metadata.AbstractObjectActionPrompt;
import oracle.dbtools.raptor.utils.XLIFFHelper;
import oracle.dbtools.raptor.utils.XMLHelper;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ObjectActionPrompt
extends AbstractObjectActionPrompt {
    public ObjectActionPrompt() {
    }

    private ObjectActionPrompt(Node node, XLIFFHelper xLIFFHelper) {
        if (node.getNodeName().equalsIgnoreCase("prompt")) {
            this.setPrompt(XMLHelper.getNodeValue((Node)node, (String)"label"));
            this.setValue(XMLHelper.getNodeValue((Node)node, (String)"value"));
            this.setDefault(XMLHelper.getNodeValue((Node)node, (String)"default"));
            this.setType(XMLHelper.getAttributeNode((Node)node, (String)"type"));
            this.setRequired(XMLHelper.getAttributeNode((Node)node, (String)"required"));
            this.setReadOnly(Boolean.parseBoolean(XMLHelper.getAttributeNode((Node)node, (String)"readonly")));
            this.setValidator(XMLHelper.getAttributeNode((Node)node, (String)"validator"));
            this.setReload(XMLHelper.getAttributeNode((Node)node, (String)"reload"));
            this.setDataType(XMLHelper.getAttributeNode((Node)node, (String)"datatype"));
            this.setTypeAttribute(XMLHelper.getAttributeNode((Node)node, (String)"type_attrib"));
            if (xLIFFHelper != null) {
                this.setPrompt(xLIFFHelper.getTranslation(this.getPrompt()));
            }
        }
    }

    public static List<ObjectActionPrompt> getPrompts(Node node, XLIFFHelper xLIFFHelper) {
        ArrayList<ObjectActionPrompt> arrayList = new ArrayList<ObjectActionPrompt>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals("prompt")) continue;
            arrayList.add(new ObjectActionPrompt(node2, xLIFFHelper));
        }
        return arrayList;
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toXML(stringBuffer);
        return stringBuffer.toString();
    }

    public void toXML(StringBuffer stringBuffer) {
        stringBuffer.append("<prompt type=\"" + this.getType() + "\" ");
        if (this.getReload() != null) {
            stringBuffer.append("reload=\"" + this.getReload() + "\" ");
        }
        stringBuffer.append("required=\"" + this.isRequired() + "\" ");
        if (this.getValidator() != null) {
            stringBuffer.append("validator=\"" + this.getValidator() + "\" ");
        }
        stringBuffer.append(">");
        stringBuffer.append("\t<label>" + this.getPrompt() + "</label>");
        if (this.getDefault() != null) {
            stringBuffer.append("\t<default><![CDATA[" + this.getDefault() + "]]></default>");
        }
        if (this.getValue() != null) {
            stringBuffer.append("\t<value><![CDATA[" + this.getValue() + "]]></value>   ");
        }
        stringBuffer.append("\t</prompt>");
    }
}

