/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.sqldialog;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.text.JTextComponent;
import oracle.dbtools.raptor.controls.RadioGroupPanel;
import oracle.javatools.editor.BasicEditorPane;
import oracle.sql.Datum;

public final class ActionSql {
    private static final String DOUBLE_QUOTE = "\"";
    private static final String EMPTY_STRING = "";
    private static final String COMMA = ",";
    private static final String SINGLE_QUOTE = "'";
    private static final String ESCAPED_SINGLE_QUOTE = "''";
    private Map<String, Object> _dict;
    private String _origSql;
    private String _cleanedSql;
    private Map<String, Object> _binds;

    public static String manualSubstitute(String string, Map<String, ?> map) {
        String string2 = string;
        if (map != null) {
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                String string3 = entry.getKey();
                if (string2.toUpperCase().indexOf(string3.toUpperCase()) <= 0) continue;
                string2 = ActionSql.subHashMark(string2, string3, entry.getValue());
            }
        }
        return string2;
    }

    private static String subHashMark(String string, String string2, Object object) {
        String string3 = null;
        if (object == null) {
            string3 = EMPTY_STRING;
        } else if (object instanceof Datum) {
            try {
                string3 = ((Datum)object).stringValue();
            }
            catch (SQLException sQLException) {
                Logger.getLogger(ActionSql.class.getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
        }
        if (string3 == null) {
            string3 = object.toString();
        }
        String string4 = string;
        String string5 = null;
        try {
            String string6 = ActionSql.makeRegExLiteral(string2);
            if (ActionSql.matches(string4, ".*#" + string6 + "#.*")) {
                string5 = string3;
                string4 = string4.replaceAll("((?i)#" + string6 + "#)", Matcher.quoteReplacement(string5));
            } else if (ActionSql.matches(string4, ".*#\"" + string6 + "\"#.*")) {
                string5 = DOUBLE_QUOTE + string3 + DOUBLE_QUOTE;
                string4 = string4.replaceAll("((?i)#\"" + string6 + "\"#)", Matcher.quoteReplacement(string5));
            } else if (ActionSql.matches(string4, ".*#," + string6 + "#.*")) {
                string5 = EMPTY_STRING.equals(string3) ? EMPTY_STRING : COMMA + string3;
                string4 = string4.replaceAll("(?i)#," + string6 + "#", Matcher.quoteReplacement(string5));
            } else if (ActionSql.matches(string4, ".*#,\"" + string6 + "\"#.*")) {
                string5 = EMPTY_STRING.equals(string3) ? EMPTY_STRING : ",\"" + string3 + DOUBLE_QUOTE;
                string4 = string4.replaceAll("((?i)#,\"" + string6 + "\"#)", Matcher.quoteReplacement(string5));
            }
            if (string5 != null) {
                String string7 = ActionSql.makeRegExLiteral(string5);
                if (ActionSql.matches(string4, ".*#esc\\(" + string7 + "\\)#.*")) {
                    string4 = string4.replaceAll("((?i)#esc\\(" + string7 + "\\)#)", Matcher.quoteReplacement(string5.replaceAll(SINGLE_QUOTE, ESCAPED_SINGLE_QUOTE)));
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(ActionSql.class.getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return string4;
    }

    public static boolean matches(String string, String string2) {
        Pattern pattern = Pattern.compile(string2, 10);
        Matcher matcher = pattern.matcher(string);
        return matcher.find();
    }

    public static String makeRegExLiteral(String string) {
        return string == null || string.length() == 0 ? string : Pattern.quote(string);
    }

    public ActionSql() {
    }

    public ActionSql(String string, Map<String, Object> map) {
        this._origSql = string;
        this._dict = map;
    }

    public void clear() {
        this._origSql = null;
        this._dict = null;
    }

    public String directSubstuitions(String string) {
        return ActionSql.manualSubstitute(string, this._dict);
    }

    private void findNamedBinds() {
        if (this._dict != null) {
            Iterator<String> iterator = this._dict.keySet().iterator();
            String string = null;
            while (iterator.hasNext()) {
                string = iterator.next();
                if (this._cleanedSql.toLowerCase().indexOf(":" + string.toLowerCase()) <= 0) continue;
                this._binds.put(string, this._dict.get(string));
            }
        }
    }

    public String processPrompts(String string, List<JComponent> list, List<String> list2) {
        String string2 = string;
        String string3 = null;
        for (int i = 0; i < list.size(); ++i) {
            JComponent jComponent = list.get(i);
            if (jComponent == null) {
                string3 = EMPTY_STRING;
            } else if (jComponent instanceof JTextComponent) {
                string3 = ((JTextComponent)jComponent).getText();
            } else if (jComponent instanceof RadioGroupPanel) {
                string3 = ((RadioGroupPanel)jComponent).getSelectedValue();
            } else if (jComponent instanceof JComboBox) {
                Object object = ((JComboBox)jComponent).getSelectedItem();
                string3 = object != null ? object.toString() : EMPTY_STRING;
            } else if (jComponent instanceof JCheckBox) {
                string3 = ((JCheckBox)jComponent).isSelected() && list2.size() > i && list2.get(i) != null ? list2.get(i) : EMPTY_STRING;
            } else if (jComponent instanceof JScrollPane && ((JViewport)((JScrollPane)jComponent).getComponent(0)).getComponent(0) instanceof BasicEditorPane) {
                string3 = ((BasicEditorPane)((JViewport)((JScrollPane)jComponent).getComponent(0)).getComponent(0)).getText();
            }
            if (string2.indexOf(":" + i) > 0) {
                this._binds.put(Integer.toString(i), string3);
            }
            string2 = ActionSql.subHashMark(string2, i + EMPTY_STRING, string3);
        }
        return string2;
    }

    public void processSql() {
        this.processSql(null, null);
    }

    public void processSql(List<JComponent> list, List<String> list2) {
        this._binds = new HashMap<String, Object>();
        this._cleanedSql = this.directSubstuitions(this._origSql);
        this.findNamedBinds();
        if (list != null) {
            this._cleanedSql = this.processPrompts(this._cleanedSql, list, list2);
        }
    }

    public void setSql(String string) {
        this._origSql = string;
    }

    public void setDict(Map<String, Object> map) {
        this._dict = map;
    }

    public String getSql() {
        return this._cleanedSql;
    }

    public String getOrigSql() {
        return this._origSql;
    }

    public Map<String, Object> getBinds() {
        return this._binds;
    }

    public Map<String, Object> getDict() {
        return this._dict;
    }
}

