/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.listtable;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.raptor.controls.listtable.ListTableModel;

public abstract class ListTablePanel<T>
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ListTableModel<T> _tableModel;
    protected JTable _table;
    protected JScrollPane _tableScrollPane;
    protected List<Action> _actions = new ArrayList<Action>();

    public ListTablePanel(ListTableModel<T> listTableModel) {
        this.setName("ListTablePanel");
        this._tableModel = listTableModel;
        this.jbInit();
        this.initTablePanel();
        this.initializeData();
        this.updateView();
    }

    protected abstract void initTablePanel();

    protected void jbInit() {
        this._table = this.newTable();
        this._tableScrollPane = new JScrollPane();
        this._tableScrollPane.setName("ListTablePane");
        this._tableScrollPane.setViewportView(this._table);
        this.initializeListeners();
    }

    protected JTable newTable() {
        JTable jTable = new JTable(){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return super.getPreferredScrollableViewportSize();
            }
        };
        jTable.setName("ListTable");
        return jTable;
    }

    protected void initializeListeners() {
        this._table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListTablePanel.this.updateView();
            }
        });
    }

    protected void initializeData() {
        this._table.setModel(this._tableModel);
        this._tableModel.setTable(this._table);
    }

    public ListTableModel<T> getListTableModel() {
        return this._tableModel;
    }

    public void setListTableModel(ListTableModel<T> listTableModel) {
        if (null == listTableModel) {
            throw new NullPointerException();
        }
        if (this._tableModel != listTableModel) {
            this._tableModel = listTableModel;
            this.initializeData();
            this.updateView();
        }
    }

    protected void updateView() {
        for (Action action : this._actions) {
            action.setEnabled(action.isEnabled());
        }
    }

    public void setEditable(boolean bl) {
        if (this.isEditable() != bl) {
            this._tableModel.setEditable(bl);
            if (!bl && null != this._table && null != this._table.getCellEditor()) {
                this._table.getCellEditor().cancelCellEditing();
            }
            this.updateView();
        }
    }

    void stopEditing() {
        boolean bl = true;
        if (null != this._table && null != this._table.getCellEditor()) {
            bl = this._table.getCellEditor().stopCellEditing();
        }
        if (!bl) {
            throw new IllegalArgumentException();
        }
    }

    public boolean isEditable() {
        return this._tableModel.isEditable();
    }

    protected JScrollPane getTableScrollPane() {
        return this._tableScrollPane;
    }

    public JTable getTable() {
        return this._table;
    }

    public Component getInitialFocus() {
        if (null == this._table) {
            return this;
        }
        return this._table;
    }
}

