/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display.html;

import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.IErrorHandler;
import oracle.dbtools.raptor.controls.display.html.HtmlGenerationContext;
import oracle.dbtools.raptor.controls.display.html.IHtmlGenerator;
import oracle.dbtools.raptor.controls.display.html.ResourceGenerationContext;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryUtils;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DataTypesUtil;

public class TableHtmlGenerator
implements IHtmlGenerator {
    private static final Set<String> FILTER_COLS = new HashSet<String>(Arrays.asList("SDEV_LINK_NAME", "SDEV_LINK_TYPE", "SDEV_LINK_OWNER"));

    @Override
    public void generateStaticResources(ResourceGenerationContext resourceGenerationContext) {
        try {
            resourceGenerationContext.appendJavaScript(this.getClass().getResourceAsStream("generationresources/table.js"));
        }
        catch (Exception exception) {
            resourceGenerationContext.errorHandler().handleError(IErrorHandler.Category.OTHER, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateHtml(HtmlGenerationContext htmlGenerationContext) {
        DisplayModel displayModel = htmlGenerationContext.model();
        Connection connection = htmlGenerationContext.connection();
        Map<String, Object> map = htmlGenerationContext.binds();
        boolean bl = false;
        String string = (String)displayModel.getExtValues().get("TYPE");
        if (string != null && string.equalsIgnoreCase("vertical")) {
            bl = true;
        }
        String string2 = null;
        HashMap hashMap = null;
        Query query = displayModel.getQuery();
        if (query != null) {
            String string3;
            hashMap = query.getBindValues();
            if (map != null) {
                hashMap.putAll(map);
            }
            if ((string3 = query.getSql()) != null) {
                string2 = QueryUtils.expandQuery((String)string3, (Map)hashMap);
            }
        }
        boolean bl2 = false;
        if (string2 != null) {
            ResultSet resultSet = null;
            Connections.getInstance().lock(connection);
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(false);
                try {
                    SQLException sQLException;
                    resultSet = dBUtil.executeQuery(string2, (Map)hashMap);
                    if (resultSet != null) {
                        try {
                            if (bl) {
                                this.generateVerticalTable(htmlGenerationContext, resultSet);
                            } else {
                                this.generateHorizontalTable(htmlGenerationContext, resultSet);
                            }
                            bl2 = true;
                        }
                        finally {
                            DBUtil.closeResultSet((ResultSet)resultSet);
                        }
                    }
                    if (!htmlGenerationContext.errorHandler().hasErrors() && (sQLException = dBUtil.getLastException()) != null) {
                        htmlGenerationContext.errorHandler().handleError(IErrorHandler.Category.SQL, sQLException);
                    }
                }
                finally {
                    dBUtil.setRaiseError(true);
                }
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        if (!htmlGenerationContext.errorHandler().hasErrors() && !bl2) {
            this.generateEmptyTable(htmlGenerationContext);
        }
    }

    private void generateVerticalTable(HtmlGenerationContext htmlGenerationContext, ResultSet resultSet) {
        try {
            Writer writer = htmlGenerationContext.writer();
            this.generateTableTag(writer, htmlGenerationContext.id());
            this.generateTh(writer, "NAME");
            this.generateTh(writer, "VALUE");
            writer.write("</tr>\n");
            if (resultSet.next()) {
                Connection connection = htmlGenerationContext.connection();
                List<String> list = this.columnsNames(resultSet.getMetaData());
                for (String string : list) {
                    writer.write("<tr>\n");
                    this.generateTd(writer, string, false);
                    this.generateTd(connection, writer, resultSet.getObject(string), false);
                    writer.write("</tr>\n");
                }
            }
            writer.write("</table>\n");
        }
        catch (Exception exception) {
            htmlGenerationContext.errorHandler().handleError(IErrorHandler.Category.OTHER, exception);
        }
    }

    private void generateHorizontalTable(HtmlGenerationContext htmlGenerationContext, ResultSet resultSet) {
        try {
            Writer writer = htmlGenerationContext.writer();
            this.generateTableTag(writer, htmlGenerationContext.id());
            writer.write("<tr>\n");
            List<String> list = this.columnsNames(resultSet.getMetaData());
            for (String object2 : list) {
                this.generateTh(writer, object2);
            }
            writer.write("</tr>\n");
            Connection connection = htmlGenerationContext.connection();
            Map<String, Object> map = htmlGenerationContext.binds();
            boolean bl = htmlGenerationContext.isChildReport();
            boolean bl2 = htmlGenerationContext.model().hasChildren();
            int n = 0;
            int n2 = htmlGenerationContext.id();
            while (resultSet.next()) {
                String string;
                HashMap<String, Object> hashMap = new HashMap<String, Object>(map);
                String string2 = string = n == 0 ? " class=\"currentrow\"" : "";
                if (bl) {
                    writer.write("<tr onclick=\"table_onSelectRow(this, " + n2 + ")\"" + string + ">\n");
                } else {
                    writer.write("<tr onclick=\"table_onSelectMasterRow(this, " + n2 + ", " + n + ")\"" + string + ">\n");
                }
                for (String string3 : list) {
                    Object object = resultSet.getObject(string3);
                    if (bl2) {
                        hashMap.put(string3, object);
                    }
                    this.generateTd(connection, writer, object, n == 0);
                }
                writer.write("</tr>\n");
                htmlGenerationContext.addChildBinding(hashMap);
                ++n;
            }
            writer.write("</table>\n");
        }
        catch (Exception exception) {
            htmlGenerationContext.errorHandler().handleError(IErrorHandler.Category.OTHER, exception);
        }
    }

    private void generateEmptyTable(HtmlGenerationContext htmlGenerationContext) {
        try {
            Writer writer = htmlGenerationContext.writer();
            this.generateTableTag(writer, htmlGenerationContext.id());
            writer.write("</table>\n");
        }
        catch (Exception exception) {
            htmlGenerationContext.errorHandler().handleError(IErrorHandler.Category.OTHER, exception);
        }
    }

    private void generateTableTag(Writer writer, int n) throws IOException {
        writer.write("<table id=\"Table." + n + "\" cellpadding=\"0\" cellspacing=\"0\" summary=\"\">\n");
    }

    private void generateTd(Connection connection, Writer writer, Object object, boolean bl) throws IOException {
        String string = null;
        if (object == null) {
            string = "null";
        } else {
            String string2 = DataTypesUtil.stringValue((Object)object, (Connection)connection);
            if (string2.startsWith("SQLDEV:LINK")) {
                String string3 = ":";
                if (string2.startsWith("SQLDEV:LINK{")) {
                    string3 = string2.substring(string2.indexOf("{") + 1, string2.indexOf("}"));
                    string2 = string2.substring(string2.indexOf("}") + 1);
                } else if (string2.startsWith("SQLDEV:LINK:")) {
                    string2 = string2.substring(string2.indexOf("LINK:") + 5);
                }
                String[] stringArray = string2.split(string3);
                string2 = stringArray[stringArray.length - 2];
            }
            string = this.escape(string2);
        }
        this.generateTd(writer, string, bl);
    }

    private void generateTd(Writer writer, String string, boolean bl) throws IOException {
        String string2 = bl ? " class=\"currentcell\"" : "";
        writer.write("<td" + string2 + ">");
        writer.write(string.replace(" ", "&nbsp;"));
        writer.write("</td>\n");
    }

    private void generateTh(Writer writer, String string) throws IOException {
        writer.write("<th>");
        writer.write(string);
        writer.write("</th>\n");
    }

    private String escape(String string) {
        if (string != null) {
            return string.replaceAll("<", "&lt;");
        }
        return string;
    }

    private List<String> columnsNames(ResultSetMetaData resultSetMetaData) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (resultSetMetaData != null) {
            int n = resultSetMetaData.getColumnCount();
            for (int i = 1; i <= n; ++i) {
                String string = resultSetMetaData.getColumnName(i);
                if (FILTER_COLS.contains(string.toUpperCase())) continue;
                arrayList.add(string);
            }
        }
        return arrayList;
    }
}

