/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display.chart;

import java.awt.Color;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import oracle.dbtools.raptor.controls.display.chart.Alignment;
import oracle.dbtools.raptor.controls.display.chart.Archiver;
import oracle.dbtools.raptor.controls.display.chart.BooleanArchiver;
import oracle.dbtools.raptor.controls.display.chart.BooleanListArchiver;
import oracle.dbtools.raptor.controls.display.chart.ChartFont;
import oracle.dbtools.raptor.controls.display.chart.ChartFontArchiver;
import oracle.dbtools.raptor.controls.display.chart.ChartPropertyManagerImpl;
import oracle.dbtools.raptor.controls.display.chart.ChartType;
import oracle.dbtools.raptor.controls.display.chart.ColorListArchiver;
import oracle.dbtools.raptor.controls.display.chart.DoubleArchiver;
import oracle.dbtools.raptor.controls.display.chart.DoubleListArchiver;
import oracle.dbtools.raptor.controls.display.chart.EnumArchiver;
import oracle.dbtools.raptor.controls.display.chart.EnumListArchiver;
import oracle.dbtools.raptor.controls.display.chart.IntegerArchiver;
import oracle.dbtools.raptor.controls.display.chart.LabelSkipMode;
import oracle.dbtools.raptor.controls.display.chart.LineWidth;
import oracle.dbtools.raptor.controls.display.chart.LogarithmicBase;
import oracle.dbtools.raptor.controls.display.chart.NumberFormats;
import oracle.dbtools.raptor.controls.display.chart.NumberFormatsArchiver;
import oracle.dbtools.raptor.controls.display.chart.Property;
import oracle.dbtools.raptor.controls.display.chart.PropertyDef;
import oracle.dbtools.raptor.controls.display.chart.PropertyGroup;
import oracle.dbtools.raptor.controls.display.chart.PropertyType;
import oracle.dbtools.raptor.controls.display.chart.Rotation;
import oracle.dbtools.raptor.controls.display.chart.StringArchiver;
import oracle.dbtools.raptor.controls.display.chart.StringListArchiver;
import oracle.dbtools.raptor.controls.display.chart.TransparentColor;
import oracle.dbtools.raptor.controls.display.chart.TransparentColorArchiver;
import oracle.dss.graph.Graph;
import oracle.dss.graph.ReferenceObject;

class XAxisProperties
extends PropertyGroup {
    XAxisProperties() {
    }

    @Override
    void register(Map<PropertyType, PropertyDef> map) {
        BitSet bitSet = ChartType.all();
        bitSet.andNot(ChartType.polars());
        bitSet.andNot(ChartType.radars());
        map.put(PropertyType.XAXIS_TITLE, new PropertyDef<Boolean>(bitSet){
            private BooleanArchiver archiver;
            {
                this.archiver = new BooleanArchiver();
            }

            @Override
            Boolean getGraphValue(Graph graph) {
                return graph.getO1Title().isVisible();
            }

            @Override
            void setGraphValue(Graph graph, Boolean bl) {
                graph.getO1Title().setVisible(bl.booleanValue());
            }

            @Override
            Archiver<Boolean> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.XAXIS_TITLE_TEXT, new PropertyDef<String>(bitSet){
            private StringArchiver archiver;
            {
                this.archiver = new StringArchiver();
            }

            @Override
            String getGraphValue(Graph graph) {
                return graph.getO1Title().getText();
            }

            @Override
            void setGraphValue(Graph graph, String string) {
                graph.getO1Title().setText(string);
            }

            @Override
            Archiver<String> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.XAXIS_TITLE_ALIGNMENT, new PropertyDef<Alignment>(bitSet){
            private EnumArchiver<Alignment> archiver;
            {
                this.archiver = new EnumArchiver(Alignment.class, (Enum[])Alignment.values());
            }

            @Override
            Alignment getGraphValue(Graph graph) {
                return Alignment.get(graph.getO1Title().getHorizontalAlignment());
            }

            @Override
            void setGraphValue(Graph graph, Alignment alignment) {
                graph.getO1Title().setHorizontalAlignment(alignment.swingConstant());
            }

            @Override
            Archiver<Alignment> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.XAXIS_TITLE_FONT, new PropertyDef<ChartFont>(bitSet){
            private ChartFontArchiver archiver;
            {
                this.archiver = new ChartFontArchiver();
            }

            @Override
            PropertyType groupPropertyType() {
                return PropertyType.FONT;
            }

            @Override
            ChartFont getGraphValue(Graph graph) {
                return this.archiver.retrieveValue(graph.getO1Title().getGraphFont());
            }

            @Override
            void setGraphValue(Graph graph, ChartFont chartFont) {
                this.archiver.applyValue(chartFont, graph.getO1Title().getGraphFont());
            }

            @Override
            Archiver<ChartFont> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet2 = ChartType.all();
        bitSet2.andNot(ChartType.pies());
        bitSet2.andNot(ChartType.threeDs());
        map.put(PropertyType.XAXIS_LINE_COLOR, new PropertyDef<TransparentColor>(bitSet2){
            private TransparentColorArchiver archiver;
            {
                this.archiver = new TransparentColorArchiver();
            }

            @Override
            PropertyType groupPropertyType() {
                return PropertyType.FOREGROUND_COLOR;
            }

            @Override
            TransparentColor getGraphValue(Graph graph) {
                return new TransparentColor(false, graph.getO1Axis().getLineColor());
            }

            @Override
            void setGraphValue(Graph graph, TransparentColor transparentColor) {
                graph.getO1Axis().setLineColor(transparentColor.color());
            }

            @Override
            Archiver<TransparentColor> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet3 = ChartType.all();
        bitSet3.andNot(ChartType.pies());
        bitSet3.andNot(ChartType.threeDs());
        bitSet3.andNot(ChartType.polars());
        bitSet3.andNot(ChartType.radars());
        map.put(PropertyType.XAXIS_LINE_WIDTH, new PropertyDef<LineWidth>(bitSet3){
            private EnumArchiver<LineWidth> archiver;
            {
                this.archiver = new EnumArchiver(LineWidth.class, (Enum[])LineWidth.values());
            }

            @Override
            LineWidth getGraphValue(Graph graph) {
                return LineWidth.get(graph.getO1Axis().getLineWidth());
            }

            @Override
            void setGraphValue(Graph graph, LineWidth lineWidth) {
                graph.getO1Axis().setLineWidth(lineWidth.pixels());
            }

            @Override
            Archiver<LineWidth> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet4 = ChartType.vBars();
        bitSet4.or(ChartType.hBars());
        bitSet4.or(ChartType.lines());
        bitSet4.or(ChartType.areas());
        bitSet4.or(ChartType.combinations());
        bitSet4.or(ChartType.stocks());
        bitSet4.or(ChartType.paretos());
        bitSet4.or(ChartType.funnels());
        bitSet4.or(ChartType.radars());
        bitSet4.or(ChartType.threeDs());
        map.put(PropertyType.XAXIS_TICK_LABEL_SKIP_MODE, new PropertyDef<LabelSkipMode>(bitSet4){
            private EnumArchiver<LabelSkipMode> archiver;
            {
                this.archiver = new EnumArchiver(LabelSkipMode.class, (Enum[])LabelSkipMode.values());
            }

            @Override
            LabelSkipMode getGraphValue(Graph graph) {
                return LabelSkipMode.get(graph.getO1TickLabel().getTickLabelSkipMode());
            }

            @Override
            void setGraphValue(Graph graph, LabelSkipMode labelSkipMode) {
                graph.getO1TickLabel().setTickLabelSkipMode(labelSkipMode.graphConstant());
            }

            @Override
            Archiver<LabelSkipMode> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.XAXIS_TICK_LABEL_SKIP_COUNT, new PropertyDef<Integer>(bitSet4){
            private IntegerArchiver archiver;
            {
                this.archiver = new IntegerArchiver();
            }

            @Override
            Integer getGraphValue(Graph graph) {
                return graph.getO1TickLabel().getTickLabelSkipCount();
            }

            @Override
            void setGraphValue(Graph graph, Integer n) {
                graph.getO1TickLabel().setTickLabelSkipCount(n.intValue());
            }

            @Override
            Archiver<Integer> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.XAXIS_TICK_LABEL_SKIP_FIRST, new PropertyDef<Integer>(bitSet4){
            private IntegerArchiver archiver;
            {
                this.archiver = new IntegerArchiver();
            }

            @Override
            Integer getGraphValue(Graph graph) {
                return graph.getO1TickLabel().getTickLabelSkipFirst();
            }

            @Override
            void setGraphValue(Graph graph, Integer n) {
                graph.getO1TickLabel().setTickLabelSkipFirst(n.intValue());
            }

            @Override
            Archiver<Integer> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet5 = ChartType.all();
        map.put(PropertyType.XAXIS_TICK_LABEL_AUTO_ROTATE, new PropertyDef<Boolean>(bitSet5){
            private BooleanArchiver archiver;
            {
                this.archiver = new BooleanArchiver();
            }

            @Override
            Boolean getGraphValue(Graph graph) {
                return graph.getO1TickLabel().getAutomaticRotation() != 0;
            }

            @Override
            void setGraphValue(Graph graph, Boolean bl) {
                graph.getO1TickLabel().setAutomaticRotation(bl != false ? 2 : 0);
            }

            @Override
            Archiver<Boolean> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.XAXIS_TICK_LABEL_ROTATE, new PropertyDef<Rotation>(bitSet5){
            private EnumArchiver<Rotation> archiver;
            {
                this.archiver = new EnumArchiver(Rotation.class, (Enum[])Rotation.values());
            }

            @Override
            Rotation getGraphValue(Graph graph) {
                return Rotation.get(graph.getO1TickLabel().getTextRotation());
            }

            @Override
            void setGraphValue(Graph graph, Rotation rotation) {
                graph.getO1TickLabel().setTextRotation(rotation.graphConstant());
            }

            @Override
            Archiver<Rotation> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.XAXIS_TICK_LABEL_FONT, new PropertyDef<ChartFont>(bitSet5){
            private ChartFontArchiver archiver;
            {
                this.archiver = new ChartFontArchiver();
            }

            @Override
            PropertyType groupPropertyType() {
                return PropertyType.FONT;
            }

            @Override
            ChartFont getGraphValue(Graph graph) {
                return this.archiver.retrieveValue(graph.getO1TickLabel().getGraphFont());
            }

            @Override
            void setGraphValue(Graph graph, ChartFont chartFont) {
                this.archiver.applyValue(chartFont, graph.getO1TickLabel().getGraphFont());
            }

            @Override
            Archiver<ChartFont> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet6 = ChartType.pies();
        bitSet6.or(ChartType.scatters());
        bitSet6.or(ChartType.bubbles());
        bitSet6.or(ChartType.polars());
        map.put(PropertyType.XAXIS_SCALE_INCREMENT_AUTOMATIC, new PropertyDef<Boolean>(bitSet6){
            private BooleanArchiver archiver;
            {
                this.archiver = new BooleanArchiver();
            }

            @Override
            Boolean getGraphValue(Graph graph) {
                return graph.getX1Axis().isMajorTickStepAutomatic();
            }

            @Override
            void setGraphValue(Graph graph, Boolean bl) {
                graph.getX1Axis().setMajorTickStepAutomatic(bl.booleanValue());
            }

            @Override
            Archiver<Boolean> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.XAXIS_SCALE_INCREMENT, new PropertyDef<Double>(bitSet6){
            private DoubleArchiver archiver;
            {
                this.archiver = new DoubleArchiver();
            }

            @Override
            Double getGraphValue(Graph graph) {
                return graph.getX1Axis().getMajorTickStep();
            }

            @Override
            void setGraphValue(Graph graph, Double d) {
                graph.getX1Axis().setMajorTickStep(d.doubleValue());
            }

            @Override
            Archiver<Double> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet7 = ChartType.scatters();
        bitSet7.or(ChartType.bubbles());
        bitSet7.or(ChartType.polars());
        map.put(PropertyType.XAXIS_SCALE_MINIMUM_AUTOMATIC, new PropertyDef<Boolean>(bitSet7){
            private BooleanArchiver archiver;
            {
                this.archiver = new BooleanArchiver();
            }

            @Override
            Boolean getGraphValue(Graph graph) {
                return graph.getX1Axis().isAxisMinAutoScaled();
            }

            @Override
            void setGraphValue(Graph graph, Boolean bl) {
                graph.getX1Axis().setAxisMinAutoScaled(bl.booleanValue());
            }

            @Override
            Archiver<Boolean> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.XAXIS_SCALE_MINIMUM, new PropertyDef<Double>(bitSet7){
            private DoubleArchiver archiver;
            {
                this.archiver = new DoubleArchiver();
            }

            @Override
            Double getGraphValue(Graph graph) {
                return graph.getX1Axis().getAxisMinValue();
            }

            @Override
            void setGraphValue(Graph graph, Double d) {
                graph.getX1Axis().setAxisMinValue(d.doubleValue());
            }

            @Override
            Archiver<Double> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.XAXIS_SCALE_MAXIMUM_AUTOMATIC, new PropertyDef<Boolean>(bitSet7){
            private BooleanArchiver archiver;
            {
                this.archiver = new BooleanArchiver();
            }

            @Override
            Boolean getGraphValue(Graph graph) {
                return graph.getX1Axis().isAxisMaxAutoScaled();
            }

            @Override
            void setGraphValue(Graph graph, Boolean bl) {
                graph.getX1Axis().setAxisMaxAutoScaled(bl.booleanValue());
            }

            @Override
            Archiver<Boolean> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.XAXIS_SCALE_MAXIMUM, new PropertyDef<Double>(bitSet7){
            private DoubleArchiver archiver;
            {
                this.archiver = new DoubleArchiver();
            }

            @Override
            Double getGraphValue(Graph graph) {
                return graph.getX1Axis().getAxisMaxValue();
            }

            @Override
            void setGraphValue(Graph graph, Double d) {
                graph.getX1Axis().setAxisMaxValue(d.doubleValue());
            }

            @Override
            Archiver<Double> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet8 = ChartType.scatters();
        bitSet8.or(ChartType.bubbles());
        bitSet8.or(ChartType.polars());
        map.put(PropertyType.XAXIS_LOGARITHMIC_SCALE, new PropertyDef<Boolean>(bitSet8){
            private BooleanArchiver archiver;
            {
                this.archiver = new BooleanArchiver();
            }

            @Override
            Boolean getGraphValue(Graph graph) {
                return graph.getX1Axis().isScaledLogarithmic();
            }

            @Override
            void setGraphValue(Graph graph, Boolean bl) {
                graph.getX1Axis().setScaledLogarithmic(bl.booleanValue());
            }

            @Override
            Archiver<Boolean> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.XAXIS_LOGARITHMIC_BASE, new PropertyDef<LogarithmicBase>(bitSet8){
            private EnumArchiver<LogarithmicBase> archiver;
            {
                this.archiver = new EnumArchiver(LogarithmicBase.class, (Enum[])LogarithmicBase.values());
            }

            @Override
            LogarithmicBase getGraphValue(Graph graph) {
                return LogarithmicBase.get(graph.getX1Axis().getLogarithmicBase());
            }

            @Override
            void setGraphValue(Graph graph, LogarithmicBase logarithmicBase) {
                graph.getX1Axis().setLogarithmicBase(logarithmicBase.base());
            }

            @Override
            Archiver<LogarithmicBase> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet9 = ChartType.pies();
        bitSet9.or(ChartType.scatters());
        bitSet9.or(ChartType.bubbles());
        bitSet9.or(ChartType.polars());
        map.put(PropertyType.XAXIS_NUMBER_FORMATS, new PropertyDef<NumberFormats>(bitSet9){
            private NumberFormatsArchiver archiver;
            {
                this.archiver = new NumberFormatsArchiver();
            }

            @Override
            PropertyType groupPropertyType() {
                return PropertyType.NUMBER_FORMATS;
            }

            @Override
            NumberFormats getGraphValue(Graph graph) {
                return this.archiver.retrieveValue(graph.getX1Axis().getViewFormat());
            }

            @Override
            void setGraphValue(Graph graph, NumberFormats numberFormats) {
                this.archiver.applyValue(numberFormats, graph.getX1Axis().getViewFormat());
            }

            @Override
            Archiver<NumberFormats> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet10 = ChartType.scatters();
        bitSet10.or(ChartType.bubbles());
        bitSet10.or(ChartType.polars());
        map.put(PropertyType.XAXIS_REFOBJ_COUNT, new PropertyDef<Integer>(bitSet10){
            private IntegerArchiver archiver;
            {
                this.archiver = new IntegerArchiver();
            }

            @Override
            Integer getGraphValue(Graph graph) {
                return graph.getReferenceObjects(41).size();
            }

            @Override
            void setGraphValue(Graph graph, Integer n) {
                graph.destroyReferenceObjects(41);
                for (int i = 0; i < n; ++i) {
                    ReferenceObject referenceObject = graph.createReferenceObject();
                    referenceObject.setAssociation(41);
                }
            }

            @Override
            Archiver<Integer> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.XAXIS_REFOBJ_VISIBLE, new PropertyDef<List<Boolean>>(bitSet10){
            private BooleanListArchiver archiver;
            {
                this.archiver = new BooleanListArchiver(){

                    @Override
                    void verifyValue(ChartPropertyManagerImpl chartPropertyManagerImpl, List<Boolean> list) {
                        int n = chartPropertyManagerImpl.get(PropertyType.XAXIS_REFOBJ_COUNT, Integer.class);
                        if (list.size() != n) {
                            if (n == 0) {
                                Property<?> property = chartPropertyManagerImpl.property(PropertyType.XAXIS_REFOBJ_VISIBLE);
                                property.set(new ArrayList());
                            } else {
                                throw new IllegalArgumentException();
                            }
                        }
                    }

                    @Override
                    List<Boolean> createDefaultList(ChartPropertyManagerImpl chartPropertyManagerImpl) {
                        int n = chartPropertyManagerImpl.get(PropertyType.XAXIS_REFOBJ_COUNT, Integer.class);
                        ArrayList<Boolean> arrayList = new ArrayList<Boolean>(n);
                        for (int i = 0; i < n; ++i) {
                            arrayList.add(false);
                        }
                        return arrayList;
                    }
                };
            }

            @Override
            PropertyType[] dependencies() {
                return new PropertyType[]{PropertyType.XAXIS_REFOBJ_COUNT};
            }

            @Override
            List<Boolean> getGraphValue(Graph graph) {
                List list = graph.getReferenceObjects(41);
                ArrayList<Boolean> arrayList = new ArrayList<Boolean>(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    arrayList.add(((ReferenceObject)list.get(i)).isDisplayedInLegend());
                }
                return arrayList;
            }

            @Override
            void setGraphValue(Graph graph, List<Boolean> list) {
                List list2 = graph.getReferenceObjects(41);
                for (int i = 0; i < list2.size(); ++i) {
                    ((ReferenceObject)list2.get(i)).setDisplayedInLegend(list.get(i).booleanValue());
                }
            }

            @Override
            Archiver<List<Boolean>> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.XAXIS_REFOBJ_TEXT, new PropertyDef<List<String>>(bitSet10){
            private StringListArchiver archiver;
            {
                this.archiver = new StringListArchiver(){

                    @Override
                    void verifyValue(ChartPropertyManagerImpl chartPropertyManagerImpl, List<String> list) {
                        int n = chartPropertyManagerImpl.get(PropertyType.XAXIS_REFOBJ_COUNT, Integer.class);
                        if (list.size() != n) {
                            if (n == 0) {
                                Property<?> property = chartPropertyManagerImpl.property(PropertyType.XAXIS_REFOBJ_TEXT);
                                property.set(new ArrayList());
                            } else {
                                throw new IllegalArgumentException();
                            }
                        }
                    }

                    @Override
                    List<String> createDefaultList(ChartPropertyManagerImpl chartPropertyManagerImpl) {
                        int n = chartPropertyManagerImpl.get(PropertyType.XAXIS_REFOBJ_COUNT, Integer.class);
                        ArrayList<String> arrayList = new ArrayList<String>(n);
                        for (int i = 0; i < n; ++i) {
                            arrayList.add("");
                        }
                        return arrayList;
                    }
                };
            }

            @Override
            PropertyType[] dependencies() {
                return new PropertyType[]{PropertyType.XAXIS_REFOBJ_COUNT};
            }

            @Override
            List<String> getGraphValue(Graph graph) {
                List list = graph.getReferenceObjects(41);
                ArrayList<String> arrayList = new ArrayList<String>(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    arrayList.add(((ReferenceObject)list.get(i)).getText());
                }
                return arrayList;
            }

            @Override
            void setGraphValue(Graph graph, List<String> list) {
                List list2 = graph.getReferenceObjects(41);
                for (int i = 0; i < list2.size(); ++i) {
                    ((ReferenceObject)list2.get(i)).setText(list.get(i));
                }
            }

            @Override
            Archiver<List<String>> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.XAXIS_REFOBJ_LINE_VALUE, new PropertyDef<List<Double>>(bitSet10){
            private DoubleListArchiver archiver;
            {
                this.archiver = new DoubleListArchiver(){

                    @Override
                    void verifyValue(ChartPropertyManagerImpl chartPropertyManagerImpl, List<Double> list) {
                        int n = chartPropertyManagerImpl.get(PropertyType.XAXIS_REFOBJ_COUNT, Integer.class);
                        if (list.size() != n) {
                            if (n == 0) {
                                Property<?> property = chartPropertyManagerImpl.property(PropertyType.XAXIS_REFOBJ_LINE_VALUE);
                                property.set(new ArrayList());
                            } else {
                                throw new IllegalArgumentException();
                            }
                        }
                    }

                    @Override
                    List<Double> createDefaultList(ChartPropertyManagerImpl chartPropertyManagerImpl) {
                        int n = chartPropertyManagerImpl.get(PropertyType.XAXIS_REFOBJ_COUNT, Integer.class);
                        ArrayList<Double> arrayList = new ArrayList<Double>(n);
                        for (int i = 0; i < n; ++i) {
                            arrayList.add(0.0);
                        }
                        return arrayList;
                    }
                };
            }

            @Override
            PropertyType[] dependencies() {
                return new PropertyType[]{PropertyType.XAXIS_REFOBJ_COUNT};
            }

            @Override
            List<Double> getGraphValue(Graph graph) {
                List list = graph.getReferenceObjects(41);
                ArrayList<Double> arrayList = new ArrayList<Double>(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    arrayList.add(((Number)((ReferenceObject)list.get(i)).getLineValue()).doubleValue());
                }
                return arrayList;
            }

            @Override
            void setGraphValue(Graph graph, List<Double> list) {
                List list2 = graph.getReferenceObjects(41);
                for (int i = 0; i < list2.size(); ++i) {
                    ((ReferenceObject)list2.get(i)).setLineValue((Object)list.get(i));
                }
            }

            @Override
            Archiver<List<Double>> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.XAXIS_REFOBJ_COLOR, new PropertyDef<List<Color>>(bitSet10){
            private ColorListArchiver archiver;
            {
                this.archiver = new ColorListArchiver(){

                    @Override
                    void verifyValue(ChartPropertyManagerImpl chartPropertyManagerImpl, List<Color> list) {
                        int n = chartPropertyManagerImpl.get(PropertyType.XAXIS_REFOBJ_COUNT, Integer.class);
                        if (list.size() != n) {
                            if (n == 0) {
                                Property<?> property = chartPropertyManagerImpl.property(PropertyType.XAXIS_REFOBJ_COLOR);
                                property.set(new ArrayList());
                            } else {
                                throw new IllegalArgumentException();
                            }
                        }
                    }

                    @Override
                    List<Color> createDefaultList(ChartPropertyManagerImpl chartPropertyManagerImpl) {
                        int n = chartPropertyManagerImpl.get(PropertyType.XAXIS_REFOBJ_COUNT, Integer.class);
                        ArrayList<Color> arrayList = new ArrayList<Color>(n);
                        for (int i = 0; i < n; ++i) {
                            arrayList.add(Color.BLACK);
                        }
                        return arrayList;
                    }
                };
            }

            @Override
            PropertyType[] dependencies() {
                return new PropertyType[]{PropertyType.XAXIS_REFOBJ_COUNT};
            }

            @Override
            List<Color> getGraphValue(Graph graph) {
                List list = graph.getReferenceObjects(41);
                ArrayList<Color> arrayList = new ArrayList<Color>(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    arrayList.add(((ReferenceObject)list.get(i)).getColor());
                }
                return arrayList;
            }

            @Override
            void setGraphValue(Graph graph, List<Color> list) {
                List list2 = graph.getReferenceObjects(41);
                for (int i = 0; i < list2.size(); ++i) {
                    ((ReferenceObject)list2.get(i)).setColor(list.get(i));
                }
            }

            @Override
            Archiver<List<Color>> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.XAXIS_REFOBJ_WIDTH, new PropertyDef<List<LineWidth>>(bitSet10){
            private EnumListArchiver<LineWidth> archiver;
            {
                this.archiver = new EnumListArchiver<LineWidth>(LineWidth.class){

                    @Override
                    void verifyValue(ChartPropertyManagerImpl chartPropertyManagerImpl, List<LineWidth> list) {
                        int n = chartPropertyManagerImpl.get(PropertyType.XAXIS_REFOBJ_COUNT, Integer.class);
                        if (list.size() != n) {
                            if (n == 0) {
                                Property<?> property = chartPropertyManagerImpl.property(PropertyType.XAXIS_REFOBJ_WIDTH);
                                property.set(new ArrayList());
                            } else {
                                throw new IllegalArgumentException();
                            }
                        }
                    }

                    @Override
                    List<LineWidth> createDefaultList(ChartPropertyManagerImpl chartPropertyManagerImpl) {
                        int n = chartPropertyManagerImpl.get(PropertyType.XAXIS_REFOBJ_COUNT, Integer.class);
                        ArrayList<LineWidth> arrayList = new ArrayList<LineWidth>(n);
                        for (int i = 0; i < n; ++i) {
                            arrayList.add(LineWidth.THINNEST);
                        }
                        return arrayList;
                    }

                    @Override
                    Object getDefaultItem() {
                        return LineWidth.THINNEST;
                    }
                };
            }

            @Override
            PropertyType[] dependencies() {
                return new PropertyType[]{PropertyType.XAXIS_REFOBJ_COUNT};
            }

            @Override
            List<LineWidth> getGraphValue(Graph graph) {
                List list = graph.getReferenceObjects(41);
                ArrayList<LineWidth> arrayList = new ArrayList<LineWidth>(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    arrayList.add(LineWidth.get(((ReferenceObject)list.get(i)).getLineWidth()));
                }
                return arrayList;
            }

            @Override
            void setGraphValue(Graph graph, List<LineWidth> list) {
                List list2 = graph.getReferenceObjects(41);
                for (int i = 0; i < list2.size(); ++i) {
                    ((ReferenceObject)list2.get(i)).setLineWidth(list.get(i).pixels());
                }
            }

            @Override
            Archiver<List<LineWidth>> archiver() {
                return this.archiver;
            }
        });
    }
}

