/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.controls.display.IDisplayDetail;
import oracle.ide.util.ResourceUtils;

public class DisplayTableDetails
extends JPanel
implements IDisplayDetail {
    private static final long serialVersionUID = 1L;
    private JComboBox _type;
    private JTextPane _info;
    private String[] TABLE_TYPES = new String[]{Messages.getString("DisplayTableHorizontal"), Messages.getString("DisplayTableVertical")};

    public DisplayTableDetails() {
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this._type = new JComboBox();
        this._type.setModel(new DefaultComboBoxModel<String>(this.TABLE_TYPES));
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._type, (String)Messages.getString("DisplayTableDetails.0"));
        JTextPane jTextPane = new JTextPane();
        jTextPane.setOpaque(false);
        jTextPane.setRequestFocusEnabled(false);
        jTextPane.setFocusable(false);
        this._info = new JTextPane();
        this._info.setOpaque(false);
        this._info.setRequestFocusEnabled(false);
        this._info.setFocusable(false);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 6), 0, 0));
        jPanel.add((Component)this._type, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        int n = 0;
        this.add((Component)jTextPane, new GridBagConstraints(0, n, 1, 1, 1.0, 0.0, 23, 2, new Insets(10, 0, 20, 0), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 4, 10, 0), 0, 0));
        this.add((Component)this._info, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, ++n, 3, 3, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jTextPane.setText(Messages.getString("DisplayTableDetails.5"));
        jTextPane.setEditable(false);
        this._type.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int n = DisplayTableDetails.this._type.getSelectedIndex();
                if (n == 0) {
                    DisplayTableDetails.this._info.setText("");
                } else if (n == 1) {
                    DisplayTableDetails.this._info.setText(Messages.getString("DisplayTableDetails.4"));
                }
            }
        });
    }

    @Override
    public Map<String, String> getValues() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = this._type.getSelectedIndex();
        hashMap.put("TYPE", n == 0 ? "horizontal" : "vertical");
        return hashMap;
    }

    @Override
    public void setValues(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        String string = null;
        String string2 = map.get("TYPE");
        string = string2 != null && !string2.isEmpty() ? (string2.equalsIgnoreCase("vertical") ? this.TABLE_TYPES[1] : this.TABLE_TYPES[0]) : this.TABLE_TYPES[0];
        this._type.getModel().setSelectedItem(string);
    }
}

