/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ide.util.MetaClass;
import oracle.dbtools.raptor.controls.ControlsArb;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.SQLDevXMLFactory;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryCache;
import oracle.dbtools.raptor.support.MetaXMLReference;
import oracle.dbtools.raptor.utils.AbstractFolderedXml;
import oracle.dbtools.raptor.utils.XLIFFHelper;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.ide.editor.Editor;
import org.w3c.dom.Node;

public abstract class AbstractDisplayModelParser
extends AbstractFolderedXml {
    private static final String EDITOR_CLASS = "editorClass";
    private static Map<String, String[]> s_nodeTypeMap = new HashMap<String, String[]>();

    public static String[] getTypesForNode(String string) {
        return s_nodeTypeMap.get(string);
    }

    @Override
    public void openFolder(String string, String string2, String string3, MetaXMLReference metaXMLReference, XLIFFHelper xLIFFHelper) {
    }

    @Override
    public void closeFolder() {
    }

    @Override
    public void newNode(MetaXMLReference metaXMLReference, XLIFFHelper xLIFFHelper) {
        this.newItem(metaXMLReference, xLIFFHelper);
    }

    public DisplayModel createDisplayModelFromEditor(Node node, String string) {
        if (string != null && string.equals("editor")) {
            DisplayModel displayModel;
            String string2;
            DisplayModel displayModel2 = (DisplayModel)SQLDevXMLFactory.getInstance().createDisplayModel(node, this.getClass().getClassLoader(), null);
            if (displayModel2.getName() == null) {
                displayModel2.setName(XMLHelper.getNodeValue((Node)node, (String)"title"));
            }
            if (displayModel2.getType() == null) {
                displayModel2.setType(XMLHelper.getAttributeNode((Node)node, (String)"vertical"));
            }
            if (displayModel2.getStyle() == null) {
                displayModel2.setStyle(XMLHelper.getAttributeNode((Node)node, (String)"display"));
            }
            if ((string2 = XMLHelper.getAttributeNode((Node)XMLHelper.getChildNode((Node)node, (String)"query"), (String)"id")) != null && !string2.equals("")) {
                displayModel2.setQueries(QueryCache.getQueries((String)string2));
            } else {
                displayModel2.setQueries(Query.getQueries((Node)node));
            }
            if (XMLHelper.getChildNode((Node)node, (String)"bottomquery") != null) {
                displayModel = new DisplayModel();
                displayModel.setName(XMLHelper.getNodeValue((Node)XMLHelper.getChildNode((Node)node, (String)"bottomquery"), (String)"title"));
                string2 = XMLHelper.getAttributeNode((Node)XMLHelper.getChildNode((Node)XMLHelper.getChildNode((Node)node, (String)"bottomquery"), (String)"query"), (String)"id");
                if (string2 != null && !string2.equals("")) {
                    displayModel.setQueries(QueryCache.getQueries((String)string2));
                } else {
                    displayModel.setQueries(Query.getQueries((Node)XMLHelper.getChildNode((Node)node, (String)"bottomquery")));
                }
                displayModel2.addChild(displayModel);
            }
            if (XMLHelper.getChildNode((Node)node, (String)"subquery") != null) {
                displayModel = new DisplayModel();
                displayModel.setQueries(Query.getQueries((Node)XMLHelper.getChildNode((Node)node, (String)"subquery")));
                displayModel.setStyle(XMLHelper.getAttributeNode((Node)XMLHelper.getChildNode((Node)node, (String)"subquery"), (String)"type"));
                displayModel2.addChild(displayModel);
            }
            return displayModel2;
        }
        return new DisplayModel();
    }

    @Override
    public void newItem(MetaXMLReference metaXMLReference, XLIFFHelper xLIFFHelper) {
        String string;
        Object object;
        Node node = metaXMLReference.getNode();
        String string2 = XMLHelper.getAttributeNode((Node)node, (String)"type");
        String string3 = XMLHelper.getAttributeNode((Node)node, (String)"connType") == null ? "Oracle" : XMLHelper.getAttributeNode((Node)node, (String)"connType");
        String string4 = XMLHelper.getAttributeNode((Node)node, (String)"objectType");
        String[] stringArray = null;
        String[] stringArray2 = null;
        if (string3 != null && string3.indexOf(",") != -1) {
            stringArray2 = string3.split(",");
        } else if (string3 != null) {
            stringArray2 = new String[]{string3};
        }
        if (string4 == null) {
            object = XMLHelper.getAttributeNode((Node)node, (String)"node");
            if (object != null && (stringArray = s_nodeTypeMap.get(object)) == null) {
                LOGGER.warning(ControlsArb.format("AbstractDisplayModel_BogusNodeType", object));
            }
        } else {
            stringArray = string4.indexOf(",") != -1 ? string4.split(",") : new String[]{string4};
        }
        object = null;
        if (node.getNodeName().equals("display")) {
            object = xLIFFHelper != null ? DisplayModel.getDisplayModel(metaXMLReference, xLIFFHelper) : DisplayModel.getDisplayModel(metaXMLReference, null);
        } else if (string2 != null && string2.equals("editor")) {
            object = this.createDisplayModelFromEditor(node, string2);
        } else if (string2 != null && string2.equals("sharedQuery")) {
            string = XMLHelper.getAttributeNode((Node)node, (String)"id");
            QueryCache.putQuery((String)string, (List)Query.getQueries((Node)node));
        } else {
            object = DisplayModel.getDisplayModel(metaXMLReference, null);
        }
        if (string2 == null || !string2.equals("sharedQuery")) {
            MetaClass metaClass;
            string = object.getExtAttributes() == null ? null : (String)object.getExtAttributes().get(EDITOR_CLASS);
            MetaClass metaClass2 = metaClass = string != null ? new MetaClass(metaXMLReference.getReferenceClassLoader(), string) : null;
            if (stringArray != null) {
                for (String string5 : stringArray) {
                    for (String string6 : stringArray2) {
                        this.registerEditor(string6, string5, (DisplayModel)object, (MetaClass<? extends Editor>)metaClass);
                    }
                }
            }
        }
    }

    protected abstract void registerEditor(String var1, String var2, DisplayModel var3, MetaClass<? extends Editor> var4);

    static {
        s_nodeTypeMap.put("TableNode", new String[]{"TABLE"});
        s_nodeTypeMap.put("ViewNode", new String[]{"VIEW"});
        s_nodeTypeMap.put("MViewNode", new String[]{"MATERIALIZED_VIEW"});
        s_nodeTypeMap.put("PlSqlBaseNode", new String[]{"PROCEDURE", "FUNCTION", "PACKAGE", "PACKAGE BODY", "TYPE", "TYPE BODY"});
        s_nodeTypeMap.put("DatabaseLinkNode", new String[]{"DATABASE LINK"});
        s_nodeTypeMap.put("MViewLogNode", new String[]{"MATERIALIZED VIEW LOG"});
        s_nodeTypeMap.put("TriggerNode", new String[]{"TRIGGER"});
        s_nodeTypeMap.put("IndexNode", new String[]{"INDEX"});
        s_nodeTypeMap.put("RecycledObjectNode", new String[]{"RECYCLEBIN"});
        s_nodeTypeMap.put("DirectoryNode", new String[]{"DIRECTORY"});
        s_nodeTypeMap.put("QueueNode", new String[]{"QUEUE"});
        s_nodeTypeMap.put("QueueTableNode", new String[]{"QUEUE TABLE"});
        s_nodeTypeMap.put("JavaNode", new String[]{"JAVA"});
        s_nodeTypeMap.put("XmlSchemaNode", new String[]{"XML SCHEMA"});
        s_nodeTypeMap.put("FunctionNode", new String[]{"FUNCTION"});
    }
}

