/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.celleditor.popups;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.controls.celleditor.popups.ExtendedTypeEditPanel;
import oracle.dbtools.raptor.extendedtype.ExtendedType;
import oracle.dbtools.raptor.extendedtype.XMLExtendeType;
import oracle.dbtools.raptor.navigator.net.editor.XMLTypeBreakoutEditorAction;
import oracle.dbtools.raptor.navigator.net.editor.XMLTypeNodeFactory;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;
import oracle.ide.editor.EditorUtil;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.HyperlinkButton;
import oracle.sql.OPAQUE;

public class XMLTypeEditPanel
extends ExtendedTypeEditPanel {
    public XMLTypeEditPanel() {
        super((ExtendedType)new XMLExtendeType(null));
        this.localDataTextArea = this.savedDataTextArea;
    }

    @Override
    protected void createGUI() {
        this.savedDataTextArea.setEditable(false);
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.savedDataTextArea);
        jScrollPane.setPreferredSize(new Dimension(400, 300));
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setViewportBorder(null);
        this.add((Component)jScrollPane, "Center");
        JPanel jPanel = this.getButtonPanel();
        jPanel.setLayout(new FlowLayout(2));
        this.add((Component)jPanel, "South");
        this.showAsText(this.extendedType, true);
    }

    protected JPanel getButtonPanel() {
        this.buttonPanel.add((Component)this.getLoadButton(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.5, 10, 0, new Insets(10, 0, 10, 5), 0, 0));
        this.buttonPanel.add((Component)this.getSaveButton(), new GridBagConstraints(-1, 1, 1, 1, 0.0, 0.5, 10, 0, new Insets(10, 5, 10, 5), 0, 0));
        this.buttonPanel.add((Component)this.getSetNullButton(), new GridBagConstraints(-1, 1, 1, 1, 0.0, 0.5, 10, 0, new Insets(10, 5, 10, 5), 0, 0));
        this.buttonPanel.add((Component)this.getEditorButton(), new GridBagConstraints(-1, 1, 1, 1, 0.0, 0.5, 10, 0, new Insets(10, 5, 10, 5), 0, 0));
        return this.buttonPanel;
    }

    @Override
    protected String[][] getTableData() {
        return null;
    }

    protected HyperlinkButton getEditorButton() {
        ResourceUtils.resButton((AbstractButton)this.editorButton, (String)Messages.getString("ExtendedTypeEditPanel.33"));
        this.editorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                XMLTypeEditPanel.this.setXML();
            }
        });
        return this.editorButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setXML() {
        block13: {
            String string = this.savedDataTextArea.getText();
            if (string != null) {
                try {
                    Node node;
                    XMLExtendeType xMLExtendeType = (XMLExtendeType)this.extendedType;
                    final XMLTypeBreakoutEditorAction xMLTypeBreakoutEditorAction = new XMLTypeBreakoutEditorAction(xMLExtendeType, this.getBreakoutEditorListener());
                    URL uRL = null;
                    if (xMLExtendeType.getLoadFromURL() != null) {
                        uRL = xMLExtendeType.getLoadFromURL();
                    } else {
                        node = XMLTypeNodeFactory.lookupNode(xMLExtendeType);
                        if (node != null) {
                            uRL = node.getURL();
                        }
                    }
                    final Node node2 = XMLTypeNodeFactory.findOrCreate(uRL, xMLTypeBreakoutEditorAction);
                    if (node2 == null) break block13;
                    if (uRL == null && node2 instanceof TextNode) {
                        node = null;
                        try {
                            node = ((TextNode)node2).acquireTextBuffer();
                            node.beginEdit();
                            node.removeToEnd(0);
                            node.append(string.toCharArray());
                        }
                        finally {
                            if (node != null) {
                                node.endEdit();
                                ((TextNode)node2).releaseTextBuffer();
                                ((TextNode)node2).markDirty(false);
                            }
                        }
                    }
                    XMLTypeNodeFactory.cacheNode(xMLExtendeType, node2);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            xMLTypeBreakoutEditorAction.setEditor(EditorUtil.openDefaultEditorInFrame((Node)node2));
                        }
                    });
                    this.setEditorBrokeout(true);
                    this._dialog.closeDialog(true);
                }
                catch (IOException iOException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, illegalAccessException.getStackTrace()[0].toString(), illegalAccessException);
                }
                catch (InstantiationException instantiationException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, instantiationException.getStackTrace()[0].toString(), instantiationException);
                }
            }
        }
    }

    @Override
    protected void load() {
        String string = this.getFilePath();
        if (string != null) {
            URL uRL = URLFactory.newFileURL((String)string);
            ((XMLExtendeType)this.extendedType).setLoadFromURL(uRL);
            this.showAsText(this.extendedType, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean saveToDisk(URL uRL, RaptorTaskDescriptor raptorTaskDescriptor) {
        if (uRL != null) {
            try (OutputStream outputStream = URLFileSystem.openOutputStream((URL)uRL);){
                outputStream.write(this.savedDataTextArea.getText().getBytes());
            }
            catch (FileNotFoundException fileNotFoundException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, fileNotFoundException.getStackTrace()[0].toString(), fileNotFoundException);
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
        }
        return true;
    }

    private String getFilePath() {
        URLFileChooser uRLFileChooser = new URLFileChooser();
        uRLFileChooser.clearChooseableURLFilters();
        uRLFileChooser.setSelectionScope(0);
        uRLFileChooser.setSelectionMode(0);
        uRLFileChooser.setURLFilter((URLFilter)new DefaultURLFilter(Messages.getString("XMLTypeEditPanel.0"), new String[]{"xml", "XML"}));
        int n = uRLFileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("XMLTypeEditPanel.3"));
        if (n == 0) {
            return uRLFileChooser.getSelectedURL().getPath();
        }
        return null;
    }

    @Override
    public boolean processExtendedType() {
        return true;
    }

    @Override
    public JComponent getDefaultComponent() {
        return this;
    }

    @Override
    public String getHelpTopicId() {
        return null;
    }

    @Override
    public Object getValue() {
        if (this.extendedType == null || this.extendedType.isSetNULL()) {
            return null;
        }
        return this.extendedType;
    }

    @Override
    public void setValue(Object object) {
        if (object instanceof OPAQUE) {
            this.extendedType = new XMLExtendeType(null);
            ((XMLExtendeType)this.extendedType).setValue((OPAQUE)object);
        } else if (object instanceof String && ((String)object).length() > 0) {
            this.extendedType = new XMLExtendeType(null);
            ((XMLExtendeType)this.extendedType).setLoadFromURL(URLFactory.newFileURL((String)((String)object)));
        } else {
            this.extendedType = object instanceof XMLExtendeType ? (ExtendedType)object : new XMLExtendeType(null);
        }
        this.reload();
        this.showAsText(this.extendedType, true);
    }

    @Override
    protected void reload() {
        if (((XMLExtendeType)this.extendedType).getObjectValue() == null) {
            this.saveButton.setEnabled(false);
            this.extEditorButton.setEnabled(false);
        } else {
            this.saveButton.setEnabled(true);
            this.extEditorButton.setEnabled(true);
        }
    }
}

