/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.celleditor.popups;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.controls.TemporalController;
import oracle.dbtools.raptor.controls.celleditor.popups.AbstractPopupCellEditor;
import oracle.dbtools.raptor.datatypes.objects.OraTemporalDatum;
import oracle.dbtools.raptor.ui.controls.DateTimeEditor;
import oracle.javatools.ui.calendar.CalendarPanel;

public abstract class OracleTemporalEditPanel
extends AbstractPopupCellEditor {
    protected Object _initValue;
    protected OraTemporalDatum temporalDatum;
    protected static final int CALENDAR = 1;
    protected static final int TIME = 2;
    protected static final int NANOS = 4;
    protected static final int TIMEZONE = 8;
    protected static final int ALL_ON = 255;
    protected static final int ALL_OFF = 0;
    private JLabel _dateLabel;
    private JLabel _timeLabel;
    private JLabel _timezoneLabel;
    private JLabel _separator;
    private CalendarPanel _calPanel;
    private DateTimeEditor _timeEditor;
    protected TemporalController.NanoSpinner _nanoSpinner;
    private JComboBox _timezones;
    private JButton _today;
    private JButton _now;
    private JButton _reset;
    protected final int _features;
    private TemporalController temporalController;

    protected boolean isEnabled(int n) {
        return n == (this._features & n);
    }

    public OracleTemporalEditPanel(int n) {
        this._features = n;
        this.temporalDatum = this.getNow();
        this.temporalController = new TemporalController(this.temporalDatum, true);
        this.createDateTimeEditPanel(true);
    }

    public void createDateTimeEditPanel(boolean bl) {
        if (this.isEnabled(1)) {
            this._dateLabel = new JLabel(Messages.getString("TemporalEditPanel.1"));
            this._calPanel = this.temporalController.getCalendarPanel();
        }
        if (this.isEnabled(2) || this.isEnabled(4)) {
            this._timeLabel = new JLabel(Messages.getString("TemporalEditPanel.2"));
        }
        if (this.isEnabled(2)) {
            this._timeEditor = this.temporalController.getDateTimeEditor();
        }
        if (this.isEnabled(4)) {
            if (this.isEnabled(2)) {
                this._separator = new JLabel(Character.toString(this.temporalController.getDecimalSeparator()));
            }
            this._nanoSpinner = this.temporalController.getNanoSpinner();
        }
        if (this.isEnabled(8)) {
            this._timezoneLabel = new JLabel(Messages.getString("TemporalEditPanel.3"));
            this._timezones = this.temporalController.getTimeZoneComboBox();
        }
        Serializable serializable = new AbstractAction("Now"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OracleTemporalEditPanel.this.temporalDatum.setNow();
            }
        };
        this._now = new JButton((Action)((Object)serializable));
        this._now.setText(StringUtils.stripMnemonic((String)Messages.getString("TemporalEditPanel.6")));
        this._now.setMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("TemporalEditPanel.6")));
        serializable = new JPanel(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        if (this._dateLabel != null) {
            ((Container)serializable).add(this._dateLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (this._calPanel != null) {
            ((Container)serializable).add((Component)this._calPanel, new GridBagConstraints(0, 1, 1, 3, 0.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
        }
        if (this._timeLabel != null) {
            ((Container)serializable).add(this._timeLabel, new GridBagConstraints(1, 0, 3, 1, 0.0, 0.0, 18, 2, new Insets(0, 10, 0, 0), 0, 0));
        }
        if (this._timeEditor != null) {
            ((Container)serializable).add((Component)((Object)this._timeEditor), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 10, 0, 0), 0, 0));
        }
        if (this._separator != null) {
            ((Container)serializable).add(this._separator, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
        }
        if (this._nanoSpinner != null) {
            ((Container)serializable).add(this._nanoSpinner, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
        }
        if (this._timezoneLabel != null) {
            ((Container)serializable).add(this._timezoneLabel, new GridBagConstraints(1, 2, 3, 1, 0.0, 0.0, 18, 2, new Insets(10, 10, 0, 0), 0, 0));
        }
        if (this._timezones != null) {
            ((Container)serializable).add(this._timezones, new GridBagConstraints(1, 3, 3, 1, 0.0, 0.0, 18, 2, new Insets(5, 10, 0, 0), 0, 0));
        }
        if (jPanel != null) {
            ((Container)serializable).add(jPanel, new GridBagConstraints(0, 4, 4, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        }
        int n = 0;
        if (this._today != null) {
            jPanel.add((Component)this._today, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, n * 10, 0, 0), 0, 0));
            ++n;
        }
        if (this._now != null) {
            jPanel.add((Component)this._now, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, n * 10, 0, 0), 0, 0));
            ++n;
        }
        if (this._reset != null) {
            jPanel.add((Component)this._reset, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, n * 10, 0, 0), 0, 0));
            ++n;
        }
        this.add((Component)serializable);
        this.enableUI();
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String getHelpTopicId() {
        return "f1_extendeddataedit_html";
    }

    @Override
    public JComponent getDefaultComponent() {
        if (this._calPanel != null) {
            return this._calPanel;
        }
        if (this._timeEditor != null) {
            return this._timeEditor;
        }
        if (this._nanoSpinner != null) {
            return this._nanoSpinner;
        }
        if (this._timezones != null) {
            return this._timezones;
        }
        if (this._today != null) {
            return this._today;
        }
        if (this._now != null) {
            return this._now;
        }
        if (this._reset != null) {
            return this._reset;
        }
        return null;
    }

    protected boolean hasChanged() {
        return this._initValue == null || this.temporalController.hasChanged();
    }

    @Override
    public boolean isEditable() {
        return this.temporalController.isEditable();
    }

    @Override
    public boolean isNULL() {
        return false;
    }

    @Override
    public void setEditable(boolean bl) {
        this.temporalController.setEditable(bl);
        this.enableUI();
    }

    @Override
    public String validateValue() {
        return null;
    }

    protected void initValue(Object object, OraTemporalDatum oraTemporalDatum) {
        this._initValue = object;
        this.temporalDatum.replicate(oraTemporalDatum == null ? this.getNow() : oraTemporalDatum);
        this.temporalController.setChanged(false);
    }

    @Override
    public abstract void setValue(Object var1);

    @Override
    public Object getValue() {
        if (this.hasChanged()) {
            return this.temporalDatum.getDatum();
        }
        return this._initValue;
    }

    protected void reset() {
        this.setValue(this._initValue);
    }

    private void enableUI() {
        if (this._dateLabel != null) {
            this._dateLabel.setEnabled(this._calPanel != null ? this._calPanel.isEnabled() : false);
        }
        if (this._today != null) {
            this._today.setEnabled(this._calPanel != null ? this._calPanel.isEnabled() : false);
        }
        if (this._reset != null) {
            this._reset.setEnabled(this.temporalController.isEnabled());
        }
        if (this._timeLabel != null) {
            this._timeLabel.setEnabled(this._timeEditor != null ? this._timeEditor.isEnabled() : false);
        }
        if (this._separator != null) {
            this._separator.setEnabled(this._nanoSpinner != null ? this._nanoSpinner.isEnabled() : false);
        }
        if (this._now != null) {
            this._now.setEnabled(this.temporalController.isEnabled());
        }
        if (this._timezoneLabel != null) {
            this._timezoneLabel.setEnabled(this._timezones != null ? this._timezones.isEnabled() : false);
        }
    }

    protected static boolean areEqual(Object object, Object object2) {
        return object == object2 || object != null && object2 != null && object.equals(object2);
    }

    @Override
    public void setPopupDialog(JEWTDialog jEWTDialog) {
    }

    protected abstract OraTemporalDatum getNow();
}

