/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.celleditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.raptor.controls.SquareIconButton;
import oracle.dbtools.raptor.controls.celleditor.popups.PopupCellEditor;
import oracle.dbtools.raptor.controls.celleditor.popups.PopupCellEditorHandler;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import oracle.javatools.icons.OracleIcons;

public class RaptorTableEditorJPanel
extends JPanel {
    private boolean firstEdit = true;
    private EditorDelegate editorDelegate;
    private PopupCellEditor _popupEditor;
    private IdeAction _editAction;
    private static final int POPUP_CMD_ID = Ide.findOrCreateCmdID((String)"raptor.dataeditor.cell.popup");
    public static final String ACCEL_FILE = "oracle/dbtools/raptor/oviewer/base/accelerators2.xml";

    protected RaptorTableEditorJPanel() {
        super(new BorderLayout());
    }

    public RaptorTableEditorJPanel(PopupCellEditorHandler popupCellEditorHandler, JComponent jComponent, boolean bl, PopupCellEditor popupCellEditor) {
        this();
        this.init(popupCellEditorHandler, new EditorDelegate(jComponent){}, bl, popupCellEditor);
    }

    public RaptorTableEditorJPanel(PopupCellEditorHandler popupCellEditorHandler, final JTextField jTextField, boolean bl, PopupCellEditor popupCellEditor) {
        this();
        this.init(popupCellEditorHandler, new EditorDelegate(jTextField){

            @Override
            public void setEditable(boolean bl) {
                jTextField.setEditable(bl);
            }
        }, bl, popupCellEditor);
    }

    public RaptorTableEditorJPanel(PopupCellEditorHandler popupCellEditorHandler, final JComboBox jComboBox, boolean bl, PopupCellEditor popupCellEditor) {
        this();
        this.init(popupCellEditorHandler, new EditorDelegate(jComboBox){

            @Override
            public void setEditable(boolean bl) {
                jComboBox.setEditable(bl);
            }
        }, bl, popupCellEditor);
    }

    private static KeyStrokeContext getKeyStrokeContext() {
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        return keyStrokeContextRegistry.getContext(ACCEL_FILE);
    }

    protected void init(final PopupCellEditorHandler popupCellEditorHandler, EditorDelegate editorDelegate, boolean bl, PopupCellEditor popupCellEditor) {
        this.editorDelegate = editorDelegate;
        this.editorDelegate.setEditable(bl);
        this.add((Component)this.editorDelegate.getEditor(), "Center");
        this._popupEditor = popupCellEditor;
        if (popupCellEditor != null) {
            KeyStrokes keyStrokes;
            final SquareIconButton squareIconButton = new SquareIconButton();
            squareIconButton.setName("EditCell");
            squareIconButton.setMargin(new Insets(2, 2, 2, 2));
            AbstractAction abstractAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    popupCellEditorHandler.handlePopupEdit(RaptorTableEditorJPanel.this._popupEditor);
                }
            };
            abstractAction.putValue("SmallIcon", OracleIcons.getIcon((String)"edit.png"));
            squareIconButton.setAction(abstractAction);
            this.add((Component)squareIconButton, "East");
            KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
            KeyStrokeMap keyStrokeMap = keyStrokeOptions.getLocalKeyMap(RaptorTableEditorJPanel.getKeyStrokeContext());
            List list = keyStrokeMap.getKeyStrokesFor(POPUP_CMD_ID);
            if (list != null && !list.isEmpty() && (keyStrokes = (KeyStrokes)list.get(0)) != null && keyStrokes.getLength() > 0) {
                AbstractAction abstractAction2 = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        squareIconButton.doClick();
                    }
                };
                InputMap inputMap = this.getInputMap(1);
                inputMap.put(keyStrokes.getKeyStroke(0), "RaptorTableEditorJPanel.popEditor");
                this.getActionMap().put("RaptorTableEditorJPanel.popEditor", abstractAction2);
            }
        }
    }

    @Override
    public void requestFocus() {
        this.editorDelegate.requestFocus();
    }

    public void setPopup(PopupCellEditor popupCellEditor) {
        this._popupEditor = popupCellEditor;
    }

    public void setEditable(boolean bl) {
        this.editorDelegate.setEditable(bl);
    }

    public EditorDelegate getEditorDelegate() {
        return this.editorDelegate;
    }

    public abstract class EditorDelegate {
        JComponent editor;

        public EditorDelegate(JComponent jComponent) {
            this.editor = jComponent;
        }

        public JComponent getEditor() {
            return this.editor;
        }

        public void requestFocus() {
            this.editor.requestFocusInWindow();
        }

        public void setEditable(boolean bl) {
        }
    }
}

