/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.ui.URLFileChooser;

public class FilePanel
extends JPanel
implements ActionListener {
    protected static final long serialVersionUID = 1L;
    protected JTextField _fileName;
    private Component _parent;
    private JButton _browse;
    protected String _defaultName = "";
    private String _encoding;
    private boolean _includeAcc;
    protected int _selectionMode = 0;

    public FilePanel(Component component) {
        this(component, true);
    }

    public FilePanel(Component component, boolean bl) {
        this(component, bl, true);
    }

    public FilePanel(Component component, boolean bl, boolean bl2) {
        this._parent = component;
        this._includeAcc = bl;
        this.setLayout(new BorderLayout(6, 0));
        this._fileName = new JTextField(this._defaultName);
        this.add((Component)this._fileName, "Center");
        this._browse = new JButton(StringUtils.stripMnemonic((String)Messages.getString("FilePanel.1")));
        if (bl2) {
            this._browse.setMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("FilePanel.1")));
        }
        this._browse.addActionListener(this);
        this.add((Component)this._browse, "East");
        int n = Double.valueOf(this.getPreferredSize().getWidth()).intValue();
        Dimension dimension = new Dimension(n + 150, Double.valueOf(this.getPreferredSize().getHeight()).intValue());
        this.setSize(dimension);
        this.setPreferredSize(dimension);
        this.setMaximumSize(dimension);
    }

    public void prompt() {
        Object object;
        URLFileChooser uRLFileChooser = new URLFileChooser();
        uRLFileChooser.setSelectionScope(this._selectionMode);
        String string = this._fileName.getText();
        String string2 = this.getDefaultDir();
        if (string.equals("")) {
            String string3 = string2;
            try {
                if (this._selectionMode == 0) {
                    string3 = string3 + this.getDefaultName();
                }
                File file = new File(string3);
                uRLFileChooser.setSelectedFile(file);
            }
            catch (Exception exception) {
                object = new File(string3);
                uRLFileChooser.setSelectedFile((File)object);
            }
        } else {
            int n = string.lastIndexOf(File.separator);
            if (this._selectionMode == 0) {
                if (n > -1) {
                    uRLFileChooser.setSelectedFile(new File(string));
                } else {
                    uRLFileChooser.setSelectedFile(new File(this.getDefaultDir() + File.separator + string));
                }
            } else {
                uRLFileChooser.setSelectedFile(new File(""));
                if (n > -1) {
                    uRLFileChooser.setCurrentDirectory(new File(string));
                } else {
                    uRLFileChooser.setCurrentDirectory(new File(this.getDefaultDir() + File.separator + string));
                }
            }
        }
        if (this._includeAcc) {
            uRLFileChooser.showEncodings(true);
        }
        if (uRLFileChooser.showSaveDialog(this._parent, Messages.getString("FilePanel.2")) == 0) {
            String string4 = uRLFileChooser.getSelectedFile().toString();
            int n = string4.lastIndexOf(File.separator);
            object = string4.substring(n);
            if (this._selectionMode == 0) {
                if (((String)object).lastIndexOf(".") > -1) {
                    this._fileName.setText(uRLFileChooser.getSelectedFile().toString());
                } else {
                    this._fileName.setText(uRLFileChooser.getSelectedFile().toString() + ".sql");
                }
            } else {
                this._fileName.setText(uRLFileChooser.getSelectedFile().toString());
            }
            if (this._includeAcc) {
                this._encoding = uRLFileChooser.getEncoding();
            }
        }
    }

    public String getDefaultName() {
        String string = this.getDefaultDir();
        if (this._selectionMode == 0) {
            string = string + "export.sql";
        }
        return string;
    }

    public String getDefaultDir() {
        DBConfig dBConfig = DBConfig.getInstance();
        String string = dBConfig.getString("EXPORTDIR") + File.separator;
        if (string == null || string.equals("")) {
            string = System.getProperty("user.home");
        }
        return string;
    }

    public void setFileName(String string) {
        this._fileName.setText(string);
    }

    public String getFileName() {
        return this._fileName.getText();
    }

    public void setComponentsEnabled(boolean bl) {
        this._browse.setEnabled(bl);
        this._fileName.setEnabled(bl);
    }

    public String getEncoding() {
        return this._encoding;
    }

    public void setSelectionMode(int n) {
        this._selectionMode = n;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.prompt();
    }
}

