/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections.impexp;

import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.Icon;
import oracle.dbtools.raptor.connections.impexp.FilenamePanel;
import oracle.dbtools.raptor.connections.impexp.ImpExpEngine;
import oracle.dbtools.raptor.connections.impexp.ImpExpFile;
import oracle.dbtools.raptor.connections.impexp.Source;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.migration.CMConnectionsReader;
import oracle.jdeveloper.db.migration.ConnectionsInfo;

abstract class ImportSource
implements ImpExpFile,
Source {
    private URL m_url;
    protected ImpExpEngine.PasswordMode m_mode;
    protected String m_key;
    private Map<String, Properties> m_conns;

    static ImportSource createSource(URL uRL) throws ConnectionException {
        ImportSource importSource;
        if (FilenamePanel.PROPS_FILTER.accept(uRL)) {
            importSource = new LegacySource(uRL);
        } else {
            assert (FilenamePanel.XML_FILTER.accept(uRL));
            ConnectionsInfo connectionsInfo = ConnectionsInfo.getConnectionsInfo((URL)uRL);
            if (connectionsInfo.isLegacyCMFormat()) {
                importSource = new LegacySource(uRL);
            } else {
                importSource = new ConnectionStoreSource(uRL);
                if (!connectionsInfo.requiresPassphrase()) {
                    importSource.setMode(ImpExpEngine.PasswordMode.LEGACY);
                } else {
                    importSource.setMode(ImpExpEngine.PasswordMode.KEY);
                }
            }
        }
        return importSource;
    }

    protected ImportSource(URL uRL) {
        this.m_url = uRL;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String getLabel() {
        return URLFileSystem.getFileName((URL)this.m_url);
    }

    @Override
    public void setURL(URL uRL) {
        throw new UnsupportedOperationException();
    }

    @Override
    public URL getURL() {
        return this.m_url;
    }

    @Override
    public void setMode(ImpExpEngine.PasswordMode passwordMode) {
        this.clearConnections();
        this.m_mode = passwordMode;
    }

    @Override
    public final ImpExpEngine.PasswordMode getMode() {
        return this.m_mode;
    }

    @Override
    public void setKey(String string) {
        this.clearConnections();
        this.m_key = string;
    }

    @Override
    public final String getKey() {
        return this.m_key;
    }

    @Override
    public Icon getIcon() {
        return OracleIcons.getIcon((String)"xmlfile.png");
    }

    @Override
    public Collection<String> listAllConnections() throws ConnectionException {
        if (this.m_conns == null) {
            this.m_conns = this.loadConnections();
        }
        return this.m_conns.keySet();
    }

    @Override
    public Properties getConnectionProperties(String string) throws ConnectionException {
        if (this.m_conns == null) {
            this.m_conns = this.loadConnections();
        }
        return this.m_conns.get(string);
    }

    protected abstract Map<String, Properties> loadConnections() throws ConnectionException;

    protected void clearConnections() {
        this.m_conns = null;
    }

    protected boolean checkKey() {
        return true;
    }

    public final boolean isKeyValid() throws ConnectionException {
        if (this.m_conns == null) {
            this.m_conns = this.loadConnections();
        }
        return this.checkKey();
    }

    private static class ConnectionStoreSource
    extends ImportSource {
        private boolean mValidKey = true;

        protected ConnectionStoreSource(URL uRL) {
            super(uRL);
        }

        @Override
        protected Map<String, Properties> loadConnections() throws ConnectionException {
            DatabaseConnections databaseConnections;
            HashMap<String, Properties> hashMap = new HashMap<String, Properties>();
            boolean bl = false;
            String string = this.getKey();
            if (this.getMode() == ImpExpEngine.PasswordMode.LEGACY) {
                databaseConnections = DatabaseConnections.getLegacyPrivateInstance((URL)this.getURL());
            } else {
                databaseConnections = DatabaseConnections.getPrivateInstance((URL)this.getURL(), (String)string);
                if (this.getMode() == ImpExpEngine.PasswordMode.STRIP) {
                    bl = true;
                }
            }
            this.mValidKey = true;
            for (String string2 : databaseConnections.listConnections()) {
                Properties properties = databaseConnections.getProperties(string2);
                if (properties != null) {
                    String string3;
                    String string4;
                    if (bl) {
                        properties.put("SavePassword", Boolean.FALSE);
                    }
                    if (!bl && this.mValidKey && "Key".equals(string4 = properties.getProperty("ExportPasswordMode")) && !"ValidKey".equals(string3 = properties.getProperty("ExportKeyChecksum"))) {
                        this.mValidKey = false;
                    }
                    properties.remove("ExportPasswordMode");
                    properties.remove("ExportKeyChecksum");
                }
                hashMap.put(string2, properties);
            }
            return hashMap;
        }

        @Override
        protected boolean checkKey() {
            return this.mValidKey;
        }
    }

    static class LegacySource
    extends ImportSource {
        private boolean m_properties;

        protected LegacySource(URL uRL) {
            super(uRL);
            this.setMode(ImpExpEngine.PasswordMode.LEGACY);
            this.m_properties = FilenamePanel.PROPS_FILTER.accept(uRL);
        }

        @Override
        public Icon getIcon() {
            return this.m_properties ? OracleIcons.getIcon((String)"properties.png") : super.getIcon();
        }

        @Override
        protected Map<String, Properties> loadConnections() {
            URL uRL = this.getURL();
            HashMap<String, Properties> hashMap = new HashMap<String, Properties>();
            CMConnectionsReader cMConnectionsReader = new CMConnectionsReader(URLFileSystem.getPath((URL)uRL), true);
            for (Properties properties : cMConnectionsReader.read()) {
                String string = properties.getProperty("ConnectionName");
                if (string == null) continue;
                hashMap.put(string, properties);
            }
            return hashMap;
        }
    }
}

