/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections.impexp;

import java.net.URL;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.connections.impexp.FilenamePanel;
import oracle.dbtools.raptor.connections.impexp.ImpExpEngine;
import oracle.dbtools.raptor.connections.impexp.ImpExpFile;
import oracle.dbtools.raptor.connections.impexp.ImpExpResources;
import oracle.dbtools.raptor.connections.impexp.ImportSource;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.jdeveloper.db.ConnectionException;

class ImportFilenamePanel
extends FilenamePanel {
    private Object m_exitTransition = "Transition.Password";

    ImportFilenamePanel() {
    }

    @Override
    public Object getExitTransition() {
        return this.m_exitTransition;
    }

    @Override
    protected URLFileChooser.URLFileChooserPanel createChooserPanel() {
        URLFileChooser.URLFileChooserPanel uRLFileChooserPanel = URLFileChooser.createURLFileChooserPanel(0, ImpExpResources.getString("FILENAME_LABEL"), ImpExpResources.getString("CHOSER_TITLE_IMPORT"), true, true);
        uRLFileChooserPanel.clearChooseableURLFilters();
        uRLFileChooserPanel.addChooseableURLFilter(XML_FILTER);
        uRLFileChooserPanel.addChooseableURLFilter(PROPS_FILTER);
        return uRLFileChooserPanel;
    }

    @Override
    protected String getDescriptionText() {
        return ImpExpResources.getString("BOILERPLATE_IMPORT");
    }

    @Override
    protected void setURLInNamespace(URL uRL, TraversableContext traversableContext) throws TraversalException {
        try {
            ImportSource importSource = ImportSource.createSource(uRL);
            if (importSource.listAllConnections().size() == 0) {
                throw new TraversalException(ConnectionArb.format((String)"IMPORT_NO_CONNS", (Object[])new Object[]{URLFileSystem.getPlatformPathName((URL)uRL)}), ConnectionArb.getString((String)"IMPEXP_BAD_FILE_TITLE"));
            }
            this.m_exitTransition = importSource.getMode() == ImpExpEngine.PasswordMode.LEGACY ? "Transition.SelectConnections" : "Transition.Password";
            traversableContext.put("ImportExport.SOURCE", (Object)importSource);
        }
        catch (ConnectionException connectionException) {
            throw new TraversalException(ConnectionArb.format((String)"IMPORT_NO_CONNS", (Object[])new Object[]{URLFileSystem.getPlatformPathName((URL)uRL)}), ConnectionArb.getString((String)"IMPEXP_BAD_FILE_TITLE"));
        }
    }

    @Override
    protected URL getURLFromNamespace(TraversableContext traversableContext) {
        ImpExpFile impExpFile = (ImpExpFile)traversableContext.get("ImportExport.SOURCE");
        return impExpFile != null ? impExpFile.getURL() : null;
    }

    @Override
    boolean isURLAccepted(URL uRL) {
        return XML_FILTER.accept(uRL) || PROPS_FILTER.accept(uRL);
    }

    @Override
    protected void validateURL(URL uRL) throws TraversalException {
        super.validateURL(uRL);
        if (!URLFileSystem.exists((URL)uRL)) {
            throw new TraversalException(ImpExpResources.format("ERROR_CANNOT_READ_FILE", URLFileSystem.getPlatformPathName((URL)uRL)), ConnectionArb.getString((String)"IMPEXP_BAD_FILE_TITLE"));
        }
    }

    @Override
    public String getHelpID() {
        return "f1_idedimportcxn_html";
    }

    @Override
    protected Boolean getBackButtonState(TraversableContext traversableContext) {
        return null;
    }

    @Override
    protected Boolean getNextButtonState(TraversableContext traversableContext) {
        return Boolean.TRUE;
    }

    @Override
    protected Boolean getFinishButtonState(TraversableContext traversableContext) {
        return null;
    }
}

