/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections.impexp;

import oracle.dbtools.raptor.connections.impexp.Destination;
import oracle.dbtools.raptor.connections.impexp.FinishPanel;
import oracle.dbtools.raptor.connections.impexp.ImpExpEngine;
import oracle.dbtools.raptor.connections.impexp.ImpExpResources;
import oracle.dbtools.raptor.connections.impexp.ImportConnectionListPanel;
import oracle.dbtools.raptor.connections.impexp.ImportDestination;
import oracle.dbtools.raptor.connections.impexp.ImportFilenamePanel;
import oracle.dbtools.raptor.connections.impexp.ImportPasswordPanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.Step;
import oracle.jdeveloper.db.DatabaseConnections;

class ImportEngine
extends ImpExpEngine {
    private DatabaseConnections m_destStore;

    ImportEngine(DatabaseConnections databaseConnections) {
        this.m_destStore = databaseConnections;
    }

    @Override
    protected FSM createFSM() {
        FSMBuilder fSMBuilder = new FSMBuilder();
        Step step = new Step(ImpExpResources.get("TITLE_SOURCE"), ImportFilenamePanel.class, null);
        fSMBuilder.newStartState(step, null);
        fSMBuilder.addStateTrans((Object)"Transition.Password", (Object)"State.Password");
        fSMBuilder.addStateTrans((Object)"Transition.SelectConnections", (Object)"State.SelectConnections");
        Step step2 = new Step(ImpExpResources.get("TITLE_PASSWORD_HANDLING"), ImportPasswordPanel.class, null);
        fSMBuilder.newState((Object)"State.Password", step2, (Object)"State.SelectConnections");
        Step step3 = new Step(ImpExpResources.get("TITLE_CONNECTIONS_SELECTION"), ImportConnectionListPanel.class, null);
        fSMBuilder.newState((Object)"State.SelectConnections", step3, (Object)"State.Finish");
        Step step4 = new Step(ImpExpResources.getString("TITLE_SUMMARY"), FinishPanel.class, null);
        fSMBuilder.newFinalState((Object)"State.Finish", step4);
        try {
            return fSMBuilder.getFSM();
        }
        catch (FSMInvalidException fSMInvalidException) {
            fSMInvalidException.printStackTrace();
            return null;
        }
    }

    @Override
    protected String getDialogTitle() {
        return ImpExpResources.getString("TITLE_IMPORT_DIALOG");
    }

    @Override
    protected void initNamespace(Namespace namespace) {
        namespace.put("ImportExport.DESTINATION", (Object)new ImportDestination(this.m_destStore));
    }

    @Override
    protected void performAction(TraversableContext traversableContext) throws TraversalException {
        Destination destination = (Destination)traversableContext.get("ImportExport.DESTINATION");
        destination.commitChanges();
    }
}

