/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections.impexp;

import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.JDialog;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.dbtools.raptor.connections.impexp.ExportEngine;
import oracle.dbtools.raptor.connections.impexp.ImportEngine;
import oracle.dbtools.raptor.export.wizard.ExportWizArb;
import oracle.ide.Ide;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.CommitListener;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMWizard;
import oracle.jdeveloper.db.DatabaseConnections;

public abstract class ImpExpEngine {
    public static final String EXPORT_PASSWORD_CHECKSUM = "ExportKeyChecksum";
    public static final int IMPORT_CMD_ID = Ide.findCmdID((String)"ConnectionImportExport.IMPORT");
    public static final int EXPORT_CMD_ID = Ide.findCmdID((String)"ConnectionImportExport.EXPORT");
    static final String SOURCE_KEY = "ImportExport.SOURCE";
    static final String DESTINATION_KEY = "ImportExport.DESTINATION";
    static final String PASSWORD_LISTENER_KEY = "ImportExport.PASSWORD_LISTENER";
    static final String TRANSITION_PASSWORD = "Transition.Password";
    static final String TRANSITION_SELECT_CONNECTIONS = "Transition.SelectConnections";
    static final String STATE_PASSWORD = "State.Password";
    static final String STATE_SELECT_CONNECTIONS = "State.SelectConnections";
    static final String STATE_FINISH = "State.Finish";
    static final String EXPORT_PASSWORD_MODE = "ExportPasswordMode";
    static final String EXPORT_PASSWORD_KEY = "Key";
    static final String CHECKSUM_VALUE = "ValidKey";

    public static ImpExpEngine createImportEngine(DatabaseConnections databaseConnections) {
        return new ImportEngine(databaseConnections);
    }

    public static ImpExpEngine createExportEngine(DatabaseConnections databaseConnections) {
        return new ExportEngine(databaseConnections);
    }

    protected ImpExpEngine() {
    }

    public final void invoke() {
        FSM fSM = this.createFSM();
        Namespace namespace = new Namespace();
        this.initNamespace(namespace);
        FSMWizard fSMWizard = new FSMWizard(fSM, namespace);
        fSMWizard.setWizardTitle(this.getDialogTitle());
        fSMWizard.updateImage(ExportWizArb.getImage("WIZ_IMAGE"));
        fSMWizard.setLogoImage(ExportWizArb.getImage("WIZ_LOGO"));
        fSMWizard.setRoadmapVisible(true);
        fSMWizard.addCommitListener(new CommitListener(){

            public void rollback(ApplyEvent applyEvent) {
            }

            public void commit(ApplyEvent applyEvent) throws TraversalException {
                ImpExpEngine.this.performAction(applyEvent.getTraversableContext());
            }

            public void checkCommit(ApplyEvent applyEvent) throws TraversalException {
            }

            public void cancel(ApplyEvent applyEvent) {
            }
        });
        WizardDialog wizardDialog = fSMWizard.getDialog((Frame)Ide.getMainWindow());
        Dimension dimension = fSMWizard.getPreferredSize();
        int n = (int)dimension.getHeight() + 500;
        int n2 = (int)dimension.getWidth() + 500;
        wizardDialog.setSize(n2, n);
        wizardDialog.setPreferredSize(new Dimension(n2, n));
        WizardLauncher.runDialog((JDialog)wizardDialog);
    }

    protected abstract FSM createFSM();

    protected abstract String getDialogTitle();

    protected abstract void initNamespace(Namespace var1);

    protected abstract void performAction(TraversableContext var1) throws TraversalException;

    public static enum PasswordMode {
        STRIP,
        KEY,
        LEGACY;

    }
}

