/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.connections.LDAPServiceKeySelectionManager;
import oracle.dbtools.raptor.connections.OracleConnectionPanel;
import oracle.dbtools.raptor.connections.OracleConnectionType;
import oracle.dbtools.raptor.connections.OracleConnectionTypePanel;
import oracle.dbtools.raptor.controls.FilteringJList;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.raptor.utils.LDAPHelper;
import oracle.dbtools.raptor.utils.TCPTNSEntry;
import oracle.ide.util.ResourceUtils;

public class LDAPConnectionPanel
extends JPanel
implements OracleConnectionTypePanel {
    private static final long serialVersionUID = 671332892390943229L;
    private OracleConnectionPanel _panel;
    private JLabel ldapServerLbl = new JLabel();
    private JComboBox ldapServerCbx;
    private DataModel _model;
    private JComboBox dbServiceCbx;
    private FilteringJList dbServiceAuto;
    private DataModel _dbModel;
    private JLabel userLbl = new JLabel();
    private JTextField userTxt;
    private JLabel passwdLbl = new JLabel();
    private JPasswordField passwdTxt;
    private static final String LDAP_SERVER = "LDAP_SERVER";
    private static final String LDAP_USER = "LDAP_USER";
    private static final String LDAP_NETWORK_ALIAS = "LDAP_NETWORK_ALIAS";
    private static final String LDAP_CONTEXT = "LDAP_CONTEXT";
    private JButton loadBtn;
    private JLabel dbServiceLbl = new JLabel();
    private JLabel ldapContextLbl = new JLabel();
    private JComboBox ldapContext;
    private DataModel contextModel;

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this._model = new DataModel();
        this.ldapServerCbx = new JComboBox(this._model);
        ResourceUtils.resLabel((JLabel)this.ldapServerLbl, (Component)this.ldapServerCbx, (String)ConnectionDialogArb.getString(LDAP_SERVER));
        this._model.setData(LDAPHelper.getLDAPServers());
        this.ldapServerCbx.setEditable(true);
        this._dbModel = new DataModel();
        this.dbServiceCbx = new JComboBox(this._dbModel);
        this.dbServiceCbx.setEditable(false);
        this.dbServiceCbx.setKeySelectionManager(new LDAPServiceKeySelectionManager());
        this.userTxt = new JTextField();
        this.passwdTxt = new JPasswordField();
        ResourceUtils.resLabel((JLabel)this.userLbl, (Component)this.userTxt, (String)ConnectionDialogArb.getString(LDAP_USER));
        ResourceUtils.resLabel((JLabel)this.passwdLbl, (Component)this.passwdTxt, (String)ConnectionDialogArb.getString("LDAP_PASSWORD"));
        this.ldapContextLbl.setText(ConnectionDialogArb.getString(LDAP_CONTEXT));
        this.contextModel = new DataModel();
        this.ldapContext = new JComboBox(this.contextModel);
        this.ldapServerCbx.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    try {
                        ArrayList<String> arrayList = new ArrayList();
                        ArrayList<String> arrayList2 = new ArrayList<String>();
                        String string = (String)LDAPConnectionPanel.this.ldapServerCbx.getSelectedItem();
                        if (string == null || string.indexOf(":") == -1) {
                            LDAPConnectionPanel.this._panel.setErrorStatus(ConnectionDialogArb.getString("CONNECTION_DIALOG_STATUS_FAILURE") + ConnectionDialogArb.getString("LDAP_HOST_AND_PORT"));
                        } else {
                            LDAPConnectionPanel.this._panel.setStatus("");
                            arrayList = LDAPHelper.getLDAPContexts((String)((String)LDAPConnectionPanel.this.ldapServerCbx.getSelectedItem()));
                        }
                        LDAPConnectionPanel.this.contextModel.setData(arrayList);
                        if (arrayList.size() > 0) {
                            LDAPConnectionPanel.this.ldapContext.setSelectedIndex(0);
                        } else {
                            LDAPConnectionPanel.this.ldapContext.setSelectedIndex(-1);
                        }
                        LDAPConnectionPanel.this._dbModel.setData(arrayList2);
                        LDAPConnectionPanel.this.dbServiceCbx.setSelectedIndex(-1);
                    }
                    catch (Exception exception) {
                        LDAPConnectionPanel.this._panel.setErrorStatus(ConnectionDialogArb.getString("CONNECTION_DIALOG_STATUS_FAILURE") + exception.getMessage());
                    }
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.dbServiceCbx, "Center");
        this.loadBtn = new JButton(Messages.getString("LDAPConnectionPanel.2"));
        jPanel.add((Component)this.loadBtn, "East");
        this.dbServiceLbl.setText(Messages.getString("LDAPConnectionPanel.3"));
        this.loadBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    List list = LDAPHelper.getOrclServiceEntries((String)((String)LDAPConnectionPanel.this.ldapServerCbx.getSelectedItem()), (String)((String)LDAPConnectionPanel.this.ldapContext.getSelectedItem()));
                    Collections.sort(list, String.CASE_INSENSITIVE_ORDER);
                    LDAPConnectionPanel.this._dbModel.setData(list);
                    if (list == null || list.size() != 0) {
                        LDAPConnectionPanel.this.dbServiceCbx.setSelectedIndex(0);
                    } else {
                        LDAPConnectionPanel.this.dbServiceCbx.setSelectedIndex(-1);
                    }
                    LDAPConnectionPanel.this._panel.setStatus(ConnectionDialogArb.getString("CONNECTION_DIALOG_STATUS"));
                }
                catch (Exception exception) {
                    LDAPConnectionPanel.this._panel.setErrorStatus(ConnectionDialogArb.getString("CONNECTION_DIALOG_STATUS_FAILURE") + exception.getMessage());
                }
            }
        });
        this.add((Component)this.ldapServerLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 5, 0, 0), 0, 0));
        this.add((Component)this.ldapServerCbx, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(2, 5, 0, 0), 0, 0));
        this.add((Component)this.ldapContextLbl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 5, 0, 0), 0, 0));
        this.add((Component)this.ldapContext, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(2, 5, 0, 0), 0, 0));
        this.add((Component)this.dbServiceLbl, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 18, 2, new Insets(2, 5, 0, 0), 0, 0));
    }

    @Override
    public void clear() {
    }

    @Override
    public void generateProperties(Properties properties) {
        if (this.ldapServerCbx.getSelectedItem() != null) {
            properties.setProperty(LDAP_SERVER, (String)this.ldapServerCbx.getSelectedItem());
        }
        properties.setProperty(LDAP_USER, this.userTxt.getText());
        if (this.ldapContext.getSelectedItem() != null) {
            properties.setProperty(LDAP_CONTEXT, (String)this.ldapContext.getSelectedItem());
        }
        if (this.dbServiceCbx.getSelectedItem() != null) {
            properties.setProperty(LDAP_NETWORK_ALIAS, (String)this.dbServiceCbx.getSelectedItem());
            TCPTNSEntry tCPTNSEntry = LDAPHelper.getEntry((String)((String)this.dbServiceCbx.getSelectedItem()));
            if (tCPTNSEntry != null) {
                properties.setProperty("customUrl", tCPTNSEntry.getJDBCUrl());
                properties.setProperty("hostname", tCPTNSEntry.getHostname());
                properties.setProperty("port", tCPTNSEntry.getPortno());
                if (tCPTNSEntry.getSid() != null) {
                    properties.setProperty("sid", tCPTNSEntry.getSid());
                }
                if (tCPTNSEntry.getServicename() != null) {
                    properties.setProperty("serviceName", tCPTNSEntry.getServicename());
                }
                if (tCPTNSEntry.getSid() == null && tCPTNSEntry.getServicename() == null) {
                    try {
                        throw new Exception();
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                }
            }
        }
        properties.setProperty("OracleConnectionType", OracleConnectionType.LDAP.name());
    }

    @Override
    public void setDefaultPrompts() {
    }

    @Override
    public void updatePrompts(Properties properties) {
        this._model.setSelectedItem(properties.getProperty(LDAP_SERVER));
        this.userTxt.setText(properties.getProperty(LDAP_USER));
        String string = properties.getProperty(LDAP_NETWORK_ALIAS);
        String string2 = properties.getProperty(LDAP_CONTEXT);
        if (string2 != null && !string2.equals("")) {
            this.ldapContext.setSelectedItem(string2);
        }
        if (string != null && !string.equals("")) {
            this._dbModel.setSelectedItem(string);
        } else {
            this._dbModel.setSelectedItem(properties.getProperty("serviceName"));
        }
    }

    @Override
    public Component getPanel() {
        if (this.ldapServerCbx == null) {
            try {
                this.jbInit();
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
        return this;
    }

    @Override
    public OracleConnectionType getConnectionType() {
        return OracleConnectionType.LDAP;
    }

    @Override
    public void setOwner(OracleConnectionPanel oracleConnectionPanel) {
        this._panel = oracleConnectionPanel;
    }

    private class DataModel
    extends DefaultComboBoxModel {
        List<String> data = null;

        private DataModel() {
        }

        public void setData(List<String> list) {
            this.data = list;
        }

        public List<String> getData() {
            return this.data;
        }

        public String getRowData(int n) {
            return this.data.get(n);
        }

        @Override
        public Object getElementAt(int n) {
            return this.getRowData(n);
        }

        @Override
        public int getSize() {
            return this.data != null ? this.data.size() : 0;
        }
    }
}

