/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Map;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dbtools.raptor.connections.AdvancedPropertiesTab;
import oracle.dbtools.raptor.connections.ProxyConnectionPanel;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.ide.controls.tabbedpane.CustomTabbedPaneUI;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.panels.TraversalException;

final class AdvancedOracleConnectionProperties {
    private final Properties mAdvProperties = new Properties();
    private final AdvancedPropertiesTab[] mSubPanels = new AdvancedPropertiesTab[]{ProxyConnectionPanel.createProxyPanel()};
    private int mCurrPanel = -1;

    AdvancedOracleConnectionProperties() {
    }

    Properties getAdvancedProperties() {
        return this.mAdvProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAdvancedProperties(Properties properties) {
        Properties properties2 = this.mAdvProperties;
        synchronized (properties2) {
            this.mAdvProperties.clear();
            this.mAdvProperties.putAll((Map<?, ?>)this.parseAdvancedProperties(properties));
        }
    }

    private Properties parseAdvancedProperties(Properties properties) {
        Properties properties2 = new Properties();
        for (AdvancedPropertiesTab advancedPropertiesTab : this.mSubPanels) {
            properties2.putAll((Map<?, ?>)advancedPropertiesTab.parseProperties(properties));
        }
        return properties2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void showDialog(JComponent jComponent) {
        final JComponent jComponent2 = this.createUI();
        HelpUtils.setHelpID((JComponent)jComponent2, (String)"f1_proxy_connection_html");
        VetoableChangeListener vetoableChangeListener = new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                if ("closed".equals(propertyChangeEvent.getPropertyName()) && Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
                    try {
                        if (AdvancedOracleConnectionProperties.this.mCurrPanel >= 0 && AdvancedOracleConnectionProperties.this.mCurrPanel < AdvancedOracleConnectionProperties.this.mSubPanels.length) {
                            AdvancedOracleConnectionProperties.this.mSubPanels[AdvancedOracleConnectionProperties.this.mCurrPanel].validateProperties();
                        }
                    }
                    catch (TraversalException traversalException) {
                        traversalException.showMessageDialog((Component)jComponent2);
                        throw new PropertyVetoException("no", propertyChangeEvent);
                    }
                }
            }
        };
        for (AdvancedPropertiesTab advancedPropertiesTab : this.mSubPanels) {
            advancedPropertiesTab.populate(this.mAdvProperties);
        }
        boolean bl = OnePageWizardDialogFactory.runDialog((Component)jComponent, (Component)jComponent2, (Component)this.getCurrentDefaultComponent(), (String)ConnectionDialogArb.getString("ADVANCED_TITLE"), (int)7, (VetoableChangeListener)vetoableChangeListener);
        if (bl) {
            Properties properties = this.mAdvProperties;
            synchronized (properties) {
                this.mAdvProperties.clear();
                for (AdvancedPropertiesTab advancedPropertiesTab : this.mSubPanels) {
                    this.mAdvProperties.putAll((Map<?, ?>)advancedPropertiesTab.getProperties());
                }
            }
        }
    }

    private JComponent getCurrentDefaultComponent() {
        JComponent jComponent = null;
        if (this.mCurrPanel >= 0 && this.mCurrPanel < this.mSubPanels.length) {
            jComponent = this.mSubPanels[this.mCurrPanel].getInitialFocusComponent();
        }
        return jComponent != null ? jComponent : null;
    }

    private JComponent createUI() {
        final JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel = LayoutControl.GBC.createDialogMainPanel(jTabbedPane);
        jTabbedPane.setUI((TabbedPaneUI)new CustomTabbedPaneUI());
        jTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = jTabbedPane.getSelectedIndex();
                if (n != AdvancedOracleConnectionProperties.this.mCurrPanel) {
                    final int n2 = AdvancedOracleConnectionProperties.this.mCurrPanel;
                    AdvancedOracleConnectionProperties.this.mCurrPanel = n;
                    if (n2 != -1) {
                        try {
                            AdvancedOracleConnectionProperties.this.mSubPanels[n2].validateProperties();
                            JComponent jComponent = AdvancedOracleConnectionProperties.this.getCurrentDefaultComponent();
                            if (jComponent != null) {
                                jComponent.requestFocusInWindow();
                            }
                        }
                        catch (TraversalException traversalException) {
                            AdvancedOracleConnectionProperties.this.mCurrPanel = n2;
                            traversalException.showMessageDialog((Component)jTabbedPane);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    jTabbedPane.setSelectedIndex(n2);
                                }
                            });
                        }
                    }
                }
            }
        });
        this.mCurrPanel = 0;
        for (AdvancedPropertiesTab advancedPropertiesTab : this.mSubPanels) {
            JComponent jComponent = advancedPropertiesTab.getUI();
            jTabbedPane.addTab(advancedPropertiesTab.getSetName(), jComponent);
        }
        return jPanel;
    }
}

