/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.ide.help.HelpSystem;

public class WorksheetDndOptionPanel
extends JPanel {
    private static final long serialVersionUID = 1416481723588593798L;
    private ButtonGroup m_dragGroup = new ButtonGroup();
    private ButtonGroup m_dragSelectGroup = new ButtonGroup();
    private JRadioButton m_name = new JRadioButton();
    private JRadioButton m_insert = new JRadioButton();
    private JLabel m_drag_label = new JLabel();
    private JRadioButton m_delete = new JRadioButton();
    private JRadioButton m_update = new JRadioButton();
    private JRadioButton m_select = new JRadioButton();
    private JRadioButton m_selectStar = new JRadioButton();
    private JRadioButton m_selectJoin = new JRadioButton();
    private JCheckBox m_selectPrompt = new JCheckBox();
    private boolean canceled = true;
    private boolean enableJoin = true;

    public void setCancel(boolean bl) {
        this.canceled = bl;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public WorksheetDndOptionPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void disableJoin() {
        this.enableJoin = false;
    }

    public void enableJoin() {
        this.enableJoin = true;
    }

    private void jbInit() throws Exception {
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_worksheetdragndrop_html");
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 8};
        this.setLayout(gridBagLayout);
        this.setBorder(BorderFactory.createTitledBorder(PreferencesArb.getString("DND_TITLE")));
        this.m_dragGroup.add(this.m_name);
        this.m_name.setText(StringUtils.stripMnemonic((String)PreferencesArb.getString("DND_NAMEONLY")));
        this.m_name.setMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("DND_NAMEONLY")));
        this.m_name.setToolTipText(PreferencesArb.getString("DND_NAMEONLY_TIP"));
        this.m_drag_label.setText(PreferencesArb.getString("DND_LABEL"));
        this.m_dragGroup.add(this.m_insert);
        this.m_insert.setText(StringUtils.stripMnemonic((String)PreferencesArb.getString("DND_INSERT")));
        this.m_insert.setMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("DND_INSERT")));
        this.m_insert.setToolTipText(PreferencesArb.getString("DND_INSERT_TIP"));
        this.m_drag_label.setText(PreferencesArb.getString("DND_LABEL"));
        this.m_dragGroup.add(this.m_update);
        this.m_update.setText(StringUtils.stripMnemonic((String)PreferencesArb.getString("DND_UPDATE")));
        this.m_update.setMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("DND_UPDATE")));
        this.m_update.setToolTipText(PreferencesArb.getString("DND_UPDATE_TIP"));
        this.m_dragGroup.add(this.m_delete);
        this.m_delete.setText(StringUtils.stripMnemonic((String)PreferencesArb.getString("DND_DELETE")));
        this.m_delete.setMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("DND_DELETE")));
        this.m_delete.setToolTipText(PreferencesArb.getString("DND_DELETE_TIP"));
        this.m_dragGroup.add(this.m_select);
        this.m_select.setText(StringUtils.stripMnemonic((String)PreferencesArb.getString("DND_SELECT")));
        this.m_select.setMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("DND_SELECT")));
        this.m_select.setToolTipText(PreferencesArb.getString("DND_SELECT_TIP"));
        this.m_dragSelectGroup.add(this.m_selectStar);
        this.m_selectStar.setText(StringUtils.stripMnemonic((String)PreferencesArb.getString("DND_INDIVIDUAL_STATEMENTS")));
        this.m_selectStar.setMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("DND_INDIVIDUAL_STATEMENTS")));
        this.m_selectStar.setEnabled(false);
        this.m_selectStar.setToolTipText(PreferencesArb.getString("DND_INDIV_TIP"));
        this.m_dragSelectGroup.add(this.m_selectJoin);
        this.m_selectJoin.setText(StringUtils.stripMnemonic((String)PreferencesArb.getString("DND_JOIN")));
        this.m_selectJoin.setMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("DND_JOIN")));
        this.m_selectJoin.setEnabled(false);
        this.m_selectJoin.setToolTipText(PreferencesArb.getString("DND_JOIN_TIP"));
        this.m_selectPrompt.setText(StringUtils.stripMnemonic((String)PreferencesArb.getString("DND_PROMPT")));
        this.m_selectPrompt.setMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("DND_PROMPT")));
        this.m_selectPrompt.setToolTipText(PreferencesArb.getString("DND_PROMPT_TIP"));
        this.add((Component)this.m_drag_label, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_name, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.m_insert, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.m_update, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.m_delete, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.m_select, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.m_selectStar, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 15, 0, 0), 0, 0));
        this.add((Component)this.m_selectJoin, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 15, 0, 0), 0, 0));
        this.add((Component)this.m_selectPrompt, new GridBagConstraints(1, 7, 1, 1, 0.0, 1.0, 18, 2, new Insets(0, 5, 0, 0), 0, 0));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
                if (jRadioButton.isSelected()) {
                    WorksheetDndOptionPanel.this.m_dragSelectGroup.remove(WorksheetDndOptionPanel.this.m_selectStar);
                    WorksheetDndOptionPanel.this.m_dragSelectGroup.remove(WorksheetDndOptionPanel.this.m_selectJoin);
                    WorksheetDndOptionPanel.this.m_selectStar.setSelected(false);
                    WorksheetDndOptionPanel.this.m_selectStar.setEnabled(false);
                    WorksheetDndOptionPanel.this.m_selectJoin.setSelected(false);
                    WorksheetDndOptionPanel.this.m_selectJoin.setEnabled(false);
                    WorksheetDndOptionPanel.this.m_dragSelectGroup.add(WorksheetDndOptionPanel.this.m_selectStar);
                    WorksheetDndOptionPanel.this.m_dragSelectGroup.add(WorksheetDndOptionPanel.this.m_selectJoin);
                }
            }
        };
        ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
                if (jRadioButton.isSelected()) {
                    WorksheetDndOptionPanel.this.m_selectStar.setEnabled(true);
                    WorksheetDndOptionPanel.this.m_selectStar.setSelected(true);
                    WorksheetDndOptionPanel.this.m_selectJoin.setEnabled(WorksheetDndOptionPanel.this.enableJoin);
                }
            }
        };
        this.m_name.addActionListener(actionListener);
        this.m_insert.addActionListener(actionListener);
        this.m_delete.addActionListener(actionListener);
        this.m_update.addActionListener(actionListener);
        this.m_select.addActionListener(actionListener2);
    }

    public int getDragType() {
        int n = 0;
        if (this.m_insert.isSelected()) {
            n = 3;
        } else if (this.m_delete.isSelected()) {
            n = 5;
        } else if (this.m_update.isSelected()) {
            n = 4;
        } else if (this.m_select.isSelected()) {
            n = this.m_selectJoin.isSelected() ? 2 : 1;
        } else if (this.m_name.isSelected()) {
            n = 6;
        }
        return n;
    }

    public void setDragType(int n) {
        switch (n) {
            case 3: {
                this.m_insert.setSelected(true);
                this.m_select.setEnabled(true);
                break;
            }
            case 5: {
                this.m_delete.setSelected(true);
                this.m_select.setEnabled(true);
                break;
            }
            case 4: {
                this.m_update.setSelected(true);
                this.m_select.setEnabled(true);
                break;
            }
            case 1: {
                this.m_select.setSelected(true);
                this.m_selectStar.setSelected(true);
                this.m_selectStar.setEnabled(true);
                this.m_selectJoin.setEnabled(this.enableJoin);
                break;
            }
            case 2: {
                this.m_select.setSelected(true);
                this.m_selectJoin.setSelected(this.enableJoin);
                this.m_selectStar.setSelected(!this.enableJoin);
                this.m_selectStar.setEnabled(true);
                this.m_selectJoin.setEnabled(true);
                break;
            }
            case 6: {
                this.m_name.setSelected(true);
                break;
            }
        }
    }

    public static void main(String[] stringArray) {
        JDialog jDialog = new JDialog();
        jDialog.setLayout(new BorderLayout());
        WorksheetDndOptionPanel worksheetDndOptionPanel = new WorksheetDndOptionPanel();
        jDialog.add((Component)worksheetDndOptionPanel, "Center");
        jDialog.pack();
        jDialog.setLocationRelativeTo(null);
        jDialog.setVisible(true);
    }

    public int getPrompt() {
        if (this.m_selectPrompt.isSelected()) {
            return 0;
        }
        return 1;
    }

    public void setPrompt(int n) {
        if (n == 0) {
            this.m_selectPrompt.setSelected(true);
        } else {
            this.m_selectPrompt.setSelected(false);
        }
    }
}

