/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.net.URL;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.net.URLPath;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;

public class URLFileChooserPaths
extends HashStructureAdapter {
    public static final String DEFAULT_CONTEXT_KEY = "DEFAULT_CONTEXT";
    private static final String INSTANCE_KEY = URLFileChooserPaths.class.getSimpleName();
    private static URLFileChooserPaths INSTANCE;
    private int historyCount = 10;
    private int defaultContextHistoryCount = 100;
    private NodeListener _nodelistener = new URLFileChooserPathNodelistener();
    public static final String TEMP_WORKSHEET_PROTOCOL = "ide.worksheet";

    protected URLFileChooserPaths(HashStructure hashStructure) {
        super(hashStructure);
    }

    static URLFileChooserPaths findOrCreate(HashStructure hashStructure) {
        if (null == INSTANCE) {
            HashStructure hashStructure2 = hashStructure.getOrCreateHashStructure(INSTANCE_KEY);
            INSTANCE = new URLFileChooserPaths(hashStructure2);
        }
        return INSTANCE;
    }

    public URLFileChooserPathContext getPathContext(String string) {
        if (null == string) {
            throw new IllegalArgumentException("key is null");
        }
        return new URLFileChooserPathContext(string, this.getHashStructure());
    }

    public void listenForNodeType(Class<? extends Node> clazz) {
        Node.addNodeListenerForType(clazz, (NodeListener)this._nodelistener);
    }

    private boolean ignore(URL uRL) {
        return null == uRL || uRL.getProtocol().startsWith(TEMP_WORKSHEET_PROTOCOL) || uRL.getProtocol().startsWith("sqldev.nav");
    }

    private class URLFileChooserPathNodelistener
    extends NodeListener {
        private URLFileChooserPathContext pathContext;

        private URLFileChooserPathNodelistener() {
            this.pathContext = URLFileChooserPaths.this.getPathContext(URLFileChooserPaths.DEFAULT_CONTEXT_KEY);
        }

        public void nodeOpened(NodeEvent nodeEvent) {
            this.processPathContext(nodeEvent.getNode().getURL(), true);
        }

        public void nodeSaved(NodeEvent nodeEvent) {
            this.processPathContext(nodeEvent.getNode().getURL(), true);
        }

        public void nodeDeleted(NodeEvent nodeEvent) {
            this.processPathContext(nodeEvent.getNode().getURL(), false);
        }

        private void processPathContext(URL uRL, boolean bl) {
            if (URLFileChooserPaths.this.ignore(uRL)) {
                return;
            }
            if (bl) {
                this.pathContext.add(uRL);
            } else {
                this.pathContext.remove(uRL);
            }
        }
    }

    public class URLFileChooserPathContext
    extends HashStructureAdapter {
        private String key;

        protected URLFileChooserPathContext(String string, HashStructure hashStructure) {
            super(hashStructure);
            this.key = string;
        }

        public String getKey() {
            return this.key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public URLPath getURLPath() {
            URLPath uRLPath = new URLPath();
            ListStructure listStructure = this.getURLList();
            Object object = listStructure.iteratorLock();
            synchronized (object) {
                for (Object e : listStructure) {
                    URL uRL = (URL)e;
                    if (URLFileChooserPaths.this.ignore(uRL)) continue;
                    uRLPath.add(uRL);
                }
            }
            return uRLPath;
        }

        public void putURLPath(URLPath uRLPath) {
            ListStructure listStructure = ListStructure.newInstance();
            for (URL uRL : uRLPath.asList()) {
                if (URLFileChooserPaths.this.ignore(uRL)) continue;
                listStructure.add((Object)uRL);
            }
            this.trimListStructure(listStructure);
            this.getHashStructure().putListStructure(this.key, listStructure);
        }

        public void add(URL uRL) {
            if (URLFileChooserPaths.this.ignore(uRL)) {
                return;
            }
            ListStructure listStructure = this.getURLList();
            if (listStructure.contains((Object)uRL)) {
                listStructure.remove((Object)uRL);
            }
            listStructure.add(0, (Object)uRL);
            this.trimListStructure(listStructure);
        }

        public void remove(URL uRL) {
            if (null == uRL) {
                return;
            }
            ListStructure listStructure = this.getURLList();
            if (listStructure.contains((Object)uRL)) {
                listStructure.remove((Object)uRL);
            }
        }

        private ListStructure getURLList() {
            return this.getHashStructure().getOrCreateListStructure(this.key);
        }

        private void trimListStructure(ListStructure listStructure) {
            int n;
            int n2 = n = URLFileChooserPaths.DEFAULT_CONTEXT_KEY == this.key ? URLFileChooserPaths.this.defaultContextHistoryCount : URLFileChooserPaths.this.historyCount;
            while (listStructure.size() > n) {
                listStructure.remove(listStructure.size() - 1);
            }
        }
    }
}

