/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.GridBagLayout;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.util.ModelUtil;

public final class TnsnamesDirChooser
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private URLFileChooser.URLFileChooserPanel tnsnamesPanel = URLFileChooser.createURLFileChooserPanel(0, PreferencesArb.getString("TNS_NAMES_DIR_TEXT"));
    private GridBagLayout layMain = new GridBagLayout();

    public TnsnamesDirChooser() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        String string = dBConfig.getString("TNS_NAMES_DIR");
        URL uRL = ModelUtil.hasLength((String)string) ? URLFactory.newFileURL((String)string) : null;
        this.tnsnamesPanel.setSelectedURL(uRL);
    }

    public void onExit(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        URL uRL = this.tnsnamesPanel.getSelectedURL();
        String string = uRL != null ? URLFileSystem.getPlatformPathName((URL)uRL) : "";
        dBConfig.putString("TNS_NAMES_DIR", string);
    }

    private void jbInit() throws Exception {
        this.tnsnamesPanel.setSelectionMode(0);
        this.tnsnamesPanel.setSelectionScope(1);
        this.tnsnamesPanel.setPathContext("TNS_NAMES_DIR");
        this.setLayout(this.layMain);
        this.add(this.tnsnamesPanel, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.NONE, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
    }
}

