/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.app.Format;
import oracle.dbtools.app.FormattingPreferences;
import oracle.dbtools.app.Persist2XML;
import oracle.dbtools.format.FormatCommand;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.config.CustomFormat;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.dbtools.raptor.newscriptrunner.commands.HiddenParameters;
import oracle.dbtools.util.Logger;
import oracle.dbtools.util.Service;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.controls.WholeNumberField;
import oracle.ide.net.URLFactory;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;

public class FormatSQLOptionsPanel
extends DefaultTraversablePanel
implements ActionListener {
    JPanel aggregateFormatPanel = new JPanel(new GridBagLayout());
    JPanel autoReadonlyPanel = new JPanel(new GridBagLayout());
    private JCheckBox autoFormatReadonly = new JCheckBox();
    JPanel tabIdPanel = new JPanel(new GridBagLayout());
    private JLabel label_tab = new JLabel(Messages.getString("FormatSQLOptionsPanel.indentSpaces") + ":");
    private WholeNumberField tabSize = new WholeNumberField(1);
    private JLabel label_idcase = new JLabel(Messages.getString("FormatSQLOptionsPanel.idCase") + ":");
    private JComboBox id_case = new JComboBox();
    private JLabel label_kwcase = new JLabel(Messages.getString("FormatSQLOptionsPanel.kwCase") + ":");
    private JComboBox kw_case = new JComboBox();
    protected JRadioButton preview = new JRadioButton(Messages.getString("FormatSQLOptionsPanel.preview"));
    protected JRadioButton detect = new JRadioButton(Messages.getString("FormatSQLOptionsPanel.detect"));
    protected JPanel editorChoosePreviewDetectPanel = new JPanel(new GridBagLayout());
    protected BasicEditorPane editor = null;
    String upper;
    String lower;
    String initCap;
    String none;
    String multiLine;
    String singleLine;
    String before;
    String after;
    String beforeAndAfter;
    String noBreak;
    String singleBreak;
    String tab;
    String spaces;
    String deflt;
    String inside;
    String outside;
    String noSpace;
    String[] caseConversion;
    String[] singleLineCommentsOptions;
    String[] beforeAfterCommaItems;
    String[] beforeAfterConcatItems;
    String[] afterLogicalConnectorItems;
    String[] isolateStatementsItems;
    String[] tabSpacesItems;
    String[] bracketSpacing;
    private static final String fname = "formatterOptions.xml";
    final KeyListener editorKeyListener = new KeyListener(){

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (FormatSQLOptionsPanel.this.detect.isSelected()) {
                if (keyEvent.isControlDown() && keyEvent.getKeyChar() == '\u0016' || keyEvent.getKeyChar() == '\n') {
                    String string = FormatSQLOptionsPanel.this.editor.getText();
                    List list = LexerToken.parse((String)string);
                    SqlEarley sqlEarley = SqlEarley.getInstance();
                    Matrix matrix = new Matrix((Parser)sqlEarley);
                    ParseNode parseNode = sqlEarley.parse(list);
                    FormattingPreferences.debug = "true".equals(HiddenParameters.parameters.get("debugFormatPreferences"));
                    FormattingPreferences.guessKwCase((String)string, (List)list, (ParseNode)parseNode, null);
                    FormattingPreferences.guessIdCase((String)string, (List)list, (ParseNode)parseNode, null);
                    FormattingPreferences.guessSpaces((String)string, (List)list, (ParseNode)parseNode, null);
                    FormatSQLOptionsPanel.this.tabSize.setValue(((Integer)Format.options.get(Format.identSpaces)).intValue());
                    FormatSQLOptionsPanel.this.id_case.setSelectedItem(FormatSQLOptionsPanel.this.persisted2displayed(Format.idCase));
                    FormatSQLOptionsPanel.this.kw_case.setSelectedItem(FormatSQLOptionsPanel.this.persisted2displayed(Format.kwCase));
                }
                return;
            }
            if (keyEvent.isControlDown() && keyEvent.getKeyChar() == '\u0016') {
                FormatSQLOptionsPanel.this.updatePreview();
            }
            if (keyEvent.getKeyChar() == '\n') {
                FormatSQLOptionsPanel.this.updatePreview();
            }
        }
    };
    int editorRgtMarginCol;
    boolean editorRgtMarginIsVisible;
    Object editorRgtMarginColor;
    static Insets emptyInsets = new Insets(0, 0, 0, 0);
    static Insets defaultInsets = new Insets(0, 0, 5, 5);
    static Insets indentedInsets = new Insets(0, 18, 5, 0);
    static Insets indentedHeaderInsets = new Insets(0, 18, 7, 5);
    private static String sample = null;
    private NumberFormat numberFormatter;

    public FormatSQLOptionsPanel() {
        this.setHelpID("f1_formatsql_html");
        this.upper = Messages.getString("FormatSQLOptionsPanel.upper");
        this.lower = Messages.getString("FormatSQLOptionsPanel.lower");
        this.initCap = Messages.getString("FormatSQLOptionsPanel.initCap");
        this.none = Messages.getString("FormatSQLOptionsPanel.none");
        this.multiLine = Messages.getString("FormatSQLAdvancedOptions.multiLine");
        this.singleLine = Messages.getString("FormatSQLAdvancedOptions.singleLine");
        this.before = Messages.getString("FormatSQLOptionsPanel.before");
        this.after = Messages.getString("FormatSQLOptionsPanel.after");
        this.beforeAndAfter = Messages.getString("FormatSQLOptionsPanel.beforeAndAfter");
        this.noBreak = Messages.getString("FormatSQLOptionsPanel.noBreak");
        this.tab = Messages.getString("FormatSQLAdvancedOptions.tab");
        this.spaces = Messages.getString("FormatSQLAdvancedOptions.spaces");
        this.deflt = Messages.getString("FormatSQLAdvancedOptions.default");
        this.inside = Messages.getString("FormatSQLAdvancedOptions.inside");
        this.outside = Messages.getString("FormatSQLAdvancedOptions.outside");
        this.noSpace = Messages.getString("FormatSQLAdvancedOptions.noSpace");
        this.singleBreak = Messages.getString("FormatSQLOptionsPanel.singleBreak");
        this.caseConversion = new String[]{this.upper, this.lower, this.initCap, this.none};
        this.singleLineCommentsOptions = new String[]{this.none, this.multiLine, this.singleLine};
        this.beforeAfterCommaItems = new String[]{this.before, this.after, this.noBreak};
        this.beforeAfterConcatItems = new String[]{this.before, this.after, this.noBreak};
        this.afterLogicalConnectorItems = new String[]{this.beforeAndAfter, this.before, this.after, this.noBreak};
        this.isolateStatementsItems = new String[]{Messages.getString("FormatSQLOptionsPanel.doubleBreak"), this.singleBreak};
        this.tabSpacesItems = new String[]{this.tab, this.spaces};
        this.bracketSpacing = new String[]{this.deflt, this.inside, this.outside, this.noSpace};
        this.initEditor();
        this.jbInit();
        this.addListeners();
    }

    protected static void saveOptions() {
        FormatSQLOptionsPanel.exportOptions(FormatSQLOptionsPanel.getDefaultURL());
    }

    public static void loadOptions() {
        FormatSQLOptionsPanel.importOptions(FormatSQLOptionsPanel.getDefaultURL());
    }

    protected static void exportOptions(URL uRL) {
        try {
            Persist2XML.write((URL)uRL, (Object)Format.options);
        }
        catch (Exception exception) {
            Logger.severe(FormatSQLOptionsPanel.class, (String)exception.getMessage());
        }
    }

    public static void importOptions(URL uRL) {
        try {
            Map map = Persist2XML.read((URL)uRL);
            Format.setOptions((Map)map);
        }
        catch (Exception exception) {
            if (uRL.equals(FormatSQLOptionsPanel.getDefaultURL())) {
                Format.setDefaultOptions();
            }
            Logger.severe(FormatSQLOptionsPanel.class, (String)exception.getMessage());
        }
    }

    private static URL getDefaultURL() {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
        URL uRL = extensionRegistry.getSystemDirectory("oracle.sqldeveloper");
        return URLFactory.newURL((URL)uRL, (String)fname);
    }

    public void onEntry(TraversableContext traversableContext) {
        FormatSQLOptionsPanel.loadOptions();
        int n = (Integer)Format.options.get(Format.identSpaces);
        this.tabSize.setValue(n);
        this.id_case.setModel(new DefaultComboBoxModel<String>(this.caseConversion));
        this.id_case.setSelectedItem(this.persisted2displayed(Format.idCase));
        this.kw_case.setModel(new DefaultComboBoxModel<String>(this.caseConversion));
        this.kw_case.setSelectedItem(this.persisted2displayed(Format.kwCase));
        int n2 = (Integer)Format.options.get(Format.maxCharLineSize);
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        this.autoFormatReadonly.setSelected(dBConfig.getBoolean("AUTO_READONLY_FORMAT"));
        this.editorRgtMarginCol = EditorProperties.getProperties().getIntegerProperty("right-margin-column");
        this.editorRgtMarginIsVisible = EditorProperties.getProperties().getBooleanProperty("right-margin-visible");
        this.editorRgtMarginColor = EditorProperties.getProperties().getProperty("right-margin-color");
        EditorProperties.getProperties().putIntegerProperty("right-margin-column", n2);
        EditorProperties.getProperties().putBooleanProperty("right-margin-visible", true);
        EditorProperties.getProperties().putProperty("right-margin-color", (Object)new Color(230, 200, 200));
        if (this.preview.isSelected()) {
            this.updatePreview();
        }
    }

    protected Object persisted2displayed(String string) {
        Object v = Format.options.get(string);
        if (Format.kwCase.equals(string) || Format.idCase.equals(string)) {
            return Format.Case.lower == v ? this.lower : (Format.Case.UPPER == v ? this.upper : (Format.Case.InitCap == v ? this.initCap : this.none));
        }
        if (Format.singleLineComments.equals(string)) {
            return Format.InlineComments.SingleLine == v ? this.singleLine : (Format.InlineComments.MultiLine == v ? this.multiLine : this.none);
        }
        if (Format.breaksComma.equals(string) || Format.breaksConcat.equals(string) || Format.breaksAroundLogicalConjunctions.equals(string)) {
            if (Format.Breaks.Before == v) {
                return this.before;
            }
            if (Format.Breaks.After == v) {
                return this.after;
            }
            if (Format.Breaks.BeforeAndAfter == v) {
                return this.beforeAndAfter;
            }
            return this.noBreak;
        }
        if (Format.extraLinesAfterSignificantStatements.equals(string)) {
            Boolean bl = (Boolean)v;
            return bl != false ? this.isolateStatementsItems[0] : this.isolateStatementsItems[1];
        }
        if (Format.useTab.equals(string)) {
            Boolean bl = (Boolean)v;
            return bl != false ? this.tab : this.spaces;
        }
        if (Format.spaceAroundBrackets.equals(string)) {
            if (Format.Space.Outside == v) {
                return this.outside;
            }
            if (Format.Space.NoSpace == v) {
                return this.noSpace;
            }
            return this.inside;
        }
        return v;
    }

    protected void displayed2persisted(String string, Object object) {
        if (Format.kwCase.equals(string) || Format.idCase.equals(string)) {
            Format.options.put(string, this.upper.equalsIgnoreCase((String)object) ? Format.Case.UPPER : (this.lower.equalsIgnoreCase((String)object) ? Format.Case.lower : (this.initCap.equalsIgnoreCase((String)object) ? Format.Case.InitCap : Format.Case.NoCaseChange)));
            return;
        }
        if (Format.singleLineComments.equals(string)) {
            Format.options.put(string, this.singleLine.equalsIgnoreCase((String)object) ? Format.InlineComments.SingleLine : (this.multiLine.equalsIgnoreCase((String)object) ? Format.InlineComments.MultiLine : Format.InlineComments.CommentsUnchanged));
            return;
        }
        if (Format.breaksComma.equals(string) || Format.breaksConcat.equals(string) || Format.breaksAroundLogicalConjunctions.equals(string)) {
            Format.Breaks breaks = Format.Breaks.BeforeAndAfter;
            if (this.before.equalsIgnoreCase((String)object)) {
                breaks = Format.Breaks.Before;
            }
            if (this.after.equalsIgnoreCase((String)object)) {
                breaks = Format.Breaks.After;
            }
            if (this.noBreak.equalsIgnoreCase((String)object)) {
                breaks = Format.Breaks.None;
            }
            Format.options.put(string, breaks);
            return;
        }
        if (Format.breaksAroundLogicalConjunctions.equals(string)) {
            Format.options.put(string, !object.equals(this.noBreak));
            return;
        }
        if (Format.extraLinesAfterSignificantStatements.equals(string)) {
            Format.options.put(string, !object.equals(this.singleBreak));
            return;
        }
        if (Format.useTab.equals(string)) {
            Format.options.put(string, object.equals(this.tab));
            return;
        }
        if (Format.spaceAroundBrackets.equals(string)) {
            if (this.outside.equals(object)) {
                Format.options.put(string, Format.Space.Outside);
            } else if (this.noSpace.equals(object)) {
                Format.options.put(string, Format.Space.NoSpace);
            } else {
                Format.options.put(string, Format.Space.Inside);
            }
            return;
        }
        Format.options.put(string, object);
    }

    private void addListeners() {
        this.tabSize.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                Format.options.put(Format.identSpaces, FormatSQLOptionsPanel.this.tabSize.getValue());
                FormatSQLOptionsPanel.this.updatePreview();
            }
        });
        this.editor.addKeyListener(this.editorKeyListener);
        this.detect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FormatSQLOptionsPanel.this.editor.setText("-- " + Messages.getString("FormatSQLOptionsPanel.pasteCodeToAutodetect"));
            }
        });
        this.id_case.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)FormatSQLOptionsPanel.this.id_case.getSelectedItem();
                Format.options.put(Format.idCase, FormatSQLOptionsPanel.this.upper.equalsIgnoreCase(string) ? Format.Case.UPPER : (FormatSQLOptionsPanel.this.lower.equalsIgnoreCase(string) ? Format.Case.lower : (FormatSQLOptionsPanel.this.initCap.equalsIgnoreCase(string) ? Format.Case.InitCap : Format.Case.NoCaseChange)));
                if (FormatSQLOptionsPanel.this.preview.isSelected()) {
                    FormatSQLOptionsPanel.this.updatePreview();
                }
            }
        });
        this.kw_case.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)FormatSQLOptionsPanel.this.kw_case.getSelectedItem();
                Format.options.put(Format.kwCase, FormatSQLOptionsPanel.this.upper.equalsIgnoreCase(string) ? Format.Case.UPPER : (FormatSQLOptionsPanel.this.lower.equalsIgnoreCase(string) ? Format.Case.lower : (FormatSQLOptionsPanel.this.initCap.equalsIgnoreCase(string) ? Format.Case.InitCap : Format.Case.NoCaseChange)));
                if (FormatSQLOptionsPanel.this.preview.isSelected()) {
                    FormatSQLOptionsPanel.this.updatePreview();
                }
            }
        });
    }

    public void onExit(TraversableContext traversableContext) {
        EditorProperties.getProperties().putIntegerProperty("right-margin-column", this.editorRgtMarginCol);
        EditorProperties.getProperties().putBooleanProperty("right-margin-visible", this.editorRgtMarginIsVisible);
        EditorProperties.getProperties().putProperty("right-margin-color", this.editorRgtMarginColor);
        this.displayed2persisted(Format.identSpaces, this.tabSize.getValue());
        this.displayed2persisted(Format.kwCase, this.kw_case.getSelectedItem());
        this.displayed2persisted(Format.idCase, this.id_case.getSelectedItem());
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putBoolean("AUTO_READONLY_FORMAT", this.autoFormatReadonly.isSelected());
        FormatSQLOptionsPanel.saveOptions();
    }

    private void jbInit() {
        this.setLayout(new BorderLayout());
        this.numberFormatter = NumberFormat.getNumberInstance();
        this.numberFormatter.setMinimumFractionDigits(0);
        this.numberFormatter.setMaximumFractionDigits(0);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.preview);
        buttonGroup.add(this.detect);
        this.autoFormatReadonly.setText(StringUtils.stripMnemonic((String)PreferencesArb.getString("AUTOFORMAT_TEXT")));
        this.autoFormatReadonly.setMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("AUTOFORMAT_TEXT")));
        this.autoFormatReadonly.setToolTipText(StringUtils.stripMnemonic((String)PreferencesArb.getString("AUTOFORMAT_TEXT")));
        this.autoReadonlyPanel.add((Component)this.autoFormatReadonly, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.aggregateFormatPanel.add((Component)this.autoReadonlyPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, emptyInsets, 0, 0));
        int n = 0;
        this.tabIdPanel.add((Component)this.label_tab, new GridBagConstraints(n++, 0, 1, 1, 0.0, 0.0, 17, 0, defaultInsets, 5, 0));
        this.tabIdPanel.add((Component)this.tabSize, new GridBagConstraints(n++, 0, 1, 1, 0.0, 0.0, 17, 0, defaultInsets, 5, 0));
        this.tabIdPanel.add(Box.createHorizontalStrut(10), new GridBagConstraints(n++, 0, 1, 1, 0.0, 0.0, 17, 0, defaultInsets, 5, 0));
        this.tabIdPanel.add((Component)this.label_idcase, new GridBagConstraints(n++, 0, 1, 1, 0.0, 0.0, 17, 0, defaultInsets, 5, 0));
        this.tabIdPanel.add((Component)this.id_case, new GridBagConstraints(n++, 0, 1, 1, 0.0, 0.0, 17, 0, defaultInsets, 5, 0));
        this.tabIdPanel.add(Box.createHorizontalStrut(10), new GridBagConstraints(n++, 0, 1, 1, 0.0, 0.0, 17, 0, defaultInsets, 5, 0));
        this.tabIdPanel.add((Component)this.label_kwcase, new GridBagConstraints(n++, 0, 1, 1, 0.0, 0.0, 17, 0, defaultInsets, 5, 0));
        this.tabIdPanel.add((Component)this.kw_case, new GridBagConstraints(n++, 0, 1, 1, 0.0, 0.0, 17, 0, defaultInsets, 5, 0));
        this.aggregateFormatPanel.add((Component)this.tabIdPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, emptyInsets, 0, 0));
        this.editorChoosePreviewDetectPanel.add((Component)this.preview, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, defaultInsets, 5, 0));
        this.editorChoosePreviewDetectPanel.add((Component)this.detect, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, defaultInsets, 5, 0));
        this.preview.setSelected(true);
        this.preview.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (FormatSQLOptionsPanel.this.preview.isSelected()) {
                    FormatSQLOptionsPanel.this.updatePreview();
                }
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.aggregateFormatPanel, "West");
        this.add(jPanel, "First");
        JScrollPane jScrollPane = new JScrollPane((Component)this.editor);
        this.add(jScrollPane, "Center");
    }

    public void initEditor() {
        this.editor = EditorFactory.createIdeEditorPane();
        this.editor.setDocument((Document)new BasicDocument("template.plsql"));
        this.editor.installPlugin((EditorPlugin)new LineHighlightPlugin());
        LineGutterPlugin lineGutterPlugin = new LineGutterPlugin();
        this.editor.installPlugin((EditorPlugin)lineGutterPlugin);
        this.editor.setText(FormatSQLOptionsPanel.getSample());
    }

    public static String getSample() {
        if (sample != null) {
            return sample;
        }
        try {
            sample = Service.readFile(FormatCommand.class, (String)"sample.sql");
        }
        catch (IOException iOException) {
            sample = "-- " + iOException.getMessage() + " ";
        }
        return sample;
    }

    public synchronized void updatePreview() {
        try {
            this.editor.setEditable(true);
            Caret caret = this.editor.getCaret();
            CustomFormat customFormat = CustomFormat.getInstance();
            customFormat.inputPos = caret.getDot();
            String string = this.editor.getText();
            customFormat.inputPos = this.editor.getCaretPosition();
            String string2 = customFormat.format(string);
            int n = string2.indexOf("/*** Syntax Error at line");
            if (0 <= n) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2.substring(n, string2.indexOf("Expected:")), (String)"Syntax Error", null);
                return;
            }
            this.editor.setText(string2);
            this.editor.setCaretPosition(customFormat.inputPos);
            int n2 = (Integer)Format.options.get(Format.maxCharLineSize);
            EditorProperties.getProperties().putIntegerProperty("right-margin-column", n2);
            EditorProperties.getProperties().putIntegerProperty("indent-size", ((Integer)Format.options.get(Format.identSpaces)).intValue());
            EditorProperties.getProperties().putBooleanProperty("use-tabs", ((Boolean)Format.options.get(Format.useTab)).booleanValue());
            EditorProperties.getProperties().putIntegerProperty("tab-size", ((Integer)Format.options.get(Format.identSpaces)).intValue());
        }
        catch (IOException iOException) {
            Logger.severe(this.getClass(), (String)iOException.getMessage());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    public static void main(String[] stringArray) {
        System.out.println(Format.Case.lower);
        System.out.println(Format.Case.lower.toString());
    }
}

