/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.navigator;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Icon;
import oracle.dbtools.raptor.cloud.CloudBrowserResources;
import oracle.dbtools.raptor.cloud.connection.CConnectionEvent;
import oracle.dbtools.raptor.cloud.connection.CConnections;
import oracle.dbtools.raptor.cloud.connection.CConnectionsListener;
import oracle.dbtools.raptor.cloud.navigator.CloudConnection;
import oracle.dbtools.raptor.navigator.DatabaseTypeRoot;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;

public class CloudConnections
extends DatabaseTypeRoot
implements CConnectionsListener {
    static CloudConnections getInstance() {
        return Holder.CONNECTIONS;
    }

    public static CloudConnection getConnectionNode(String string, boolean bl) {
        CloudConnection cloudConnection = null;
        URL uRL = DBURLFormatHelper.getURL("sqldev.cloud", string);
        cloudConnection = bl ? CloudConnection.findOrCreateConnectionNode(uRL) : CloudConnection.findConnectionNode(uRL);
        return cloudConnection;
    }

    private CloudConnections() {
    }

    @Override
    public String getKey() {
        return this.getShortLabel();
    }

    @Override
    public int getWeight() {
        return 1;
    }

    public String getShortLabel() {
        return CloudBrowserResources.getString("CLOUD_CONNECTIONS_NODE");
    }

    public Icon getIcon() {
        return CloudBrowserResources.getIcon("CLOUD_ICON");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openImpl() throws IOException {
        CConnections cConnections = CConnections.getInstance();
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            for (String string : cConnections.listConnections()) {
                CloudConnection cloudConnection = CloudConnections.getConnectionNode(string, true);
                if (cloudConnection == null) continue;
                this._children.add(cloudConnection);
            }
        }
        cConnections.addListener(this);
    }

    protected void closeImpl() throws IOException {
        CConnections.getInstance().removeListener(this);
    }

    public void markDirty(boolean bl) {
    }

    @Override
    public void connectionAdded(CConnectionEvent cConnectionEvent) {
        String string = cConnectionEvent.getConnectionName();
        CloudConnection cloudConnection = CloudConnections.getConnectionNode(string, true);
        if (cloudConnection != null) {
            this.add(cloudConnection, true);
        }
    }

    @Override
    public void connectionRemoved(CConnectionEvent cConnectionEvent) {
        String string = cConnectionEvent.getConnectionName();
        CloudConnection cloudConnection = CloudConnections.getConnectionNode(string, false);
        if (cloudConnection != null) {
            this.remove(cloudConnection, true);
        }
    }

    @Override
    public void connectionModified(CConnectionEvent cConnectionEvent) {
    }

    @Override
    public void connectionOpened(CConnectionEvent cConnectionEvent) {
        String string = cConnectionEvent.getConnectionName();
        CloudConnection cloudConnection = CloudConnections.getConnectionNode(string, false);
        if (cloudConnection != null && cloudConnection.openConnection()) {
            UpdateMessage.fireObjectOpened((Subject)cloudConnection);
        }
    }

    @Override
    public void connectionClosed(CConnectionEvent cConnectionEvent) {
        String string = cConnectionEvent.getConnectionName();
        CloudConnection cloudConnection = CloudConnections.getConnectionNode(string, false);
        if (cloudConnection != null && cloudConnection.isConnectionOpen()) {
            cloudConnection.closeConnection(false);
            UpdateMessage.fireObjectClosed((Subject)cloudConnection);
        }
    }

    private static class Holder {
        private static final CloudConnections CONNECTIONS = new CloudConnections();

        private Holder() {
        }
    }
}

