/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.connection;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.naming.NameAlreadyBoundException;
import javax.swing.SwingUtilities;
import oracle.dbtools.http.Client;
import oracle.dbtools.http.SessionException;
import oracle.dbtools.http.SessionInfo;
import oracle.dbtools.http.SessionManager;
import oracle.dbtools.http.SessionType;
import oracle.dbtools.raptor.cloud.connection.CConnectionEvent;
import oracle.dbtools.raptor.cloud.connection.CConnectionsListener;
import oracle.dbtools.raptor.cloud.connection.CloudConnectionType;
import oracle.dbtools.raptor.cloud.connection.ConnectionInfoReferenceable;
import oracle.dbtools.raptor.cloud.connection.DefaultClient;
import oracle.dbtools.raptor.utils.persistence.PersistenceManager;

public class CConnections
extends SessionManager {
    private static Map<SessionType, CConnections> s_connTypes = new HashMap<SessionType, CConnections>();
    private List<CConnectionsListener> m_listeners = new CopyOnWriteArrayList<CConnectionsListener>();
    private PersistenceManager<ConnectionInfoReferenceable> mPersistenceManager;

    public static synchronized CConnections getInstance() {
        return CConnections.getInstance(CloudConnectionType.getInstance());
    }

    public static synchronized CConnections getInstance(SessionType sessionType) {
        CConnections cConnections = s_connTypes.get(sessionType);
        if (cConnections == null) {
            cConnections = new CConnections(sessionType);
            s_connTypes.put(sessionType, cConnections);
        }
        return cConnections;
    }

    private CConnections(SessionType sessionType) {
        super(sessionType);
    }

    protected Client createClient() {
        return new DefaultClient(this.getConnectionType());
    }

    PersistenceManager<ConnectionInfoReferenceable> getPersistenceManager() {
        if (this.mPersistenceManager == null) {
            this.mPersistenceManager = new PersistenceManager<ConnectionInfoReferenceable>(this.getConnectionType().getType(), ConnectionInfoReferenceable.class);
        }
        return this.mPersistenceManager;
    }

    void migrateConnections(Map<String, SessionInfo> map) {
        if (map.size() > 0) {
            HashMap<String, ConnectionInfoReferenceable> hashMap = new HashMap<String, ConnectionInfoReferenceable>();
            for (Map.Entry<String, SessionInfo> entry : map.entrySet()) {
                hashMap.put(entry.getKey(), new ConnectionInfoReferenceable(entry.getValue()));
            }
            this.getPersistenceManager().addObjects(hashMap);
        }
    }

    public void addListener(CConnectionsListener cConnectionsListener) {
        this.m_listeners.add(cConnectionsListener);
    }

    public void removeListener(CConnectionsListener cConnectionsListener) {
        this.m_listeners.remove(cConnectionsListener);
    }

    protected void notifyConnectionClosed(String string) {
        this.fireConnectionsEvent(new CConnectionEvent(1, string), false);
    }

    protected void notifyConnectionOpened(String string) {
        this.fireConnectionsEvent(new CConnectionEvent(0, string), false);
    }

    void fireConnectionsEvent(final CConnectionEvent cConnectionEvent, boolean bl) {
        final Iterator<CConnectionsListener> iterator = this.m_listeners.iterator();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                switch (cConnectionEvent.getID()) {
                    case 2: {
                        while (iterator.hasNext()) {
                            ((CConnectionsListener)iterator.next()).connectionAdded(cConnectionEvent);
                        }
                        break;
                    }
                    case 3: {
                        while (iterator.hasNext()) {
                            ((CConnectionsListener)iterator.next()).connectionRemoved(cConnectionEvent);
                        }
                        break;
                    }
                    case 4: {
                        while (iterator.hasNext()) {
                            ((CConnectionsListener)iterator.next()).connectionModified(cConnectionEvent);
                        }
                        break;
                    }
                    case 1: {
                        while (iterator.hasNext()) {
                            ((CConnectionsListener)iterator.next()).connectionClosed(cConnectionEvent);
                        }
                        break;
                    }
                    case 0: {
                        while (iterator.hasNext()) {
                            ((CConnectionsListener)iterator.next()).connectionOpened(cConnectionEvent);
                        }
                        break;
                    }
                }
            }
        };
        if (bl) {
            SwingUtilities.invokeLater(runnable);
        } else {
            runnable.run();
        }
    }

    public String[] listConnections() {
        return this.getPersistenceManager().listNames();
    }

    public void addConnection(String string, SessionInfo sessionInfo) throws SessionException {
        try {
            if (this.getPersistenceManager().addObject(string, new ConnectionInfoReferenceable(sessionInfo))) {
                this.fireConnectionsEvent(new CConnectionEvent(2, string), true);
            }
        }
        catch (NameAlreadyBoundException nameAlreadyBoundException) {
            throw new SessionException((Throwable)new IllegalArgumentException("Duplicate name: " + string));
        }
    }

    protected void modifyConnectionImpl(String string, SessionInfo sessionInfo) {
        if (this.getPersistenceManager().updateObject(string, new ConnectionInfoReferenceable(sessionInfo))) {
            this.fireConnectionsEvent(new CConnectionEvent(4, string), true);
        }
    }

    protected void removeConnectionImpl(String string) {
        if (this.getPersistenceManager().removeObject(string)) {
            this.fireConnectionsEvent(new CConnectionEvent(3, string), true);
        }
    }

    public SessionInfo getConnectionInfo(String string) {
        ConnectionInfoReferenceable connectionInfoReferenceable = this.getPersistenceManager().getObject(string);
        return connectionInfoReferenceable != null ? connectionInfoReferenceable.getConnectionInfo() : null;
    }
}

