/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.awt.Component;
import java.awt.Point;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.SwingWorker;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.DictionaryQuery;
import oracle.dbtools.parser.plsql.IdentifiersDb;
import oracle.dbtools.parser.plsql.Item;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.parser.plsql.Messages;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.raptor.RaptorDBAddin;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.ViewerOpener;
import oracle.dbtools.raptor.editors.DbEditor;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.Member;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.oviewer.base.PopupDescribe;
import oracle.dbtools.raptor.plsql.BackgroundParser;
import oracle.dbtools.raptor.plsql.EquippedWithParser;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.TNSHelper;
import oracle.dbtools.util.Array;
import oracle.dbtools.util.Pair;
import oracle.dbtools.util.Service;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.AbstractBrowseClickPlugin;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.view.View;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.BasicEditorPaneContainer;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.plugins.AbstractClickPlugin;
import oracle.javatools.util.ModelUtil;

public final class IdentifierDefinitionLookup
extends AbstractBrowseClickPlugin
implements Controller {
    private static final Logger LOGGER = Logger.getLogger(IdentifierDefinitionLookup.class.getName());
    public static final int DEF_LOOKUP_ID = Ide.findOrCreateCmdID((String)"oracle.dbtools.parser.plsql.IdentifierDefinitionLookup.DEF_LOOKUP_ID");
    private LazyNode m_output;
    private List<LexerToken> m_src;
    BasicEditorPane m_pane;
    String m_connName;
    private String m_schema;
    private ParseNode m_id;
    private ParseNode m_def;
    private Action m_action;
    static int[] plsqlRules = null;
    Context ctx;
    private URL m_url;
    private static ViewerOpener viewerOpener;

    private String getConnectionName(Context context) {
        String string = null;
        Node node = context.getNode();
        View view = context.getView();
        if (node instanceof PlSqlNode) {
            PlSqlNode plSqlNode = (PlSqlNode)node;
            string = plSqlNode.getConnectionName() != null ? plSqlNode.getConnectionName() : DBURLFormatHelper.getConnectionName(plSqlNode.getURL());
        } else if (view instanceof BasicEditorPaneContainer) {
            string = view instanceof DbEditor ? ((DbEditor)view).getConnectionName() : (String)context.getProperty("Connections.db_name");
        }
        return string;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == DEF_LOOKUP_ID) {
            Node node = context.getNode();
            View view = context.getView();
            this.m_connName = this.getConnectionName(context);
            if (node instanceof PlSqlNode) {
                PlSqlNode plSqlNode = (PlSqlNode)node;
                this.m_schema = (String)plSqlNode.getProperty("SCHEMA");
                this.m_pane = ((BasicEditorPaneContainer)view).getFocusedEditorPane();
                this.m_src = plSqlNode.getParser().src;
                this.m_output = plSqlNode.getParser().output;
                this.finishIdLookup(plSqlNode);
            } else if (view instanceof BasicEditorPaneContainer && view instanceof EquippedWithParser && view instanceof DbEditor) {
                this.m_pane = ((BasicEditorPaneContainer)view).getFocusedEditorPane();
                BackgroundParser backgroundParser = ((EquippedWithParser)view).getParser();
                this.m_src = backgroundParser.src;
                this.m_output = backgroundParser.output;
                this.finishIdLookup(null);
            }
            return true;
        }
        return false;
    }

    void finishIdLookup(PlSqlNode plSqlNode) {
        int n = this.m_pane.getCaretPosition();
        LOGGER.info(Messages.getString("IdentifierDefinitionLookup.3") + n);
        this.parseIdentifierAtOffset(n, this.m_output, this.m_src, this.m_connName, this.m_pane, plSqlNode);
        if (this.m_action != null) {
            this.m_action.schema = this.m_schema;
            this.m_action.eval();
        }
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == DEF_LOOKUP_ID) {
            ideAction.setEnabled(this.isAvailable(context));
            return true;
        }
        return false;
    }

    private boolean isAvailable(Context context) {
        BackgroundParser backgroundParser;
        PlSqlNode plSqlNode;
        this.m_connName = this.getConnectionName(context);
        if (this.m_connName == null) {
            return false;
        }
        if (Connections.getInstance().checkLock(this.m_connName)) {
            return false;
        }
        Node node = context.getNode();
        View view = context.getView();
        return node instanceof PlSqlNode ? (plSqlNode = (PlSqlNode)node).getParser() != null && plSqlNode.getParser().output != null : view instanceof BasicEditorPaneContainer && view instanceof EquippedWithParser && view instanceof DbEditor && (backgroundParser = ((EquippedWithParser)view).getParser()) != null && backgroundParser.output != null;
    }

    protected void parseIdentifierAtOffset(int n, LazyNode lazyNode, List<LexerToken> list, String string, BasicEditorPane basicEditorPane, PlSqlNode plSqlNode) {
        String string2;
        Matrix matrix;
        Object object3;
        Object object22;
        this.m_action = null;
        LOGGER.info("Source offset:" + n);
        LexerToken lexerToken = null;
        int n2 = -1;
        int n3 = -1;
        for (Object object22 : list) {
            ++n3;
            if (".".equals(object22.content)) {
                lexerToken = object22;
            }
            if ("@".equals(object22.content)) {
                n2 = n3;
            }
            if (object22.begin > n || n > object22.end) continue;
            if (n2 != -1 && n3 < n2 + 20) {
                LinkedList<LexerToken> linkedList = new LinkedList<LexerToken>();
                for (int i = n2; i < list.size() && i < n3 + 20; ++i) {
                    linkedList.add(list.get(i));
                }
                object3 = SqlEarley.partialRecognizer();
                matrix = new Matrix((Parser)object3);
                object3.parse(linkedList, matrix);
                ParseNode parseNode = object3.forest(linkedList, matrix);
                ParseNode parseNode2 = this.recognizeAtCommand(parseNode);
                if (parseNode2 != null && parseNode2.from == 0) {
                    String string3 = "";
                    for (int i = 1; i < parseNode2.to; ++i) {
                        string3 = string3 + ((LexerToken)linkedList.get((int)i)).content;
                    }
                    if (string3.startsWith("@")) {
                        string3 = string3.substring(1);
                    }
                    if (string3.charAt(0) == '\"') {
                        string3 = string3.substring(1, string3.length() - 1);
                    }
                    this.m_action = new Action.SCRIPT(string3, string, this.m_url);
                    parseNode2.from += n2;
                    parseNode2.to += n2;
                    this.m_id = parseNode2;
                    return;
                }
            }
            if (object22.type != Token.IDENTIFIER && object22.type != Token.DQUOTED_STRING) continue;
            int n4 = n3;
            if (lexerToken != null && lexerToken.end == object22.begin && 1 < n3) {
                n4 = n3 - 2;
            }
            if (lexerToken == null && n3 + 1 < list.size() && ".".equals(list.get((int)(n3 + 1)).content)) {
                lazyNode.expand();
                object3 = lazyNode.parent(n4, n4 + 1);
                if (object3 != null && object3.contains(IdentifiersDb.instance.table_reference)) {
                    n3 += 2;
                }
            }
            this.m_id = new ParseNode(n4, n3 + 1, -1, -1, null);
            break;
        }
        if (this.m_id == null) {
            return;
        }
        LOGGER.info("Identifier: [" + this.m_id.from + "," + this.m_id.to + ")");
        this.m_def = this.getIdentifierDefinition(this.m_id.content(list), this.m_id.from, (ParseNode)lazyNode, list);
        if (this.m_def != null && this.m_def.from <= this.m_id.from && this.m_id.to <= this.m_def.to && (this.m_def.contains(IdentifiersDb.instance.table_reference) || this.m_def.contains(IdentifiersDb.instance.aliased_dml_table_expression_clause))) {
            this.m_action = new Action.TABLE(list, this.m_id, string);
            return;
        }
        if (this.m_def != null) {
            LOGGER.info(MessageFormat.format(Messages.getString("IdentifierDefinitionLookup.10"), this.m_def.from, this.m_def.to));
            this.m_action = new Action.LOCAL(list, this.m_def, basicEditorPane);
            return;
        }
        if (this.memberLookup(lazyNode, list, basicEditorPane, plSqlNode)) {
            return;
        }
        ParseNode parseNode = lazyNode.parent(this.m_id.from, this.m_id.to);
        object22 = this.m_id;
        if (parseNode != null) {
            for (Object object3 : parseNode.children()) {
                if (((ParseNode)object3).from != this.m_id.from || ((ParseNode)object3).to != this.m_id.to) continue;
                object22 = object3;
            }
            if (parseNode != null && (parseNode.contains(IdentifiersDb.instance.procedure_call) || parseNode.contains(IdentifiersDb.instance.name_wo_function_call))) {
                this.m_action = new Action.PLSQL(list, parseNode, string, n, (ParseNode)lazyNode, basicEditorPane);
                this.m_id = parseNode;
                return;
            }
            if (object22.contains(IdentifiersDb.instance.procedure_call) || object22.contains(IdentifiersDb.instance.expr) || object22.contains(IdentifiersDb.instance.unconstrained_type)) {
                this.m_action = new Action.PLSQL(list, (ParseNode)object22, string, n, (ParseNode)lazyNode, basicEditorPane);
                this.m_id = object22;
                return;
            }
            if (parseNode != null && parseNode.contains(IdentifiersDb.instance.adt_field) || parseNode != null && parseNode.contains(IdentifiersDb.instance.object_d)) {
                this.m_action = new Action.TYPE(list, parseNode, string);
                return;
            }
        }
        if (3 < list.size() && list.size() < 1000) {
            SqlEarley sqlEarley = SqlEarley.partialRecognizer();
            object3 = new Matrix((Parser)sqlEarley);
            sqlEarley.parse(list, (Matrix)object3);
            if (plsqlRules == null) {
                int n5 = IdentifiersDb.instance.procedure_call;
                int n6 = sqlEarley.getSymbol("function_call");
                for (int i = 0; i < sqlEarley.rules.length; ++i) {
                    Earley.Tuple tuple = sqlEarley.rules[i];
                    if (tuple.head != n5 && tuple.head != n6) continue;
                    plsqlRules = Array.insert((int[])plsqlRules, (int)i);
                }
            }
            if ((matrix = object3.get(this.m_id.from, this.m_id.to)) == null) {
                return;
            }
            for (int i = 0; i < matrix.size(); ++i) {
                int n7 = matrix.getRule(i);
                if (plsqlRules[Array.indexOf((int[])plsqlRules, (int)n7)] != n7) continue;
                this.m_action = new Action.PLSQL(list, this.m_id, string, n, (ParseNode)lazyNode, basicEditorPane);
                return;
            }
        }
        if ((object3 = DBObject.getDBObjectForName((string2 = PopupDescribe.extractName(n, list)).toString(), string)) != null) {
            if ("TABLE".equals(((DBObject)object3).getObjectType()) || "VIEW".equals(((DBObject)object3).getObjectType())) {
                this.m_action = new Action.TABLE(list, this.m_id, string);
            } else if (((DBObject)object3).getObjectType().startsWith("PACKAGE") || "PROCEDURE".equals(((DBObject)object3).getObjectType()) || "TYPE".equals(((DBObject)object3).getObjectType()) || "FUNCTION".equals(((DBObject)object3).getObjectType())) {
                this.m_action = new Action.PLSQL(list, this.m_id, string, n, (ParseNode)lazyNode, basicEditorPane);
            }
        }
    }

    private ParseNode recognizeAtCommand(ParseNode parseNode) {
        if (parseNode.contains(SqlEarley.getInstance().getSymbol("double_at_sign"))) {
            return parseNode;
        }
        if (parseNode.contains(SqlEarley.getInstance().getSymbol("at_sign"))) {
            return parseNode;
        }
        for (ParseNode parseNode2 : parseNode.children()) {
            ParseNode parseNode3 = this.recognizeAtCommand(parseNode2);
            if (parseNode3 == null) continue;
            return parseNode3;
        }
        return null;
    }

    private boolean memberLookup(LazyNode lazyNode, List<LexerToken> list, BasicEditorPane basicEditorPane, PlSqlNode plSqlNode) {
        if (plSqlNode != null) {
            PlSqlNode plSqlNode2;
            URL uRL;
            String string;
            URL uRL2 = plSqlNode.getURL();
            if (!plSqlNode.isBody()) {
                string = DBURLFormatHelper.getBaseType(uRL2) + " BODY";
                uRL = DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", DBURLFormatHelper.getConnectionName(uRL2), "", DBURLFormatHelper.getSchema(uRL2), string), DBURLFormatHelper.getName(uRL2));
                plSqlNode2 = PlSqlNode.find(uRL);
                if (plSqlNode2 != null && this.findMember(lazyNode, list, basicEditorPane, plSqlNode2)) {
                    return true;
                }
            }
            if (this.findMember(lazyNode, list, basicEditorPane, plSqlNode)) {
                return true;
            }
            if (plSqlNode.isBody()) {
                string = DBURLFormatHelper.getBaseType(uRL2);
                uRL = DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", DBURLFormatHelper.getConnectionName(uRL2), "", DBURLFormatHelper.getSchema(uRL2), string.substring(0, string.indexOf(32))), DBURLFormatHelper.getName(uRL2));
                plSqlNode2 = PlSqlNode.find(uRL);
                if (this.findMember(lazyNode, list, basicEditorPane, plSqlNode2)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean findMember(LazyNode lazyNode, List<LexerToken> list, BasicEditorPane basicEditorPane, PlSqlNode plSqlNode) {
        String string = this.m_id.content(list);
        Member object = null;
        List<Member> list2 = plSqlNode.getMembers(string);
        if (list2.size() == 1) {
            object = list2.get(0);
        } else {
            ParseNode parseNode;
            int n = 0;
            int n2 = -1;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (LexerToken object2 : list) {
                if (++n2 <= this.m_id.from) continue;
                if ("(".equals(object2.content)) {
                    ++n;
                } else if (")".equals(object2.content)) {
                    --n;
                }
                if (n == 0) break;
                if (object2.type == Token.OPERATION) continue;
                if (object2.type == Token.DIGITS) {
                    arrayList.add("NUMBER");
                    continue;
                }
                if (object2.type == Token.QUOTED_STRING) {
                    arrayList.add("CHAR");
                    continue;
                }
                parseNode = this.getIdentifierDefinition(object2.content, n2, (ParseNode)lazyNode, list);
                if (parseNode == null) continue;
                arrayList.add(list.get((int)(parseNode.from + 1)).content);
            }
            for (Member member : list2) {
                parseNode = member.getSignature();
                if (parseNode.size() != arrayList.size()) continue;
                boolean bl = false;
                for (int i = 0; i < parseNode.size(); ++i) {
                    String string2 = parseNode.get((int)i).type;
                    String string3 = (String)arrayList.get(i);
                    if (this.typesMatch(string2, string3)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                object = member;
                break;
            }
        }
        if (object != null) {
            LOGGER.info("Found member:" + object.name);
            this.m_action = new Action.MEMBER(object, basicEditorPane);
            return true;
        }
        return false;
    }

    private boolean typesMatch(String string, String string2) {
        if (string.equalsIgnoreCase(string2)) {
            return true;
        }
        if ("CHAR".equalsIgnoreCase(string)) {
            return string2.contains(string);
        }
        if ("CHAR".equalsIgnoreCase(string2)) {
            return string.contains(string2);
        }
        if ("INTEGER".equalsIgnoreCase(string2)) {
            return string.equalsIgnoreCase("NUMBER");
        }
        if ("INTEGER".equalsIgnoreCase(string)) {
            return string2.equalsIgnoreCase("NUMBER");
        }
        return false;
    }

    private static void goToTable(String string, String string2, String string3, String string4) {
        DictionaryQuery dictionaryQuery = new DictionaryQuery(string, string4);
        if (string3 == null) {
            dictionaryQuery.prepareAllObjects(string2, new String[]{"TABLE", "VIEW", "SYNONYM"}, new String[0]);
        } else {
            dictionaryQuery.prepareAllObjects(string2, new String[]{"TABLE", "VIEW", "SYNONYM"}, new String[]{string3});
        }
        ArrayList<Item> arrayList = dictionaryQuery.fetch(null);
        if (arrayList.size() == 0) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)MessageFormat.format(Messages.getString("ObjectDoesntExist"), "Table", string2), (String)Messages.getString("DefinitionNotFound"), null);
            return;
        }
        arrayList.get(0).goTo(dictionaryQuery.getConnectionName());
    }

    private static void goToPlSql(String string, String string2, String string3, List<LexerToken> list, String string4) {
        Object object;
        DictionaryQuery dictionaryQuery = new DictionaryQuery(string, string4);
        if (string3.charAt(0) != '\"') {
            string3 = string3.toUpperCase();
        }
        if (string2 == null) {
            dictionaryQuery.prepareAllObjects(string3, "FUNCTION");
            dictionaryQuery.prepareAllObjects(string3, "PROCEDURE");
            dictionaryQuery.prepareAllObjects(string3, "TYPE");
            object = IdentifierDefinitionLookup.getPkgName(list);
            if (object != null) {
                dictionaryQuery.prepareAllSource(string4, (String)object, string3);
            } else {
                dictionaryQuery.prepareAllObjects(string3, "PACKAGE");
            }
        } else {
            dictionaryQuery.prepareProcedure(string2, string3);
        }
        object = dictionaryQuery.fetch(null);
        if (((ArrayList)object).size() == 0) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)MessageFormat.format(Messages.getString("ObjectDoesntExist"), "PL/SQL unit", string3), (String)Messages.getString("DefinitionNotFound"), null);
            return;
        }
        Item item = ((ArrayList)object).get(0);
        Iterator iterator = ((ArrayList)object).iterator();
        while (iterator.hasNext()) {
            Item item2 = (Item)iterator.next();
            if (item2.line >= 0) continue;
            item = item2;
            break;
        }
        item.goTo(dictionaryQuery.getConnectionName());
    }

    private static void goToType(String string, String string2, String string3, String string4) {
        DictionaryQuery dictionaryQuery = new DictionaryQuery(string, string4);
        dictionaryQuery.prepareObject(string2, "TYPE", string3);
        dictionaryQuery.fetch(null).get(0).goTo(dictionaryQuery.getConnectionName());
    }

    private static void goToScript(String string, String string2, URL uRL) {
        Object object;
        Object object2;
        String string3 = File.separator;
        String string4 = string2.replaceFirst("@", "").trim();
        if (string2.startsWith("?")) {
            object2 = TNSHelper.getOracleHome();
            string4 = (String)(object2 == null ? "" : object2) + string2.substring(1);
        } else if (!string2.startsWith(File.separator) && !string2.contains(":")) {
            object2 = DBConfig.getInstance().getScriptDirectory().getFile();
            string4 = (String)object2 + (!((String)object2).endsWith(string3) ? string3 : "") + string2;
        }
        object2 = new File(string4);
        if (!((File)object2).exists() && uRL != null) {
            object = uRL.getPath().substring(0, uRL.getPath().lastIndexOf(string3));
            String string5 = (String)object + (!((String)object).endsWith(string3) ? string3 : "") + string2;
            object2 = new File(string5);
        }
        if (((File)object2).exists() && ((File)object2).canRead()) {
            try {
                object = ((File)object2).toURI().toURL();
                RaptorDBAddin.getSqlOpener().openNewEditor((URL)object, string);
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println("goToScript() MalformedURLException: " + string2);
            }
        } else {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)"File does not exist or cannot be located. ", (String)"File Not Found", (String)"f1_ctrlclick_file_html");
        }
    }

    private static String getPkgName(List<LexerToken> list) {
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        int n = -1;
        for (LexerToken lexerToken : list) {
            if (++n > 10) break;
            if (bl2) {
                string = lexerToken.content;
            }
            bl2 = bl && "BODY".equalsIgnoreCase(lexerToken.content);
            if ("PACKAGE".equalsIgnoreCase(lexerToken.content)) {
                bl = true;
                continue;
            }
            bl = false;
        }
        return string;
    }

    public ParseNode getIdentifierDefinition(String string, int n, ParseNode parseNode, List<LexerToken> list) {
        Map<ParseNode, Pair<Integer, Integer>> map = null;
        map = parseNode instanceof LazyNode ? IdentifiersDb.collectIdentifiers(n, n + 1, (LazyNode)parseNode) : IdentifiersDb.instance.collectIdentifiers(parseNode);
        return IdentifiersDb.getIdentifierDefinition(string, n, list, map);
    }

    public IdentifierDefinitionLookup() {
        this(null);
    }

    public IdentifierDefinitionLookup(Context context) {
        this.ctx = context;
    }

    protected NumberRange getIdentifierAtOffset(int n) {
        if (this.ctx == null) {
            return null;
        }
        Node node = this.ctx.getNode();
        View view = this.ctx.getView();
        if (node instanceof PlSqlNode) {
            PlSqlNode plSqlNode = (PlSqlNode)node;
            this.m_pane = ((BasicEditorPaneContainer)view).getFocusedEditorPane();
            this.m_url = ((PlSqlNode)node).getURL();
            this.m_schema = (String)plSqlNode.getProperty("SCHEMA");
            this.m_connName = plSqlNode.getConnectionName() != null ? plSqlNode.getConnectionName() : DBURLFormatHelper.getConnectionName(plSqlNode.getURL());
            this.m_src = plSqlNode.getParser().src;
            this.m_output = plSqlNode.getParser().output;
            return this.finishIdSelection(n, plSqlNode);
        }
        if (view instanceof BasicEditorPaneContainer && view instanceof EquippedWithParser && view instanceof DbEditor) {
            this.m_pane = ((BasicEditorPaneContainer)view).getFocusedEditorPane();
            this.m_url = node.getURL();
            this.m_connName = ((DbEditor)view).getConnectionName();
            BackgroundParser backgroundParser = ((EquippedWithParser)view).getParser();
            this.m_src = backgroundParser.src;
            this.m_output = backgroundParser.output;
            return this.finishIdSelection(n, null);
        }
        return null;
    }

    private NumberRange finishIdSelection(int n, PlSqlNode plSqlNode) {
        this.parseIdentifierAtOffset(n, this.m_output, this.m_src, this.m_connName, this.m_pane, plSqlNode);
        if (this.m_action != null) {
            return new NumberRange(this.m_src.get((int)this.m_id.from).begin, this.m_src.get((int)(this.m_id.to - 1)).end);
        }
        return null;
    }

    protected void performDeclarationClick(Point point) {
        if (this.m_action != null) {
            this.m_action.schema = this.m_schema;
            this.m_action.eval();
        }
    }

    public static boolean goTo(URL uRL, boolean bl) {
        return IdentifierDefinitionLookup.goTo(uRL, bl, null);
    }

    private static boolean goTo(URL uRL, boolean bl, String string) {
        if (uRL == null) {
            return false;
        }
        String string2 = null;
        if (bl) {
            string2 = Service.from2chars((String)DBURLFormatHelper.getCatalog(uRL));
        }
        if (string2 != null) {
            int n = string2.indexOf(44);
            int n2 = Integer.parseInt(string2.substring(0, n));
            int n3 = Service.X((int)n2);
            int n4 = Service.Y((int)n2);
            URL uRL2 = DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", DBURLFormatHelper.getConnectionName(uRL), "", DBURLFormatHelper.getSchema(uRL), DBURLFormatHelper.getBaseType(uRL)), DBURLFormatHelper.getName(uRL));
            return viewerOpener.waitOnOpen(uRL2, n3, n4);
        }
        String string3 = DBURLFormatHelper.getName(uRL);
        boolean bl2 = viewerOpener.waitOnOpen(uRL, string);
        if (!bl2 && ModelUtil.hasLength((String)string3) && string3.indexOf(46) >= 0) {
            string3 = string3.substring(0, string3.indexOf(46));
            uRL = DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", DBURLFormatHelper.getConnectionName(uRL), "", DBURLFormatHelper.getSchema(uRL), DBURLFormatHelper.getBaseType(uRL)), string3);
            return viewerOpener.waitOnOpen(uRL, string);
        }
        return bl2;
    }

    public static void registerViewerOpener(ViewerOpener viewerOpener) {
        IdentifierDefinitionLookup.viewerOpener = viewerOpener;
    }

    protected void updateHighlight(Point point, final int n) {
        Method method;
        HighlightLayer highlightLayer = null;
        try {
            method = AbstractClickPlugin.class.getDeclaredMethod("getHighlightLayer", new Class[0]);
            method.setAccessible(true);
            highlightLayer = (HighlightLayer)method.invoke((Object)this, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        method = highlightLayer;
        if (point == null) {
            if (method != null) {
                method.removeAllHighlights();
            }
            return;
        }
        final int n2 = this.getEditorPane().viewToModel(point);
        if (method != null) {
            method.removeAllHighlights();
            SwingWorker swingWorker = new SwingWorker((HighlightLayer)method){
                NumberRange offsets = null;
                HighlightStyle highlightToUse = null;
                final /* synthetic */ HighlightLayer val$layerToUse;
                {
                    this.val$layerToUse = highlightLayer;
                }

                public Object doInBackground() {
                    if (n != -1) {
                        this.highlightToUse = IdentifierDefinitionLookup.this.getHighlightStyleFor(n);
                        if (this.highlightToUse != null) {
                            this.offsets = IdentifierDefinitionLookup.this.getRegionFor(n2, n);
                        }
                    }
                    return null;
                }

                @Override
                public void done() {
                    if (this.offsets != null && this.highlightToUse != null) {
                        this.val$layerToUse.addHighlight(this.highlightToUse, this.offsets.start, this.offsets.end);
                    }
                    IdentifierDefinitionLookup.this.updateHint(n);
                }
            };
            swingWorker.execute();
        }
    }

    static abstract class Action {
        String schema = null;

        Action() {
        }

        abstract void eval();

        static class SCRIPT
        extends Action {
            String fileName;
            String connName;
            URL url;

            SCRIPT(String string, String string2, URL uRL) {
                this.fileName = string;
                this.connName = string2;
                this.url = uRL;
            }

            @Override
            void eval() {
                IdentifierDefinitionLookup.goToScript(this.connName, this.fileName, this.url);
            }
        }

        static class TYPE
        extends Action {
            List<LexerToken> src;
            ParseNode id;
            String connName;

            TYPE(List<LexerToken> list, ParseNode parseNode, String string) {
                this.src = list;
                this.id = parseNode;
                this.connName = string;
            }

            @Override
            void eval() {
                String string = null;
                if (this.id.from + 3 == this.id.to) {
                    string = this.src.get((int)this.id.from).content;
                }
                IdentifierDefinitionLookup.goToType(this.connName, this.src.get((int)(this.id.to - 1)).content, string, this.schema);
            }
        }

        static class PLSQL
        extends Action {
            List<LexerToken> src;
            ParseNode id;
            ParseNode output;
            String connName;
            int scannerPos;
            BasicEditorPane panel;

            PLSQL(List<LexerToken> list, ParseNode parseNode, String string, int n, ParseNode parseNode2, BasicEditorPane basicEditorPane) {
                this.src = list;
                this.id = parseNode;
                this.connName = string;
                this.scannerPos = n;
                this.output = parseNode2;
                this.panel = basicEditorPane;
            }

            @Override
            void eval() {
                String string = null;
                String string2 = this.src.get((int)this.id.from).content;
                if (this.src.size() > this.id.from + 2 && ".".equals(this.src.get((int)(this.id.from + 1)).content)) {
                    string = this.src.get((int)this.id.from).content;
                    string2 = this.src.get((int)(this.id.from + 2)).content;
                }
                IdentifierDefinitionLookup.goToPlSql(this.connName, string, string2, this.src, this.schema);
            }
        }

        static class MEMBER
        extends Action {
            Member member;
            BasicEditorPane panel = null;
            PlSqlNode node = null;

            MEMBER(Member member, BasicEditorPane basicEditorPane) {
                this.member = member;
                this.panel = basicEditorPane;
            }

            MEMBER(Member member, PlSqlNode plSqlNode) {
                this.member = member;
                this.node = plSqlNode;
            }

            @Override
            void eval() {
                if (this.panel != null) {
                    this.panel.setSelectionStart(this.member.codeOffset);
                    this.panel.setSelectionEnd(this.member.codeOffset + this.member.name.length());
                } else {
                    Object object2;
                    EditorManager editorManager = EditorManager.getEditorManager();
                    Context context = null;
                    for (Object object2 : editorManager.getAllEditors()) {
                        Context context2 = ((Editor)object2).getContext();
                        Node node = context2 != null ? context2.getNode() : null;
                        if (node != this.node) continue;
                        context = context2;
                    }
                    if (context == null) {
                        context = Context.newIdeContext((Node)this.node);
                    }
                    OpenEditorOptions openEditorOptions = new OpenEditorOptions(context, CodeEditor.class);
                    object2 = (CodeEditor)editorManager.openEditor(openEditorOptions);
                    object2.setCaretPosition(this.member.codeOffset);
                }
            }
        }

        static class LOCAL
        extends Action {
            List<LexerToken> src;
            ParseNode def;
            BasicEditorPane panel;

            LOCAL(List<LexerToken> list, ParseNode parseNode, BasicEditorPane basicEditorPane) {
                this.src = list;
                this.def = parseNode;
                this.panel = basicEditorPane;
            }

            @Override
            void eval() {
                NumberRange numberRange = new NumberRange(this.src.get((int)this.def.from).begin, this.src.get((int)this.def.from).end);
                this.panel.setSelectionStart(numberRange.start);
                this.panel.setSelectionEnd(numberRange.end);
            }
        }

        static class TABLE
        extends Action {
            List<LexerToken> src;
            ParseNode id;
            String connName;

            TABLE(List<LexerToken> list, ParseNode parseNode, String string) {
                this.src = list;
                this.id = parseNode;
                this.connName = string;
            }

            @Override
            void eval() {
                String string = null;
                if (this.id.from + 3 == this.id.to) {
                    string = this.src.get((int)this.id.from).content;
                }
                IdentifierDefinitionLookup.goToTable(this.connName, this.src.get((int)(this.id.to - 1)).content, string, this.schema);
            }
        }
    }
}

