/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.sdm.debugger.gui;

import ilog.views.css.model.IlvRule;
import ilog.views.sdm.debugger.IlvDebuggerContext;
import ilog.views.sdm.debugger.IlvRulePositionTable;
import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.IlvResourceUtil;
import ilog.views.util.css.IlvCSSDocument;
import ilog.views.util.css.parser.Rule;
import ilog.views.util.styling.IlvCSSDeclaration;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class IlvTextPanel
extends JPanel {
    private IlvDebuggerContext a;
    private StyledDocument b;
    private JTextPane c;
    private Style d;
    private Style e;
    private Style f;
    private Style g;
    private Style h;
    private static ImageIcon i;
    private static ImageIcon j;
    private static ImageIcon k;
    private static ImageIcon l;
    private static ImageIcon m;
    private ArrayList<Integer> n = new ArrayList();
    private ArrayList<JButton> o = new ArrayList();
    private static final int p = 0;
    private static final int q = 1;
    private static final int r = 2;
    private IlvRulePositionTable s;
    private JTextField t;
    public static final byte ERROR_DECL = 21;
    public static final byte SKIP_DECL = 22;
    public static final byte SET_DECL = 23;
    private Style u;
    private int v;

    public IlvTextPanel(IlvDebuggerContext ilvDebuggerContext) {
        super(new BorderLayout());
        this.a = ilvDebuggerContext;
        ilvDebuggerContext.setBundle(IlvResourceUtil.getBundle((String)"ilog.views.sdm.debugger.gui", (Locale)IlvLocaleUtil.getCurrentLocale(), (ClassLoader)IlvTextPanel.class.getClassLoader()));
        this.c();
        this.a.setTextPanel(this);
    }

    private void c() {
        this.c = new JTextPane(){

            @Override
            public boolean getScrollableTracksViewportWidth() {
                Container container = this.getParent();
                TextUI textUI = this.getUI();
                return container != null ? textUI.getPreferredSize((JComponent)this).width <= container.getSize().width : true;
            }
        };
        this.c.setEditable(false);
        this.a(this.c);
        this.b(this.c);
        if (i == null) {
            i = new ImageIcon(this.getClass().getResource("bullet.gif"));
            j = new ImageIcon(this.getClass().getResource("next.gif"));
            k = new ImageIcon(this.getClass().getResource("bug.gif"));
            l = new ImageIcon(this.getClass().getResource("stop.gif"));
            m = new ImageIcon(this.getClass().getResource("customize-all.gif"));
        }
        this.c.addMouseListener(new TextClickListener());
        this.add((Component)new JScrollPane(this.c), "Center");
        this.t = new JTextField("         ");
        this.t.setEditable(false);
        this.t.setBorder(BorderFactory.createEtchedBorder());
        this.t.setHorizontalAlignment(10);
        this.add((Component)this.t, "South");
        this.add(this.d(), "North");
        this.setSize(200, 500);
        this.validate();
    }

    public boolean hasBreakpoints() {
        return !this.n.isEmpty();
    }

    private Component d() {
        JToolBar jToolBar = new JToolBar();
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand() == "debug") {
                    JButton jButton = (JButton)actionEvent.getSource();
                    jButton.setIcon(l);
                    jButton.setActionCommand("stop");
                    jButton.setToolTipText(IlvTextPanel.this.a.getBundle().getString("IlvTextPane.text.toolbar.stop.tooltiptext"));
                    IlvTextPanel.this.a.getDebugger().startAction();
                } else if (actionEvent.getActionCommand() == "next") {
                    IlvTextPanel.this.a.getDebugger().nextAction();
                } else if (actionEvent.getActionCommand() == "refresh") {
                    IlvTextPanel.this.a.getDiagrammer().getEngine().customizeAllObjects();
                } else if (actionEvent.getActionCommand() == "stop") {
                    JButton jButton = (JButton)actionEvent.getSource();
                    jButton.setIcon(k);
                    jButton.setActionCommand("debug");
                    jButton.setToolTipText(IlvTextPanel.this.a.getBundle().getString("IlvTextPane.text.toolbar.debug.tooltiptext"));
                    IlvTextPanel.this.a.getDebugger().stopAction();
                }
            }
        };
        this.o.add(this.a(k, "debug", this.a.getBundle().getString("IlvTextPane.text.toolbar.debug.tooltiptext"), actionListener, true));
        this.o.add(this.a(m, "refresh", this.a.getBundle().getString("IlvTextPane.text.toolbar.refresh.tooltiptext"), actionListener, true));
        this.o.add(this.a(j, "next", this.a.getBundle().getString("IlvTextPane.text.toolbar.next.tooltiptext"), actionListener, false));
        jToolBar.add(this.o.get(0));
        jToolBar.add(this.o.get(1));
        jToolBar.add(this.o.get(2));
        return jToolBar;
    }

    private JButton a(ImageIcon imageIcon, String string, String string2, ActionListener actionListener, boolean bl) {
        JButton jButton = new JButton();
        jButton.setActionCommand(string);
        jButton.setToolTipText(string2);
        jButton.setIcon(imageIcon);
        jButton.setEnabled(bl);
        jButton.addActionListener(actionListener);
        return jButton;
    }

    private void a(Point point) {
        int n = this.c.viewToModel(point);
        int n2 = this.s.getHomePosition(n);
        this.c.select(n2, n2 + 1);
        Integer n3 = new Integer(n2);
        if (this.n.contains(n3)) {
            this.n.remove(n3);
            try {
                this.b.remove(n2, 1);
                this.b.insertString(n2, " ", this.e);
                this.c.select(1, 1);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        } else {
            this.c.insertIcon(i);
            this.n.add(n3);
        }
    }

    private void a(JTextPane jTextPane) {
        this.b = jTextPane.getStyledDocument();
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        this.d = this.b.addStyle("regular", style);
        StyleConstants.setFontFamily(style, "Monospaced");
        this.e = this.b.addStyle("decl", this.d);
        StyleConstants.setBold(this.e, true);
        this.f = this.b.addStyle("stepDecl", this.e);
        StyleConstants.setBackground(this.f, Color.gray);
        StyleConstants.setForeground(this.f, Color.orange);
        this.g = this.b.addStyle("warningDecl", this.f);
        StyleConstants.setForeground(this.g, Color.blue);
        this.h = this.b.addStyle("errorDecl", this.f);
        StyleConstants.setForeground(this.h, Color.red);
    }

    public static void main(String[] stringArray) {
        HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
        HTMLDocument hTMLDocument = (HTMLDocument)hTMLEditorKit.createDefaultDocument();
        StyleSheet styleSheet = hTMLDocument.getStyleSheet();
        Enumeration<?> enumeration = styleSheet.getStyleNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Style style = styleSheet.getStyle(string);
            System.out.println(style.toString());
        }
        System.exit(0);
    }

    private void b(JTextPane jTextPane) {
        StyledDocument styledDocument = jTextPane.getStyledDocument();
        IlvCSSDocument ilvCSSDocument = new IlvCSSDocument();
        IlvRule[] ilvRuleArray = this.a.getRuleModel().getAllRules(true);
        this.s = new IlvRulePositionTable(ilvRuleArray.length);
        block3: for (int i = 0; i < ilvRuleArray.length; ++i) {
            Object object;
            IlvRule ilvRule = ilvRuleArray[i];
            if (ilvRule.isConfigurationRule()) continue;
            String string = ilvRule.getSelectorsString();
            if (!string.startsWith("node")) {
                if (!string.startsWith("link")) continue;
            }
            boolean bl = true;
            IlvCSSDeclaration[] ilvCSSDeclarationArray = ilvRule.getMetadata();
            for (int j = 0; j < ilvCSSDeclarationArray.length; ++j) {
                object = ilvCSSDeclarationArray[j];
                if (object.getProperty() != "_WRITABLE") continue;
                if (!object.getValue().equals("false")) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            StringWriter stringWriter = new StringWriter();
            object = new PrintWriter(stringWriter);
            ilvRule.printCSS((PrintWriter)object, ilvCSSDocument);
            ((PrintWriter)object).close();
            BufferedReader bufferedReader = new BufferedReader(new StringReader(stringWriter.toString()));
            try {
                int n = styledDocument.getLength();
                this.s.add(ilvRule, n);
                styledDocument.insertString(n, bufferedReader.readLine() + "\n", this.d);
                while (true) {
                    String string2 = bufferedReader.readLine();
                    if (string2.startsWith("}")) {
                        styledDocument.insertString(styledDocument.getLength(), "}\n", this.d);
                        continue block3;
                    }
                    n = styledDocument.getLength();
                    styledDocument.insertString(n, " " + string2 + "\n", this.e);
                    if (string2.trim().startsWith("_")) continue;
                    this.s.setNextDeclarationPosition(n);
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public boolean isKnownRule(Rule rule) {
        return this.s.isKnownRule(rule);
    }

    public void waitOn(Rule rule, String string, byte by, String string2) {
        int n = this.s.getPosition(rule, string);
        if (n == -1) {
            return;
        }
        this.a(rule, string, by, string2);
    }

    public boolean waitOnBreakpoint(Rule rule, String string, Object object, boolean bl) {
        boolean bl2 = false;
        int n = this.s.getPosition(rule, string);
        if (bl && n != -1 || this.n.contains(new Integer(n))) {
            this.a(rule, string, (byte)23, this.a.getBundle().getString("IlvTextPanel.message.prefix") + object);
            bl2 = true;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(Rule rule, String string, byte by, String string2) {
        Object object;
        Object object2 = object = this.a.getLock();
        synchronized (object2) {
            try {
                this.highlight(rule, string, string2, by);
                this.a.getDiagramPanel().highlightCurrentGraphic(true);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((JButton)IlvTextPanel.this.o.get(2)).setEnabled(true);
                        ((JButton)IlvTextPanel.this.o.get(1)).setEnabled(false);
                    }
                });
                try {
                    this.a.getEngine().getGrapher().abortReDraws();
                    object.wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                this.unhighlight();
                this.a.getDiagramPanel().highlightCurrentGraphic(false);
            }
            catch (Throwable throwable) {
                this.unhighlight();
                this.a.getDiagramPanel().highlightCurrentGraphic(false);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((JButton)IlvTextPanel.this.o.get(2)).setEnabled(false);
                        ((JButton)IlvTextPanel.this.o.get(1)).setEnabled(true);
                    }
                });
                throw throwable;
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
    }

    public void unhighlight() {
        if (this.u != null) {
            this.b.setLogicalStyle(this.v, this.u);
            this.u = null;
        }
        this.t.setText("   ");
    }

    public void highlight(Rule rule, String string, String string2, byte by) {
        if (SwingUtilities.isEventDispatchThread()) {
            System.err.println("IlvTextPanel.highlight(): in EDT!!");
        }
        try {
            this.unhighlight();
            this.v = this.s.getPosition(rule, string);
            this.u = this.b.getLogicalStyle(this.v);
            switch (by) {
                case 21: {
                    this.b.setLogicalStyle(this.v, this.h);
                    this.t.setText(string2);
                    break;
                }
                case 22: {
                    this.b.setLogicalStyle(this.v, this.g);
                    break;
                }
                case 23: {
                    this.b.setLogicalStyle(this.v, this.f);
                    this.t.setText(string2);
                }
            }
            this.c.select(this.v, this.v);
            this.repaint();
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    private class TextClickListener
    extends MouseAdapter {
        private TextClickListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            IlvTextPanel.this.a(mouseEvent.getPoint());
        }
    }
}

