/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.sdm.builder.gui;

import ilog.views.IlvGraphic;
import ilog.views.appframe.IlvApplication;
import ilog.views.builder.IlvBuilder;
import ilog.views.builder.gui.Utils;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.builder.docview.IlvSDMBuilderDocument;
import ilog.views.sdm.builder.gui.IlvPaletteGUI;
import ilog.views.symbology.IlvSymbolDescriptor;
import ilog.views.symbology.palettes.IlvPalette;
import ilog.views.symbology.palettes.IlvPaletteManager;
import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.IlvResourceUtil;
import ilog.views.util.swing.border.IlvEtchedLineBorder;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;

public class IlvManagePaletteDialog {
    private IlvSDMBuilderDocument a;
    private JDialog b;
    private ManagePaletteGUI c;
    private static final ResourceBundle d = IlvResourceUtil.getBundle((String)"ilog.views.sdm.builder.gui.IlvManagePaletteDialog", (Locale)IlvLocaleUtil.getCurrentLocale(), (ClassLoader)IlvManagePaletteDialog.class.getClassLoader());

    public IlvManagePaletteDialog(IlvSDMBuilderDocument ilvSDMBuilderDocument) {
        this.a = ilvSDMBuilderDocument;
        this.b = null;
        JFrame jFrame = IlvBuilder.getBuilder((IlvApplication)this.a.getApplication()).getFrame();
        this.a(jFrame);
    }

    public void showDialog() {
        JFrame jFrame = IlvBuilder.getBuilder((IlvApplication)this.a.getApplication()).getFrame();
        this.c.setCurrentPalettes(this.getCurrentPalettes());
        this.c.updateContents();
        this.b.setLocationRelativeTo(jFrame);
        this.b.setVisible(true);
    }

    protected Set<IlvPalette> getCurrentPalettes() {
        HashSet<IlvPalette> hashSet = new HashSet<IlvPalette>();
        Iterator iterator = this.a.getDiagrammer().getAllObjects();
        IlvSDMEngine ilvSDMEngine = this.a.getDiagrammer().getEngine();
        while (iterator.hasNext()) {
            IlvGraphic ilvGraphic = ilvSDMEngine.getGraphic(iterator.next(), false);
            IlvSymbolDescriptor ilvSymbolDescriptor = IlvSymbolDescriptor.get((IlvGraphic)ilvGraphic);
            if (ilvSymbolDescriptor == null) continue;
            hashSet.add(ilvSymbolDescriptor.getPalette());
        }
        return hashSet;
    }

    private void a(JFrame jFrame) {
        this.b = new JDialog((Frame)jFrame, true);
        ComponentOrientation componentOrientation = jFrame.getComponentOrientation();
        if (this.b.getComponentOrientation() != componentOrientation) {
            this.b.applyComponentOrientation(componentOrientation);
        }
        JComponent jComponent = (JComponent)this.b.getContentPane();
        this.c = new ManagePaletteGUI(this.a.getApplication(), this.a.getPaletteManager(), this.getCurrentPalettes());
        jComponent.add((Component)this.c.getComponent(), "Center");
        JPanel jPanel = new JPanel();
        jPanel.setBorder((Border)new IlvEtchedLineBorder());
        final JButton jButton = new JButton(d.getString("IlvManagePaletteDialog.close"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IlvManagePaletteDialog.this.b.setVisible(false);
            }
        });
        jPanel.add(jButton);
        jComponent.add((Component)jPanel, "South");
        jComponent.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jButton.doClick(10);
            }
        }, "close", KeyStroke.getKeyStroke(27, 0), 2);
        this.b.setTitle(this.c.getTitle());
        this.b.setSize(650, 600);
    }

    public static class ManagePaletteGUI
    extends IlvPaletteGUI {
        private Set<IlvPalette> a;

        public ManagePaletteGUI(IlvApplication ilvApplication, IlvPaletteManager ilvPaletteManager, Set<IlvPalette> set) {
            super(ilvApplication, ilvPaletteManager);
            this.a = set;
        }

        public void setCurrentPalettes(Set<IlvPalette> set) {
            this.a = set;
        }

        @Override
        protected String getTitle() {
            return d.getString("IlvManagePaletteDialog.title");
        }

        @Override
        protected String getDialogTitle() {
            return d.getString("IlvManagePaletteDialog.dialog.title");
        }

        @Override
        protected String getDialogDescription() {
            return d.getString("IlvManagePaletteDialog.dialog.description");
        }

        @Override
        protected boolean isClosePaletteAvailable() {
            return true;
        }

        @Override
        protected boolean isClosePaletteButtonEnabled() {
            IlvPalette ilvPalette = this._tree.getSelectedPalette();
            if (ilvPalette != null) {
                return !this.a.contains(ilvPalette);
            }
            return false;
        }

        @Override
        protected void updateContents() {
            super.updateContents();
            if (!this.a.isEmpty()) {
                this._tree.select(this.a.iterator().next());
            }
        }

        @Override
        protected void updateDetailArea(Box box) {
            JLabel jLabel;
            box.removeAll();
            Box box2 = new Box(2);
            if (this.a.isEmpty()) {
                jLabel = new JLabel(d.getString("IlvManagePaletteDialog.detail.noSymbol"));
            } else {
                Locale locale = IlvLocaleUtil.getCurrentLocale();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<html>");
                stringBuffer.append(d.getString("IlvManagePaletteDialog.detail.intro"));
                stringBuffer.append("<ul>");
                for (IlvPalette ilvPalette : this.a) {
                    stringBuffer.append("<li>");
                    stringBuffer.append(ilvPalette.getName(locale));
                    stringBuffer.append("<br>");
                    stringBuffer.append(ilvPalette.getJarURL().toExternalForm());
                    stringBuffer.append("</li>");
                }
                stringBuffer.append("</ul>");
                stringBuffer.append("</html>");
                jLabel = new JLabel(stringBuffer.toString());
            }
            jLabel.setForeground(Utils.LABEL_FOREGROUND_COLOR);
            jLabel.setFont(Utils.DESCRIPTION_FONT);
            box2.add(Box.createHorizontalStrut(5));
            box2.add(jLabel);
            box.add(box2);
            box.add(Box.createVerticalStrut(5));
        }
    }
}

