/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.hypergraph.edgeconnector;

import ilog.views.IlvApplyObject;
import ilog.views.IlvApplyObjects;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicVector;
import ilog.views.IlvManager;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvTransformer;
import ilog.views.hypergraph.IlvHyperEdge;
import ilog.views.hypergraph.IlvHyperEdgeEnd;
import ilog.views.hypergraph.edgeconnector.IlvHyperEdgeConnectorWithCache;
import ilog.views.hypergraph.edgeconnector.IlvHyperEdgePinConnectorSelection;
import ilog.views.hypergraph.edgeconnector.IlvHyperGrapherPin;
import ilog.views.hypergraph.internal.IlvGeometryUtil;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvPersistentObject;
import ilog.views.io.IlvReadFileException;
import ilog.views.util.collections.IlvCollections;
import java.awt.Graphics;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class IlvHyperEdgePinConnector
extends IlvHyperEdgeConnectorWithCache {
    private ArrayList a;
    private transient HashMap b;
    private transient boolean c;
    private transient boolean d;
    private boolean e = true;
    private boolean f = true;

    public IlvHyperEdgePinConnector() {
        this.e = true;
        this.f = true;
    }

    public IlvHyperEdgePinConnector(boolean bl) {
        this.e = bl;
        this.f = true;
    }

    public IlvHyperEdgePinConnector(IlvGraphic ilvGraphic) {
        super(ilvGraphic);
        this.e = true;
        this.f = true;
    }

    public IlvHyperEdgePinConnector(IlvHyperEdgePinConnector ilvHyperEdgePinConnector) {
        super(ilvHyperEdgePinConnector);
        this.e = ilvHyperEdgePinConnector.e;
        this.f = ilvHyperEdgePinConnector.f;
        if (ilvHyperEdgePinConnector.a != null) {
            int n = ilvHyperEdgePinConnector.a.size();
            ArrayList<IlvHyperGrapherPin> arrayList = new ArrayList<IlvHyperGrapherPin>(n);
            for (int i = 0; i < n; ++i) {
                IlvHyperGrapherPin ilvHyperGrapherPin = (IlvHyperGrapherPin)ilvHyperEdgePinConnector.a.get(i);
                arrayList.add(ilvHyperGrapherPin.copy());
            }
            this.addPins(arrayList, false);
        }
    }

    public IlvGraphic copy() {
        return new IlvHyperEdgePinConnector(this);
    }

    public IlvHyperEdgePinConnector(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.e = ilvInputStream.readBoolean("zoomable");
        this.f = ilvInputStream.readBoolean("restrictedToBorder");
        try {
            IlvPersistentObject[] ilvPersistentObjectArray = ilvInputStream.readPersistentObjects("pins");
            ArrayList<IlvPersistentObject> arrayList = new ArrayList<IlvPersistentObject>(ilvPersistentObjectArray.length);
            for (int i = 0; i < ilvPersistentObjectArray.length; ++i) {
                arrayList.add(ilvPersistentObjectArray[i]);
            }
            this.addPins(arrayList, false);
        }
        catch (IlvReadFileException ilvReadFileException) {
            // empty catch block
        }
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("zoomable", this.e);
        ilvOutputStream.write("restrictedToBorder", this.f);
        if (this.a != null && this.a.size() > 0) {
            IlvPersistentObject[] ilvPersistentObjectArray = new IlvPersistentObject[this.a.size()];
            ilvPersistentObjectArray = this.a.toArray(ilvPersistentObjectArray);
            ilvOutputStream.write("pins", ilvPersistentObjectArray);
        }
    }

    @Override
    public boolean isGraphic() {
        return true;
    }

    @Override
    public void attach(IlvGraphic ilvGraphic, boolean bl) {
        super.attach(ilvGraphic, bl);
    }

    @Override
    protected void attachImpl(IlvGraphic ilvGraphic) {
        super.attachImpl(ilvGraphic);
        this.b();
    }

    @Override
    public void detach(boolean bl) {
        super.detach(bl);
    }

    @Override
    protected void detachImpl() {
        this.disconnectAll();
        super.detachImpl();
    }

    public IlvGraphic getNode() {
        return this.getOwner();
    }

    public void addPin(IlvHyperGrapherPin ilvHyperGrapherPin, boolean bl) {
        IlvHyperEdgePinConnector ilvHyperEdgePinConnector = ilvHyperGrapherPin.getHyperEdgeConnector();
        if (ilvHyperEdgePinConnector == this) {
            return;
        }
        if (ilvHyperEdgePinConnector != null) {
            ilvHyperEdgePinConnector.removePin(ilvHyperGrapherPin, bl);
        }
        if (this.getGraphicBag() == null) {
            this.a(ilvHyperGrapherPin);
            this.b();
        } else {
            this.getGraphicBag().applyToObject((IlvGraphic)this, new IlvApplyObject(){

                public void apply(IlvGraphic ilvGraphic, Object object) {
                    IlvHyperEdgePinConnector.this.a((IlvHyperGrapherPin)object);
                    IlvHyperEdgePinConnector.this.b();
                }
            }, (Object)ilvHyperGrapherPin, bl);
        }
    }

    private void a(IlvHyperGrapherPin ilvHyperGrapherPin) {
        if (ilvHyperGrapherPin.getHyperEdgeConnector() != null) {
            throw new IllegalArgumentException("Pin already in a different connector");
        }
        if (this.a == null) {
            this.a = new ArrayList();
        }
        this.a.add(ilvHyperGrapherPin);
        ilvHyperGrapherPin.a(this);
    }

    public void addPins(Collection collection, boolean bl) {
        if (collection == null) {
            throw new IllegalArgumentException("Null pin collection");
        }
        if (this.a == null) {
            this.a = new ArrayList(collection.size());
        }
        if (this.getGraphicBag() == null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.a((IlvHyperGrapherPin)iterator.next());
            }
            this.b();
        } else {
            this.getGraphicBag().applyToObject((IlvGraphic)this, new IlvApplyObject(){

                public void apply(IlvGraphic ilvGraphic, Object object) {
                    Collection collection = (Collection)object;
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        IlvHyperEdgePinConnector.this.a((IlvHyperGrapherPin)iterator.next());
                    }
                    IlvHyperEdgePinConnector.this.b();
                }
            }, (Object)collection, bl);
        }
    }

    public void removePin(IlvHyperGrapherPin ilvHyperGrapherPin, boolean bl) {
        if (this.getGraphicBag() == null) {
            this.b(ilvHyperGrapherPin);
            this.b();
        } else {
            this.getGraphicBag().applyToObject((IlvGraphic)this, new IlvApplyObject(){

                public void apply(IlvGraphic ilvGraphic, Object object) {
                    IlvHyperEdgePinConnector.this.b((IlvHyperGrapherPin)object);
                    IlvHyperEdgePinConnector.this.b();
                }
            }, (Object)ilvHyperGrapherPin, bl);
        }
    }

    private void b(final IlvHyperGrapherPin ilvHyperGrapherPin) {
        if (ilvHyperGrapherPin.getHyperEdgeConnector() != this) {
            throw new IllegalArgumentException("Pin not in this connector");
        }
        IlvGraphicVector ilvGraphicVector = new IlvGraphicVector();
        Iterator iterator = ilvHyperGrapherPin.getConnectedEnds();
        IlvManager ilvManager = null;
        while (iterator.hasNext()) {
            IlvHyperEdgeEnd ilvHyperEdgeEnd = (IlvHyperEdgeEnd)iterator.next();
            IlvHyperEdge ilvHyperEdge = ilvHyperEdgeEnd.getHyperEdge();
            if (ilvHyperEdge == null || ilvHyperEdge.getGraphicBag() == null) continue;
            if (ilvManager != null) {
                ilvManager = (IlvManager)ilvHyperEdgeEnd.getHyperEdge().getTopLevelGraphicBag();
            }
            ilvGraphicVector.addElement((IlvGraphic)ilvHyperEdgeEnd.getHyperEdge());
        }
        if (ilvManager == null) {
            this.c(ilvHyperGrapherPin);
        } else {
            ilvManager.applyToObjects(ilvGraphicVector, new IlvApplyObjects(){

                public void apply(IlvGraphicVector ilvGraphicVector, Object object) {
                    IlvHyperEdgePinConnector.this.c(ilvHyperGrapherPin);
                }
            }, null, true);
        }
    }

    private void c(IlvHyperGrapherPin ilvHyperGrapherPin) {
        Iterator iterator = ilvHyperGrapherPin.getConnectedEnds();
        ilvHyperGrapherPin.a();
        while (iterator.hasNext()) {
            this.disconnect((IlvHyperEdgeEnd)iterator.next());
        }
        if (this.a != null) {
            this.a.remove(ilvHyperGrapherPin);
            if (this.a.size() == 0) {
                this.a = null;
            }
        }
        ilvHyperGrapherPin.a((IlvHyperEdgePinConnector)null);
    }

    public void removeAllPins(boolean bl) {
        if (this.a == null || this.a.size() == 0) {
            return;
        }
        ArrayList arrayList = this.a;
        this.a = null;
        this.removePins(arrayList, bl);
    }

    public void removePins(Collection collection, boolean bl) {
        if (collection == null) {
            throw new IllegalArgumentException("Null pin collection");
        }
        if (this.getGraphicBag() == null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.b((IlvHyperGrapherPin)iterator.next());
            }
            this.b();
        } else {
            this.getGraphicBag().applyToObject((IlvGraphic)this, new IlvApplyObject(){

                public void apply(IlvGraphic ilvGraphic, Object object) {
                    Collection collection = (Collection)object;
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        IlvHyperEdgePinConnector.this.b((IlvHyperGrapherPin)iterator.next());
                    }
                    IlvHyperEdgePinConnector.this.b();
                }
            }, (Object)collection, bl);
        }
    }

    public final Iterator getPins() {
        return this.a != null ? IlvCollections.unmodifiableIterator(this.a.iterator()) : IlvCollections.emptyIterator();
    }

    public final int getPinsCount() {
        return this.a != null ? this.a.size() : 0;
    }

    public IlvHyperGrapherPin getClosestPin(IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        return this.getClosestPin(null, ilvPoint, ilvTransformer);
    }

    public IlvHyperGrapherPin getClosestPin(IlvHyperEdgeEnd ilvHyperEdgeEnd, IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        if (this.a == null) {
            return null;
        }
        IlvHyperGrapherPin ilvHyperGrapherPin = null;
        double d = Double.MAX_VALUE;
        int n = this.a.size();
        for (int i = 0; i < n; ++i) {
            IlvHyperGrapherPin ilvHyperGrapherPin2 = (IlvHyperGrapherPin)this.a.get(i);
            if (ilvHyperEdgeEnd != null && !ilvHyperGrapherPin2.allow(ilvHyperEdgeEnd)) continue;
            IlvPoint ilvPoint2 = ilvHyperGrapherPin2.getPosition(ilvTransformer);
            double d2 = ilvPoint.x - ilvPoint2.x;
            double d3 = ilvPoint.y - ilvPoint2.y;
            double d4 = d2 * d2 + d3 * d3;
            if (ilvHyperGrapherPin != null && !(d4 < d)) continue;
            ilvHyperGrapherPin = ilvHyperGrapherPin2;
            d = d4;
        }
        return ilvHyperGrapherPin;
    }

    @Override
    public boolean connect(IlvHyperEdgeEnd ilvHyperEdgeEnd, IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        IlvGraphic ilvGraphic = ilvHyperEdgeEnd.getNode();
        IlvHyperEdge ilvHyperEdge = ilvHyperEdgeEnd.getHyperEdge();
        if (ilvGraphic == null || ilvHyperEdge == null) {
            throw new RuntimeException("Hyperedge end is not connected");
        }
        ilvGraphic = ilvHyperEdge.getVisibleEndNode(ilvGraphic);
        if (this.getNode() != null && ilvGraphic != this.getNode()) {
            throw new IllegalArgumentException("connector has different node than the end");
        }
        ilvGraphic = this.getNode();
        IlvTransformer ilvTransformer2 = IlvGeometryUtil.getTransformerFromTo(ilvHyperEdge, ilvTransformer, ilvGraphic);
        IlvHyperGrapherPin ilvHyperGrapherPin = this.getClosestPin(ilvHyperEdgeEnd, ilvPoint, ilvTransformer2);
        if (ilvHyperGrapherPin == null) {
            return false;
        }
        this.connect(ilvHyperEdgeEnd, ilvHyperGrapherPin);
        ilvHyperGrapherPin.a(ilvTransformer2);
        return true;
    }

    public void connect(IlvHyperEdgeEnd ilvHyperEdgeEnd, IlvHyperGrapherPin ilvHyperGrapherPin) {
        if (ilvHyperGrapherPin.getHyperEdgeConnector() != this) {
            throw new IllegalArgumentException("pin not in this connector");
        }
        IlvGraphic ilvGraphic = ilvHyperEdgeEnd.getNode();
        IlvHyperEdge ilvHyperEdge = ilvHyperEdgeEnd.getHyperEdge();
        if (ilvGraphic == null || ilvHyperEdge == null) {
            throw new RuntimeException("Hyperedge end is not connected");
        }
        ilvGraphic = ilvHyperEdge.getVisibleEndNode(ilvGraphic);
        if (this.getNode() != null && ilvGraphic != this.getNode()) {
            throw new IllegalArgumentException("connector has different node than the end");
        }
        if (!ilvHyperGrapherPin.allow(ilvHyperEdgeEnd)) {
            throw new IllegalArgumentException("The pin does not allow connection to this end");
        }
        IlvHyperGrapherPin ilvHyperGrapherPin2 = this.getPin(ilvHyperEdgeEnd);
        if (ilvHyperGrapherPin2 != ilvHyperGrapherPin) {
            this.disconnect(ilvHyperEdgeEnd);
            this.a(ilvHyperEdgeEnd, ilvHyperGrapherPin);
            ilvHyperGrapherPin.a(ilvHyperEdgeEnd);
            if (ilvHyperEdgeEnd.getHyperEdge() != null) {
                ilvHyperGrapherPin.a((IlvTransformer)null);
            }
        }
    }

    @Override
    public boolean disconnect(IlvHyperEdgeEnd ilvHyperEdgeEnd) {
        super.disconnect(ilvHyperEdgeEnd);
        IlvHyperGrapherPin ilvHyperGrapherPin = this.getPin(ilvHyperEdgeEnd);
        if (ilvHyperGrapherPin != null) {
            this.a(ilvHyperEdgeEnd);
            ilvHyperGrapherPin.b(ilvHyperEdgeEnd);
            return true;
        }
        return false;
    }

    @Override
    protected IlvPoint calcConnectionPoint(IlvHyperEdgeEnd ilvHyperEdgeEnd, IlvTransformer ilvTransformer) {
        IlvPoint ilvPoint;
        IlvGraphic ilvGraphic = ilvHyperEdgeEnd.getNode();
        IlvHyperEdge ilvHyperEdge = ilvHyperEdgeEnd.getHyperEdge();
        if (ilvGraphic == null || ilvHyperEdge == null) {
            throw new RuntimeException("Hyperedge end is not connected");
        }
        if (this.getNode() != null) {
            ilvGraphic = this.getNode();
        }
        IlvTransformer ilvTransformer2 = IlvGeometryUtil.getTransformerFromTo(ilvHyperEdge, ilvTransformer, ilvGraphic);
        IlvHyperGrapherPin ilvHyperGrapherPin = this.getPin(ilvHyperEdgeEnd);
        if (ilvHyperGrapherPin == null && (ilvHyperGrapherPin = this.getClosestPin(ilvHyperEdgeEnd, ilvPoint = this.a(ilvTransformer2), ilvTransformer2)) == null) {
            return ilvPoint;
        }
        return ilvHyperGrapherPin.a(ilvHyperEdgeEnd, ilvTransformer2);
    }

    private IlvPoint a(IlvTransformer ilvTransformer) {
        IlvGraphic ilvGraphic = this.getNode();
        if (ilvGraphic == null) {
            return new IlvPoint();
        }
        if (this.e && ilvGraphic.zoomable()) {
            IlvRect ilvRect = ilvGraphic.boundingBox();
            if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                ilvTransformer.apply(ilvRect);
            }
            return new IlvPoint(ilvRect.x + 0.5f * ilvRect.width, ilvRect.y + 0.5f * ilvRect.height);
        }
        IlvRect ilvRect = ilvGraphic.boundingBox(ilvTransformer);
        return new IlvPoint(ilvRect.x + 0.5f * ilvRect.width, ilvRect.y + 0.5f * ilvRect.height);
    }

    @Override
    public IlvPoint getClosestConnectionPoint(IlvHyperEdgeEnd ilvHyperEdgeEnd, IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        IlvGraphic ilvGraphic = ilvHyperEdgeEnd.getNode();
        IlvHyperEdge ilvHyperEdge = ilvHyperEdgeEnd.getHyperEdge();
        if (ilvGraphic == null || ilvHyperEdge == null) {
            throw new RuntimeException("Hyperedge end is not connected");
        }
        if (this.getNode() != null) {
            ilvGraphic = this.getNode();
        }
        IlvTransformer ilvTransformer2 = IlvGeometryUtil.getTransformerFromTo(ilvHyperEdge, ilvTransformer, ilvGraphic);
        IlvHyperGrapherPin ilvHyperGrapherPin = this.getPin(ilvHyperEdgeEnd);
        if (ilvHyperGrapherPin == null) {
            ilvHyperGrapherPin = this.getClosestPin(ilvHyperEdgeEnd, ilvPoint, ilvTransformer2);
        }
        if (ilvHyperGrapherPin == null) {
            return this.a(ilvTransformer2);
        }
        return ilvHyperGrapherPin.a(ilvHyperEdgeEnd, ilvTransformer2);
    }

    public void disconnectAll() {
        if (this.a == null) {
            return;
        }
        int n = this.a.size();
        for (int i = 0; i < n; ++i) {
            IlvHyperGrapherPin ilvHyperGrapherPin = (IlvHyperGrapherPin)this.a.get(i);
            Iterator iterator = ilvHyperGrapherPin.getConnectedEnds();
            ilvHyperGrapherPin.a();
            while (iterator.hasNext()) {
                this.disconnect((IlvHyperEdgeEnd)iterator.next());
            }
        }
    }

    private void a(IlvHyperEdgeEnd ilvHyperEdgeEnd, IlvHyperGrapherPin ilvHyperGrapherPin) {
        if (this.b == null) {
            this.b = new HashMap();
        }
        this.b.put(ilvHyperEdgeEnd, ilvHyperGrapherPin);
    }

    private void a(IlvHyperEdgeEnd ilvHyperEdgeEnd) {
        if (this.b == null) {
            return;
        }
        this.b.remove(ilvHyperEdgeEnd);
        if (this.b.size() == 0) {
            this.b = null;
        }
    }

    public IlvHyperGrapherPin getPin(IlvHyperEdgeEnd ilvHyperEdgeEnd) {
        if (this.b == null) {
            return null;
        }
        return (IlvHyperGrapherPin)this.b.get(ilvHyperEdgeEnd);
    }

    @Override
    public void actOnWrite(IlvHyperEdgeEnd ilvHyperEdgeEnd, IlvOutputStream ilvOutputStream) throws IOException {
        super.actOnWrite(ilvHyperEdgeEnd, ilvOutputStream);
        IlvHyperGrapherPin ilvHyperGrapherPin = this.getPin(ilvHyperEdgeEnd);
        if (ilvHyperGrapherPin != null) {
            ilvOutputStream.write("pin", (IlvPersistentObject)ilvHyperGrapherPin);
        }
    }

    @Override
    public void actOnRead(IlvHyperEdgeEnd ilvHyperEdgeEnd, IlvInputStream ilvInputStream) throws IlvReadFileException {
        super.actOnRead(ilvHyperEdgeEnd, ilvInputStream);
        try {
            IlvHyperGrapherPin ilvHyperGrapherPin = (IlvHyperGrapherPin)ilvInputStream.readPersistentObject("pin");
            if (ilvHyperGrapherPin != null) {
                this.connect(ilvHyperEdgeEnd, ilvHyperGrapherPin);
            }
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    public void setPinDraggingRestrictedToNodeBorder(boolean bl) {
        this.f = bl;
    }

    public boolean isPinDraggingRestrictedToNodeBorder() {
        return this.f;
    }

    @Override
    public boolean connectionsZoomable() {
        return this.d;
    }

    boolean a() {
        return this.e;
    }

    @Override
    public boolean zoomable() {
        return this.c;
    }

    private final void a(final boolean bl, final boolean bl2) {
        IlvGraphicBag ilvGraphicBag;
        if (bl == this.c && this.d == bl2) {
            this.clearBoundingBoxCache();
            return;
        }
        IlvGraphic ilvGraphic = this.getNode();
        IlvGraphicBag ilvGraphicBag2 = ilvGraphicBag = ilvGraphic == null ? null : ilvGraphic.getGraphicBag();
        if (ilvGraphic == null || ilvGraphicBag == null) {
            this.c = bl;
            this.d = bl2;
            this.clearBoundingBoxCache();
            return;
        }
        ilvGraphicBag.applyToObject(ilvGraphic, new IlvApplyObject(){

            public void apply(IlvGraphic ilvGraphic, Object object) {
                IlvHyperEdgePinConnector.this.c = bl;
                IlvHyperEdgePinConnector.this.d = bl2;
                IlvHyperEdgePinConnector.this.clearBoundingBoxCache();
            }
        }, null, true);
    }

    private void b() {
        if (!this.a()) {
            this.a(false, false);
            return;
        }
        IlvGraphic ilvGraphic = this.getNode();
        if (ilvGraphic != null && !ilvGraphic.zoomable()) {
            this.a(false, false);
            return;
        }
        boolean bl = true;
        boolean bl2 = true;
        int n = this.a == null ? 0 : this.a.size();
        for (int i = 0; i < n; ++i) {
            IlvHyperGrapherPin ilvHyperGrapherPin = (IlvHyperGrapherPin)this.a.get(i);
            if (!ilvHyperGrapherPin.zoomable()) {
                bl = false;
            }
            if (!ilvHyperGrapherPin.connectionZoomable()) {
                bl2 = false;
            }
            if (bl || bl2) continue;
            this.a(false, false);
            return;
        }
        this.a(bl, bl2);
    }

    @Override
    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        if (this.a == null) {
            return;
        }
        int n = this.a.size();
        for (int i = 0; i < n; ++i) {
            IlvHyperGrapherPin ilvHyperGrapherPin = (IlvHyperGrapherPin)this.a.get(i);
            ilvHyperGrapherPin.draw(graphics, ilvTransformer);
        }
    }

    @Override
    protected IlvRect calcBoundingBox(IlvTransformer ilvTransformer) {
        IlvRect ilvRect = super.calcBoundingBox(ilvTransformer);
        if (this.a != null) {
            int n = this.a.size();
            for (int i = 0; i < n; ++i) {
                IlvHyperGrapherPin ilvHyperGrapherPin = (IlvHyperGrapherPin)this.a.get(i);
                ilvRect.add(ilvHyperGrapherPin.boundingBox(ilvTransformer));
            }
        }
        return ilvRect;
    }

    @Override
    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (this.a == null) {
            return false;
        }
        int n = this.a.size();
        for (int i = 0; i < n; ++i) {
            IlvHyperGrapherPin ilvHyperGrapherPin = (IlvHyperGrapherPin)this.a.get(i);
            if (!ilvHyperGrapherPin.contains(ilvPoint, ilvPoint2, ilvTransformer)) continue;
            return true;
        }
        return false;
    }

    public IlvSelection makeSelection() {
        return new IlvHyperEdgePinConnectorSelection(this);
    }

    public void selectAllPins(boolean bl, boolean bl2) {
        IlvHyperGrapherPin ilvHyperGrapherPin;
        Iterator iterator = this.getPins();
        while (iterator.hasNext()) {
            ilvHyperGrapherPin = (IlvHyperGrapherPin)iterator.next();
            ilvHyperGrapherPin.setSelected(bl);
        }
        if (bl2 && (ilvHyperGrapherPin = (IlvManager)this.getGraphicBag()) != null) {
            ilvHyperGrapherPin.initReDraws();
            ilvHyperGrapherPin.invalidateRegion(this);
            ilvHyperGrapherPin.reDrawViews();
        }
    }

    public void selectPin(IlvHyperGrapherPin ilvHyperGrapherPin, boolean bl, boolean bl2) {
        IlvManager ilvManager;
        if (this.a == null || !this.a.contains(ilvHyperGrapherPin)) {
            throw new RuntimeException("The pin does not belong to this connector");
        }
        ilvHyperGrapherPin.setSelected(bl);
        if (bl2 && (ilvManager = (IlvManager)this.getGraphicBag()) != null) {
            ilvManager.initReDraws();
            ilvManager.invalidateRegion((IlvGraphic)this);
            ilvManager.reDrawViews();
        }
    }

    public static void snapPinToNodeBorder(final IlvHyperGrapherPin ilvHyperGrapherPin, int n) {
        if (ilvHyperGrapherPin == null) {
            return;
        }
        IlvHyperEdgePinConnector ilvHyperEdgePinConnector = ilvHyperGrapherPin.getHyperEdgeConnector();
        if (ilvHyperEdgePinConnector == null) {
            return;
        }
        if (!(ilvHyperEdgePinConnector.getGraphicBag() instanceof IlvManager)) {
            return;
        }
        final IlvPoint ilvPoint = ilvHyperGrapherPin.getPosition(null);
        IlvGraphic ilvGraphic = ilvHyperEdgePinConnector.getNode();
        IlvManager ilvManager = (IlvManager)ilvHyperEdgePinConnector.getGraphicBag();
        final IlvPoint ilvPoint2 = new IlvPoint((float)n, (float)n);
        IlvPoint ilvPoint3 = ilvHyperGrapherPin.getProportionalOffset();
        ilvHyperGrapherPin.setProportionalOffset(1.0f, 1.0f);
        IlvGeometryUtil.snapPinToNodeBorder(ilvHyperGrapherPin, ilvPoint, ilvPoint2, null);
        ilvHyperGrapherPin.setProportionalOffset(ilvPoint3.x, ilvPoint3.y);
        ilvGraphic.getGraphicBag().applyToObject(ilvGraphic, new IlvApplyObject(){

            public void apply(IlvGraphic ilvGraphic, Object object) {
                ilvHyperGrapherPin.setAbsoluteOffset(ilvPoint2.x, ilvPoint2.y);
                ilvHyperGrapherPin.setPosition(ilvPoint, null);
            }
        }, null, true);
    }
}

