/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.hypergraph.crossing;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.hypergraph.IlvSegmentedHyperEdge;
import ilog.views.hypergraph.crossing.IlvAbstractCrossingGraphic;
import ilog.views.hypergraph.crossing.IlvCrossingAwareObject;
import ilog.views.internal.IlvStrokeInfo;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Graphics;
import java.io.IOException;

public class IlvTunnelCrossings
extends IlvAbstractCrossingGraphic {
    public IlvTunnelCrossings(IlvSegmentedHyperEdge ilvSegmentedHyperEdge) {
        super(ilvSegmentedHyperEdge);
    }

    public IlvTunnelCrossings(IlvTunnelCrossings ilvTunnelCrossings) {
        super(ilvTunnelCrossings);
    }

    public IlvTunnelCrossings(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
    }

    public IlvGraphic copy() {
        return new IlvTunnelCrossings(this);
    }

    @Override
    public void drawCrossing(Graphics graphics, IlvTransformer ilvTransformer, IlvCrossingAwareObject ilvCrossingAwareObject, IlvCrossingAwareObject ilvCrossingAwareObject2, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvPoint ilvPoint4, float f, float f2, float f3) {
        DrawingParameters drawingParameters = new DrawingParameters(ilvTransformer, ilvCrossingAwareObject, ilvPoint, ilvPoint2, ilvPoint3, ilvPoint4, f3, true, false);
        if (!drawingParameters.g) {
            return;
        }
        IlvGraphicUtil.DrawBezier((Graphics)graphics, (IlvPoint[])drawingParameters.a, (int)4, (float)drawingParameters.e, (int)0, (int)1, (float[])drawingParameters.f, (IlvTransformer)ilvTransformer, (boolean)true);
        IlvGraphicUtil.DrawBezier((Graphics)graphics, (IlvPoint[])drawingParameters.b, (int)4, (float)drawingParameters.e, (int)0, (int)1, (float[])drawingParameters.f, (IlvTransformer)ilvTransformer, (boolean)true);
        IlvGraphicUtil.DrawPolyline((Graphics)graphics, (IlvPoint[])drawingParameters.c, (int)2, (float)drawingParameters.e, (int)0, (int)1, (float[])drawingParameters.f, (IlvTransformer)ilvTransformer, (boolean)true);
    }

    @Override
    public boolean containsAtCrossing(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer, IlvCrossingAwareObject ilvCrossingAwareObject, IlvCrossingAwareObject ilvCrossingAwareObject2, IlvPoint ilvPoint3, IlvPoint ilvPoint4, IlvPoint ilvPoint5, IlvPoint ilvPoint6, float f, float f2, float f3) {
        DrawingParameters drawingParameters = new DrawingParameters(ilvTransformer, ilvCrossingAwareObject, ilvPoint3, ilvPoint4, ilvPoint5, ilvPoint6, f3, false, false);
        if (!drawingParameters.g) {
            return false;
        }
        if (IlvGraphicUtil.PointInBezier((IlvPoint)ilvPoint2, (IlvPoint[])drawingParameters.a, (int)4, (float)drawingParameters.d, (int)0, (int)1, null)) {
            return true;
        }
        if (IlvGraphicUtil.PointInBezier((IlvPoint)ilvPoint2, (IlvPoint[])drawingParameters.b, (int)4, (float)drawingParameters.d, (int)0, (int)1, null)) {
            return true;
        }
        return IlvGraphicUtil.PointInPolyline((IlvPoint)ilvPoint2, (IlvPoint[])drawingParameters.c, (int)2, (float)drawingParameters.d, (int)0, (int)1, null);
    }

    @Override
    protected IlvRect calcBoundingBox(IlvTransformer ilvTransformer) {
        float f;
        IlvSegmentedHyperEdge ilvSegmentedHyperEdge = this.a();
        IlvRect ilvRect = ilvSegmentedHyperEdge.boundingBox(ilvTransformer);
        double d = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
        float f2 = ilvSegmentedHyperEdge.getGap();
        if (ilvSegmentedHyperEdge.isGapZoomable()) {
            f2 = (float)((double)f2 * d);
        }
        if ((f = ilvSegmentedHyperEdge.getLineWidth()) != 0.0f) {
            float f3 = ilvSegmentedHyperEdge.getMaximumLineWidth();
            f = IlvStrokeInfo.zoomedLineWidth((float)f, (float)f3, (IlvTransformer)ilvTransformer, (boolean)true);
        }
        f = (float)((double)f * d);
        IlvRect ilvRect2 = new IlvRect(0.0f, 0.0f, 2.0f * f2 + f, f2);
        IlvPoint ilvPoint = new IlvPoint(0.0f, 0.0f);
        IlvPoint ilvPoint2 = new IlvPoint(2.0f * f2 + f, 0.0f);
        this.addCrossingBound(ilvRect2, ilvTransformer, ilvSegmentedHyperEdge, ilvSegmentedHyperEdge, null, ilvPoint, ilvPoint2, null, 0.0f, 0.0f, f2);
        IlvRect ilvRect3 = new IlvRect(0.0f, 0.0f, f2, 2.0f * f2 + f);
        ilvPoint.move(0.0f, 0.0f);
        ilvPoint2.move(0.0f, 2.0f * f2 + f);
        this.addCrossingBound(ilvRect3, ilvTransformer, ilvSegmentedHyperEdge, ilvSegmentedHyperEdge, null, ilvPoint, ilvPoint2, null, 0.0f, 0.0f, f2);
        ilvRect.x -= 1.5f * ilvRect3.width;
        ilvRect.y -= 1.5f * ilvRect2.height;
        ilvRect.width += 3.0f * ilvRect3.width;
        ilvRect.height += 3.0f * ilvRect2.height;
        return ilvRect;
    }

    @Override
    public void addCrossingBound(IlvRect ilvRect, IlvTransformer ilvTransformer, IlvCrossingAwareObject ilvCrossingAwareObject, IlvCrossingAwareObject ilvCrossingAwareObject2, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvPoint ilvPoint4, float f, float f2, float f3) {
        DrawingParameters drawingParameters = new DrawingParameters(ilvTransformer, ilvCrossingAwareObject, ilvPoint, ilvPoint2, ilvPoint3, ilvPoint4, f3, false, true);
        if (!drawingParameters.g) {
            return;
        }
        IlvRect ilvRect2 = new IlvRect();
        IlvGraphicUtil.BezierBoundingBox((IlvRect)ilvRect2, (IlvPoint[])drawingParameters.a, (int)4, (float)drawingParameters.d, (int)0, (int)1, null);
        ilvRect.add(ilvRect2);
        IlvGraphicUtil.BezierBoundingBox((IlvRect)ilvRect2, (IlvPoint[])drawingParameters.b, (int)4, (float)drawingParameters.d, (int)0, (int)1, null);
        ilvRect.add(ilvRect2);
        ilvRect.add(IlvGraphicUtil.PolylineBBox((IlvPoint[])drawingParameters.c, (int)2, (float)drawingParameters.d, (int)0, (int)1, null));
    }

    @Override
    public boolean zoomable() {
        IlvSegmentedHyperEdge ilvSegmentedHyperEdge = this.a();
        if (ilvSegmentedHyperEdge == null) {
            return true;
        }
        if (!ilvSegmentedHyperEdge.zoomable()) {
            return false;
        }
        return ilvSegmentedHyperEdge.isGapZoomable();
    }

    private IlvSegmentedHyperEdge a() {
        return (IlvSegmentedHyperEdge)this.getRelatedObject();
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
    }

    class DrawingParameters {
        IlvPoint[] a;
        IlvPoint[] b;
        IlvPoint[] c;
        float d;
        float e;
        float[] f;
        boolean g = true;

        DrawingParameters(IlvTransformer ilvTransformer, IlvCrossingAwareObject ilvCrossingAwareObject, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvPoint ilvPoint4, float f, boolean bl, boolean bl2) {
            float f2;
            double d;
            IlvSegmentedHyperEdge ilvSegmentedHyperEdge = (IlvSegmentedHyperEdge)ilvCrossingAwareObject;
            this.e = ilvSegmentedHyperEdge.getLineWidth();
            double d2 = d = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
            if (bl) {
                this.f = ilvSegmentedHyperEdge.getLineStyle();
            }
            if (this.e != 0.0f) {
                f2 = ilvSegmentedHyperEdge.getMaximumLineWidth();
                if (bl) {
                    this.f = IlvStrokeInfo.zoomedLineStyle((float[])this.f, (float)this.e, (float)f2, (IlvTransformer)ilvTransformer);
                }
                this.e = IlvStrokeInfo.zoomedLineWidth((float)this.e, (float)f2, (IlvTransformer)ilvTransformer, (boolean)bl2);
            }
            this.d = (float)((double)this.e * d);
            f2 = ilvPoint3.x - ilvPoint2.x;
            float f3 = ilvPoint3.y - ilvPoint2.y;
            double d3 = Math.sqrt(f2 * f2 + f3 * f3);
            if (d3 == 0.0) {
                this.g = false;
                return;
            }
            float f4 = 0.5f * this.d + f;
            float f5 = 0.5f * this.d + f;
            if (f5 == 0.0f) {
                this.g = false;
                return;
            }
            if ((double)(2.0f * f4) > d3) {
                f4 = (float)(d3 / 2.0);
            }
            int n = -1;
            if (f2 < 0.0f || f2 == 0.0f && f3 < 0.0f) {
                n = 1;
            }
            this.a = new IlvPoint[4];
            this.b = new IlvPoint[4];
            this.c = new IlvPoint[2];
            float f6 = ilvPoint2.x;
            float f7 = ilvPoint2.y;
            float f8 = ilvPoint3.x;
            float f9 = ilvPoint3.y;
            float f10 = -((float)((double)((float)n * f5 * f3) / d3));
            float f11 = (float)((double)((float)n * f5 * f2) / d3);
            float f12 = (float)((double)(f4 * f2) / d3);
            float f13 = (float)((double)(f4 * f3) / d3);
            this.a[0] = new IlvPoint(f6, f7);
            this.a[1] = new IlvPoint(f6 + 0.42f * f10, f7 + 0.42f * f11);
            this.a[2] = new IlvPoint(f6 + 0.58f * f12 + f10, f7 + 0.58f * f13 + f11);
            this.a[3] = new IlvPoint(f6 + f12 + f10, f7 + f13 + f11);
            this.b[0] = new IlvPoint(f8, f9);
            this.b[1] = new IlvPoint(f8 + 0.42f * f10, f9 + 0.42f * f11);
            this.b[2] = new IlvPoint(f8 - 0.58f * f12 + f10, f9 - 0.58f * f13 + f11);
            this.b[3] = new IlvPoint(f8 - f12 + f10, f9 - f13 + f11);
            this.c[0] = this.a[3];
            this.c[1] = this.b[3];
        }
    }
}

