/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout.hierarchical;

import ilog.views.graphlayout.hierarchical.CalcCrossings;
import ilog.views.graphlayout.hierarchical.HGraph;
import ilog.views.graphlayout.hierarchical.HGraphIterator;
import ilog.views.graphlayout.hierarchical.HLevel;
import ilog.views.graphlayout.hierarchical.HLevelIterator;
import ilog.views.graphlayout.hierarchical.HLevelSweepAlgorithm;
import ilog.views.graphlayout.hierarchical.HNode;
import ilog.views.graphlayout.hierarchical.HNodeIterator;
import ilog.views.graphlayout.hierarchical.HNodeSort;
import ilog.views.graphlayout.hierarchical.HSegment;
import ilog.views.graphlayout.hierarchical.HSegmentIterator;
import ilog.views.graphlayout.hierarchical.IlvHierarchicalLayout;
import ilog.views.graphlayout.hierarchical.relpositioning.HRPGraph;
import ilog.views.graphlayout.hierarchical.relpositioning.HRPSolving;
import ilog.views.util.collections.IlvUnsynchronizedStack;
import java.util.HashMap;

class RecCrossingReductionAlgorithm
extends HLevelSweepAlgorithm {
    protected HNodeSort _nodeSortAlg;
    protected boolean _usePortBaryCenter = false;
    private boolean a;
    private CalcCrossings b = new CalcCrossings(true);
    protected int _numberOfSweeps;
    protected boolean _checkBestPositions;
    private int c;
    private int d;
    private HashMap e;

    RecCrossingReductionAlgorithm(HGraph hGraph) {
        super.init(hGraph);
        IlvHierarchicalLayout ilvHierarchicalLayout = hGraph.v();
        this._nodeSortAlg = new HNodeSort();
        this._numberOfSweeps = ilvHierarchicalLayout.getNumberOfLinkCrossingSweeps();
        this._checkBestPositions = ilvHierarchicalLayout.isBacktrackCrossingReductionEnabled();
        this.a = ilvHierarchicalLayout.isMedianCrossingValueEnabled();
        this.e = new HashMap();
    }

    @Override
    void a() {
        super.a();
        this._nodeSortAlg = null;
    }

    HRPSolving a(HGraph hGraph) {
        HRPSolving hRPSolving = (HRPSolving)this.e.get(hGraph);
        if (hRPSolving == null) {
            IlvHierarchicalLayout ilvHierarchicalLayout = hGraph.v();
            hRPSolving = new HRPSolving(null, ilvHierarchicalLayout, hGraph.bq());
            this.e.put(hGraph, hRPSolving);
        }
        return hRPSolving;
    }

    @Override
    public void run() {
        HGraph hGraph = this.getGraph();
        int n = (this._numberOfSweeps + 3) * (hGraph.z() - 1) + 2;
        if (hGraph.bh() || hGraph.bi()) {
            n += 2 * (hGraph.z() - 1);
        }
        this.d().startStep(this.e().ac[5], n, false);
        this.b(hGraph);
        this.updateInfoInLevels(hGraph);
        this.c = Integer.MAX_VALUE;
        boolean bl = false;
        if (hGraph.bh() || hGraph.bi()) {
            this._usePortBaryCenter = true;
            this.b();
            bl = true;
            if (!this.h()) {
                this.c();
            }
        }
        this._usePortBaryCenter = false;
        if (hGraph.z() == 1) {
            this.treatForwardLevel(null, hGraph.am());
        } else {
            for (int i = 0; !(i >= this._numberOfSweeps || bl && this.h()); ++i) {
                if (i % 2 == 0) {
                    this.b();
                } else {
                    this.c();
                }
                bl = true;
            }
        }
        this.d(hGraph);
        this.calcCrossings(hGraph, true);
        this.storeLevelPositionsInNodes(hGraph);
    }

    private void b(HGraph hGraph) {
        this.d = 1;
        HNodeIterator hNodeIterator = hGraph.aa();
        while (hNodeIterator.hasNext()) {
            hNodeIterator.next().a(-1.0f);
        }
        hNodeIterator = hGraph.aa();
        while (hNodeIterator.hasNext()) {
            HNode hNode = hNodeIterator.next();
            if (!(hNode.ao() < 0.0f)) continue;
            this.a(hGraph, hNode);
        }
        HLevelIterator hLevelIterator = hGraph.ah();
        while (hLevelIterator.hasNext()) {
            HLevel hLevel = hLevelIterator.next();
            if (hLevel.d() != null) {
                this._nodeSortAlg.sort(hLevel.d());
            }
            this.f();
        }
        HGraphIterator hGraphIterator = hGraph.aj();
        while (hGraphIterator.hasNext()) {
            HGraph hGraph2 = hGraphIterator.next();
            this.b(hGraph2);
        }
    }

    private void a(HGraph hGraph, HNode hNode) {
        IlvUnsynchronizedStack ilvUnsynchronizedStack = new IlvUnsynchronizedStack();
        hNode.a((float)this.d++);
        ilvUnsynchronizedStack.push((Object)hNode);
        while (!ilvUnsynchronizedStack.isEmpty()) {
            HNode hNode2;
            HSegment hSegment;
            hNode = (HNode)ilvUnsynchronizedStack.pop();
            HSegmentIterator hSegmentIterator = hNode.a(true, true, true, true);
            while (hSegmentIterator.hasNext()) {
                hSegment = hSegmentIterator.next();
                hNode2 = hGraph.a(hSegment.b());
                if (hNode2 == null || !(hNode2.ao() < 0.0f)) continue;
                hNode2.a((float)this.d++);
                ilvUnsynchronizedStack.push((Object)hNode2);
            }
            hSegmentIterator = hNode.b(true, true, true, true);
            while (hSegmentIterator.hasNext()) {
                hSegment = hSegmentIterator.next();
                hNode2 = hGraph.a(hSegment.a());
                if (hNode2 == null || !(hNode2.ao() < 0.0f)) continue;
                hNode2.a((float)this.d++);
                ilvUnsynchronizedStack.push((Object)hNode2);
            }
        }
    }

    private void b() {
        this.sweepForward();
        this.g();
    }

    private void c() {
        this.sweepBackward();
        this.g();
    }

    private final void a(HLevel hLevel) {
        int n = hLevel.h();
        if (n > 0 && hLevel.q()) {
            HNodeIterator hNodeIterator = hLevel.f();
            int n2 = 0;
            int n3 = hLevel.h() + 1;
            while (hNodeIterator.hasNext()) {
                HNode hNode = hNodeIterator.next();
                int n4 = hNode.am();
                for (int i = n3; n4 != n2 && n4 >= 0 && n4 < n && i > 0; --i) {
                    HNode hNode2 = hLevel.d()[n4];
                    hLevel.d()[n4] = hNode;
                    hLevel.d()[n2] = hNode2;
                    hNode = hNode2;
                    n4 = hNode.am();
                }
                ++n2;
            }
        }
    }

    private final void b(HLevel hLevel) {
        HSegmentIterator hSegmentIterator;
        HNode hNode;
        int n = hLevel.h();
        HNodeIterator hNodeIterator = hLevel.f();
        if (this._usePortBaryCenter) {
            while (hNodeIterator.hasNext()) {
                hNodeIterator.next().g(true);
            }
        } else {
            while (hNodeIterator.hasNext()) {
                hNodeIterator.next().a(true, n);
            }
        }
        if (this.a) {
            double d = n > 0 ? 1.0E-5 / (double)n : 1.0E-5;
            hNodeIterator = hLevel.f();
            while (hNodeIterator.hasNext()) {
                hNodeIterator.next().a(d);
            }
        }
        float f = 0.0f;
        hNodeIterator = hLevel.f();
        while (hNodeIterator.hasNext()) {
            hNode = hNodeIterator.next();
            hSegmentIterator = hNode.b(true, true, true, false);
            if (!hSegmentIterator.hasNext()) {
                hNode.a(f);
                continue;
            }
            f = hNode.ao();
        }
        hNodeIterator = hLevel.g();
        while (hNodeIterator.hasNext()) {
            hNode = hNodeIterator.next();
            hSegmentIterator = hNode.b(true, true, true, false);
            if (!hSegmentIterator.hasNext()) {
                hNode.a((f + hNode.ao()) / 2.0f);
                continue;
            }
            f = hNode.ao();
        }
    }

    private final void c(HLevel hLevel) {
        HSegmentIterator hSegmentIterator;
        HNode hNode;
        int n = hLevel.h();
        HNodeIterator hNodeIterator = hLevel.f();
        if (this._usePortBaryCenter) {
            while (hNodeIterator.hasNext()) {
                hNodeIterator.next().h(true);
            }
        } else {
            while (hNodeIterator.hasNext()) {
                hNodeIterator.next().b(true, n);
            }
        }
        if (this.a) {
            double d = n > 0 ? 1.0E-5 / (double)n : 1.0E-5;
            hNodeIterator = hLevel.f();
            while (hNodeIterator.hasNext()) {
                hNodeIterator.next().b(d);
            }
        }
        float f = 0.0f;
        hNodeIterator = hLevel.f();
        while (hNodeIterator.hasNext()) {
            hNode = hNodeIterator.next();
            hSegmentIterator = hNode.a(true, true, true, false);
            if (!hSegmentIterator.hasNext()) {
                hNode.a(f);
                continue;
            }
            f = hNode.ao();
        }
        hNodeIterator = hLevel.g();
        while (hNodeIterator.hasNext()) {
            hNode = hNodeIterator.next();
            hSegmentIterator = hNode.a(true, true, true, false);
            if (!hSegmentIterator.hasNext()) {
                hNode.a((f + hNode.ao()) / 2.0f);
                continue;
            }
            f = hNode.ao();
        }
    }

    private final void d(HLevel hLevel) {
        HNode hNode;
        HGraph hGraph = this.getGraph();
        HRPGraph hRPGraph = hLevel.r();
        if (hRPGraph == null) {
            return;
        }
        HRPSolving hRPSolving = this.a(hGraph);
        hRPSolving.init(hRPGraph);
        HNodeIterator hNodeIterator = hLevel.f();
        while (hNodeIterator.hasNext()) {
            hNode = hNodeIterator.next();
            hGraph.c(hNode).setBarycenter(hNode.ao(), 1.0f);
        }
        hRPSolving.run();
        hNodeIterator = hLevel.f();
        while (hNodeIterator.hasNext()) {
            hNode = hNodeIterator.next();
            hNode.a((float)hGraph.c(hNode).getPositionNumber());
        }
    }

    @Override
    protected void initForwardFirstLevel(HLevel hLevel) {
        this.e(hLevel);
        this.treatForwardLevel(null, hLevel);
    }

    @Override
    protected void initBackwardFirstLevel(HLevel hLevel) {
        this.e(hLevel);
        this.treatBackwardLevel(null, hLevel);
    }

    private void e(HLevel hLevel) {
        HNodeIterator hNodeIterator = hLevel.f();
        int n = 1;
        while (hNodeIterator.hasNext()) {
            hNodeIterator.next().a((float)n++);
        }
    }

    @Override
    protected void treatForwardLevel(HLevel hLevel, HLevel hLevel2) {
        this.b(hLevel2);
        this.d(hLevel2);
        if (hLevel2.d() != null) {
            this._nodeSortAlg.sort(hLevel2.d());
        }
        this.a(hLevel2);
        hLevel2.a(1, false);
        this.sweepForward(hLevel2);
    }

    @Override
    protected void treatBackwardLevel(HLevel hLevel, HLevel hLevel2) {
        this.c(hLevel2);
        this.d(hLevel2);
        if (hLevel2.d() != null) {
            this._nodeSortAlg.sort(hLevel2.d());
        }
        this.a(hLevel2);
        hLevel2.a(1, false);
        this.sweepBackward(hLevel2);
    }

    private final void g() {
        if (!this._checkBestPositions) {
            return;
        }
        int n = this.calcCrossings(this.getGraph(), false);
        if (n < this.c) {
            this.c(this.getGraph());
            this.c = n;
        }
    }

    private final boolean h() {
        return this._checkBestPositions && this.c == 0;
    }

    private final void c(HGraph hGraph) {
        HNodeIterator hNodeIterator = hGraph.aa();
        while (hNodeIterator.hasNext()) {
            hNodeIterator.next().at();
        }
        HGraphIterator hGraphIterator = hGraph.aj();
        while (hGraphIterator.hasNext()) {
            HGraph hGraph2 = hGraphIterator.next();
            this.c(hGraph2);
        }
    }

    private final void d(HGraph hGraph) {
        if (!this._checkBestPositions) {
            return;
        }
        HNodeIterator hNodeIterator = hGraph.aa();
        while (hNodeIterator.hasNext()) {
            hNodeIterator.next().au();
        }
        HLevelIterator hLevelIterator = hGraph.ah();
        while (hLevelIterator.hasNext()) {
            HLevel hLevel = hLevelIterator.next();
            if (hLevel.d() != null) {
                this._nodeSortAlg.sort(hLevel.d());
            }
            hLevel.a(1, false);
        }
        HGraphIterator hGraphIterator = hGraph.aj();
        while (hGraphIterator.hasNext()) {
            HGraph hGraph2 = hGraphIterator.next();
            this.d(hGraph2);
        }
    }

    protected final void storeLevelPositionsInNodes(HGraph hGraph) {
        HLevelIterator hLevelIterator = hGraph.ah();
        while (hLevelIterator.hasNext()) {
            hLevelIterator.next().a(0, false);
            this.d().addPoints(1);
            this.f();
        }
        HGraphIterator hGraphIterator = hGraph.aj();
        while (hGraphIterator.hasNext()) {
            HGraph hGraph2 = hGraphIterator.next();
            this.storeLevelPositionsInNodes(hGraph2);
        }
    }

    protected final void updateInfoInLevels(HGraph hGraph) {
        HLevelIterator hLevelIterator = hGraph.ah();
        while (hLevelIterator.hasNext()) {
            hLevelIterator.next().c();
            this.d().addPoints(1);
            this.f();
        }
        HGraphIterator hGraphIterator = hGraph.aj();
        while (hGraphIterator.hasNext()) {
            HGraph hGraph2 = hGraphIterator.next();
            this.updateInfoInLevels(hGraph2);
        }
    }

    protected int calcCrossings(HGraph hGraph, boolean bl) {
        HLevelIterator hLevelIterator = hGraph.ah();
        HLevel hLevel = null;
        int n = 0;
        while (hLevelIterator.hasNext()) {
            HLevel hLevel2 = hLevelIterator.next();
            if (hLevel != null) {
                int n2 = this.b.getNumberOfCrossings(hLevel, hLevel2);
                n += n2;
                if (bl) {
                    hLevel.g(n2);
                }
            }
            hLevel = hLevel2;
        }
        HGraphIterator hGraphIterator = hGraph.aj();
        while (hGraphIterator.hasNext()) {
            HGraph hGraph2 = hGraphIterator.next();
            n += this.calcCrossings(hGraph2, bl);
        }
        return n;
    }
}

