/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout.grid;

import ilog.views.IlvGraphic;
import ilog.views.IlvNamedProperty;
import ilog.views.graphlayout.IlvGraphLayout;
import ilog.views.graphlayout.IlvGraphLayoutNodeProperty;
import ilog.views.graphlayout.IlvGrapherPropertyAdapter;
import ilog.views.graphlayout.grid.IlvGridLayout;
import ilog.views.graphlayout.internalutil.AlignmentOptions;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.io.IOException;

public class IlvGridLayoutNodeProperty
extends IlvGraphLayoutNodeProperty {
    static final long serialVersionUID = 2272851156909189612L;
    private int a;
    private int b;
    private int c;

    public IlvGridLayoutNodeProperty(String string, IlvGridLayout ilvGridLayout, IlvGraphic ilvGraphic, boolean bl) {
        super(string, ilvGridLayout, ilvGraphic, bl);
        try {
            this.a = ilvGridLayout.getHorizontalAlignment(ilvGraphic);
        }
        catch (Exception exception) {
            this.a = 0;
        }
        try {
            this.b = ilvGridLayout.getVerticalAlignment(ilvGraphic);
        }
        catch (Exception exception) {
            this.b = 0;
        }
        try {
            this.c = ilvGridLayout.getIndex(ilvGraphic);
        }
        catch (Exception exception) {
            this.c = -1;
        }
    }

    public IlvGridLayoutNodeProperty(IlvGridLayoutNodeProperty ilvGridLayoutNodeProperty) {
        super(ilvGridLayoutNodeProperty);
        this.a = ilvGridLayoutNodeProperty.a;
        this.b = ilvGridLayoutNodeProperty.b;
        this.c = ilvGridLayoutNodeProperty.c;
    }

    public IlvGridLayoutNodeProperty(IlvInputStream ilvInputStream) throws IOException, IlvReadFileException {
        this(ilvInputStream, false);
    }

    protected IlvGridLayoutNodeProperty(IlvInputStream ilvInputStream, boolean bl) throws IOException, IlvReadFileException {
        super(ilvInputStream, true);
        this.a = 0;
        this.b = 0;
        this.c = -1;
        if (!bl) {
            boolean bl2 = true;
            while (bl2) {
                bl2 = this.readProperties(ilvInputStream);
            }
        }
    }

    @Override
    protected boolean readProperties(IlvInputStream ilvInputStream) throws IOException, IlvReadFileException {
        boolean bl = super.readProperties(ilvInputStream);
        try {
            this.a = AlignmentOptions.valueOf(ilvInputStream.readString("horizontalAlignment"));
            bl = true;
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.b = AlignmentOptions.valueOf(ilvInputStream.readString("verticalAlignment"));
            bl = true;
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.c = ilvInputStream.readInt("index");
            bl = true;
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        return bl;
    }

    @Override
    public IlvNamedProperty copy() {
        return new IlvGridLayoutNodeProperty(this);
    }

    @Override
    public boolean isPersistent() {
        if (super.isPersistent()) {
            return true;
        }
        if (this.a != 0) {
            return true;
        }
        if (this.b != 0) {
            return true;
        }
        return this.c != -1;
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        block11: {
            block10: {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                super.write(ilvOutputStream);
                                if (this.a != 0) break block6;
                                if (this.omitDefaults()) break block7;
                            }
                            ilvOutputStream.write("horizontalAlignment", AlignmentOptions.toString(this.a));
                        }
                        if (this.b != 0) break block8;
                        if (this.omitDefaults()) break block9;
                    }
                    ilvOutputStream.write("verticalAlignment", AlignmentOptions.toString(this.b));
                }
                if (this.c != -1) break block10;
                if (this.omitDefaults()) break block11;
            }
            ilvOutputStream.write("index", this.c);
        }
    }

    @Override
    public void transfer(IlvGraphLayout ilvGraphLayout, IlvGraphic ilvGraphic) {
        if (ilvGraphLayout == null) {
            return;
        }
        super.transfer(ilvGraphLayout, ilvGraphic);
        IlvGridLayout ilvGridLayout = (IlvGridLayout)ilvGraphLayout;
        try {
            ilvGridLayout.setHorizontalAlignment(ilvGraphic, this.a);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ilvGridLayout.setVerticalAlignment(ilvGraphic, this.b);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ilvGridLayout.setIndex(ilvGraphic, this.c);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void dispose(IlvGrapherPropertyAdapter ilvGrapherPropertyAdapter) {
        super.dispose(ilvGrapherPropertyAdapter);
    }
}

