/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout.basic;

import ilog.views.IlvGraphicVector;
import ilog.views.IlvPoint;
import ilog.views.graphlayout.IlvGraphLayout;
import ilog.views.graphlayout.IlvGraphLayoutException;
import ilog.views.graphlayout.IlvGraphLayoutGrapherProperty;
import ilog.views.graphlayout.IlvGraphLayoutReport;
import ilog.views.graphlayout.IlvGraphModel;
import ilog.views.graphlayout.IlvInappropriateLinkException;
import ilog.views.graphlayout.basic.IlvBasicLinkStyleLayoutGrapherProperty;
import ilog.views.graphlayout.internalutil.LayoutUtil;
import ilog.views.graphlayout.internalutil.LogResUtil;
import ilog.views.graphlayout.internalutil.MultiAndSelfLinkUtil;
import ilog.views.graphlayout.internalutil.ReshapeLinkUtil;
import java.util.ArrayList;
import java.util.HashSet;

public class IlvBasicLinkStyleLayout
extends IlvGraphLayout {
    public static final int STRAIGHT_LINE_STYLE = 1;
    public static final int NO_RESHAPE_STYLE = 0;
    public static final int NO_BUNDLE = 0;
    public static final int STRAIGHT_LINE_BUNDLE = 1;
    public static final int NARROW_STRAIGHT_LINE_BUNDLE = 10;
    public static final int CONNECTED_ONE_BEND_BUNDLE = 11;
    public static final int FREE_ONE_BEND_BUNDLE = 12;
    public static final int NO_BENDS = 0;
    public static final int CONNECTED_RECTANGULAR = 16;
    public static final int FREE_RECTANGULAR = 17;
    public static final int CONNECTED_SQUARE = 32;
    public static final int FREE_SQUARE = 33;
    public static final int NARROW_CONNECTED_RECTANGULAR = 18;
    public static final int NARROW_FREE_RECTANGULAR = 19;
    public static final int NARROW_CONNECTED_SQUARE = 34;
    public static final int NARROW_FREE_SQUARE = 35;
    public static final int TOP_LEFT = 1;
    public static final int BOTTOM_LEFT = 2;
    public static final int TOP_RIGHT = 4;
    public static final int BOTTOM_RIGHT = 8;
    public static final int ALL_CORNERS = 15;
    public static final int CLOCK_WISE = 0;
    public static final int COUNTER_CLOCK_WISE = 1;
    public static final int HORIZONTAL_TO_VERTICAL = 2;
    public static final int VERTICAL_TO_HORIZONTAL = 3;
    public static final int CENTERED = 0;
    public static final int OUTER = 1;
    public static final int INNER = 2;
    static final boolean a = false;
    static final int b = 1;
    static final int c = 10;
    static final float d = 10.0f;
    static final float e = 50.0f;
    static final int f = 18;
    static final int g = 0;
    static final int h = 15;
    static final float i = 5.0f;
    static final IlvPoint j = new IlvPoint(0.5f, 0.5f);
    static final IlvPoint k = new IlvPoint(0.0f, 0.0f);
    static final boolean l = false;
    static final int m = 0;
    static final float n = 10.0f;
    static final float o = 50.0f;
    private boolean p;
    private int q;
    private int r;
    private float s;
    private float t;
    private int u;
    private int v;
    private int w;
    private float x;
    private IlvPoint y;
    private IlvPoint z;
    private boolean aa;
    private int ab;
    private float ac;
    private float ad;
    private transient HashSet ae = null;
    private transient HashSet af = null;

    public IlvBasicLinkStyleLayout() {
    }

    @Override
    protected void init() {
        super.init();
        this.p = false;
        this.q = 1;
        this.r = 10;
        this.s = 10.0f;
        this.t = 50.0f;
        this.u = 18;
        this.v = 0;
        this.w = 15;
        this.x = 5.0f;
        this.y = new IlvPoint(j);
        this.z = new IlvPoint(k);
        this.aa = false;
        this.ab = 0;
        this.ac = 10.0f;
        this.ad = 50.0f;
    }

    public IlvBasicLinkStyleLayout(IlvBasicLinkStyleLayout ilvBasicLinkStyleLayout) {
        super(ilvBasicLinkStyleLayout);
    }

    @Override
    public IlvGraphLayout copy() {
        return new IlvBasicLinkStyleLayout(this);
    }

    @Override
    public void copyParameters(IlvGraphLayout ilvGraphLayout) {
        super.copyParameters(ilvGraphLayout);
        if (ilvGraphLayout instanceof IlvBasicLinkStyleLayout) {
            IlvBasicLinkStyleLayout ilvBasicLinkStyleLayout = (IlvBasicLinkStyleLayout)ilvGraphLayout;
            this.setConnectLinksToNodeCenters(ilvBasicLinkStyleLayout.isConnectLinksToNodeCenters());
            this.setLinkStyle(ilvBasicLinkStyleLayout.getLinkStyle());
            this.setMultiLinkMode(ilvBasicLinkStyleLayout.getMultiLinkMode());
            this.setMultiLinkOffset(ilvBasicLinkStyleLayout.getMultiLinkOffset());
            this.setMultiLinkMaxSpread(ilvBasicLinkStyleLayout.getMultiLinkMaxSpread());
            this.setSelfLinkMode(ilvBasicLinkStyleLayout.getSelfLinkMode());
            this.setSelfLinkOrientation(ilvBasicLinkStyleLayout.getSelfLinkOrientation());
            this.setSelfLinkAllowedCorners(ilvBasicLinkStyleLayout.getSelfLinkAllowedCorners());
            this.setSelfLinkSpacing(ilvBasicLinkStyleLayout.getSelfLinkSpacing());
            this.setSelfLinkRelativeAttachPosition(ilvBasicLinkStyleLayout.getSelfLinkRelativeAttachPosition());
            this.setSelfLinkAbsoluteAttachPosition(ilvBasicLinkStyleLayout.getSelfLinkAbsoluteAttachPosition());
            this.setSelfLinkConnectToNodeCenter(ilvBasicLinkStyleLayout.isSelfLinkConnectToNodeCenter());
            this.setMultiSelfLinkDistribution(ilvBasicLinkStyleLayout.getMultiSelfLinkDistribution());
            this.setMultiSelfLinkOffset(ilvBasicLinkStyleLayout.getMultiSelfLinkOffset());
            this.setMultiSelfLinkMaxSpread(ilvBasicLinkStyleLayout.getMultiSelfLinkMaxSpread());
        }
    }

    @Override
    public final boolean supportsPreserveFixedNodes() {
        return true;
    }

    @Override
    public final boolean supportsPreserveFixedLinks() {
        return true;
    }

    @Override
    public boolean supportsAllowedTime() {
        return true;
    }

    @Override
    public boolean supportsStopImmediately() {
        return true;
    }

    @Override
    public final boolean supportsLayoutOfConnectedComponents() {
        return true;
    }

    @Override
    public final boolean supportsLinkConnectionBox() {
        return true;
    }

    @Override
    public final boolean supportsLinkClipping() {
        return true;
    }

    @Override
    public boolean supportsPercentageComplete() {
        return true;
    }

    @Override
    public final boolean supportsSaveParametersToNamedProperties() {
        return true;
    }

    @Override
    protected void layout(boolean bl) throws IlvGraphLayoutException {
        int[] nArray = this.getPercentagesOfCompletion();
        IlvGraphLayoutReport ilvGraphLayoutReport = this.getLayoutReport();
        this.ae = new HashSet();
        this.af = new HashSet();
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        MultiAndSelfLinkUtil multiAndSelfLinkUtil = new MultiAndSelfLinkUtil(this);
        multiAndSelfLinkUtil.setMultiLinkOffset(this.getMultiLinkOffset());
        multiAndSelfLinkUtil.setMultiLinkMaxSpread(this.getMultiLinkMaxSpread());
        multiAndSelfLinkUtil.setConnectToCenter(this.isConnectLinksToNodeCenters());
        multiAndSelfLinkUtil.setSelfLinkSpacing(this.getSelfLinkSpacing());
        multiAndSelfLinkUtil.setSelfLinkOffset(this.getMultiSelfLinkOffset());
        multiAndSelfLinkUtil.setSelfLinkMaxSpread(this.getMultiSelfLinkMaxSpread());
        multiAndSelfLinkUtil.setAllowedSelfLinkCorners(this.b(this.getSelfLinkAllowedCorners()));
        multiAndSelfLinkUtil.setSelfLinkAttachXPosition(this.y.x, this.z.x);
        multiAndSelfLinkUtil.setSelfLinkAttachYPosition(this.y.y, this.z.y);
        if (this.getLinkStyle() != 0) {
            if (this.getMultiLinkMode() != 0) {
                multiAndSelfLinkUtil.collectMultilinks(arrayList, this.ae, true, false);
            }
            if (this.getSelfLinkMode() != 0) {
                multiAndSelfLinkUtil.collectSelflinks(arrayList2, arrayList3, this.af);
            }
        }
        this.increasePercentageComplete(nArray[0]);
        this.callLayoutStepPerformedIfNeeded();
        if (this.isInterrupted()) {
            this.c();
            return;
        }
        this.internalLayout(bl);
        this.increasePercentageComplete(nArray[1]);
        this.callLayoutStepPerformedIfNeeded();
        if (this.isInterrupted()) {
            this.c();
            return;
        }
        if (this.getLinkStyle() != 0) {
            if (this.supportsLinkClipping() && this.getLinkClipInterface() != null) {
                this.clipAllLinks(true, bl);
            } else if (this.isConnectLinksToNodeCenters()) {
                this.connectAllLinksToCenter(bl);
            }
        }
        if (this.isInterrupted()) {
            this.c();
            return;
        }
        if (arrayList.size() > 0) {
            switch (this.getMultiLinkMode()) {
                case 1: {
                    multiAndSelfLinkUtil.shiftMultilinks(arrayList, false, bl);
                    break;
                }
                case 10: {
                    multiAndSelfLinkUtil.shiftMultilinks(arrayList, true, bl);
                    break;
                }
                case 11: {
                    multiAndSelfLinkUtil.addBendToMultilinks(arrayList, false, true, true, bl);
                    break;
                }
                case 12: {
                    multiAndSelfLinkUtil.addBendToMultilinks(arrayList, true, false, false, bl);
                }
            }
        }
        this.increasePercentageComplete(nArray[2]);
        this.callLayoutStepPerformedIfNeeded();
        if (this.isInterrupted()) {
            this.c();
            return;
        }
        boolean bl2 = this.isSelfLinkConnectToNodeCenter();
        if (arrayList3.size() > 0) {
            switch (this.getSelfLinkMode()) {
                case 16: {
                    multiAndSelfLinkUtil.addBendToSelfLinkBundles(arrayList3, false, false, this.getSelfLinkOrientation(), this.getMultiSelfLinkDistribution(), bl2, true, bl);
                    break;
                }
                case 17: {
                    multiAndSelfLinkUtil.addBendToSelfLinkBundles(arrayList3, false, false, this.getSelfLinkOrientation(), this.getMultiSelfLinkDistribution(), false, false, bl);
                    break;
                }
                case 18: {
                    multiAndSelfLinkUtil.addBendToSelfLinkBundles(arrayList3, true, false, this.getSelfLinkOrientation(), this.getMultiSelfLinkDistribution(), bl2, true, bl);
                    break;
                }
                case 19: {
                    multiAndSelfLinkUtil.addBendToSelfLinkBundles(arrayList3, true, false, this.getSelfLinkOrientation(), this.getMultiSelfLinkDistribution(), false, false, bl);
                    break;
                }
                case 32: {
                    multiAndSelfLinkUtil.addBendToSelfLinkBundles(arrayList3, false, true, this.getSelfLinkOrientation(), this.getMultiSelfLinkDistribution(), bl2, true, bl);
                    break;
                }
                case 33: {
                    multiAndSelfLinkUtil.addBendToSelfLinkBundles(arrayList3, false, true, this.getSelfLinkOrientation(), this.getMultiSelfLinkDistribution(), false, false, bl);
                    break;
                }
                case 34: {
                    multiAndSelfLinkUtil.addBendToSelfLinkBundles(arrayList3, true, true, this.getSelfLinkOrientation(), this.getMultiSelfLinkDistribution(), bl2, true, bl);
                    break;
                }
                case 35: {
                    multiAndSelfLinkUtil.addBendToSelfLinkBundles(arrayList3, true, true, this.getSelfLinkOrientation(), this.getMultiSelfLinkDistribution(), false, false, bl);
                }
            }
        }
        if (arrayList2.size() > 0) {
            switch (this.getSelfLinkMode()) {
                case 16: 
                case 18: {
                    multiAndSelfLinkUtil.addBendToSelfLinks(arrayList2, false, this.getSelfLinkOrientation(), bl2, true, bl);
                    break;
                }
                case 17: 
                case 19: {
                    multiAndSelfLinkUtil.addBendToSelfLinks(arrayList2, false, this.getSelfLinkOrientation(), false, false, bl);
                    break;
                }
                case 32: 
                case 34: {
                    multiAndSelfLinkUtil.addBendToSelfLinks(arrayList2, true, this.getSelfLinkOrientation(), bl2, true, bl);
                    break;
                }
                case 33: 
                case 35: {
                    multiAndSelfLinkUtil.addBendToSelfLinks(arrayList2, true, this.getSelfLinkOrientation(), false, false, bl);
                }
            }
        }
        this.increasePercentageComplete(nArray[3]);
        this.layoutStepPerformed();
        if (ilvGraphLayoutReport.getCode() != 6 && ilvGraphLayoutReport.getCode() != 7) {
            ilvGraphLayoutReport.setCode(5);
        }
        this.ae = null;
        this.af = null;
    }

    protected void internalLayout(boolean bl) throws IlvGraphLayoutException {
        this.checkAppropriateLinks();
        if (!this.isInterrupted() && this.getLinkStyle() == 1) {
            IlvGraphModel ilvGraphModel = this.getGraphModel();
            ReshapeLinkUtil.deleteIntermediatePointsOnLinks(ilvGraphModel, this, bl);
        }
    }

    protected final int getSelfLinksCount() {
        if (this.af != null) {
            return this.af.size();
        }
        return 0;
    }

    protected final int getMultiLinksCount() {
        if (this.ae != null) {
            return this.ae.size();
        }
        return 0;
    }

    protected boolean isInterrupted() {
        if (this.supportsAllowedTime() && this.isLayoutTimeElapsed()) {
            return true;
        }
        return this.supportsStopImmediately() && this.isStoppedImmediately();
    }

    private void c() {
        IlvGraphLayoutReport ilvGraphLayoutReport = this.getLayoutReport();
        ilvGraphLayoutReport.setCode(this.getLayoutCodeOnInterrupt());
        this.layoutStepPerformed();
        this.ae = null;
        this.af = null;
    }

    protected int getLayoutCodeOnInterrupt() {
        return 7;
    }

    protected int[] getPercentagesOfCompletion() {
        return new int[]{20, 60, 80, 100};
    }

    @Override
    public void increasePercentageComplete(int n) {
        if (this.supportsPercentageComplete()) {
            super.increasePercentageComplete(n);
        }
    }

    public void setLinkStyle(int n) {
        if (n != 1 && n != 0) {
            LogResUtil.logAndThrowIllegalArgExc(IlvGraphLayout.class, "graphlayout.expert.message.6090E", n);
        }
        if (n != this.q) {
            this.q = n;
            this.onParameterChanged("LinkStyle");
        }
    }

    public int getLinkStyle() {
        return this.isUseDefaultParameters() ? 1 : this.q;
    }

    public void setConnectLinksToNodeCenters(boolean bl) {
        if (bl != this.p) {
            this.p = bl;
            this.onParameterChanged("ConnectLinksToNodeCenters");
        }
    }

    public boolean isConnectLinksToNodeCenters() {
        return this.isUseDefaultParameters() ? false : this.p;
    }

    public void setMultiLinkMode(int n) {
        if (n != 0 && n != 1 && n != 10 && n != 11 && n != 12) {
            LogResUtil.logAndThrowIllegalArgExc(IlvGraphLayout.class, "graphlayout.expert.message.6090E", n);
        }
        if (n != this.r) {
            this.r = n;
            this.onParameterChanged("MultiLinkMode");
        }
    }

    public int getMultiLinkMode() {
        return this.isUseDefaultParameters() ? 10 : this.r;
    }

    public final void setMultiLinkOffset(float f) {
        if (f < 0.0f) {
            LogResUtil.logAndThrowIllegalArgExc(IlvGraphLayout.class, "graphlayout.expert.message.6091E", f);
        }
        if (f != this.s) {
            this.s = f;
            this.onParameterChanged("MultiLinkOffset");
        }
    }

    public final float getMultiLinkOffset() {
        if (this.isUseDefaultParameters()) {
            return 10.0f;
        }
        return this.s;
    }

    public final void setMultiLinkMaxSpread(float f) {
        if (f < 0.0f) {
            LogResUtil.logAndThrowIllegalArgExc(IlvGraphLayout.class, "graphlayout.expert.message.6091E", f);
        }
        if (f != this.t) {
            this.t = f;
            this.onParameterChanged("MultiLinkMaxSpread");
        }
    }

    public final float getMultiLinkMaxSpread() {
        if (this.isUseDefaultParameters()) {
            return 50.0f;
        }
        return this.t;
    }

    public void setSelfLinkMode(int n) {
        if (n != 0 && n != 16 && n != 17 && n != 18 && n != 19 && n != 32 && n != 33 && n != 34 && n != 35) {
            LogResUtil.logAndThrowIllegalArgExc(IlvGraphLayout.class, "graphlayout.expert.message.6090E", n);
        }
        if (n != this.u) {
            this.u = n;
            this.onParameterChanged("SelfLinkMode");
        }
    }

    public int getSelfLinkMode() {
        return this.isUseDefaultParameters() ? 18 : this.u;
    }

    public void setSelfLinkOrientation(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            LogResUtil.logAndThrowIllegalArgExc(IlvGraphLayout.class, "graphlayout.expert.message.6090E", n);
        }
        if (n != this.v) {
            this.v = n;
            this.onParameterChanged("SelfLinkOrientation");
        }
    }

    public int getSelfLinkOrientation() {
        return this.isUseDefaultParameters() ? 0 : this.v;
    }

    public void setSelfLinkAllowedCorners(int n) {
        if ((n & 0xFFFFFFF0) != 0) {
            LogResUtil.logAndThrowIllegalArgExc(IlvGraphLayout.class, "graphlayout.expert.message.6090E", n);
        }
        if (n != this.w) {
            this.w = n;
            this.onParameterChanged("SelfLinkAllowedCorners");
        }
    }

    public final int getSelfLinkAllowedCorners() {
        return this.isUseDefaultParameters() ? 15 : this.w;
    }

    private int b(int n) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= 8;
        }
        if ((n & 4) != 0) {
            n2 |= 4;
        }
        if ((n & 8) != 0) {
            n2 |= 2;
        }
        if ((n & 2) != 0) {
            n2 |= 1;
        }
        return n2;
    }

    public final void setSelfLinkSpacing(float f) {
        if (f != this.x) {
            this.x = f;
            this.onParameterChanged("SelfLinkSpacing");
        }
    }

    public final float getSelfLinkSpacing() {
        if (this.isUseDefaultParameters()) {
            return 5.0f;
        }
        return this.x;
    }

    public final void setSelfLinkRelativeAttachPosition(IlvPoint ilvPoint) {
        if (ilvPoint == null) {
            LogResUtil.logAndThrowIllegalArgExc(IlvGraphLayout.class, "graphlayout.expert.message.6092E");
        }
        if (!ilvPoint.equals((Object)this.y)) {
            this.y = new IlvPoint(ilvPoint);
            this.onParameterChanged("SelfLinkRelativeAttachPosition");
        }
    }

    public final IlvPoint getSelfLinkRelativeAttachPosition() {
        IlvPoint ilvPoint = this.isUseDefaultParameters() ? j : this.y;
        return new IlvPoint(ilvPoint);
    }

    public final void setSelfLinkAbsoluteAttachPosition(IlvPoint ilvPoint) {
        if (ilvPoint == null) {
            LogResUtil.logAndThrowIllegalArgExc(IlvGraphLayout.class, "graphlayout.expert.message.6092E");
        }
        if (!ilvPoint.equals((Object)this.z)) {
            this.z = new IlvPoint(ilvPoint);
            this.onParameterChanged("SelfLinkAbsoluteAttachPosition");
        }
    }

    public final IlvPoint getSelfLinkAbsoluteAttachPosition() {
        IlvPoint ilvPoint = this.isUseDefaultParameters() ? k : this.z;
        return new IlvPoint(ilvPoint);
    }

    public final void setSelfLinkConnectToNodeCenter(boolean bl) {
        if (bl != this.aa) {
            this.aa = bl;
            this.onParameterChanged("SelfLinkConnectToNodeCenter");
        }
    }

    public final boolean isSelfLinkConnectToNodeCenter() {
        if (this.isUseDefaultParameters()) {
            return false;
        }
        return this.aa;
    }

    public void setMultiSelfLinkDistribution(int n) {
        if (n != 0 && n != 1 && n != 2) {
            LogResUtil.logAndThrowIllegalArgExc(IlvGraphLayout.class, "graphlayout.expert.message.6090E", n);
        }
        if (n != this.ab) {
            this.ab = n;
            this.onParameterChanged("MultiSelfLinkDistribution");
        }
    }

    public int getMultiSelfLinkDistribution() {
        return this.isUseDefaultParameters() ? 0 : this.ab;
    }

    public final void setMultiSelfLinkOffset(float f) {
        if (f < 0.0f) {
            LogResUtil.logAndThrowIllegalArgExc(IlvGraphLayout.class, "graphlayout.expert.message.6091E", f);
        }
        if (f != this.ac) {
            this.ac = f;
            this.onParameterChanged("MultiSelfLinkOffset");
        }
    }

    public final float getMultiSelfLinkOffset() {
        if (this.isUseDefaultParameters()) {
            return 10.0f;
        }
        return this.ac;
    }

    public final void setMultiSelfLinkMaxSpread(float f) {
        if (f < 0.0f) {
            LogResUtil.logAndThrowIllegalArgExc(IlvGraphLayout.class, "graphlayout.expert.message.6091E", f);
        }
        if (f != this.ad) {
            this.ad = f;
            this.onParameterChanged("MultiSelfLinkMaxSpread");
        }
    }

    public final float getMultiSelfLinkMaxSpread() {
        if (this.isUseDefaultParameters()) {
            return 50.0f;
        }
        return this.ad;
    }

    @Override
    public void checkAppropriateLinks() throws IlvInappropriateLinkException {
        Object object = this.getProperty("__CheckAppropriateLinksNeeded");
        if (object == Boolean.FALSE) {
            return;
        }
        boolean bl = this.ae == null;
        boolean bl2 = this.af == null;
        MultiAndSelfLinkUtil multiAndSelfLinkUtil = null;
        if (bl || bl2) {
            multiAndSelfLinkUtil = new MultiAndSelfLinkUtil(this);
        }
        if (bl) {
            this.ae = new HashSet();
            if (this.getLinkStyle() != 0 && this.getMultiLinkMode() != 0) {
                multiAndSelfLinkUtil.collectMultilinks(new ArrayList(), this.ae, true, false);
            }
        }
        if (bl2) {
            this.af = new HashSet();
            if (this.getLinkStyle() != 0 && this.getSelfLinkMode() != 0) {
                multiAndSelfLinkUtil.collectSelflinks(new ArrayList(), new ArrayList(), this.af);
            }
        }
        super.checkAppropriateLinks();
        if (bl) {
            this.ae = null;
        }
        if (bl2) {
            this.af = null;
        }
    }

    @Override
    public int checkAppropriateLink(Object object) {
        if (this.getLinkStyle() == 0) {
            return 0;
        }
        int n = 0;
        IlvGraphModel ilvGraphModel = this.getGraphModel();
        boolean bl = false;
        boolean bl2 = false;
        if (ilvGraphModel.isLinkCheckEnabled() || ilvGraphModel.isConnectionPointCheckEnabled()) {
            bl = this.ae.contains(object);
            bl2 = this.af.contains(object);
        }
        if (ilvGraphModel.isLinkCheckEnabled()) {
            boolean bl3 = true;
            int n2 = 1;
            if (bl) {
                switch (this.getMultiLinkMode()) {
                    case 11: 
                    case 12: {
                        bl3 = false;
                        n2 = 2;
                    }
                }
            }
            if (bl2 && this.getSelfLinkMode() != 0) {
                bl3 = false;
                n2 = 2;
            }
            if (!ilvGraphModel.isReshapeableLink(object, bl3)) {
                n |= n2;
            }
        }
        if (ilvGraphModel.isConnectionPointCheckEnabled()) {
            if (this.supportsLinkClipping() && this.getLinkClipInterface() != null) {
                n |= LayoutUtil.CheckAppropriateLinkConnection(object, ilvGraphModel);
            } else if (this.isConnectLinksToNodeCenters()) {
                n |= LayoutUtil.CheckAppropriateLinkConnection(object, ilvGraphModel);
            } else if (bl) {
                switch (this.getMultiLinkMode()) {
                    case 1: 
                    case 10: 
                    case 11: {
                        n |= LayoutUtil.CheckAppropriateLinkConnection(object, ilvGraphModel);
                    }
                }
            } else if (bl2) {
                switch (this.getSelfLinkMode()) {
                    case 16: 
                    case 18: 
                    case 32: 
                    case 34: {
                        n |= LayoutUtil.CheckAppropriateLinkConnection(object, ilvGraphModel);
                    }
                }
            }
        }
        return n;
    }

    @Override
    public IlvGraphicVector getMovingNodes() {
        return LayoutUtil.getDefaultMovingNodes(this.getGraphModel());
    }

    @Override
    protected IlvGraphLayoutGrapherProperty createLayoutGrapherProperty(String string, boolean bl) {
        return new IlvBasicLinkStyleLayoutGrapherProperty(string, this, bl);
    }
}

